/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.ClassTypePointerFactory;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.kotlin.com.intellij.psi.SmartTypePointer;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.TypePointerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiClassReferenceTypePointerFactory
implements ClassTypePointerFactory {
    private static final Logger LOG = Logger.getInstance(PsiClassReferenceTypePointerFactory.class);

    @Override
    @Nullable
    public SmartTypePointer createClassTypePointer(@NotNull PsiClassType classType, @NotNull Project project) {
        if (classType == null) {
            PsiClassReferenceTypePointerFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PsiClassReferenceTypePointerFactory.$$$reportNull$$$0(1);
        }
        if (classType instanceof PsiClassReferenceType) {
            return new ClassReferenceTypePointer((PsiClassReferenceType)classType, project);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "classType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/PsiClassReferenceTypePointerFactory";
        objectArray[2] = "createClassTypePointer";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClassReferenceTypePointer
    extends TypePointerBase<PsiClassReferenceType> {
        private final SmartPsiElementPointer mySmartPsiElementPointer;
        private final String myReferenceText;
        private final Project myProject;

        ClassReferenceTypePointer(@NotNull PsiClassReferenceType type2, Project project) {
            if (type2 == null) {
                ClassReferenceTypePointer.$$$reportNull$$$0(0);
            }
            super(type2);
            this.myProject = project;
            PsiJavaCodeReferenceElement reference = type2.getReference();
            this.mySmartPsiElementPointer = SmartPointerManager.getInstance(this.myProject).createSmartPsiElementPointer(reference);
            this.myReferenceText = reference.getText();
        }

        @Override
        protected PsiClassReferenceType calcType() {
            PsiClassReferenceType myType = null;
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.mySmartPsiElementPointer.getElement();
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(this.myProject);
            if (referenceElement != null) {
                myType = (PsiClassReferenceType)factory2.createType(referenceElement);
            } else {
                try {
                    myType = (PsiClassReferenceType)factory2.createTypeFromText(this.myReferenceText, null);
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }
            return myType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/PsiClassReferenceTypePointerFactory$ClassReferenceTypePointer", "<init>"));
        }
    }
}

