/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.ShapeQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class XYShapeQuery
extends ShapeQuery {
    final XYGeometry[] geometries;
    private final Component2D component2D;

    XYShapeQuery(String field, ShapeField.QueryRelation queryRelation, XYGeometry ... geometries) {
        super(field, queryRelation);
        this.component2D = XYGeometry.create(geometries);
        this.geometries = (XYGeometry[])geometries.clone();
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minY = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, minYOffset));
        double minX = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, minXOffset));
        double maxY = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, maxYOffset));
        double maxX = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, maxXOffset));
        return this.component2D.relate(minX, maxX, minY, maxY);
    }

    @Override
    protected boolean queryIntersects(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        switch (scratchTriangle.type) {
            case POINT: {
                double y = XYEncodingUtils.decode(scratchTriangle.aY);
                double x = XYEncodingUtils.decode(scratchTriangle.aX);
                return this.component2D.contains(x, y);
            }
            case LINE: {
                double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                return this.component2D.intersectsLine(aX, aY, bX, bY);
            }
            case TRIANGLE: {
                double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                double cY = XYEncodingUtils.decode(scratchTriangle.cY);
                double cX = XYEncodingUtils.decode(scratchTriangle.cX);
                return this.component2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
            }
        }
        throw new IllegalArgumentException("Unsupported triangle type :[" + (Object)((Object)scratchTriangle.type) + "]");
    }

    @Override
    protected boolean queryContains(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        switch (scratchTriangle.type) {
            case POINT: {
                double y = XYEncodingUtils.decode(scratchTriangle.aY);
                double x = XYEncodingUtils.decode(scratchTriangle.aX);
                return this.component2D.contains(x, y);
            }
            case LINE: {
                double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                return this.component2D.containsLine(aX, aY, bX, bY);
            }
            case TRIANGLE: {
                double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                double cY = XYEncodingUtils.decode(scratchTriangle.cY);
                double cX = XYEncodingUtils.decode(scratchTriangle.cX);
                return this.component2D.containsTriangle(aX, aY, bX, bY, cX, cY);
            }
        }
        throw new IllegalArgumentException("Unsupported triangle type :[" + (Object)((Object)scratchTriangle.type) + "]");
    }

    @Override
    protected Component2D.WithinRelation queryWithin(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        switch (scratchTriangle.type) {
            case POINT: {
                double y = XYEncodingUtils.decode(scratchTriangle.aY);
                double x = XYEncodingUtils.decode(scratchTriangle.aX);
                return this.component2D.withinPoint(x, y);
            }
            case LINE: {
                double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                return this.component2D.withinLine(aX, aY, scratchTriangle.ab, bX, bY);
            }
            case TRIANGLE: {
                double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                double cY = XYEncodingUtils.decode(scratchTriangle.cY);
                double cX = XYEncodingUtils.decode(scratchTriangle.cX);
                return this.component2D.withinTriangle(aX, aY, scratchTriangle.ab, bX, bY, scratchTriangle.bc, cX, cY, scratchTriangle.ca);
            }
        }
        throw new IllegalArgumentException("Unsupported triangle type :[" + (Object)((Object)scratchTriangle.type) + "]");
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("[");
        for (int i = 0; i < this.geometries.length; ++i) {
            sb.append(this.geometries[i].toString());
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.geometries, ((XYShapeQuery)o).geometries);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.geometries);
        return hash;
    }
}

