/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.AnnotatedConstantBindingBuilder;
import com.google.inject.binder.AnnotatedElementBuilder;
import com.google.inject.internal.AbstractBindingBuilder;
import com.google.inject.internal.BindingBuilder;
import com.google.inject.internal.ConstantBindingBuilderImpl;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ExposureBuilder;
import com.google.inject.internal.InternalFlags;
import com.google.inject.internal.MoreTypes;
import com.google.inject.internal.PrivateElementsImpl;
import com.google.inject.internal.ProviderMethodsModule;
import com.google.inject.internal.util.SourceProvider;
import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.DisableCircularProxiesOption;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.MembersInjectorLookup;
import com.google.inject.spi.Message;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import com.google.inject.spi.ModuleAnnotatedMethodScannerBinding;
import com.google.inject.spi.ModuleSource;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.spi.ProvisionListenerBinding;
import com.google.inject.spi.RequireAtInjectOnConstructorsOption;
import com.google.inject.spi.RequireExactBindingAnnotationsOption;
import com.google.inject.spi.RequireExplicitBindingsOption;
import com.google.inject.spi.ScopeBinding;
import com.google.inject.spi.StaticInjectionRequest;
import com.google.inject.spi.TypeConverter;
import com.google.inject.spi.TypeConverterBinding;
import com.google.inject.spi.TypeListener;
import com.google.inject.spi.TypeListenerBinding;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Elements {
    private static final BindingTargetVisitor<Object, Object> GET_INSTANCE_VISITOR = new DefaultBindingTargetVisitor<Object, Object>(){

        @Override
        public Object visit(InstanceBinding<?> binding2) {
            return binding2.getInstance();
        }

        @Override
        protected Object visitOther(Binding<?> binding2) {
            throw new IllegalArgumentException();
        }
    };

    public static List<Element> getElements(Module ... modules) {
        return Elements.getElements(Stage.DEVELOPMENT, Arrays.asList(modules));
    }

    public static List<Element> getElements(Stage stage, Module ... modules) {
        return Elements.getElements(stage, Arrays.asList(modules));
    }

    public static List<Element> getElements(Iterable<? extends Module> modules) {
        return Elements.getElements(Stage.DEVELOPMENT, modules);
    }

    public static List<Element> getElements(Stage stage, Iterable<? extends Module> modules) {
        RecordingBinder binder = new RecordingBinder(stage);
        for (Module module : modules) {
            binder.install(module);
        }
        binder.scanForAnnotatedMethods();
        for (RecordingBinder recordingBinder : binder.privateBinders) {
            recordingBinder.scanForAnnotatedMethods();
        }
        StackTraceElements.clearCache();
        return Collections.unmodifiableList(binder.elements);
    }

    public static Module getModule(Iterable<? extends Element> elements) {
        return new ElementsAsModule(elements);
    }

    static <T> BindingTargetVisitor<T, T> getInstanceVisitor() {
        return GET_INSTANCE_VISITOR;
    }

    private static class RecordingBinder
    implements Binder,
    PrivateBinder {
        private final Stage stage;
        private final Map<Module, ModuleInfo> modules;
        private final List<Element> elements;
        private final Object source;
        private ModuleSource moduleSource = null;
        private final SourceProvider sourceProvider;
        private final Set<ModuleAnnotatedMethodScanner> scanners;
        private final RecordingBinder parent;
        private final PrivateElementsImpl privateElements;
        private final List<RecordingBinder> privateBinders;

        private RecordingBinder(Stage stage) {
            this.stage = stage;
            this.modules = Maps.newLinkedHashMap();
            this.scanners = Sets.newLinkedHashSet();
            this.elements = Lists.newArrayList();
            this.source = null;
            this.sourceProvider = SourceProvider.DEFAULT_INSTANCE.plusSkippedClasses(Elements.class, RecordingBinder.class, AbstractModule.class, ConstantBindingBuilderImpl.class, AbstractBindingBuilder.class, BindingBuilder.class);
            this.parent = null;
            this.privateElements = null;
            this.privateBinders = Lists.newArrayList();
        }

        private RecordingBinder(RecordingBinder prototype, Object source2, SourceProvider sourceProvider) {
            Preconditions.checkArgument(source2 == null ^ sourceProvider == null);
            this.stage = prototype.stage;
            this.modules = prototype.modules;
            this.elements = prototype.elements;
            this.scanners = prototype.scanners;
            this.source = source2;
            this.moduleSource = prototype.moduleSource;
            this.sourceProvider = sourceProvider;
            this.parent = prototype.parent;
            this.privateElements = prototype.privateElements;
            this.privateBinders = prototype.privateBinders;
        }

        private RecordingBinder(RecordingBinder parent, PrivateElementsImpl privateElements) {
            this.stage = parent.stage;
            this.modules = Maps.newLinkedHashMap();
            this.scanners = Sets.newLinkedHashSet(parent.scanners);
            this.elements = privateElements.getElementsMutable();
            this.source = parent.source;
            this.moduleSource = parent.moduleSource;
            this.sourceProvider = parent.sourceProvider;
            this.parent = parent;
            this.privateElements = privateElements;
            this.privateBinders = parent.privateBinders;
        }

        @Override
        public void bindScope(Class<? extends Annotation> annotationType, Scope scope) {
            this.elements.add(new ScopeBinding(this.getElementSource(), annotationType, scope));
        }

        @Override
        public void requestInjection(Object instance) {
            this.requestInjection(TypeLiteral.get(instance.getClass()), instance);
        }

        @Override
        public <T> void requestInjection(TypeLiteral<T> type2, T instance) {
            this.elements.add(new InjectionRequest<T>(this.getElementSource(), MoreTypes.canonicalizeForKey(type2), instance));
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
            MembersInjectorLookup<T> element2 = new MembersInjectorLookup<T>(this.getElementSource(), MoreTypes.canonicalizeForKey(typeLiteral));
            this.elements.add(element2);
            return element2.getMembersInjector();
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(Class<T> type2) {
            return this.getMembersInjector(TypeLiteral.get(type2));
        }

        @Override
        public void bindListener(Matcher<? super TypeLiteral<?>> typeMatcher, TypeListener listener) {
            this.elements.add(new TypeListenerBinding(this.getElementSource(), listener, typeMatcher));
        }

        @Override
        public void bindListener(Matcher<? super Binding<?>> bindingMatcher, ProvisionListener ... listeners) {
            this.elements.add(new ProvisionListenerBinding(this.getElementSource(), bindingMatcher, listeners));
        }

        @Override
        public void requestStaticInjection(Class<?> ... types) {
            for (Class<?> type2 : types) {
                this.elements.add(new StaticInjectionRequest(this.getElementSource(), type2));
            }
        }

        void scanForAnnotatedMethods() {
            for (ModuleAnnotatedMethodScanner scanner : this.scanners) {
                for (Map.Entry<Module, ModuleInfo> entry : Maps.newLinkedHashMap(this.modules).entrySet()) {
                    Module module = entry.getKey();
                    ModuleInfo info = entry.getValue();
                    if (info.skipScanning) continue;
                    this.moduleSource = entry.getValue().moduleSource;
                    try {
                        info.binder.install(ProviderMethodsModule.forModule(module, scanner));
                    }
                    catch (RuntimeException e2) {
                        Collection<Message> messages = Errors.getMessagesFromThrowable(e2);
                        if (!messages.isEmpty()) {
                            this.elements.addAll(messages);
                            continue;
                        }
                        this.addError(e2);
                    }
                }
            }
            this.moduleSource = null;
        }

        @Override
        public void install(Module module) {
            if (!this.modules.containsKey(module)) {
                RecordingBinder binder = this;
                boolean unwrapModuleSource = false;
                if (module instanceof ProviderMethodsModule) {
                    Object delegate = ((ProviderMethodsModule)module).getDelegateModule();
                    if (this.moduleSource == null || !this.moduleSource.getModuleClassName().equals(delegate.getClass().getName())) {
                        this.moduleSource = this.getModuleSource(delegate);
                        unwrapModuleSource = true;
                    }
                } else {
                    this.moduleSource = this.getModuleSource(module);
                    unwrapModuleSource = true;
                }
                boolean skipScanning = false;
                if (module instanceof PrivateModule) {
                    binder = (RecordingBinder)binder.newPrivateBinder();
                    binder.modules.put(module, new ModuleInfo(binder, this.moduleSource, false));
                    skipScanning = true;
                }
                this.modules.put(module, new ModuleInfo(binder, this.moduleSource, skipScanning));
                try {
                    module.configure(binder);
                }
                catch (RuntimeException e2) {
                    Collection<Message> messages = Errors.getMessagesFromThrowable(e2);
                    if (!messages.isEmpty()) {
                        this.elements.addAll(messages);
                    }
                    this.addError(e2);
                }
                binder.install(ProviderMethodsModule.forModule(module));
                if (unwrapModuleSource) {
                    this.moduleSource = this.moduleSource.getParent();
                }
            }
        }

        @Override
        public Stage currentStage() {
            return this.stage;
        }

        @Override
        public void addError(String message, Object ... arguments) {
            this.elements.add(new Message(this.getElementSource(), Errors.format(message, arguments)));
        }

        @Override
        public void addError(Throwable t) {
            String message = "An exception was caught and reported. Message: " + t.getMessage();
            this.elements.add(new Message(ImmutableList.of(this.getElementSource()), message, t));
        }

        @Override
        public void addError(Message message) {
            this.elements.add(message);
        }

        public <T> AnnotatedBindingBuilder<T> bind(Key<T> key2) {
            BindingBuilder<T> builder = new BindingBuilder<T>(this, this.elements, this.getElementSource(), MoreTypes.canonicalizeKey(key2));
            return builder;
        }

        @Override
        public <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
            return this.bind((Key)Key.get(typeLiteral));
        }

        @Override
        public <T> AnnotatedBindingBuilder<T> bind(Class<T> type2) {
            return this.bind((Key)Key.get(type2));
        }

        @Override
        public AnnotatedConstantBindingBuilder bindConstant() {
            return new ConstantBindingBuilderImpl(this, this.elements, this.getElementSource());
        }

        @Override
        public <T> Provider<T> getProvider(Key<T> key2) {
            return this.getProvider(Dependency.get(key2));
        }

        @Override
        public <T> Provider<T> getProvider(Dependency<T> dependency) {
            ProviderLookup<T> element2 = new ProviderLookup<T>((Object)this.getElementSource(), dependency);
            this.elements.add(element2);
            return element2.getProvider();
        }

        @Override
        public <T> Provider<T> getProvider(Class<T> type2) {
            return this.getProvider(Key.get(type2));
        }

        @Override
        public void convertToTypes(Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter converter) {
            this.elements.add(new TypeConverterBinding(this.getElementSource(), typeMatcher, converter));
        }

        @Override
        public RecordingBinder withSource(Object source2) {
            return source2 == this.source ? this : new RecordingBinder(this, source2, null);
        }

        @Override
        public RecordingBinder skipSources(Class ... classesToSkip) {
            if (this.source != null) {
                return this;
            }
            SourceProvider newSourceProvider = this.sourceProvider.plusSkippedClasses(classesToSkip);
            return new RecordingBinder(this, null, newSourceProvider);
        }

        @Override
        public PrivateBinder newPrivateBinder() {
            PrivateElementsImpl privateElements = new PrivateElementsImpl(this.getElementSource());
            RecordingBinder binder = new RecordingBinder(this, privateElements);
            this.privateBinders.add(binder);
            this.elements.add(privateElements);
            return binder;
        }

        @Override
        public void disableCircularProxies() {
            this.elements.add(new DisableCircularProxiesOption(this.getElementSource()));
        }

        @Override
        public void requireExplicitBindings() {
            this.elements.add(new RequireExplicitBindingsOption(this.getElementSource()));
        }

        @Override
        public void requireAtInjectOnConstructors() {
            this.elements.add(new RequireAtInjectOnConstructorsOption(this.getElementSource()));
        }

        @Override
        public void requireExactBindingAnnotations() {
            this.elements.add(new RequireExactBindingAnnotationsOption(this.getElementSource()));
        }

        @Override
        public void scanModulesForAnnotatedMethods(ModuleAnnotatedMethodScanner scanner) {
            this.scanners.add(scanner);
            this.elements.add(new ModuleAnnotatedMethodScannerBinding(this.getElementSource(), scanner));
        }

        @Override
        public void expose(Key<?> key2) {
            this.exposeInternal(key2);
        }

        @Override
        public AnnotatedElementBuilder expose(Class<?> type2) {
            return this.exposeInternal(Key.get(type2));
        }

        @Override
        public AnnotatedElementBuilder expose(TypeLiteral<?> type2) {
            return this.exposeInternal(Key.get(type2));
        }

        private <T> AnnotatedElementBuilder exposeInternal(Key<T> key2) {
            if (this.privateElements == null) {
                this.addError("Cannot expose %s on a standard binder. Exposed bindings are only applicable to private binders.", key2);
                return new AnnotatedElementBuilder(){

                    @Override
                    public void annotatedWith(Class<? extends Annotation> annotationType) {
                    }

                    @Override
                    public void annotatedWith(Annotation annotation) {
                    }
                };
            }
            ExposureBuilder<T> builder = new ExposureBuilder<T>(this, this.getElementSource(), MoreTypes.canonicalizeKey(key2));
            this.privateElements.addExposureBuilder(builder);
            return builder;
        }

        private ModuleSource getModuleSource(Object module) {
            StackTraceElement[] partialCallStack = InternalFlags.getIncludeStackTraceOption() == InternalFlags.IncludeStackTraceOption.COMPLETE ? this.getPartialCallStack(new Throwable().getStackTrace()) : new StackTraceElement[]{};
            if (this.moduleSource == null) {
                return new ModuleSource(module, partialCallStack);
            }
            return this.moduleSource.createChild(module, partialCallStack);
        }

        private ElementSource getElementSource() {
            InternalFlags.IncludeStackTraceOption stackTraceOption;
            StackTraceElement[] callStack = null;
            StackTraceElement[] partialCallStack = new StackTraceElement[]{};
            ElementSource originalSource = null;
            Object declaringSource = this.source;
            if (declaringSource instanceof ElementSource) {
                originalSource = (ElementSource)declaringSource;
                declaringSource = originalSource.getDeclaringSource();
            }
            if ((stackTraceOption = InternalFlags.getIncludeStackTraceOption()) == InternalFlags.IncludeStackTraceOption.COMPLETE || stackTraceOption == InternalFlags.IncludeStackTraceOption.ONLY_FOR_DECLARING_SOURCE && declaringSource == null) {
                callStack = new Throwable().getStackTrace();
            }
            if (stackTraceOption == InternalFlags.IncludeStackTraceOption.COMPLETE) {
                partialCallStack = this.getPartialCallStack(callStack);
            }
            if (declaringSource == null) {
                declaringSource = stackTraceOption == InternalFlags.IncludeStackTraceOption.COMPLETE || stackTraceOption == InternalFlags.IncludeStackTraceOption.ONLY_FOR_DECLARING_SOURCE ? this.sourceProvider.get(callStack) : this.sourceProvider.getFromClassNames(this.moduleSource.getModuleClassNames());
            }
            return new ElementSource(originalSource, declaringSource, this.moduleSource, partialCallStack);
        }

        private StackTraceElement[] getPartialCallStack(StackTraceElement[] callStack) {
            int toSkip = 0;
            if (this.moduleSource != null) {
                toSkip = this.moduleSource.getStackTraceSize();
            }
            int chunkSize = callStack.length - toSkip - 1;
            StackTraceElement[] partialCallStack = new StackTraceElement[chunkSize];
            System.arraycopy(callStack, 1, partialCallStack, 0, chunkSize);
            return partialCallStack;
        }

        public String toString() {
            return "Binder";
        }
    }

    private static class ModuleInfo {
        private final Binder binder;
        private final ModuleSource moduleSource;
        private final boolean skipScanning;

        private ModuleInfo(Binder binder, ModuleSource moduleSource, boolean skipScanning) {
            this.binder = binder;
            this.moduleSource = moduleSource;
            this.skipScanning = skipScanning;
        }
    }

    private static class ElementsAsModule
    implements Module {
        private final Iterable<? extends Element> elements;

        ElementsAsModule(Iterable<? extends Element> elements) {
            this.elements = elements;
        }

        @Override
        public void configure(Binder binder) {
            for (Element element2 : this.elements) {
                element2.applyTo(binder);
            }
        }
    }
}

