/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.progress.aggregate.ProgressMonitor;
import org.openide.util.Cancellable;

public final class AggregateProgressHandle {
    private static final Logger LOG = Logger.getLogger(AggregateProgressHandle.class.getName());
    private ProgressMonitor monitor;
    private ProgressHandle handle;
    static final int WORKUNITS = 10000;
    private boolean finished;
    private Collection<ProgressContributor> contributors;
    private int current;
    private String displayName;

    AggregateProgressHandle(String string, ProgressContributor[] progressContributorArray, Cancellable cancellable, Action action, boolean bl) {
        this.handle = ProgressHandleFactory.createHandle(string, cancellable, action);
        this.finished = false;
        this.contributors = new ArrayList<ProgressContributor>();
        if (progressContributorArray != null) {
            for (int i = 0; i < progressContributorArray.length; ++i) {
                this.addContributor(progressContributorArray[i]);
            }
        }
        this.displayName = string;
    }

    public void start() {
        this.start(-1L);
    }

    public synchronized void start(long l) {
        this.handle.start(10000, l);
        this.current = 0;
    }

    public synchronized void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.handle.finish();
    }

    public void suspend(String string) {
        LOG.log(Level.FINE, "{0}: {1}", new Object[]{this.displayName, string});
        this.handle.suspend(string);
    }

    public void setInitialDelay(int n) {
        this.handle.setInitialDelay(n);
    }

    public synchronized void addContributor(ProgressContributor progressContributor) {
        if (this.finished) {
            return;
        }
        int n = this.contributors.size();
        int n2 = 0;
        double d = 0.0;
        if (n > 0) {
            for (ProgressContributor progressContributor2 : this.contributors) {
                n2 += progressContributor2.getRemainingParentWorkUnits();
                d += 1.0 - progressContributor2.getCompletedRatio();
            }
        } else {
            n2 = 10000;
            d = 0.0;
        }
        int n3 = (int)((double)n2 / (d + 1.0));
        for (ProgressContributor progressContributor3 : this.contributors) {
            int n4 = (int)((1.0 - progressContributor3.getCompletedRatio()) * (double)n3);
            n2 -= n4;
            progressContributor3.setAvailableParentWorkUnits(n4);
        }
        progressContributor.setAvailableParentWorkUnits(n2);
        this.contributors.add(progressContributor);
        progressContributor.setParent(this);
    }

    int getCurrentProgress() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processContributorStep(ProgressContributor progressContributor, String string, int n) {
        AggregateProgressHandle aggregateProgressHandle = this;
        synchronized (aggregateProgressHandle) {
            if (this.finished) {
                return;
            }
            this.current += n;
            this.handle.progress(string, this.current);
        }
        if (this.monitor != null) {
            this.monitor.progressed(progressContributor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processContributorStart(ProgressContributor progressContributor, String string) {
        AggregateProgressHandle aggregateProgressHandle = this;
        synchronized (aggregateProgressHandle) {
            if (this.finished) {
                return;
            }
            if (string != null) {
                this.handle.progress(string);
            }
        }
        if (this.monitor != null) {
            this.monitor.started(progressContributor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processContributorFinish(ProgressContributor progressContributor) {
        AggregateProgressHandle aggregateProgressHandle = this;
        synchronized (aggregateProgressHandle) {
            if (this.finished) {
                return;
            }
            this.contributors.remove(progressContributor);
            if (this.contributors.size() == 0) {
                this.finish();
            }
        }
        if (this.monitor != null) {
            this.monitor.finished(progressContributor);
        }
    }

    public void setMonitor(ProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
    }

    public void setDisplayName(String string) {
        this.handle.setDisplayName(string);
    }

    JComponent extractComponent() {
        return ProgressHandleFactory.createProgressComponent(this.handle);
    }

    JLabel extractDetailLabel() {
        return ProgressHandleFactory.createDetailLabelComponent(this.handle);
    }

    JLabel extractMainLabel() {
        return ProgressHandleFactory.createMainLabelComponent(this.handle);
    }
}

