/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.util.ParameterValidator;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;

public class Organizer
extends Property {
    private static final long serialVersionUID = -5216965653165090725L;
    private URI calAddress;

    public Organizer() {
        super("ORGANIZER");
    }

    public Organizer(String value) throws URISyntaxException {
        super("ORGANIZER");
        this.setValue(value);
    }

    public Organizer(ParameterList aList, String aValue) throws URISyntaxException {
        super("ORGANIZER", aList);
        this.setValue(aValue);
    }

    public Organizer(URI aUri) {
        super("ORGANIZER");
        this.calAddress = aUri;
    }

    public Organizer(ParameterList aList, URI aUri) {
        super("ORGANIZER", aList);
        this.calAddress = aUri;
    }

    public final void validate() throws ValidationException {
        ParameterValidator.getInstance().assertOneOrLess("CN", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("DIR", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("SENT-BY", this.getParameters());
        ParameterValidator.getInstance().assertOneOrLess("LANGUAGE", this.getParameters());
    }

    public final URI getCalAddress() {
        return this.calAddress;
    }

    public final void setValue(String aValue) throws URISyntaxException {
        this.calAddress = Uris.create(aValue);
    }

    public final String getValue() {
        return Uris.decode(Strings.valueOf(this.getCalAddress()));
    }

    public final void setCalAddress(URI calAddress) {
        this.calAddress = calAddress;
    }
}

