/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.actions.downloadtasks.AbstractChangesetDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetContentDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetQueryTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDetailPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDiscussionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetTagsPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.SingleChangesetDownloadPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.ChangesetQueryDialog;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesWithReferrersTask;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.StreamUtils;

public class ChangesetCacheManager
extends JFrame {
    private static volatile ChangesetCacheManager instance;
    private JTabbedPane pnlChangesetDetailTabs;
    private ChangesetCacheManagerModel model;
    private JSplitPane spContent;
    private boolean needsSplitPaneAdjustment;
    private RemoveFromCacheAction actRemoveFromCacheAction;
    private CloseSelectedChangesetsAction actCloseSelectedChangesetsAction;
    private DownloadSelectedChangesetsAction actDownloadSelectedChangesets;
    private DownloadSelectedChangesetContentAction actDownloadSelectedContent;
    private DownloadSelectedChangesetObjectsAction actDownloadSelectedChangesetObjects;
    private JTable tblChangesets;

    public static ChangesetCacheManager getInstance() {
        if (instance == null) {
            instance = new ChangesetCacheManager();
        }
        return instance;
    }

    public static void destroyInstance() {
        if (instance != null) {
            instance.setVisible(false);
            instance.dispose();
            for (Component c : ChangesetCacheManager.instance.pnlChangesetDetailTabs.getComponents()) {
                if (!(c instanceof Destroyable)) continue;
                ((Destroyable)((Object)c)).destroy();
            }
            instance = null;
        }
    }

    static ChangesetCacheManagerModel buildModel() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.setSelectionMode(2);
        return new ChangesetCacheManagerModel(selectionModel);
    }

    static JPanel buildToolbarPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        JButton btn = new JButton(new QueryAction());
        pnl.add(btn);
        pnl.add(new SingleChangesetDownloadPanel());
        pnl.add(new JButton(new DownloadMyChangesets()));
        return pnl;
    }

    static JPanel buildButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        pnl.add(new JButton(new CancelAction()));
        pnl.add(new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/ChangesetManager"))));
        return pnl;
    }

    protected JPanel buildChangesetDetailPanel() {
        JTabbedPane tp;
        JPanel pnl = new JPanel(new BorderLayout());
        this.pnlChangesetDetailTabs = tp = new JTabbedPane();
        ChangesetDetailPanel pnlChangesetDetail = new ChangesetDetailPanel();
        tp.add(pnlChangesetDetail);
        this.model.addPropertyChangeListener(pnlChangesetDetail);
        ChangesetTagsPanel pnlChangesetTags = new ChangesetTagsPanel();
        tp.add(pnlChangesetTags);
        this.model.addPropertyChangeListener(pnlChangesetTags);
        ChangesetContentPanel pnlChangesetContent = new ChangesetContentPanel();
        tp.add(pnlChangesetContent);
        this.model.addPropertyChangeListener(pnlChangesetContent);
        ChangesetDiscussionPanel pnlChangesetDiscussion = new ChangesetDiscussionPanel();
        tp.add(pnlChangesetDiscussion);
        this.model.addPropertyChangeListener(pnlChangesetDiscussion);
        tp.setTitleAt(0, I18n.tr("Properties", new Object[0]));
        tp.setToolTipTextAt(0, I18n.tr("Display the basic properties of the changeset", new Object[0]));
        tp.setTitleAt(1, I18n.tr("Tags", new Object[0]));
        tp.setToolTipTextAt(1, I18n.tr("Display the tags of the changeset", new Object[0]));
        tp.setTitleAt(2, I18n.tr("Content", new Object[0]));
        tp.setToolTipTextAt(2, I18n.tr("Display the objects created, updated, and deleted by the changeset", new Object[0]));
        tp.setTitleAt(3, I18n.tr("Discussion", new Object[0]));
        tp.setToolTipTextAt(3, I18n.tr("Display the public discussion around this changeset", new Object[0]));
        pnl.add((Component)tp, "Center");
        return pnl;
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.spContent = new JSplitPane(0);
        this.spContent.setLeftComponent(this.buildChangesetTablePanel());
        this.spContent.setRightComponent(this.buildChangesetDetailPanel());
        this.spContent.setOneTouchExpandable(true);
        this.spContent.setDividerLocation(0.5);
        pnl.add((Component)this.spContent, "Center");
        return pnl;
    }

    protected JPanel buildChangesetTableActionPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        JToolBar tb = new JToolBar(1);
        tb.setFloatable(false);
        this.model.getSelectionModel().addListSelectionListener(this.actRemoveFromCacheAction);
        tb.add(this.actRemoveFromCacheAction);
        this.model.getSelectionModel().addListSelectionListener(this.actCloseSelectedChangesetsAction);
        tb.add(this.actCloseSelectedChangesetsAction);
        this.model.getSelectionModel().addListSelectionListener(this.actDownloadSelectedChangesets);
        tb.add(this.actDownloadSelectedChangesets);
        this.model.getSelectionModel().addListSelectionListener(this.actDownloadSelectedContent);
        tb.add(this.actDownloadSelectedContent);
        this.model.getSelectionModel().addListSelectionListener(this.actDownloadSelectedChangesetObjects);
        tb.add(this.actDownloadSelectedChangesetObjects);
        pnl.add((Component)tb, "Center");
        return pnl;
    }

    protected JPanel buildChangesetTablePanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.tblChangesets = new JTable(this.model, new ChangesetCacheTableColumnModel(), this.model.getSelectionModel());
        this.tblChangesets.addMouseListener(new MouseEventHandler());
        InputMapUtils.addEnterAction(this.tblChangesets, new ShowDetailAction(this.model));
        this.model.getSelectionModel().addListSelectionListener(new ChangesetDetailViewSynchronizer(this.model));
        this.tblChangesets.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "removeFromCache");
        this.tblChangesets.getActionMap().put("removeFromCache", this.actRemoveFromCacheAction);
        pnl.add((Component)new JScrollPane(this.tblChangesets), "Center");
        pnl.add((Component)this.buildChangesetTableActionPanel(), "West");
        return pnl;
    }

    protected void build() {
        this.setTitle(I18n.tr("Changeset Management Dialog", new Object[0]));
        this.setIconImage(ImageProvider.get("dialogs/changeset", "changesetmanager").getImage());
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.model = ChangesetCacheManager.buildModel();
        this.actRemoveFromCacheAction = new RemoveFromCacheAction(this.model);
        this.actCloseSelectedChangesetsAction = new CloseSelectedChangesetsAction(this.model);
        this.actDownloadSelectedChangesets = new DownloadSelectedChangesetsAction(this.model);
        this.actDownloadSelectedContent = new DownloadSelectedChangesetContentAction(this.model);
        this.actDownloadSelectedChangesetObjects = new DownloadSelectedChangesetObjectsAction();
        cp.add((Component)ChangesetCacheManager.buildToolbarPanel(), "North");
        cp.add((Component)this.buildContentPanel(), "Center");
        cp.add((Component)ChangesetCacheManager.buildButtonPanel(), "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/ChangesetManager"));
        InputMapUtils.addEscapeAction(this.getRootPane(), new CancelAction());
        this.addWindowListener(new WindowEventHandler());
    }

    public ChangesetCacheManager() {
        this.build();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(1000, 600))).applySafe(this);
            this.needsSplitPaneAdjustment = true;
            this.model.init();
        } else if (this.isShowing()) {
            this.model.tearDown();
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public ChangesetCacheManagerModel getModel() {
        return this.model;
    }

    public void setSelectedChangesets(Collection<Changeset> changesets) {
        this.model.setSelectedChangesets(changesets);
        int idx = this.model.getSelectionModel().getMinSelectionIndex();
        if (idx < 0) {
            return;
        }
        GuiHelper.runInEDTAndWait(() -> this.tblChangesets.scrollRectToVisible(this.tblChangesets.getCellRect(idx, 0, true)));
        this.repaint();
    }

    public void setSelectedChangesetsById(Collection<Integer> ids) {
        if (ids == null) {
            this.setSelectedChangesets(null);
            return;
        }
        HashSet<Changeset> toSelect = new HashSet<Changeset>();
        ChangesetCache cc = ChangesetCache.getInstance();
        for (int id : ids) {
            if (!cc.contains(id)) continue;
            toSelect.add(cc.get(id));
        }
        this.setSelectedChangesets(toSelect);
    }

    public void setSelectedComponentInDetailPanel(Class<? extends JComponent> clazz) {
        for (Component component : this.pnlChangesetDetailTabs.getComponents()) {
            if (!component.getClass().equals(clazz)) continue;
            this.pnlChangesetDetailTabs.setSelectedComponent(component);
            break;
        }
    }

    public void runDownloadTask(AbstractChangesetDownloadTask task) {
        MainApplication.worker.submit(new PostDownloadHandler(task, task.download()));
        MainApplication.worker.submit(() -> {
            if (task.isCanceled() || task.isFailed()) {
                return;
            }
            GuiHelper.runInEDT(() -> this.setSelectedChangesets((Collection)task.getDownloadedData()));
        });
    }

    static class ChangesetDetailViewSynchronizer
    implements ListSelectionListener {
        private final ChangesetCacheManagerModel model;

        ChangesetDetailViewSynchronizer(ChangesetCacheManagerModel model) {
            this.model = model;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            List<Changeset> selected = this.model.getSelectedChangesets();
            if (selected.size() == 1) {
                this.model.setChangesetInDetailView(selected.get(0));
            } else {
                this.model.setChangesetInDetailView(null);
            }
        }
    }

    class ChangesetTablePopupMenu
    extends JPopupMenu {
        ChangesetTablePopupMenu() {
            this.add(ChangesetCacheManager.this.actRemoveFromCacheAction);
            this.add(ChangesetCacheManager.this.actCloseSelectedChangesetsAction);
            this.add(ChangesetCacheManager.this.actDownloadSelectedChangesets);
            this.add(ChangesetCacheManager.this.actDownloadSelectedContent);
            this.add(ChangesetCacheManager.this.actDownloadSelectedChangesetObjects);
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        MouseEventHandler() {
            super(new ChangesetTablePopupMenu());
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (MouseEventHandler.isDoubleClick(evt)) {
                new ShowDetailAction(ChangesetCacheManager.this.model).showDetails();
            }
        }
    }

    static class DownloadMyChangesets
    extends AbstractAction {
        DownloadMyChangesets() {
            this.putValue("Name", I18n.tr("My changesets", new Object[0]));
            new ImageProvider("dialogs/changeset", "downloadchangeset").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Download my changesets from the OSM server (max. 100 changesets)", new Object[0]));
            this.setEnabled(!NetworkManager.isOffline(OnlineResource.OSM_API));
        }

        protected void alertAnonymousUser(Component parent) {
            HelpAwareOptionPane.showOptionDialog(parent, I18n.tr("<html>JOSM is currently running with an anonymous user. It cannot download<br>your changesets from the OSM server unless you enter your OSM user name<br>in the JOSM preferences.</html>", new Object[0]), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetManager#CanDownloadMyChangesets"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window parent = GuiHelper.getWindowAncestorFor(e);
            try {
                ChangesetQuery query = ChangesetQuery.forCurrentUser();
                if (!GraphicsEnvironment.isHeadless()) {
                    ChangesetCacheManager.getInstance().runDownloadTask(new ChangesetQueryTask(parent, query));
                }
            }
            catch (IllegalStateException ex) {
                this.alertAnonymousUser(parent);
                Logging.trace(ex);
            }
        }
    }

    static class ShowDetailAction
    extends AbstractAction {
        private final ChangesetCacheManagerModel model;

        ShowDetailAction(ChangesetCacheManagerModel model) {
            this.model = model;
        }

        protected void showDetails() {
            List<Changeset> selected = this.model.getSelectedChangesets();
            if (selected.size() == 1) {
                this.model.setChangesetInDetailView(selected.get(0));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.showDetails();
        }
    }

    private class DownloadSelectedChangesetObjectsAction
    extends AbstractAction
    implements ListSelectionListener {
        DownloadSelectedChangesetObjectsAction() {
            this.putValue("Name", I18n.tr("Download changed objects", new Object[0]));
            new ImageProvider("downloadprimitive").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Download the current version of the changed objects in the selected changesets", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GraphicsEnvironment.isHeadless()) {
                ChangesetCacheManager.this.actDownloadSelectedContent.actionPerformed(e);
                MainApplication.worker.submit(() -> {
                    List<PrimitiveId> primitiveIds = ChangesetCacheManager.this.model.getSelectedChangesets().stream().map(Changeset::getContent).filter(Objects::nonNull).flatMap(content -> StreamUtils.toStream(content::iterator)).map(ChangesetDataSet.ChangesetDataSetEntry::getPrimitive).map(HistoryOsmPrimitive::getPrimitiveId).distinct().collect(Collectors.toList());
                    new DownloadPrimitivesWithReferrersTask(false, primitiveIds, true, true, null, null).run();
                });
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetCacheManager.this.model.hasSelectedChangesets() && !NetworkManager.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    static class DownloadSelectedChangesetContentAction
    extends AbstractAction
    implements ListSelectionListener {
        private final ChangesetCacheManagerModel model;

        DownloadSelectedChangesetContentAction(ChangesetCacheManagerModel model) {
            this.putValue("Name", I18n.tr("Download changeset content", new Object[0]));
            new ImageProvider("dialogs/changeset", "downloadchangesetcontent").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Download the content of the selected changesets from the server", new Object[0]));
            this.model = model;
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GraphicsEnvironment.isHeadless()) {
                ChangesetCacheManager.getInstance().runDownloadTask(new ChangesetContentDownloadTask((Component)GuiHelper.getWindowAncestorFor(e), this.model.getSelectedChangesetIds()));
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(this.model.hasSelectedChangesets() && !NetworkManager.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    static class DownloadSelectedChangesetsAction
    extends AbstractAction
    implements ListSelectionListener {
        private final ChangesetCacheManagerModel model;

        DownloadSelectedChangesetsAction(ChangesetCacheManagerModel model) {
            this.putValue("Name", I18n.tr("Update changeset", new Object[0]));
            new ImageProvider("dialogs/changeset", "updatechangeset").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Updates the selected changesets with current data from the OSM server", new Object[0]));
            this.model = model;
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GraphicsEnvironment.isHeadless()) {
                ChangesetCacheManager.getInstance().runDownloadTask(ChangesetHeaderDownloadTask.buildTaskForChangesets(GuiHelper.getWindowAncestorFor(e), this.model.getSelectedChangesets()));
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(this.model.hasSelectedChangesets() && !NetworkManager.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    static class CloseSelectedChangesetsAction
    extends AbstractAction
    implements ListSelectionListener {
        private final ChangesetCacheManagerModel model;

        CloseSelectedChangesetsAction(ChangesetCacheManagerModel model) {
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            new ImageProvider("closechangeset").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Close the selected changesets", new Object[0]));
            this.model = model;
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainApplication.worker.submit(new CloseChangesetTask(this.model.getSelectedChangesets()));
        }

        protected void updateEnabledState() {
            List<Changeset> selected = this.model.getSelectedChangesets();
            UserIdentityManager im = UserIdentityManager.getInstance();
            for (Changeset cs : selected) {
                if (!cs.isOpen()) continue;
                if (im.isPartiallyIdentified() && cs.getUser() != null && cs.getUser().getName().equals(im.getUserName())) {
                    this.setEnabled(true);
                    return;
                }
                if (!im.isFullyIdentified() || cs.getUser() == null || cs.getUser().getId() != (long)im.getUserId()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    static class RemoveFromCacheAction
    extends AbstractAction
    implements ListSelectionListener {
        private final ChangesetCacheManagerModel model;

        RemoveFromCacheAction(ChangesetCacheManagerModel model) {
            this.putValue("Name", I18n.tr("Remove from cache", new Object[0]));
            new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Remove the selected changesets from the local cache", new Object[0]));
            this.model = model;
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChangesetCache.getInstance().remove(this.model.getSelectedChangesets());
        }

        protected void updateEnabledState() {
            this.setEnabled(this.model.hasSelectedChangesets());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    static class QueryAction
    extends AbstractAction {
        QueryAction() {
            this.putValue("Name", I18n.tr("Query", new Object[0]));
            new ImageProvider("dialogs", "search").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Launch the dialog for querying changesets", new Object[0]));
            this.setEnabled(!NetworkManager.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Window parent = GuiHelper.getWindowAncestorFor(evt);
            ChangesetQueryDialog dialog = new ChangesetQueryDialog(parent);
            dialog.initForUserInput();
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return;
            }
            try {
                ChangesetQuery query = dialog.getChangesetQuery();
                if (query != null) {
                    ChangesetCacheManager.getInstance().runDownloadTask(new ChangesetQueryTask(parent, query));
                }
            }
            catch (IllegalStateException e) {
                Logging.error(e);
                JOptionPane.showMessageDialog(parent, e.getMessage(), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    static class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Close the dialog", new Object[0]));
        }

        public void cancelAndClose() {
            ChangesetCacheManager.destroyInstance();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancelAndClose();
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            new CancelAction().cancelAndClose();
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (ChangesetCacheManager.this.needsSplitPaneAdjustment) {
                ChangesetCacheManager.this.spContent.setDividerLocation(0.5);
                ChangesetCacheManager.this.needsSplitPaneAdjustment = false;
            }
        }
    }
}

