# Typing lessons in spanish to be used with GNU Typist
# Copyright (C) 2000  Igor Támara (ikks@bigfoot.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

*:COMIENZO
B:Lecciones de manejo de teclado en español para GNU Typist
T:
 :
 :Bienvenido a las lecciones de manejo de teclado.
 :
 :Estas lecciones se usan con el programa Typist de Simon Baldwin, han sido
 :adaptadas de las lecciones de Gregg y modificadas por Igor Támara, Vladimir
 :Támara y Melissa Giraldo.
 :
 :  Febrero-Agosto de 2000. Bogotá Colombia

*:MENU_PRINCIPAL
M: "Menú principal"
 :LECCION_1  "Lección 1 Teclas guía"
 :LECCION_2  "Lección 2 Teclas cercanas   H E O"
 :LECCION_3  "Lección 3 Más teclas nuevas N R I"
 :LECCION_4  "Lección 4 Dominando lo aprendido"
 :LECCION_5  "Lección 5 Nuevas Teclas     T C Mayúscula derecha"
 :LECCION_6  "Lección 6 Nuevas Teclas     M G . (Punto)"
 :LECCION_7  "Lección 7 Nuevas Teclas     Q U Mayúscula izquierda"
 :LECCION_8  "Lección 8 Dominando lo aprendido"
 :LECCION_9  "Lección 9 Nuevas Teclas     W V ' (Tilde o acento)"
 :LECCION_10 "Lección 10 Nuevas Teclas    P B , (Coma)"
 :LECCION_11 "Lección 11 Nuevas teclas          X Y"
 :LECCION_12 "Lección 12 Nuevas teclas          Z : ;"
 :LECCION_13 "Lección 13 Nuevas teclas (Dobles) RR LL NN CC"
 :LECCION_14 "Lección 14 Practicando lo aprendido"
 :LECCION_15 "Lección 15 Mezclando Números      0 1 2 ... 9"
 :LECCION_16 "Lección 16 Algo de LaTeX          $ { } \ [ ] _ ^"
 :LECCION_17 "Lección 17 Algo de HTML           < > & " ? !"
 :LECCION_18 "Lección 18 Algo de Texinfo        # | @"
 :LECCION_19 "Lección 19 Literatura"
 :VELOCIDAD  "Evaluación de velocidad"
 :PRECISION  "Evaluación de precisión"
 :AYUDA      "Ayuda: Metodología de las Lecciones"


*:AYUDA
# NOTE: fkeys are deprecated
# B:Ayuda de las teclas
# T:
#  :                      Ayuda de las teclas de función
#  :
#  :Use las teclas de función del teclado para navegar a través de las lecciones
#  :y menús de selección de lecciones.  En una serie de lecciones presionando la
#  :tecla Fkey12 lo hará volver al menú de series; Cuando está en el menú
#  :de series, esta lo llevará al menú principal del programa.  En el menú princi-
#  :pal del programa, Fkey12 hace que salga de Typist.
#  :
#  :Si una serie de lecciones tiene más de una hoja de menú de lecciones use la
#  :tecla F11Key para ir a las páginas adicionales.
#  :
#  :Cuando está en un ejercicio, puede usar la tecla Esc para salir de la rutina
#  :o el test.
#  :
#  :Si no tiene teclas de función disponibles en su terminal, o  si no trabajan
#  :por alguna razón (Por ejemplo, otro programa las está interceptando), puede
#  :usar las teclas 1 a 9 como F1 a F9, 0 como F10, A como F11 y S como F12.
#  :Algunas combinaciones con la tecla Ctrl también sirven:  Ctrl-Q a Ctrl-P son
#  :teclas alternativas para Fkey1 a Fkey10, y Ctrl-A y Ctrl-S para Fkey11 y Fkey12.
B:Metodología de las Lecciones
T:
 :                           Uso de las lecciones
 :
 :Las lecciones se componen generalmente de tres secciones:
 :
 :La primera corresponde a instrucciones iniciales sobre la lección, donde se
 :puede introducir nuevas teclas o enunciar la metodología empleada,
 :por ejemplo indicando si se aceptan errores durante la misma o no.
 :
 :La segunda corresponde a la práctica de la lección, donde hacen ejercicios que
 :sirven como preparación para lo que se espera evaluar.
 :
 :La tercera sección es la evaluación de lo aprendido durante las lecciones ante-
 :riores.  Esta es la que servirá para hacer el control de la lección, traerá
 :instrucciones de cuáles son los requisitos para que esta sea aprobada.
 :
Q: Presione Y para continuar
Y:MENU_PRINCIPAL
G:AYUDA

*:LECCION_1

*:MENU_LECCION_1
M: UP=MENU_PRINCIPAL "Lección 1 - Teclas Guía"
 :INSTRUCCIONES_LECCION_1 "Instrucciones"
 :PRACTICA_LECCION_1      "Práctica"
 :EVALUACION_LECCION_1    "Evaluación"

*:INSTRUCCIONES_LECCION_1
B:INDICACIONES INICIALES
T:Los dedos deben estar ubicados sobre las teclas guías; se debe evitar colocar
 :las muñecas sobre el teclado, a menos que este tenga una base diseñada para
 :tal efecto.
 :
 :La mano izquierda debe estar posicionada de la siguiente forma: el meñique
 :sobre la tecla A, el anular sobre la tecla S, el del corazón sobre la D, el
 :índice sobre la F.  La mano derecha por su parte debe tener la siguiente dis-
 :posición: el índice sobre la J, el del corazón sobre la K, el anular sobre la
 :L, y el meñique sobre la Ñ en un teclado español o latinoamericano. El dedo
 :pulgar de la mano derecha debe descansar sobre la barra espaciadora.
 :
 :Los dedos deben estar ligeramente curvados, encima de las teclas guías, un
 :teclado como el que está usando es lo suficientemente sensible como para que
 :a la leve presión de sus dedos se active la tecla y obtenga una respuesta.
 :

*:PRACTICA_LECCION_1
B:Ejercicio de teclas guías
s:fff ff f jjj jj j fff jj f jjj ff j f j
 :ddd dd d kkk kk k ddd kk d kkk dd k d k
 :sss ss s lll ll l sss ll s lll ss l s l
 :aaa aa a ñññ ññ ñ aaa ññ a ñññ aa ñ a ñ

B:Ejercicio de aplicación
s:la asa ala al sal sala da ada dada a las
 :ja aja aja fa afa faja ja aja laja l ala
 :ña aña aña da aña daña la ala daña dañas

B:Comprobación de progreso
s:la sal las alas al aja faja daña sala la
 :da das ada dad la sal laja faja alas dad

*:EVALUACION_LECCION_1
B:Evaluación Lección 1.
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 :por lo menos 30 con un porcentaje de errores menor al 5%.
E:5%
F:MENU_LECCION_1
S:fff ff f jjj jj j fff jj f jjj ff j f j
 :ddd dd d kkk kk k ddd kk d kkk dd k d k
 :sss ss s lll ll l sss ll s lll ss l s l
 :aaa aa a ñññ ññ ñ aaa ññ a ñññ aa ñ a ñ
 :la asa ala al sal sala da ada dada a las
 :ja aja aja fa afa faja ja aja laja l ala
 :ña aña aña da aña daña la ala daña dañas
 :la sal las alas al aja faja daña sala la
 :da das ada dad la sal laja faja alas dad

G:LECCION_1

*:LECCION_2
*:MENU_LECCION_2
M: UP=MENU_PRINCIPAL "Lección 2 - Teclas cercana H E O"
 :INSTRUCCIONES_LECCION_2 "Instrucciones"
 :PRACTICA_LECCION_2      "Práctica"
 :EVALUACION_LECCION_2    "Evaluación"

*:INSTRUCCIONES_LECCION_2
B:NUEVAS TECLAS H E O
T:La tecla H se pulsa con el dedo índice derecho, esto es, el dedo de la J.
 :Cuando oprima esta tecla, trate de mantener los otros tres dedos de la misma
 :mano sobre sus teclas guías, K, L y Ñ, como se le indicó en las instrucciones
 :de la lección 1.
 :
 :La tecla E se pulsa con el dedo corazón de la mano izquierda, esto es, el dedo
 :de la D. De nuevo como se mencionó antes, trate de mantener el resto de los
 :dedos de dicha mano sobre las teclas guías A, S y F.
 :
 :La tecla O se pulsa con el dedo anular de la mano derecha, el dedo que tiene
 :como tecla guía la L.  Mantenga el resto de dedos de dicha mano sobre las te-
 :clas guías, J, K y Ñ.
*:PRACTICA_LECCION_2
B:Ejercicio de práctica
I:Práctica de las teclas guías.
s:a as asd asdf j jk jkl jklñ s sa sal las
 :a as asd asdf j jk jkl jklñ s sa sal las
 :f fa faj faja j ja jal jala j as aja ala
 :f fa faj faja j ja jal jala j as aja ala
 :d da dal dala k jk kal sala s sa sal asa
 :d da dal dala k jk kal sala s sa sal asa

B:Práctica de nuevas teclas
s:jh jhj hjh ha has hada ah hal hala ha ah
 :de ded ede de ele leal le lea leal de le
 :lo lol olo ol oso dado do los osos do lo

B:Ejercicio de aplicación
s:el es de ese de esa de la del oso a ella
 :el es de ese de esa de la del oso a ella
 :ha de he dado esos dos de los dos de ese
 :ha de he dado esos dos de los dos de ese
 :el de le da le ha dado esos dos de sedas
 :el de le da le ha dado esos dos de sedas

B:Comprobación de progreso
s:el oso ha dado es de seda es leal de las
 :los dos es de ella el ala es de los osos
 :el sol sale la sal dale los dos es osado

*:EVALUACION_LECCION_2
B:Evaluación Lección 2.
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 31 con un porcentaje de errores inferior al 5%.
E:5%
F:MENU_LECCION_2
S:a as asd asdf j jk jkl jklñ s sa sal las
 :a as asd asdf j jk jkl jklñ s sa sal las
 :f fa faj faja j ja jal jala j as aja ala
 :f fa faj faja j ja jal jala j as aja ala
 :d da dal dala k jk kal sala s sa sal asa
 :d da dal dala k jk kal sala s sa sal asa
 :jh jhj hjh ha has hada ah hal hala ha ah
 :de ded ede de ele leal le lea leal de le
 :lo lol olo ol oso dado do los osos do lo
 :el es de ese de esa de la del oso a ella
 :el es de ese de esa de la del oso a ella
 :ha de he dado esos dos de los dos de ese
 :ha de he dado esos dos de los dos de ese
 :el de le da le ha dado esos dos de sedas
 :el de le da le ha dado esos dos de sedas
 :el oso ha dado es de seda es leal de las
 :los dos es de ella el ala es de los osos
 :el sol sale la sal dale los dos es osado
G:LECCION_2


*:LECCION_3
*:MENU_LECCION_3
M: UP=MENU_PRINCIPAL "Lección 3 - Más teclas nuevas N R I"
 :INSTRUCCIONES_LECCION_3 "Instrucciones"
 :PRACTICA_LECCION_3      "Práctica"
 :EVALUACION_LECCION_3    "Evaluación"

*:INSTRUCCIONES_LECCION_3
B:NUEVAS TECLAS N R I
T:La tecla N se pulsa con el dedo índice derecho, esto es, el dedo de la J.
 :Cuando oprima esta tecla, trate de mantener los otros tres dedos de la misma
 :mano sobre sus teclas guías, K, L y Ñ.
 :
 :La tecla R se pulsa con el dedo índice de la mano izquierda, esto es, el dedo
 :de la F. Mantenga el resto de los dedos de dicha mano sobre las teclas guías
 :A, S y D.
 :
 :La tecla I se pulsa con el dedo medio de la mano derecha, el dedo que tiene
 :como tecla guía la K.  Mantenga el resto de dedos de dicha mano sobre las te-
 :clas guías, J, L y Ñ.


*:PRACTICA_LECCION_3
B:Ejercicio de práctica
I:Práctica de las teclas aprendidas.
s:j jf jfk jfkl ñ añ aña daña l la las faja
 :j jf jfk jfkl ñ añ aña daña l la las faja
 :e le lea leal j je eje deje a ja aje ajos
 :e le lea leal j je eje deje a ja aje ajos
 :a el los ojos e de del dedo h ah has hado
 :a el los ojos e de del dedo h ah has hado

B:Práctica de nuevas teclas
s:jn jnj nen en ene nene no son nada n nos
 :fr frf ere er oro risa re res risa r oro
 :ki iki kik ki kil kilo fi fin fina i fin


B:Ejercicio de aplicación
s:no son nene en don dedo donde ni fin lino
 :re oro rana ir res reir reloj ar aro raro
 :id ida lila si sin idea hijas de dio risa
 :es reo el niño la flor da risa el nene si

B:Comprobación de progreso
s:la flor es rosa es linda la risa del niño
 :esa fresa es de la niña esa doña ese nene
 :el hijo esa flor es de es de oro a el reo

*:EVALUACION_LECCION_3
B:Evaluación Lección 3.
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 32, con un porcentaje de error inferior al 4%.
E:4%
F:MENU_LECCION_3
S:j jf jfk jfkl ñ añ aña daña l la las faja
 :j jf jfk jfkl ñ añ aña daña l la las faja
 :e le lea leal j je eje deje a ja aje ajos
 :e le lea leal j je eje deje a ja aje ajos
 :a el los ojos e de del dedo h ah has hado
 :a el los ojos e de del dedo h ah has hado
 :jn jnj nen en ene nene no son nada n nos
 :fr frf ere er oro risa re res risa r oro
 :ki iki kik ki kil kilo fi fin fina i fin
 :no son nene en don dedo donde ni lin lino
 :re oro rana ir res reir reloj ar aro raro
 :id ida lila si sin idea hijas de dio risa
 :es reo el niño la flor da risa el nene si
 :la flor es rosa es linda la risa del niño
 :esa fresa es de la niña esa doña ese nene
 :el hijo esa flor es de es de oro a el reo

G:LECCION_3

*:LECCION_4
*:MENU_LECCION_4
M: UP=MENU_PRINCIPAL "Lección 4 - Dominando lo aprendido"
 :PRACTICA_LECCION_4_1 "Práctica 1"
 :PRACTICA_LECCION_4_2 "Práctica 2"
 :EVALUACION_LECCION_4 "Evaluación"

*:PRACTICA_LECCION_4_1
B:Práctica lección 4
I:Repaso de lo aprendido en lecciones anteriores
s:fdsa jklñ fdsa jklñ asdf ñlkj fdsa jklñ
 :fdsa jklñ fdsa jklñ asdf ñlkj fdsa jklñ
 :da sa ja la as al ña da sa fa la as ala
 :da sa ja la as al ña da sa fa la as ala
 :das sal asa ala sala daña alas faja las
 :das sal asa ala sala daña alas faja las
B:Práctica Lección 4
I:Refuerzo de destreza
s:de el es ded ded ese dedo nene eje dele
 :de el es ded ded ese dedo nene eje dele
 :lo ol or olo lol sol solo oler oro ojos
 :lo ol or olo lol sol solo oler oro ojos
 :jn no en son ene fin niño nene sin sino
 :jn no en son ene fin niño nene sin sino
B:Práctica Lección 4
I:Aún más práctica
s:ki ik si rin nin iri risa hija fin kilo
 :ki ik si rin nin iri risa hija fin kilo
 :ha he hj has hol jhj hola hoja has hija
 :ha he hj has hol jhj hola hoja has hija
 :re ri ra ere fre oro loro rosa res risa
 :re ri ra ere fre oro loro rosa res risa

*:PRACTICA_LECCION_4_2
B:Práctica Lección 4
I:Técnica de espaciado
s:a ñ s l d k f j h a ñ s l d k f j h a ñ
 :a ñ s l d k f j h a ñ s l d k f j h a ñ
 :as df jk lñ as df jk lñ jh jn de lo iki
 :as df jk lñ as df jk lñ jh jn de lo iki
 :las eje asa leo sal los olo oro del ese
 :las eje asa leo sal los olo oro del ese
 :hola hijo risa niño solo hija dale sino
 :hola hijo risa niño solo hija dale sino
B:Práctica Lección 4
I:Técnica de retorno
s:de la de las a esa de oro en la
 :la
 :sala en ese son de la hora
 :al lado
 :ese horno en serie el fin
 :de donde
B:Práctica Lección 4
I:Comprobación de progreso
s:a la sal lisa salir e de eje dele desde
 :o lo sol solo sordo i si fin fina frisa
 :h ha has hijo horno r ir era reir reina
 :n no son nene niños f fe efe faja fresa

*:EVALUACION_LECCION_4
B:Evaluación Lección 4
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 33 con un porcentaje de error inferior al 4%.
E:4%
F:MENU_LECCION_4
S:fdsa jklñ fdsa jklñ asdf ñlkj fdsa jklñ
 :fdsa jklñ fdsa jklñ asdf ñlkj fdsa jklñ
 :da sa ja la as al ña da sa fa la as ala
 :da sa ja la as al ña da sa fa la as ala
 :das sal asa ala sala daña alas faja las
 :das sal asa ala sala daña alas faja las
 :de el es ded ded ese dedo nene eje dele
 :lo ol or olo lol sol solo oler oro ojos
 :jn no en son ene fin niño nene sin sino
 :ki ik si rin nin iri risa hija fin kilo
 :ha he hj has hol jhj hola hoja has hija
 :re ri ra ere fre oro loro rosa res risa
 :a ñ s l d k f j h a ñ s l d k f j h a ñ
 :as df jk lñ as df jk lñ jh jn de lo iki
 :las eje asa leo sal los olo oro del ese
 :hola hijo risa niño solo hija dale sino
 :a la sal lisa salir e de eje dele desde
 :o lo sol solo sordo i si fin fina frisa
 :h ha has hijo horno r ir era reir reina
 :n no son nene niños f fe efe faja fresa
G:LECCION_4


*:LECCION_5
*:MENU_LECCION_5
M: UP=MENU_PRINCIPAL "Lección 5 - Nuevas teclas T C Mayúscula Derecha"
 :INSTRUCCIONES_LECCION_5 "Instrucciones"
 :PRACTICA_LECCION_5      "Práctica"
 :EVALUACION_LECCION_5    "Evaluación"

*:INSTRUCCIONES_LECCION_5
B:NUEVAS TECLAS: T C Mayúscula derecha
T:La tecla T se pulsa con el dedo índice izquierdo, esto es, el dedo de la F.
 :Cuando oprima esta tecla, trate de mantener los otros tres dedos de la misma
 :mano sobre sus teclas guías, A, S y D.
 :
 :La tecla C se pulsa con el dedo medio de la mano izquierda, esto es, el dedo
 :de la D. Mantenga el resto de los dedos de dicha mano sobre las teclas guías
 :A, S y F.
 :
 :Presione la tecla de la mayúscula derecha con el dedo meñique derecho, esto
 :es el dedo de la Ñ.  Mantenga el dedo de la J sobre la tecla guía.

*:PRACTICA_LECCION_5
B:Práctica Lección 5
I:Ejercicio de práctica
s:a la sal sala f fa fas faja e es ese seda
 :d de del dedo l lo los solo j je eje ojos
 :ñ ña año daño n no nos niño r re ere reir
B:Lección 5
I:Práctica con teclas nuevas
s:ftf ft t fff ft t ttt ft f tel ta t ata
 :dcd dc c cdc cd c ccc dc e ced ca c aca
 :AaA Sara Dora Ff Ada El R Roa Ca C Aida
 :ft tal tan te tel tela at ata atar todo
 :Al Ada Ana Ed Esa Elsa Te Ter Tere Seda
B:Lección 5
I:Ejercicio de aplicación(Teclas nuevas)
s:la casa esta cerca de teja en la tarde te
 :Es tarde cerca de  ha de cantar teje en la
 :Ana es casa de calle dos Tere Salas carta
 :t ta tal tela tarde te ten teje tejas tan
 :c ca cal cala calle ce ced cede cerca Cid
 :Tere teje en la calle en la casa Ada tina

*:EVALUACION_LECCION_5
B:Evaluación Lección 5
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 34 con un porcentaje de error inferior al 3%.
E:3%
F:MENU_LECCION_5
S:a la sal sala f fa fas faja e es ese seda
 :a la sal sala f fa fas faja e es ese seda
 :d de del dedo l lo los solo j je eje ojos
 :d de del dedo l lo los solo j je eje ojos
 :ñ ña año daño n no nos niño r re ere reir
 :ñ ña año daño n no nos niño r re ere reir
 :la casa esta cerca de teja en la tarde te
 :la casa esta cerca de teja en la tarde te
 :Es tarde cerca de  ha de cantar teje en la
 :Es tarde cerca de  ha de cantar teje en la
 :Ana es casa de calle dos Tere Salas carta
 :Ana es casa de calle dos Tere Salas carta
 :t ta tal tela tarde te ten teje tejas tan
 :c ca cal cala calle ce ced cede cerca Cid
 :Tere teje en la calle en la casa Ada tina

G:LECCION_5

*:LECCION_6
*:MENU_LECCION_6
M: UP=MENU_PRINCIPAL "Lección 6 - Nuevas teclas M G . (Punto)"
 :INSTRUCCIONES_LECCION_6 "Instrucciones"
 :PRACTICA_LECCION_6      "Práctica"
 :EVALUACION_LECCION_6    "Evaluación"

*:INSTRUCCIONES_LECCION_6
B:NUEVAS TECLAS: M G y . (Punto)
T:La tecla M se pulsa con el dedo índice derecho, esto es, el dedo de la J.
 :Cuando oprima esta tecla, trate de mantener los otros tres dedos de la misma
 :mano sobre sus teclas guías, K, L y Ñ.
 :
 :La tecla G se pulsa con el dedo indice de la mano izquierda, esto es, el dedo
 :de la F. Mantenga el resto de los dedos de dicha mano sobre las teclas guías
 :A, S y D.
 :
 :Presione la tecla del punto (.) con el dedo anular de la mano izquierda, esto
 :es el dedo de la L.  Mantenga el resto de los dedos de la misma manos sobre
 :las teclas guías.

*:PRACTICA_LECCION_6
B:Lección 6
I:Ejercicio de práctica
s:f fr efe faja fresa fiesta r re reo reir
 :f fr efe faja fresa fiesta r re reo reir
 :j jn eje hijo hiena nietas h ha has hiel
 :j jn eje hijo hiena nietas h ha has hiel
 :A Da Ana Fela Elisa Teresa s Sa Sol Sosa
 :A Da Ana Fela Elisa Teresa s Sa Sol Sosa
B:Lección 6
I:Práctica con nuevas teclas
s:jmj mj m mmm jj m mas me m mes mi j eme
 :fgf gg f gfg gf g gas ga g gas go g gol
 :1.1.1. . Dr. Sr. l.l. f. a lll l. l Sra.
 :j jm mas masa mes meses manos maja mente
 :g fg gas gasa gente grato gran gol golfoe
 :Esa frase es larga.  Ana ha de ir lejos.
B:Lección 6
I:Ejercicio de aplicación
s:m me eme mesa monte mismo mina mos mime
 :g gr gra gran grana gente gala gas gago
 :Eta desea ir a la gran fiesta de Carla.
 :Flor ha de ir al monte con Carla mañana.
 :Esa fiesta de Elisa Gago es en el monte.
 :Tere S. Salas desea ir sola a ese hotel.

*:EVALUACION_LECCION_6
B:Evaluación Lección 6
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 35 con un porcentaje de error inferior al 3%.
E:3%
F:MENU_LECCION_6
S:jmj mj m mmm jj m mas me m mes mi j eme
 :jmj mj m mmm jj m mas me m mes mi j eme
 :fgf gg f gfg gf g gas ga g gas go g gol
 :fgf gg f gfg gf g gas ga g gas go g gol
 :1.1.1. . Dr. Sr. l.l. f. a lll l. l Sra.
 :1.1.1. . Dr. Sr. l.l. f. a lll l. l Sra.
 :j jm mas masa mes meses manos maja mente
 :j jm mas masa mes meses manos maja mente
 :g fg gas gasa gente grato gran gol golfoe
 :g fg gas gasa gente grato gran gol golfoe
 :Esa frase es larga.  Ana ha de ir lejos.
 :Esa frase es larga.  Ana ha de ir lejos.
 :m me eme mesa monte mismo mina mos mime
 :g gr gra gran grana gente gala gas gago
 :Eta desea ir a la gran fiesta de Carla.
 :Flor ha de ir al monte con Carla mañana.
 :Esa fiesta de Elisa Gago es en el monte.
 :Tere S. Salas desea ir sola a ese hotel.

G:LECCION_6

*:LECCION_7
*:MENU_LECCION_7
M: UP=MENU_PRINCIPAL "Lección 7 - Nuevas Teclas Q U Mayúscula izquierda"
 :INSTRUCCIONES_LECCION_7 "Instrucciones"
 :PRACTICA_LECCION_7      "Práctica"
 :EVALUACION_LECCION_7    "Evaluación"

*:INSTRUCCIONES_LECCION_7
B:NUEVAS TECLAS: Q U Mayúscula izquierda
T:La tecla Q se pulsa con el dedo meñique izquierdo, esto es, el dedo de la A.
 :Cuando oprima esta tecla, trate de mantener los otros tres dedos de la misma
 :mano sobre sus teclas guías, S, D y F.
 :
 :La tecla U se pulsa con el dedo índice de la mano derecha, esto es, el dedo
 :de la J. Mantenga el resto de los dedos de dicha mano sobre las teclas guías
 :K, L y Ñ.
 :
 :Presione la tecla de la mayúscula izquierda con el dedo meñique izquierdo, esto
 :es el dedo de la A.  Mantenga el dedo de la F sobre la tecla guía.

*:PRACTICA_LECCION_7
B:Lección 7
I:Ejercicio de práctica
s:g gr gri gris grasa grande j ja eje laja
 :g gr gri gris grasa grande j ja eje laja
 :m mj mas maja meses mentor a al ala sala
 :m mj mas maja meses mentor a al ala sala
 :El señor Amador es maestro de Elsa Gala.
 :El señor Amador es maestro de Elsa Gala.
B:Lección 7
I:Práctica con nuevas teclas
s:aqa aq q qqq qa aqa qa q aaa qa q aqa
 :juj uj u uuu ju u juj uj u juj ju juj
 :Jaj La L Lola Ll J Juj Juan Jul Julio
 :q qa que quie quien quiere Quito Quique
 :u tu tut tute urnas Ulises usado usa su
 :Juan quiere leer el Quijote en su casa.
B:Lección 7
I:Ejercicio con nuevas teclas
s:si tu que quiere con que cuando es en su
 :dile quien es ella quiere como es que tu
 :Juan quiere su quilate al salir de Quito.
 :A Juana le gusta leer el Quijote en Quito.
 :La maestra de Luis quiere usar la quesera.
 :Me gusta jugar tute. Julio quiere a Elsa.

*:EVALUACION_LECCION_7
B:Evaluación Lección 7
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 36 con un porcentaje de error inferior al 3%.
E:3%
F:MENU_LECCION_7
S:aqa aq q qqq qa aqa qa q aaa qa q aqa
 :juj uj u uuu ju u juj uj u juj ju juj
 :Jaj La L Lola Ll J Juj Juan Jul Julio
 :q qa que quie quien quiere Quito Quique
 :u tu tut tute urnas Ulises usado usa su
 :Juan quiere leer el Quijote en su casa.
 :si tu que quiere con que cuando es en su
 :si tu que quiere con que cuando es en su
 :dile quien es ella quiere como es que tu
 :dile quien es ella quiere como es que tu
 :Juan quiere su quilate al salir de Quito.
 :Juan quiere su quilate al salir de Quito.
 :A Juana le gusta leer el Quijote en Quito.
 :A Juana le gusta leer el Quijote en Quito.
 :La maestra de Luis quiere usar la quesera.
 :La maestra de Luis quiere usar la quesera.
 :Me gusta jugar tute. Julio quiere a Elsa.
 :Me gusta jugar tute. Julio quiere a Elsa.

G:LECCION_7

*:LECCION_8
*:MENU_LECCION_8
M: UP=MENU_PRINCIPAL "Lección 8 - Dominando lo aprendido"
 :PRACTICA_LECCION_8_1 "Práctica 1"
 :PRACTICA_LECCION_8_2 "Práctica 2"
 :EVALUACION_LECCION_8 "Evaluación"

*:PRACTICA_LECCION_8_1
B:Repaso de lo aprendido en lecciones anteriores
s:a q s d e c f r t g h j u n m k i l o ñ
 :a q s d e c f r t g h j u n m k i l o ñ
 :asd dec frg frt jhn jum kil lo. año uña
 :asd dec frg frt jhn jum kil lo. año uña
 :Un kilo de queso. Nin te trae su tarea.
 :Un kilo de queso. Nin te trae su tarea.
 :ta tala te tela ti tilo to toro tu tute
 :ta tala te tela ti tilo to toro tu tute
B:Lección 8 Parte 1
I:Refuerzo
s:ca cada ce cede ci cine co codo cu cuan
 :ca cada ce cede ci cine co codo cu cuan
 :ma malo me memo mi miel mo moda mu mula
 :ma malo me memo mi miel mo moda mu mula
 :ga gato ge gema gi giro go gota gu gula
 :ga gato ge gema gi giro go gota gu gula
B:Lección 8 Parte 1
I:Más práctica
s:El hilo no sale.
 :El kilo de queso es de Rosa.
 :Esa gema es de Linda y de Lina.
 :El hijo de Luis se queda con ella.

*:PRACTICA_LECCION_8_2
B:Lección 8 Parte 2
I:Mayúsculas y retorno
s:Su niña es Gina. Juan lo deja ir tarde.
 :Su niña es Gina. Juan lo deja ir tarde.
 :Su niña es Gina. Juan lo deja ir tarde.
 :El quiso leer su memo. No quiere ceder.
 :El quiso leer su memo. No quiere ceder.
 :El quiso leer su memo. No quiere ceder.
B:Lección 8 parte 2
I:Más práctica con Mayúsculas
s:Nina es la nieta menor de Luis C. Itier.
 :Nina es la nieta menor de Luis C. Itier.
 :Nina es la nieta menor de Luis C. Itier.
 :Noelia quiso una gema de la tienda Real.
 :Me tre el giro de Luis. Te trajo todo.
 :Carlos quiere el memo unido a esa carta.

*:EVALUACION_LECCION_8
B:Evaluación Lección 8
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 37 con un porcentaje de error inferior al 3%.
E:3%
F:MENU_LECCION_8
S:a q s d e c f r t g h j u n m k i l o ñ
 :asd dec frg frt jhn jum kil lo. año uña
 :Un kilo de queso. Nin te trae su tarea.
 :ta tala te tela ti tilo to toro tu tute
 :ca cada ce cede ci cine co codo cu cuan
 :ma malo me memo mi miel mo moda mu mula
 :ga gato ge gema gi giro go gota gu gula
 :El hilo no sale.
 :El kilo de queso es de Rosa.
 :Esa gema es de Linda y de Lina.
 :El hijo de Luis se queda con ella.
 :Su niña es Gina. Juan lo deja ir tarde.
 :El quiso leer su memo. No quiere ceder.
 :Nina es la nieta menor de Luis C. Itier.
 :Noelia quiso una gema de la tienda Real.
 :Me tre el giro de Luis. Te trajo todo.
 :Carlos quiere el memo unido a esa carta.

G:LECCION_8

*:LECCION_9
*:MENU_LECCION_9
M: UP=MENU_PRINCIPAL "Lección 9 - Nuevas Teclas W V ' (Tilde o acento)"
 :INSTRUCCIONES_LECCION_9 "Instrucciones"
 :PRACTICA_LECCION_9      "Práctica"
 :EVALUACION_LECCION_9    "Evaluación"

*:INSTRUCCIONES_LECCION_9
B:NUEVAS TECLAS: V W ' (Tilde o Acento)
T:La tecla W se pulsa con el dedo anular izquierdo, esto es, el dedo de la S.
 :Cuando oprima esta tecla, trate de mantener los otros tres dedos de la misma
 :mano sobre sus teclas guías, A, D y F.
 :
 :La tecla V se pulsa con el dedo índice de la mano izquierda, esto es, el dedo
 :de la F. Mantenga el resto de los dedos de dicha mano sobre las teclas guías
 :A, S y D.
 :
 :Presione la tecla de la tilde (') con el dedo meñique derecho, esto es el dedo
 :de la Ñ.  Mantenga los dedos de la misma mano sobre las teclas guías: J, K y L.
 :
 :Para colocar la tilde sin una vocal debe oprimir la barra espaciadora despué
 :de oprimir la tecla '.  La tecla de la tilde se encuentra a la derecha de la Ñ
 :en un teclado latinoamericano, y al lado de la P en uno español.

*:PRACTICA_LECCION_9
B:Lección 9
I:Ejercicio de práctica
s:aq uj ed ik ol fr jh ft l. dc jn fg jm ñ
 :aq uj ed ik ol fr jh ft l. dc jn fg jm ñ
 :o te efe jota a ce eñe ache u ka ene ere
 :o te efe jota a ce eñe ache u ka ene ere
 :Elsa no quiere que se le queme el queso.
B:Lección 9
I:Nuevas teclas
s:sws ss sw w www sws sws ws w sal ws w
 :ñ sé sí é ése dé í tía él ' ñ'ñ tío
 :fvf vv f fvf fv f vvv fv v fff fv ver
 :fvf ve venir vu vulgo vi visa va valijas
 :ñ'ñ dé decía sé serán sí freí té tendrás
B:Lección 9
I:Práctica con las nuevas teclas
s:sws wa Wanda we Welch wo Wolf Wi William
 :ñ'ñ dé decía sé serán sí freí té tendrá
 :fvf ve venir vu vulgo vi visa va valijas
 :sws wa Wanda we Welch wo Wolf Wi William

*:EVALUACION_LECCION_9
B:Evaluación Lección 9
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 38 con un porcentaje de error inferior al 3%.
E:3%
F:MENU_LECCION_9
S:sws ss sw w www sws sws ws w sal ws w
 :ñ sé sí é ése dé í tía él ' ñ'ñ tío
 :fvf vv f fvf fv f vvv fv v fff fv ver
 :sws wa Wanda we Welch wo Wolf Wi William
 :ñ'ñ dé decía sé serán sí freí té tendrás
 :fvf ve venir vu vulgo vi visa va valijas
 :Wanda salió en la tarde al río de Welch.
 :Wanda salió en la tarde al río de Welch.
 :irá así río está ají leí ése reunión tía
 :irá así río está ají leí ése reunión tía
 :la visa tendrás que dejarla con William.
 :la visa tendrás que dejarla con William.
 :Wanda Wilson va de viaje con esa valija.
 :Julio está en la reunión del Hotel visa.
 :William desea dejarle a Waldo su valija.

G:LECCION_9

*:LECCION_10
*:MENU_LECCION_10
M: UP=MENU_PRINCIPAL "Lección 10 - Nuevas Teclas P B , (Coma)"
 :INSTRUCCIONES_LECCION_10 "Instrucciones"
 :PRACTICA_LECCION_10      "Práctica"
 :EVALUACION_LECCION_10    "Evaluación"

*:INSTRUCCIONES_LECCION_10
B:NUEVAS TECLAS: P B , (Coma)
T:La tecla P se pulsa con el dedo meñique derecho, esto es, el dedo de la Ñ.
 :Cuando oprima esta tecla, trate de mantener los otros tres dedos de la misma
 :mano sobre sus teclas guías, J, K y L.
 :
 :La tecla B se pulsa con el dedo índice de la mano izquierda, esto es, el dedo
 :de la F. Mantenga el resto de los dedos de dicha mano sobre las teclas guías
 :A, S y D.
 :
 :Presione la tecla de la coma (,) con el dedo medio derecho, esto es el dedo
 :de la K.  Mantenga los dedos de la misma mano sobre las teclas guías: J, L y Ñ.
 :

*:PRACTICA_LECCION_10
B:Práctica 10
I:Ejercicio de práctica
s:pñ pa pan pe pero pi pila po poa por op
 :pñ pa pan pe pero pi pila po poa por op
 :k, ki Kid kilo kiwi kurdo kiosco kan ki
 :k, ki Kid kilo kiwi kurdo kiosco kan ki
 :fb ba bar basta be bea bi bilis bobo bu
 :fb ba bar basta be bea bi bilis bobo bu
B:Práctica 10
I:Práctica con las nuevas teclas
s:Pedro, Berto y Alba pasearán en su bote.
 :Pedro, Berto y Alba pasearán en su bote.
 :Berta Bueso pagó la orden del miércoles.
 :Berta Bueso pagó la orden del miércoles.
 :El bus que pasa por allí salió temprano.
 :Sí, Kiko recoge plantas, fresas e higos.
 :Por favor, dígale a Bartolo que puedo ir.

*:EVALUACION_LECCION_10
B:Evaluación Lección 10
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 39 con un porcentaje de error inferior al 3%.
E:3%
F:MENU_LECCION_10
S:Quique Quiles quiere viajar a Quisquella.
 :Quique Quiles quiere viajar a Quisquella.
 :Ufa subirá con Ulises Urrutia a la cúpula.
 :Ufa subirá con Ulises Urrutia a la cúpula.
 :Wanda compró el whisky de William Wellch.
 :Wanda compró el whisky de William Wellch.
 :Vanesa va a ver a la violinista Vea Vera.
 :Vanesa va a ver a la violinista Vea Vera.
 :Si, Kathie pagó la orden de esas plantas.
 :Bob recogió su traje temprano a las doce.
 :Por favor, avisa si el bus de Pedro pasa.
 :Berta no puede ir sola al fuerte Valdés.
 :Pedro, Leo, Sonia e Irene viajan juntos.
 :Sí, mi único hijo se llama Jorge Arturo.

G:LECCION_10


*:LECCION_11
*:MENU_LECCION_11
M: UP=MENU_PRINCIPAL "Lección 11 - X Y"
 :INSTRUCCIONES_LECCION_11 "Instrucciones"
 :PRACTICA_LECCION_11      "Práctica"
 :EVALUACION_LECCION_11    "Evaluación"

*:INSTRUCCIONES_LECCION_11
B:NUEVAS TECLAS: X Y
T:La tecla X se pulsa con el dedo anular izquierdo, esto es, el dedo de la S.
 :Cuando oprima esta tecla, trate de mantener los otros tres dedos de la misma
 :mano sobre sus teclas guías, A, D y F.
 :
 :La tecla Y se pulsa con el dedo índice de la mano derecha, esto es, el dedo
 :de la J. Mantenga el resto de los dedos de dicha mano sobre las teclas guías
 :K, L y Ñ.
 :

*:PRACTICA_LECCION_11
B:Práctica 11
I:Ejercicio de práctica
s:Berta no puede ir sola al fuerte Valdés.
 :Pedro, Leo, Sonia e Irene viajan juntos.
 :Sí, mi único hijo se llama Jorge Arturo.
 :En esta práctica una intención era aprender a usar el tabulador,
 :pero cuando tenga más experiencia lo haré.  Seguramente cuando vaya
 :a programar y a hacer trabajos para el colegio.

B:Práctica 11
I:Practica con las nuevas teclas
s:sx xs sxs exo nexo taxi anexo exime ex exige
 :yj jy hay aya yodo yace yegua yerno ya yerba
 :Yo voy a la playa con Yadira en el yate Maya.
 :Xavier no puede eximir del examen a Xiomara.
 :Yaira y Xenia van solas al examen de Rayos X.

*:EVALUACION_LECCION_11
B:Evaluación Lección 11
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 39 con un porcentaje de error inferior al 3%.
E:3%
F:MENU_LECCION_11
S:Voy a ayudar a Yamilete en su examen de yodo.
 :Acomoden el yate en el anexo de Xavier Yanés.
 :Fue a visitar a su hermano que está exiliado.
 :Puede exigir al médico que cambie ese examen.
 :El domingo iremos a la playa y no al parque, como acordamos anoche.
 :Alexis y Yadi estarán en su yate y luego pasarán por el anexo a visitar a su
 :yerno Xavier.
 :El xilófono es un instrumento musical de percusión.
 :La yarda es una medida inglesa que equivale a 91 centímetros de longitud
 :La yegua come y yace sobre la yerba.
 :En Yugoeslavia hay millones de yugoeslavos y yugoeslavas.
 :El yodo ayuda a evitar el coto, por eso se cocina con sal yodada.
 :El guayabo es el árbol que produce las guayabas.
 :Sin la y no hay conjunción, y se pueden confundir ciertas palabras como aya,
 :haya y allá entre otras.

G:LECCION_11

*:LECCION_12
*:MENU_LECCION_12
M: UP=MENU_PRINCIPAL "Lección 12 - Nuevas teclas Z : ;"
 :INSTRUCCIONES_LECCION_12 "Instrucciones"
 :PRACTICA_LECCION_12      "Práctica"
 :EVALUACION_LECCION_12    "Evaluación"

*:INSTRUCCIONES_LECCION_12
B:NUEVAS TECLAS: Z : (dos puntos) ; (punto y coma)
T:La tecla Z se pulsa con el dedo meñique izquierdo, esto es, el dedo de la A.
 :Cuando oprima esta tecla, trate de mantener los otros tres dedos de la misma
 :mano sobre sus teclas guías, S, D y F.
 :
 :La tecla : se pulsa con el dedo medio de la mano derecha, esto es, el dedo
 :de la K. Mantenga el resto de los dedos de dicha mano sobre las teclas guías
 :J, L y Ñ. Debe mantener oprimido el shift izquierdo con el meñique izquierdo.
 :
 :Presione la tecla del punto y coma (;) con el dedo anular derecho, esto es el
 : dedo de la L.  Mantenga los dedos de la misma mano sobre las teclas guías: J,
 :K y Ñ. Debe mantener el oprimido el shift izquierdo con el meñique izquierdo.
 :
 :Estas instrucciones son para un teclado LatinoAmericano, probablemente la dis-
 :tribución del teclado es distinta, por ejemplo un Español.

*:PRACTICA_LECCION_12
B:Práctica 12
I:Ejercicio de práctica
s:m p . n i r v t a s d x y c f g l , o q y e
 :Xiomara y Xavier pronto regresarán de Quito.
 :Yany, la nuera de Yamil compró yuca en Yauco.
 :Visite el volcán y vea los viveros de Vanesa.
 :La única tecla del abecedario en español que falta es la última
 :Después de punto y coma ; se deja un espacio.
 :Después de dos puntos :  Se dejan dos espacios.

B:Práctica 12
I:Practica con las nuevas teclas
s:az za aza zag zinc zona haz Zoé taza zumo zejel
 :ñ; ;; si; lo; por; tal; as; de; Sr.; son; pues;
 :ñ: :: es: su: A: De: la: Para: Año: señor:
 :Señor:  Puede ir con su esposa; no con su hija.
 :int a,b,c; float d,e,f; char zar1,zar2,zar3;
 :Una idea; otra idea; más ideas.

*:EVALUACION_LECCION_12
B:Evaluación Lección 12
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 40 con un porcentaje de error inferior al 3%.
E:3%
F:MENU_LECCION_12
S:El signo ; señala una pausa intermedia, equivalente a dos tiempos, con un
 :descenso en la entonación.  Indica una pausa mayor que la señalada por la coma
 :pero no tan notable como la del punto.
 :Actualmente se le emplea menos que antes, desplazado en muchos casos por el
 :punto, la coma o los dos puntos.
 :Las sentencias de C y Java se separan con punto y coma ;
 :por ejemplo:
 :int a;
 :float b,c;
 :El signo : indica una pausa intermedia (de dos tiempos), precedida de un
 :descenso en el tono.  A diferencia del punto, indica que no se ha enunciado el
 :pensamiento completo, y que lo siguiente está relacionado con lo anterior: Es
 :una especie de llamada de atención para el lector.  Según la relación
 :existente, lo que sigue se escribe con minúscula o con mayúscula.
 :A diferencia de pascal, en C la asignación no necesita :
 :En lenguajes de programación es bastante usual encontrar los símbolos : y ;
 :para distintos usos.
 :

G:LECCION_12

*:LECCION_13
*:MENU_LECCION_13
M: UP=MENU_PRINCIPAL "Lección 13 - Nuevas teclas (Dobles) RR LL NN CC"
 :INSTRUCCIONES_LECCION_13 "Instrucciones"
 :PRACTICA_LECCION_13      "Práctica"
 :EVALUACION_LECCION_13    "Evaluación"

*:INSTRUCCIONES_LECCION_13
B:Teclas Dobles RR LL NN CC
T:Esta lección es un repaso general del teclado alfabético, simplemente se trata
 :de reforzar habilidades al escribir, teniendo en cuenta las letras repetidas
 :que se encuentran en algunas palabras en español.
 :
 :Las letras repetidas usuales son la RR, que se pulsa con el dedo índice
 :izquierdo, la LL pulsada con el anular de la mano derecha, la N, pulsada con
 :el índice de la mano derecha, y finalmente la C, pulsada con el dedo corazón
 :de la mano izquierda.
 :
 :En caso de no conocer una palabra que se encuentre en la lección es necesario
 :consultar su significado.
 :
 :Además se muestran significados de nuevas palabras y se emplea el símbolo | .

*:PRACTICA_LECCION_13
B:Práctica 12
I:Ejercicio de práctica
s:Hay abundantes palabras en el español que admiten consonantes repetidas, por
 :ejemplo, para la RR como regla general, cuando se pronuncia la R de forma
 :fuerte, se escribe doble R, si no se está al principio o al final de una
 :palabra, de lo contrario se escribe una sola R, como ejemplo en el primer caso
 :se tiene a ferrocarril, arrojar, arrastrar, arrumar, corroer, y en el segundo
 :caso se tiene ratón, rastrear, roer, rastro, ristre, aeronautica, bárbaro.
 :Las otras letras repetidas no tienen condición, por ejemplo se puede encontrar
 :innecesario, inaccesible, hallar, llama, lluvia, accidente, acceder, acceso.
 :Cabe anotar que no hay palabras que empiecen con doble C ni con doble N
B:Práctica 12
I:Práctica con las letras dobles
s:Corran por el cerro, pero cuídense del perro que cuida.
 :Corran por el cerro, pero cuídense del perro que cuida.
 :Lleva horas lloviendo y el sol aún no brilla.
 :Lleva horas lloviendo y el sol aún no brilla.
 :Es innato en él, es innecesario tratar de documentarlo.
 :Es innato en él, es innecesario tratar de documentarlo.
 :La acción tomada en el accidente es correcta.
 :La acción tomada en el accidente es correcta.

*:EVALUACION_LECCION_13
I:Para pasar a la siguiente lección, en esta evaluación su wpm real debe ser de
 : por lo menos 40 con un porcentaje de error inferior al 3%.
E:3%
F:MENU_LECCION_13
S:ferroviario, ria :adj. Perteneciente o relativo a los ferrocarriles | m y f.
 :Empleado del ferrocarril.
 :emparrado :m. Armazón que sostiene la parra u otra planta trepadora | Conjunto
 :de los vástagos y hojas de una o más parras que, sostenidas con un armazón de
 :madera, hierro u otra materia, forman cuierta. | FAM. emparrar.
 :lloriquear :intr. Gimotear, llorar sin fuerza. | FAM. lloriqueante, lloriqueo
 :embarullar : tr. Confundir, mezcla desordenadamente unas cosas con otras. |
 :Hacer algo precipitadamente. FAM. emabrulladamente, embarullado, embarullador,
 :embarullamiento.
 :innumerable :adj. Muy abundante | Que no se puede contar | FAM innumerabilidad,
 :innúmero
 :connotar :tr. Sugerir una palabra, frase o discurso, un significado secundario
 :que se suma al valor principal | FAM. connotar, connotativo.
 :Pobre hombre, parace un eccehomo con esos eccemas y esas acciones
 :Los accidentes son frecuentes al tratar de acceder al tramo de los occisos.
G:LECCION_13

*:LECCION_14
*:MENU_LECCION_14
M: UP=MENU_PRINCIPAL "Lección 14 - Practicando lo aprendido"
 :INSTRUCCIONES_LECCION_14 "Instrucciones"
 :PRACTICA_LECCION_14      "Práctica"

*:INSTRUCCIONES_LECCION_14
B:Practicando lo aprendido
T:
 :
 :Esta es una práctica, que le permitirá repasar lo aprendido antes de continuar
 :aprendiendo nuevas teclas (y nuevos conceptos).
 :
 :Esta práctica no tiene evaluación, usted se autoevaluará, y decidirá
 :continuar a la siguiente lección cuando se sienta a gusto.
 :

*:PRACTICA_LECCION_14
B:Practicando lo Aprendido
s:Un hombrecito va por allí caminando fresco, cargando un libro de Mr. Edgar
 :Allan Poe que pesa 5 kilos. De pronto un gordo lo ve pasar y se acerca y le
 :pregunta:
 : Dígame, no le molesta andar con ese libro tan pesado parriba y pabajo
 :
 :El hombrecito, que es muy bondadoso y un poco ingenuo, no se da cuenta que
 :el gordo se quiere burlar de él, y por eso piensa antes de contestar, para
 :darle la respuesta exacta; y ella es:
 : Lo que pasa es que desde hace un tiempo para acá me dí cuenta que yo vivo
 :mi vida montado en un globo, y el libro de Edgar me sirve de lastre. Lastre
 :para no elevarme tanto, para no ir a parar a una región desconocida, habitada
 :por gente que a lo mejor no me gusta, que no conozco. Además la persona que
 :más supo de globos en el mundo fue mi amigo Edgar.
 :
 :Y el gordo al oír eso se le ríe en la cara. Y el hombrecito comprende ahora
 :y se pone muy triste. Y la tristeza le dura cinco días. Hasta que se encuentra
 :en una película una actriz americana de la que se puede enamorar fácil, y la
 :tristeza se le pasa.
 :
 : Andrés Caicedo. Del libro Destinitos Fatales

*:LECCION_15
*:MENU_LECCION_15
M: UP=MENU_PRINCIPAL "Lección 15 - Mezclando Números 0 1 2 3 4 5 6 7 8 9"
 :INSTRUCCIONES_LECCION_15 "Instrucciones"
 :PRACTICA_LECCION_15      "Práctica"
 :EVALUACION_LECCION_15    "Evaluación"

*:INSTRUCCIONES_LECCION_15
T:Con está lección practicará el uso de las teclas con números y
 :algunos símbolos
 :   .   +    -    *    /
 :
 :A partir de esta lección, no se le indicarán los dedos que debe usar
 :para presionar cada tecla. Como parte de la evaluación digale a su
 :instructor los dedos que debe usar con las nuevas teclas.


*:PRACTICA_LECCION_15
s:444 555 666 456 654 456 654 456 654
 :111 222 333 123 321 123 321 132 321
 :777 888 999 789 987 789 987 789 987
 :111 444 777 222 555 888 333 666 999
 :123 456 789 987 654 321 159 753 951
 :123456789 987654321 ... ... .. ....
 :1+2+3+4+5+6+7+8+9 9+8+7+6+5+4+3+2+1
 :000 000 000 000 000 000 000 000 000
 :0123456789 9876543210 0.000
s:1.1/9+3-6
 :1.1 1.2 1.3 1.4 1.5
 :987654321/123456789
 :1.1
 :1.2
 :1.3
 :2.1
 :2.2
*:EVALUACION_LECCION_15
I:Mínimo wpm real: 30, Porcentaje de error máximo: 2%
E:2%
F:MENU_LECCION_15
S:123 456 789 987 654 321
 :147 852 369 852 147 963
 :159 753 456 852 951 357
 :9/3 es 3.
 :1+2+3+4+5+6 es 6*7/2
 :9+8+7+6+5+4+3+2+1 es 9*10/2
 :369 es 123*3
 :987 - 654 es 333
 :123 + 456 es 579
 :147 + 852 es 999

G:LECCION_15

*:LECCION_16
*:MENU_LECCION_16
M: UP=MENU_PRINCIPAL "Lección 16 - Algo de LaTeX  $ { } \ [ ] _ ^"
 :INSTRUCCIONES_LECCION_16 "Instrucciones"
 :PRACTICA_LECCION_16      "Práctica"
 :EVALUACION_LECCION_16    "Evaluación"

*:INSTRUCCIONES_LECCION_16
T:En esta lección se introducirá una forma distinta de hacer documentos, la
 :cual difiere de los sistemas "What You See Is What You Get" que es referida
 :de vez en cuando como "What You See Is All You Have Got", ejemplo de WYSIAYHG
 :son los procesadores de Texto en los cuáles uno elige cómo quiere que sea el
 :formato y lo ve automáticamente en pantalla, unos editores de este estilo son
 :StarWriter de StarOffice, WordPerfect de Corel y Word de Microsoft.
 :
 :Durante esta lección se mostrará algo de la evolución de TeX desde sus inicios
 :, se hará un ejemplo de cómo se hace un pequeño documento en LaTeX, se
 :enseñará a compilar y a ver los resultados de un documento que se haga.
 :
 :La recomendación es, intente hacer su documento, compilarlo y verlo, de esta
 :forma se dará cuenta del poder del formateado de texto, que aunque se vea más
 :complejo al principio, a medida que se hace costumbre, se logrará dominarlo.
 :
 : Los caracteres especiales que se usarán son \ { } [ ] _ ^ $
 :
 :Si le gustaron los resultados que generó después de hacer el ejemplo de la
 :evaluación y quiere aprender más sobre LaTeX, corra desde un shell
 :info latex
 :

T:Entre las ventajas que tiene LaTeX se puede encontrar la portabilidad entre
 :sistemas, está disponible para casi todas las plataformas computacionales,
 :es libre, es decir se tienen las fuentes y no hay que pagar un solo peso por
 :usarlo.
 :
 :Además puede exportar el formato de LaTeX a muchos otros, por ejemplo a HTML,
 :PostScript, PDF, RTF. Con programas especiales para esto.
 :
 :Puede adicionar gráficas, para lo cual se recomienda xtexcad y xfig, ambos
 :Software Libre
 :
 :NOTA: Aveces el caracter ^ tiene problemas para mostrarse, si no logra hacer
 :que se vea siga los siguientes pasos, emplee el Alt derecho de su teclado
 :marcando simultáneamente la tecla que tiene el ^ y oprima la barra espaciadora
 :después.
*:PRACTICA_LECCION_16
s:LaTeX2e es un sistema de preparación de documentos implementado como un
 :paquete de Macros para el programa de impresión con formato de Donald E.
 :Knuth.  Leslie Lamport fue quien concibió inicialmente tal idea.
 :El comando LaTeX imprime un archivo de texto usando el programa TeX y el
 :paquete de Macros de TeX.  Para ser más específicos, procesa un archivo
 :de entrada conteniendo el texto de un documento junto con comandos que
 :describen el formato del texto.
 :Para una descripción de lo que ocurre dentro de TeX, consulte 'The TeXbook'
 :de Donald E. Knuth, ISBN 0-201-13448-9, publicado por la Sociedad Americana
 :de Matemáticas junto con la Addison-Wesley Publishing Company.
 :Para una descripción de LaTeX, consulte:
 :LaTeX: 'A Document Preparation System', por Leslie Lamport, Addison-Wesley
 :Publishing Company, 2nd edition, 1994.
 :'The LaTeX Companion', por Michel Goossens, Frank Mittelbach, y Alexander
 :Samarin, Addison-Wesley, 1994
 :                                     Tomado del Info de LaTeX.

s:Las teclas que se usan en esta lección son \ { } [ ] _ ^ $.
 :Siempre que se quiera escribir un documento en LaTeX, se debe especificar a
 :qué tipo de documento pertenece, un libro, un artículo, una carta, incluso se
 :puede definir el estilo que uno necesite, por ejemplo una tesis.
 :
 :Para definir la clase del documento se usa \documentclass{clase} , donde clase
 :es el tipo del documento que se quiere generar.
 :
 :A continuación se debe indicar que se comenzará la escritura del documento, así
 :\begin{document}
 :Después se le puede colocar todo el texto que se desee, junto con formato
 :adicional, por ejemplo centrado se hace con \begin{center} texto a centrar
 :\end{center}.
 :
 :Para colocar texto en negrilla se usa \textbf{texto en negrilla}, para colocar
 :texto en itálica se usa \textit{texto en itálica}. Para indicar notación
 :matemática se usa el signo $.
 :Para finalizar el archivo se debe escribir
 :\end{document}


*:EVALUACION_LECCION_16
I:Mínimo wpm real: 33, Porcentaje de error máximo: 5%
E:5%
F:MENU_LECCION_16
S:Primero cree el archivo prueba.tex en un editor de texto, después de esto
 :escriba lo siguiente dentro del archivo, tal y como está, no olvide grabar
 :\documentclass{article}
 :\begin{document} \begin{center}
 :\textbf{\textit{Este es un texto centrado, en negrilla e it\'alica}}
 :\end{center} \vspace{3cm}
 :Una f\'ormula matem\'atica sencilla: $$1+2+\cdot\cdot\cdot+n=\sum_{i=0}^{n}i=
 :\frac{n(n+1)}{2}$$ \vspace{3cm}
 :Por \'ultimo un dibujo \begin{center} \begin{figure}[h] \unitlength=1.000000pt
 :\begin{center} \begin{picture}(95.00,152.00)(0.00,0.00)
 :\put(44.00,152.00){\makebox(0.00,0.00){Yo $\heartsuit$ \LaTeX}}
 :\put(43.00,123.00){\circle{8.00}} \put(51.00,75.00){\line(-2,1){51.00}}
 :\put(52.00,76.00){\line(6,5){43.00}} \put(51.00,39.00){\line(-6,-5){33.00}}
 :\put(50.00,40.00){\line(4,-5){32.00}} \put(50.00,100.00){\line(0,-1){60.00}}
 :\put(47.00,121.00){\circle{40.00}}
 :\end{picture} \end{center} \caption{Mi primer dibujo usando \LaTeX}\end{figure}
 :\end{center} \end{document}
 :Para compilar se invoca latex prueba.tex desde un shell
 :Para ver el resultado se invoca xdvi prueba.dvi desde un entorno gráfico
 :Para obtener la impresión se usa dvips prueba.dvi

G:LECCION_16

*:LECCION_17
*:MENU_LECCION_17
M: UP=MENU_PRINCIPAL "Lección 17 - Algo de HTML  < > & " ? !"
 :INSTRUCCIONES_LECCION_17 "Instrucciones"
 :PRACTICA_LECCION_17      "Práctica"
 :EVALUACION_LECCION_17    "Evaluación"

*:INSTRUCCIONES_LECCION_17
B:Algo de HTML
T:
 :Uno de los grandes éxitos en Internet ha sido el WEB.  La palabra web del
 :inglés en español es telaraña.  El Web es una telaraña de hipertextos.
 :
 :Puede empezarse por entender un hipertexto como un texto con enlaces a otros
 :otros hipertextos.  El lenguaje usado para escribir hipertextos en el Web
 :es HTML.
 :
 :En esta lección aprenderá un poco de HTML al tiempo con el uso de algunas
 :teclas con símbolos importantes para HTML.
 :
 :Las nuevas teclas serán: < > & " ? !



*:PRACTICA_LECCION_17
B:Practicando las nuevas teclas
s:Primero un calentamiento: <<< <<< >>> >>> &&& &&& """ """ ??? ??? !!! !!!
 :<> <> &" &" ?! ?! <>&"?! <>&"?! <>&"?! <<&&""??!!>> <<&&""??!!>> !?&><"
 :
 :Para escribir en HTML se usan TAGS, un tag es una palabra que se coloca
 :entre los símbolos < y >.  La mayoría de tags que se abren deben cerrarse:
 : <title>El titulo</title>
 :Se uso el tag <title> y se cerró posteriormente con el tag </title>
 :Algunos tags importantes son: <html> para indicar inicio del documento y
 :respectivamente </html> para indicar el final.
 :Todo tag que comience con "<!--" es un comentario y no necesita cerrarse:
 : <!-- Este es un comentario -->
 :Para hacer un enlace a otra página puede usarse el tag "A":
 : <a href="http://structio.sourceforge.net">Proyecto Structio</a>
 :Algunos caracteres como las tildes pueden especificarse con ayuda de &:
 : á es &aacute; é es &eacute; í es &iacute; ó es &oacute; ú es &uacute;
 :
 :Usted se preguntará: Y esto para que me sirve?
 :Y la respuesta la encontrará mirando Internet, dejándose fascinar por el Web
 :y deseando hacer su propia página. Entonces la podrá hacer en HTML.

*:EVALUACION_LECCION_17
I:Mínimo wpm real: 33, Porcentaje de error máximo: 4%
E:4%
F:MENU_LECCION_17
S:<html>
 :<head><title>Mi primer documento en HTML</title></head>
 :<!-- Escrito por: "?!" -->
 :<body>
 :Este ejemplo muestra algo de HTML!<p>
 :Sab&iacute;as que pueden hacerse listas no numeradas?
 :<ul><li>Primero de la lista no numerada</li>
 :<li>Segundo de la lista no numerada</li></ul>
 :Sab&iacute;as que pueden hacerse listas numeradas?
 :<ol><li>Primero. Precedido autom&aacute;mente por el n&uacute;mero 1</li>
 :<li>Segundo. Precedido por 2</li></ol>
 :Sab&iacute;s que incluso pueden ponerse im&aacute;genes?
 :<img src="delfin.jpg">
 :<p>Puede tambi&eacute;n cambiarse la letra: <b>Negrilla</b>,<i>Italica</i>.
 :<br>Y claro pueden hacerse enlaces a otros hipertextos escritos en HTML:
 :<a href="ejemplo2.html">Enlace al segundo ejemplo</a>
 :</body>
 :</html>

G:LECCION_17

*:LECCION_18
*:MENU_LECCION_18
M: UP=MENU_PRINCIPAL "Lección 18 - Algo de Texinfo # | @"
 :INSTRUCCIONES_LECCION_18 "Instrucciones"
 :PRACTICA_LECCION_18      "Práctica"
 :EVALUACION_LECCION_18    "Evaluación"

*:INSTRUCCIONES_LECCION_18
B:Algo de Texinfo:
T:Texinfo es un formato apropiado para documentos técnicos.  Se ha usado
 :especialmente para escribir manuales y documentación de programas.
 :
 :Los documentos escritos en este formato pueden ser traducidos por
 :herramientas a otros formatos
 :  * Al formato HTML apropiado para ver en el WEB
 :  * Al formato TeX precursor de LaTeX y apropiado para imprimir con
 :    alta calidad
 :  * Al formato info apropiado para consultar manuales y documentación
 :    en un computador.  Este es el formato de la documentación del sistema
 :    GNU/Linux, para verla puede usar el comando "info"
 :
 :La gran ventaja de Texinfo es permitirle a los autores escribir y revisar
 :sus documentos en un único formato para después generar sus documentos
 :impresos o listos para ser consultados en un computador o en el WEB.
 :
 :En esta lección aprenderá un poco de Texinfo y practicará el uso de algunas
 :teclas nuevas: @ | y #.  En la práctica de la lección los conceptos de
 :Texinfo son introducidos y en la evaluación parte de un documento Texinfo es
 :presentado.

*:PRACTICA_LECCION_18
B:Practicando las nuevas teclas: @ | #
s:@@@ @@@ ||| ||| ### ### @|@ @|@ |#| |#| |#| |@| |@| @#@ @#@
 :|@# |@# |@# #|@ #@| #@| #@| #@| #@| @#| @#| @#| |#@ |#@ |#@
 :
 :Como los documentos de Texinfo pueden ser usados para generar archivos info,
 :HTML y TeX, hay comandos especiales para lograr efectos en esos formatos.
 :Tales comandos se denominan comandos-@.  Por ejemplo @noindent, @chapter,
 :@dots, @example:
 :#- @noindent indica que el texto de la línea no debe ser indentado.
 :#- @chapter seguido de un título, indica el comienzo de un capítulo.
 :#- @example Indica el comienzo de un ejemplo, las líneas que sigan serán
 :el ejemplo y debe terminar con el comando @end example
 :
 :En el formato info, un documento se divide en nodos, estos nodos tienen
 :estructura arborescente y para referenciar un nodo desde otro cada nodo tiene
 :un nombre. El comando @node permite definir nuevos nodos, debe estar seguido
 :por 4 textos separados por comas ",".  Tales textos son nombres de nodos, el
 :primero es el nodo que se define, el segundo el nombre del nodo "siguiente",
 :el tercero el nodo "anterior" y el cuarto el nombre del nodo "superior".

*:EVALUACION_LECCION_18
I:Mínimo wpm real: 33, Porcentaje de error máximo: 4%
E:4%
F:MENU_LECCION_18
S:@node Overview, Sourcebook of Writer, Top, Top
 :@chapter Overview: The Writing Process
 :
 :@quotation
 :#I learned long ago that you cannot tell how you will end by how you start.#
 :@flushright
 :---@emph{John Steinbeck}
 :@end flushright
 :@end quotation
 :
 :|Writing|. You may think of it as an enjoyable activity. |Writing!|
 :You may consider it an irksome chore. |Writing?| You may not think much
 :about it at all.  Whatever your thoughts about it may be, the act of writing
 :is a process.  When you engage in the @strong{writing process}, you gradually
 :learn what ideas you have about people and things.  You then select ideas you
 :want to express. Finally  you put the ideas you choose into words and
 :communicate them clearly to others.
 :
 :   Taken from #MacMillan English: Thinking and Writing Processes#

G:LECCION_18

*:LECCION_19
*:MENU_LECCION_19
M: UP=MENU_PRINCIPAL "Lección 19 - Literatura"
 :INSTRUCCIONES_LECCION_19 "Instrucciones"
 :PRACTICA_LECCION_19      "Práctica"
 :EVALUACION_LECCION_19    "Evaluación"

*:INSTRUCCIONES_LECCION_19
B:Literatura
T:
 :Al llegar a esta lección ya debe dominar el teclado. Es ahora un buen
 :momento para poner en práctica sus habilidades con algunos fragmentos
 :de buena literatura.
 :
 :Hay dos fragmentos de obras en español y un fragmento de una obra clásica
 :en inglés.  Puede usar el diccionario para consultar las palabras que no
 :conozca y para traducir el fragmento de "Alicia en el país de las Maravillas".


*:PRACTICA_LECCION_19
B:Fragmento del Quijote
s:Limpias, pues, sus armas, hecho del morrión celada, puesto nombre a su
 :rocín y confirmándose a sí mismo, se dio a entender que no le faltaba otra
 :cosa sino buscar una dama de quien enamorarse; porque el caballero andante
 :sin amores era árbol sin hojas y sin fruto y cuerpo sin alma. Decíase él
 :a sí:
 :-Si yo, por malos de mis pecados, o por mi buena suerte, me encuentro por
 : ahí con algún gigante, como de ordinario les acontece a los caballeros
 : andantes, y le derribo de un encuentro, o le parto por mitad del cuerpo, o,
 : finalmente, le venzo y le rindo, ¿no será bien tener a quien enviarle
 : presentado y que entre y se hinque de rodillas ante mi dulce señora, y diga
 : con voz humilde y rendido: "Yo, señora, soy el gigante Caraculiambro,
 : señor de la ínsula Malindrania, a quien venció en singular batalla el
 : jamás como se debe alabado caballero don Quijote de la Mancha, el cual me
 : mandó que me presentase ante vuestra merced, para que la vuestra grandeza
 : disponga de mí a su talante"?
 :Oh, cómo se holgó nuestro buen caballero cuando hubo hecho este discurso,
 :y más cuando halló a quien dar nombre de su dama!
 :    Fragmento de 'El Quijote' de <Miguel de Cervantes Saavedra>.
 :    Proyecto Gutemberg. http://promo.net/pg/

B:Fragment of 'Alice in Wonderland'
s:So she was considering in her own mind (as well as she could,
 :for the hot day made her feel very sleepy and stupid), whether
 :the pleasure of making a daisy-chain would be worth the trouble
 :of getting up and picking the daisies, when suddenly a White
 :Rabbit with pink eyes ran close by her.
 :
 :There was nothing so VERY remarkable in that; nor did Alice
 :think it so VERY much out of the way to hear the Rabbit say to
 :itself, `Oh dear!  Oh dear!  I shall be late!'  (when she thought
 :it over afterwards, it occurred to her that she ought to have
 :wondered at this, but at the time it all seemed quite natural);
 :but when the Rabbit actually TOOK A WATCH OUT OF ITS WAISTCOAT-
 :POCKET, and looked at it, and then hurried on, Alice started to
 :her feet, for it flashed across her mind that she had never
 :before seen a rabbit with either a waistcoat-pocket, or a watch to
 :take out of it, and burning with curiosity, she ran across the
 :field after it, and fortunately was just in time to see it pop
 :down a large rabbit-hole under the hedge.
 :     Fragment of 'Alice in Wonderland' by <Lewis Caroll>

*:EVALUACION_LECCION_19
I:En esta evaluación se espera por lo menos 35wpm y a lo sumo 3% de error
E:3%
F:MENU_LECCION_19
S:LA PONCIA. (Sale comiendo chorizo y pan): Llevan ya más de dos horas de
 : gori-gori. Han venido curas de todos los pueblos. La iglesia está hermosa.
 : En el primer responso se desmayó la Magdalena.
 :CRIADA: Es la que se queda más sola.
 :LA PONCIA: Era la única que quería al padre. Ay! Gracias a Dios que estamos
 : solas un poquito! Yo he venido a comer.
 :CRIADA: Si te viera Bernarda!...
 :LA PONCIA: Quisiera que ahora, como no come ella, que todas nos muriéramos
 : de hambre! Mandona! Dominanta! ¡ero se fastidia! Le he abierto la orza
 : de los chorizos.
 :CRIADA: (Con tristeza, ansiosa.) Por qué no me das para mi niña, Poncia?
 :LA PONCIA: Entra y llévate también un puñado de garbanzos.
 :  Hoy no se dará cuenta!
 :VOZ. (Dentro): Bernarda!
 :LA PONCIA: La vieja. Está bien cerrada?
 :CRIADA: Con dos vueltas de llave.
 :LA PONCIA: Pero debes poner también la tranca. Tiene unos dedos como cinco
 : ganzúas.
 :         Fragmento de 'La casa de Bernarda Alba' de <Federico García Lorca>

G:LECCION_19

*:VELOCIDAD
*:MENU_VELOCIDAD
M: UP=MENU_PRINCIPAL "Menú Velocidad"
 :INSTRUCCIONES_VELOCIDAD "Instrucciones"
 :PRACTICA_VELOCIDAD1     "Práctica 1"
 :PRACTICA_VELOCIDAD2     "Práctica 2"
 :EVALUACION_VELOCIDAD    "Evaluación"

*:INSTRUCCIONES_VELOCIDAD
B:Práctica y evaluación de velocidad
T:
 :
 :En  esta  parte  de las lecciones debe concentrarse en la velocidad,
 :claro está, sin descuidar del todo la precisión.
 :
 :Tendrá  dos  páginas  de  práctica,  cada  una de las cuales podrá repetir
 :hasta que se sienta a gusto.  Después de las prácticas tendrá la evaluación
 :de velocidad.
 :
 :En  la evaluación deberá lograr por lo menos una velocidad de
 :40 palabras por minuto (velocidad ajustada) con un error no superior al 5%.

*:PRACTICA_VELOCIDAD1
B:Primera práctica de velocidad
s:El río Nilo ubicado en Egipto, es considerado el más largo del mundo con
 :4,187 millas desde su nacimiento hasta la desembocadura en el Mar
 :Mediterráneo. Por Colombia, Brasil, Perú y Ecuador pasa el río Amazonas
 :que es el segundo río más largo del mundo con una longitud de 4,080 millas.
 :   http://www.robinsonresearch.com/AFRICA/THE_LAND/Nile_River.htm
 :   http://www.letsfindout.com/subjects/places/amazon-river.html
 :
 :
 :Art. 1.- Colombia es un Estado social de derecho, organizado en forma de
 :República unitaria, descentralizada, con autonomía de sus entidades
 :territoriales, democrática, participativa y pluralista, fundada en el
 :respeto de la dignidad humana, en el trabajo y la solidaridad de las
 :personas que la integran y en la prevalencia del interés general.
 :   Constitución Política de Colombia
 :
 :
 :Fueron los dinosaurios los animales más grandes que han existido en la
 :tierra? No, el animal más grande que ha existido y que aún existe es la
 :ballena azul que en promedio mide 27 metros y pesa 120 toneladas.
 :   http://www.extremescience.com

*:PRACTICA_VELOCIDAD2
B:Segunda práctica de velocidad
s:Los organismos vivos se han agrupado en distintos reinos
 :para entenderlos y conocerlos mejor.
 :Nosotros los seres humanos al igual que los animales pertenecemos al
 :reino "Animalia", por su parte las plantas pertenecen al reino
 :"Plantae"; pero será que esos son los únicos seres vivos que existen?
 :Claro que no! Por ejemplo los hongos pertenecen al reino "Fungi", las
 :bacterias, organismos de una sola célula,  pertenecen al reino "Monera".
 :Del quinto reino, llamado "Protista", evolucionaron Animalia, Plantae y
 :Fungi. Dado que algunos de los integrantes del reino Monera tienen
 :pequeñas diferencias, algunos biólogos opinan que debe
 :dividirse en dos "Eubacteria" y "Archaebacteria".
 :   http://volweb.utk.edu/schools/sullivan/mhme/taxonomy.htm
 :   http://gened.emc.maricopa.edu/bio/bio181/BIOBK/BioBookintro.html
 :
 :Art. 22.- La paz es un derecho y un deber de obligatorio cumplimiento.
 :   Constitución Política de Colombia
 :
 :Manuel Elquin Patarroyo desarrolló la vacuna contra la malaria en 1987.
 :   http://www.idrc.ca/books/reports/10patarro.html

*:EVALUACION_VELOCIDAD
B:Evaluación de Velocidad
I:En esta evaluación se espera por lo menos 40wpm y a lo sumo 5% de error
E:5%
F:MENU_VELOCIDAD
S:Increíble, los océanos cubren aproximadamente el 71% de la superficie de
 :la tierra.
 :   http://www.abc.net.au/oceans/facts/default.htm
 :
 :Art. 13.- Todas las personas nacen libres e iguales ante la ley,
 :recibirán la misma protección y trato de las autoridades y gozarán de
 :los mismos derechos, libertades y oportunidades sin ninguna
 :discriminación por razones de sexo, raza, origen nacional o familiar,
 :lengua, religión, opinión política o filosófica.
 :  El Estado promoverá las condiciones para que la igualdad sea real
 :y efectiva y adoptará medidas en favor de grupos discriminados o
 :marginados.
 :  El Estado protegerá especialmente a aquellas personas que por su
 :condición económica, física o mental, se encuentren en circunstancia de
 :debilidad manifiesta y sancionará los abusos o maltratos que contra
 :ellas se cometan.
 :   Constitución Política de Colombia
 :
 :Arqueología es el estudio de las formas de vida del pasado.
 :   http://www.saa.org/AboutArc/ac-whatisarch.html
G:VELOCIDAD

*:PRECISION
*:MENU_PRECISION
M: UP=MENU_PRINCIPAL "Menú Precisión"
 :INSTRUCCIONES_PRECISION "Instrucciones"
 :PRACTICA_PRECISION1     "Práctica 1"
 :PRACTICA_PRECISION2     "Práctica 2"
 :EVALUACION_PRECISION    "Evaluación"

*:INSTRUCCIONES_PRECISION
B:Práctica y evaluación de precisión
T:
 :
 :En  esta  parte  de las lecciones debe concentrarse en la precisión,
 :aunque sin descuidar la velocidad.
 :
 :Tendrá  dos  páginas  de  práctica,  cada  una de las cuales podrá repetir
 :hasta que se sienta a gusto.  Después de las prácticas tendrá la evaluación
 :de precisión.
 :
 :En  la evaluación deberá lograr por lo menos una velocidad de
 :30 palabras por minuto (velocidad ajustada) con un error del 1%


*:PRACTICA_PRECISION1
B:Primera práctica de precisión
s:Fragmento de "CANCIÓN DE LA VIDA PROFUNDA"
 :
 :Hay días en que somos tan móviles, tan móviles
 :como las leves briznas al viento y al azar...
 :Tal vez bajo otro cielo la dicha nos sonría...
 :La vida es clara, undívaga y abierta como un mar.
 :
 :Y hay días en que somos tan fértiles, tan fértiles,
 :como en abril el campo, que tiembla de pasión:
 :bajo el influjo próvido de espirituales lluvias,
 :el alma está brotando florestas de ilusión.
 :
 :Y hay días en que somos tan sórdidos, tan sórdidos,
 :como la entraña obscura de obscuro pedernal:
 :la noche nos sorprende, con sus profusas lámparas,
 :en rútilas monedas tasando el Bien y el Mal.
 :
 :                 Porfirio Barba-Jacob
 :                 (1883 - 1942)

*:PRACTICA_PRECISION2
B:Segunda práctica de precisión
s:Fragmento de "NOCHE DE DICIEMBRE"
 :
 :Noche como esta, y contemplada a solas,
 :no la puede sufrir mi corazón:
 :da un dolor de hermosura irresistible,
 :un miedo profundísimo de Dios.
 :
 :Ven a partir conmigo lo que siento,
 :esto que abrumador desborda en mí;
 :ven a hacerme finito lo infinito
 :y a encarnar el angélico festín.
 :
 :Mira ese cielo! ... Es demasiado cielo
 :para el ojo de insecto de un mortal,
 :refléjame en tus ojos un fragmento
 :que yo alcance a medir y a sondear.
 :
 :                   Rafael Pombo
 :                  (1833 - 1912)

*:EVALUACION_PRECISION
B:Evaluación de precisión
I:En está evaluación se espera por lo menos 30wpm y a lo sumo 1% de error
E:1%
F:MENU_PRECISION
S:Fragmento del prologo a "POR LO QUE HE VIVIDO"
 :
 :Tres pasiones, simples pero increíblemente fuertes, han gobernado mi vida:
 :las ansias del amor, la búsqueda del conocimiento, y una insoportable
 :compasión por el sufrimiento de la humanidad.  Estas pasiones, como grandes
 :vientos, me han enviado de aquí para allá, en un curso impredecible, sobre un
 :profundo océano de angustia, llegando al borde del desespero.
 :
 :He explorado el amor, primero, porque trae éxtasis -- éxtasis tan
 :grande que yo a menudo habría sacrificado todo el resto de la vida
 :por unas pocas horas de este placer. Lo he explorado, también, porque
 :alivia la soledad -- esa terrible soledad en la cual la vibrante conciencia
 :mira en el extremo del mundo el frío e incomprensible abismo sin vida.
 :Lo he explorado, finalmente, porque en la unión del amor he visto,
 :en una mística miniatura, la visión prefigurada del cielo que santos y
 :poetas han imaginado. Esto es lo que he explorado y pensado y esto podría
 :parecer demasiado bueno para la vida humana, esto es lo que, al fin
 :he encontrado.
 :
 :                         Bertrand Russel
G:PRECISION

*:FINAL
X:
