/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;

public class SettlementType
extends FreeColGameObjectType {
    private boolean capital = false;
    private int visibleRadius = 2;
    private int claimableRadius = 1;
    private int extraClaimableRadius = 2;
    private int wanderingRadius = 4;
    private int minimumSize = 3;
    private int maximumSize = 10;
    private int minimumGrowth = 1;
    private int maximumGrowth = 10;
    private int tradeBonus = 1;
    private int convertThreshold = 100;
    private List<RandomRange> plunder = null;
    private List<RandomRange> gifts = null;
    private static final String CAPITAL_TAG = "capital";
    private static final String CLAIMABLE_RADIUS_TAG = "claimable-radius";
    private static final String CONVERT_THRESHOLD_TAG = "convert-threshold";
    private static final String EXTRA_CLAIMABLE_RADIUS_TAG = "extra-claimable-radius";
    private static final String GIFTS_TAG = "gifts";
    private static final String MAXIMUM_GROWTH_TAG = "maximum-growth";
    private static final String MAXIMUM_SIZE_TAG = "maximum-size";
    private static final String MINIMUM_GROWTH_TAG = "minimum-growth";
    private static final String MINIMUM_SIZE_TAG = "minimum-size";
    private static final String PLUNDER_TAG = "plunder";
    private static final String TRADE_BONUS_TAG = "trade-bonus";
    private static final String VISIBLE_RADIUS_TAG = "visible-radius";
    private static final String WANDERING_RADIUS_TAG = "wandering-radius";
    private static final String OLD_CLAIMABLE_RADIUS_TAG = "claimableRadius";
    private static final String OLD_CONVERT_THRESHOLD_TAG = "convertThreshold";
    private static final String OLD_EXTRA_CLAIMABLE_RADIUS_TAG = "extraClaimableRadius";
    private static final String OLD_MAXIMUM_GROWTH_TAG = "maximumGrowth";
    private static final String OLD_MAXIMUM_SIZE_TAG = "maximumSize";
    private static final String OLD_MINIMUM_GROWTH_TAG = "minimumGrowth";
    private static final String OLD_MINIMUM_SIZE_TAG = "minimumSize";
    private static final String OLD_TRADE_BONUS_TAG = "tradeBonus";
    private static final String OLD_VISIBLE_RADIUS_TAG = "visibleRadius";
    private static final String OLD_WANDERING_RADIUS_TAG = "wanderingRadius";

    public SettlementType(String id, Specification specification) {
        super(id, specification);
    }

    public SettlementType(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        super(specification);
        this.readFromXML(xr);
    }

    public final boolean isCapital() {
        return this.capital;
    }

    public final int getMinimumSize() {
        return this.minimumSize;
    }

    public final int getMaximumSize() {
        return this.maximumSize;
    }

    public final int getVisibleRadius() {
        return this.visibleRadius;
    }

    public final int getClaimableRadius() {
        return this.claimableRadius;
    }

    public final int getExtraClaimableRadius() {
        return this.extraClaimableRadius;
    }

    public final int getWanderingRadius() {
        return this.wanderingRadius;
    }

    public final int getMinimumGrowth() {
        return this.minimumGrowth;
    }

    public final int getMaximumGrowth() {
        return this.maximumGrowth;
    }

    public final int getTradeBonus() {
        return this.tradeBonus;
    }

    public int getConvertThreshold() {
        return this.convertThreshold;
    }

    public final RandomRange getPlunderRange(Unit unit) {
        return this.plunder == null ? null : CollectionUtils.find(this.plunder, p -> p.appliesTo(unit));
    }

    public final RandomRange getGifts(Unit unit) {
        return this.gifts == null ? null : CollectionUtils.find(this.gifts, g -> g.appliesTo(unit));
    }

    public int getWarehouseCapacity() {
        return 100 * this.getClaimableRadius();
    }

    private void addGift(RandomRange gift) {
        if (this.gifts == null) {
            this.gifts = new ArrayList<RandomRange>();
        }
        this.gifts.add(gift);
    }

    private void addPlunder(RandomRange range) {
        if (this.plunder == null) {
            this.plunder = new ArrayList<RandomRange>();
        }
        this.plunder.add(range);
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(CAPITAL_TAG, this.capital);
        xw.writeAttribute(MINIMUM_SIZE_TAG, this.minimumSize);
        xw.writeAttribute(MAXIMUM_SIZE_TAG, this.maximumSize);
        xw.writeAttribute(VISIBLE_RADIUS_TAG, this.visibleRadius);
        xw.writeAttribute(CLAIMABLE_RADIUS_TAG, this.claimableRadius);
        xw.writeAttribute(EXTRA_CLAIMABLE_RADIUS_TAG, this.extraClaimableRadius);
        xw.writeAttribute(WANDERING_RADIUS_TAG, this.wanderingRadius);
        xw.writeAttribute(MINIMUM_GROWTH_TAG, this.minimumGrowth);
        xw.writeAttribute(MAXIMUM_GROWTH_TAG, this.maximumGrowth);
        xw.writeAttribute(TRADE_BONUS_TAG, this.tradeBonus);
        xw.writeAttribute(CONVERT_THRESHOLD_TAG, this.convertThreshold);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.plunder != null) {
            for (RandomRange range : this.plunder) {
                range.toXML(xw, PLUNDER_TAG);
            }
        }
        if (this.gifts != null) {
            for (RandomRange range : this.gifts) {
                range.toXML(xw, GIFTS_TAG);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.capital = xr.getAttribute(CAPITAL_TAG, this.capital);
        this.minimumSize = xr.hasAttribute(OLD_MINIMUM_SIZE_TAG) ? xr.getAttribute(OLD_MINIMUM_SIZE_TAG, this.minimumSize) : xr.getAttribute(MINIMUM_SIZE_TAG, this.minimumSize);
        this.maximumSize = xr.hasAttribute(OLD_MAXIMUM_SIZE_TAG) ? xr.getAttribute(OLD_MAXIMUM_SIZE_TAG, this.maximumSize) : xr.getAttribute(MAXIMUM_SIZE_TAG, this.maximumSize);
        this.visibleRadius = xr.hasAttribute(OLD_VISIBLE_RADIUS_TAG) ? xr.getAttribute(OLD_VISIBLE_RADIUS_TAG, this.visibleRadius) : xr.getAttribute(VISIBLE_RADIUS_TAG, this.visibleRadius);
        this.claimableRadius = xr.hasAttribute(OLD_CLAIMABLE_RADIUS_TAG) ? xr.getAttribute(OLD_CLAIMABLE_RADIUS_TAG, this.claimableRadius) : xr.getAttribute(CLAIMABLE_RADIUS_TAG, this.claimableRadius);
        this.extraClaimableRadius = xr.hasAttribute(OLD_EXTRA_CLAIMABLE_RADIUS_TAG) ? xr.getAttribute(OLD_EXTRA_CLAIMABLE_RADIUS_TAG, this.extraClaimableRadius) : xr.getAttribute(EXTRA_CLAIMABLE_RADIUS_TAG, this.extraClaimableRadius);
        this.wanderingRadius = xr.hasAttribute(OLD_WANDERING_RADIUS_TAG) ? xr.getAttribute(OLD_WANDERING_RADIUS_TAG, this.wanderingRadius) : xr.getAttribute(WANDERING_RADIUS_TAG, this.wanderingRadius);
        this.minimumGrowth = xr.hasAttribute(OLD_MINIMUM_GROWTH_TAG) ? xr.getAttribute(OLD_MINIMUM_GROWTH_TAG, this.minimumGrowth) : xr.getAttribute(MINIMUM_GROWTH_TAG, this.minimumGrowth);
        this.maximumGrowth = xr.hasAttribute(OLD_MAXIMUM_GROWTH_TAG) ? xr.getAttribute(OLD_MAXIMUM_GROWTH_TAG, this.maximumGrowth) : xr.getAttribute(MAXIMUM_GROWTH_TAG, this.maximumGrowth);
        this.tradeBonus = xr.hasAttribute(OLD_TRADE_BONUS_TAG) ? xr.getAttribute(OLD_TRADE_BONUS_TAG, this.tradeBonus) : xr.getAttribute(TRADE_BONUS_TAG, this.tradeBonus);
        this.convertThreshold = xr.hasAttribute(OLD_CONVERT_THRESHOLD_TAG) ? xr.getAttribute(OLD_CONVERT_THRESHOLD_TAG, this.convertThreshold) : xr.getAttribute(CONVERT_THRESHOLD_TAG, this.convertThreshold);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.plunder = null;
            this.gifts = null;
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (GIFTS_TAG.equals(tag)) {
            this.addGift(new RandomRange(xr));
        } else if (PLUNDER_TAG.equals(tag)) {
            this.addPlunder(new RandomRange(xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return SettlementType.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "settlementType";
    }
}

