"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImage = exports.SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _overlay_mask = require("../overlay_mask");

var _icon = require("../icon");

var _i18n = require("../i18n");

var _focus_trap = require("../focus_trap");

var _services = require("../../services");

var _inner_text = require("../inner_text");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var sizeToClassNameMap = {
  s: 'euiImage--small',
  m: 'euiImage--medium',
  l: 'euiImage--large',
  xl: 'euiImage--xlarge',
  fullWidth: 'euiImage--fullWidth',
  original: ''
};
var SIZES = Object.keys(sizeToClassNameMap);
exports.SIZES = SIZES;
var fullScreenIconColorMap = {
  light: 'ghost',
  dark: 'default'
};

var EuiImage = function EuiImage(_ref) {
  var className = _ref.className,
      url = _ref.url,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'original' : _ref$size,
      caption = _ref.caption,
      hasShadow = _ref.hasShadow,
      allowFullScreen = _ref.allowFullScreen,
      _ref$fullScreenIconCo = _ref.fullScreenIconColor,
      fullScreenIconColor = _ref$fullScreenIconCo === void 0 ? 'light' : _ref$fullScreenIconCo,
      alt = _ref.alt,
      style = _ref.style,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "url", "size", "caption", "hasShadow", "allowFullScreen", "fullScreenIconColor", "alt", "style"]);

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isFullScreenActive = _useState2[0],
      setIsFullScreenActive = _useState2[1];

  var onKeyDown = function onKeyDown(event) {
    if (event.key === _services.keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      closeFullScreen();
    }
  };

  var closeFullScreen = function closeFullScreen() {
    setIsFullScreenActive(false);
  };

  var openFullScreen = function openFullScreen() {
    setIsFullScreenActive(true);
  };

  var customStyle = _objectSpread({}, style);

  var classes = (0, _classnames.default)('euiImage', {
    'euiImage--hasShadow': hasShadow,
    'euiImage--allowFullScreen': allowFullScreen
  }, className);

  if (typeof size === 'string' && SIZES.includes(size)) {
    classes = "".concat(classes, " ").concat(sizeToClassNameMap[size]);
  } else {
    classes = "".concat(classes);
    customStyle.maxWidth = size;
    customStyle.maxHeight = size; // Set width back to auto to ensure aspect ratio is kept

    customStyle.width = 'auto';
  }

  var _useInnerText = (0, _inner_text.useInnerText)(),
      _useInnerText2 = (0, _slicedToArray2.default)(_useInnerText, 2),
      optionalCaptionRef = _useInnerText2[0],
      optionalCaptionText = _useInnerText2[1];

  var optionalCaption;

  if (caption) {
    optionalCaption = /*#__PURE__*/_react.default.createElement("figcaption", {
      ref: optionalCaptionRef,
      className: "euiImage__caption"
    }, caption);
  }

  var allowFullScreenIcon = /*#__PURE__*/_react.default.createElement(_icon.EuiIcon, {
    type: "fullScreen",
    color: fullScreenIconColorMap[fullScreenIconColor],
    className: "euiImage__icon"
  });

  var fullScreenDisplay = /*#__PURE__*/_react.default.createElement(_overlay_mask.EuiOverlayMask, {
    "data-test-subj": "fullScreenOverlayMask",
    onClick: closeFullScreen
  }, /*#__PURE__*/_react.default.createElement(_focus_trap.EuiFocusTrap, {
    clickOutsideDisables: true
  }, /*#__PURE__*/_react.default.createElement("figure", {
    className: "euiImage euiImage-isFullScreen",
    "aria-label": optionalCaptionText
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    "aria-label": (0, _i18n.useEuiI18n)('euiImage.closeImage', 'Close full screen {alt} image', {
      alt: alt
    }),
    className: "euiImage__button",
    "data-test-subj": "deactivateFullScreenButton",
    onClick: closeFullScreen,
    onKeyDown: onKeyDown
  }, /*#__PURE__*/_react.default.createElement("img", (0, _extends2.default)({
    src: url,
    alt: alt,
    className: "euiImage-isFullScreen__img"
  }, rest)), /*#__PURE__*/_react.default.createElement(_icon.EuiIcon, {
    type: "cross",
    color: fullScreenIconColorMap[fullScreenIconColor],
    className: "euiImage-isFullScreen__icon"
  })), optionalCaption)));

  var fullscreenLabel = (0, _i18n.useEuiI18n)('euiImage.openImage', 'Open full screen {alt} image', {
    alt: alt
  });

  if (allowFullScreen) {
    return /*#__PURE__*/_react.default.createElement("figure", {
      className: classes,
      "aria-label": optionalCaptionText
    }, /*#__PURE__*/_react.default.createElement("button", {
      type: "button",
      "aria-label": fullscreenLabel,
      className: "euiImage__button",
      "data-test-subj": "activateFullScreenButton",
      onClick: openFullScreen
    }, /*#__PURE__*/_react.default.createElement("img", (0, _extends2.default)({
      src: url,
      alt: alt,
      className: "euiImage__img",
      style: customStyle
    }, rest)), allowFullScreenIcon), isFullScreenActive && fullScreenDisplay, optionalCaption);
  } else {
    return /*#__PURE__*/_react.default.createElement("figure", {
      className: classes,
      "aria-label": optionalCaptionText
    }, /*#__PURE__*/_react.default.createElement("img", (0, _extends2.default)({
      style: customStyle,
      src: url,
      className: "euiImage__img",
      alt: alt
    }, rest)), optionalCaption);
  }
};

exports.EuiImage = EuiImage;
EuiImage.propTypes = {
  /**
     * Separate from the caption is a title on the alt tag itself.
     * This one is required for accessibility.
     */
  alt: _propTypes.default.string.isRequired,

  /**
     * Accepts `s` / `m` / `l` / `xl` / `original` / `fullWidth` / or a CSS size of `number` or `string`.
     * `fullWidth` will set the figure to stretch to 100% of its container.
     * `string` and `number` types will max both the width or height, whichever is greater.
     */
  size: _propTypes.default.oneOfType([_propTypes.default.oneOf(["s", "m", "l", "xl", "fullWidth", "original"]).isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

  /**
     * Changes the color of the icon that floats above the image when it can be clicked to fullscreen.
     * The default value of `light` is fine unless your image has a white background, in which case you should change it to `dark`.
     */
  fullScreenIconColor: _propTypes.default.oneOf(["light", "dark"]),
  url: _propTypes.default.string.isRequired,

  /**
     * Provides the visible caption to the image
     */
  caption: _propTypes.default.node,

  /**
     * When set to `true` (default) will apply a slight shadow to the image
     */
  hasShadow: _propTypes.default.bool,

  /**
     * When set to `true` will make the image clickable to a larger version
     */
  allowFullScreen: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};