#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for eos_lacp
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type


DOCUMENTATION = """
module: eos_lacp
short_description: LACP resource module
description:
- This module manages Global Link Aggregation Control Protocol (LACP) on Arista EOS
  devices.
version_added: 1.0.0
author: Nathaniel Case (@Qalthos)
notes:
- Tested against Arista EOS 4.20.10M
- This module works with connection C(network_cli). See the L(EOS Platform Options,../network/user_guide/platform_eos.html).
options:
  config:
    description: LACP global options.
    type: dict
    suboptions:
      system:
        description: LACP system options.
        type: dict
        suboptions:
          priority:
            description:
            - The system priority to use in LACP negotiations.
            - Lower value is higher priority.
            - Refer to vendor documentation for valid values.
            type: int
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the EOS device by
      executing the command B(show running-config | section ^lacp).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  state:
    description:
    - The state of the configuration after module completion.
    type: str
    choices:
    - merged
    - replaced
    - deleted
    - parsed
    - rendered
    - gathered
    default: merged

"""
EXAMPLES = """
# Using merged

# Before state:
# -------------
# veos# show running-config | include lacp
# lacp system-priority 10

- name: Merge provided global LACP attributes with device attributes
  arista.eos.eos_lacp:
    config:
      system:
        priority: 20
    state: merged

# After state:
# ------------
# veos# show running-config | include lacp
# lacp system-priority 20
#


# Using replaced

# Before state:
# -------------
# veos# show running-config | include lacp
# lacp system-priority 10

- name: Replace device global LACP attributes with provided attributes
  arista.eos.eos_lacp:
    config:
      system:
        priority: 20
    state: replaced

# After state:
# ------------
# veos# show running-config | include lacp
# lacp system-priority 20
#


# Using deleted

# Before state:
# -------------
# veos# show running-config | include lacp
# lacp system-priority 10

- name: Delete global LACP attributes
  arista.eos.eos_lacp:
    state: deleted

# After state:
# ------------
# veos# show running-config | include lacp
#

#Using rendered:

- name: Use Rendered to convert the structured data to native config
  arista.eos.eos_lacp:
    config:
      system:
        priority: 20
    state: rendered

# Output:
# ------------
# rendered:
#   - "lacp system-priority 20"
#

# Using parsed:

# parsed.cfg
# lacp system-priority 20

- name: Use parsed to convert native configs to structured data
  arista.eos.eos_lacp:
    running_config: "{{ lookup('file', 'parsed.cfg') }}"
    state: parsed

# Output:
# parsed:
#   system:
#     priority: 20

# Using gathered:
# nathive config:
# -------------
# lacp system-priority 10

- name: Gather lacp facts from the device
  arista.eos.eos_lacp:
    state: gathered

# Output:
# gathered:
#   system:
#     priority: 10
#

"""
RETURN = """
before:
  description: The configuration as structured data prior to module invocation.
  returned: always
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The configuration as structured data after module completion.
  returned: when changed
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['lacp system-priority 10']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.arista.eos.plugins.module_utils.network.eos.argspec.lacp.lacp import (
    LacpArgs,
)
from ansible_collections.arista.eos.plugins.module_utils.network.eos.config.lacp.lacp import (
    Lacp,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    mutually_exclusive = [("config", "running_config")]
    module = AnsibleModule(
        argument_spec=LacpArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
        mutually_exclusive=mutually_exclusive,
    )

    result = Lacp(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
