/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.search.ExtensionSearch;
import org.zaproxy.zap.extension.search.HttpSearcher;
import org.zaproxy.zap.extension.search.SearchListenner;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchResult;

public class SearchThread
extends Thread {
    private static final String THREAD_NAME = "ZAP-SearchThread";
    private String filter;
    private Pattern pattern;
    private ExtensionSearch.Type reqType;
    private SearchListenner searchListenner;
    private boolean stopSearch = false;
    private boolean inverse = false;
    private boolean searchJustInScope = false;
    private String baseUrl;
    private PaginationConstraintsChecker pcc;
    private Map<String, HttpSearcher> searchers;
    private String customSearcherName;
    private boolean searchAllOccurrences;
    private static Logger log = Logger.getLogger(SearchThread.class);

    public SearchThread(String filter, ExtensionSearch.Type reqType, SearchListenner searchListenner, boolean inverse, boolean searchJustInScope, String baseUrl, int start, int count) {
        this(filter, reqType, searchListenner, inverse, searchJustInScope, baseUrl, start, count, true);
    }

    public SearchThread(String filter, ExtensionSearch.Type reqType, SearchListenner searchListenner, boolean inverse, boolean searchJustInScope, String baseUrl, int start, int count, boolean searchAllOccurrences) {
        this(filter, reqType, searchListenner, inverse, searchJustInScope, baseUrl, start, count, searchAllOccurrences, -1);
    }

    public SearchThread(String filter, ExtensionSearch.Type reqType, SearchListenner searchListenner, boolean inverse, boolean searchJustInScope, String baseUrl, int start, int count, boolean searchAllOccurrences, int maxOccurrences) {
        this(filter, reqType, null, searchListenner, inverse, searchJustInScope, baseUrl, start, count, searchAllOccurrences, maxOccurrences);
    }

    public SearchThread(String filter, ExtensionSearch.Type reqType, String customSearcherName, SearchListenner searchListenner, boolean inverse, boolean searchJustInScope, String baseUrl, int start, int count, boolean searchAllOccurrences, int maxOccurrences) {
        super(THREAD_NAME);
        this.filter = filter;
        this.pattern = Pattern.compile(filter, 10);
        this.reqType = reqType;
        this.customSearcherName = customSearcherName;
        this.searchListenner = searchListenner;
        this.inverse = inverse;
        this.searchJustInScope = searchJustInScope;
        this.baseUrl = baseUrl;
        this.pcc = new PaginationConstraintsChecker(start, count, maxOccurrences);
        this.searchAllOccurrences = searchAllOccurrences;
    }

    public void setCustomSearchers(Map<String, HttpSearcher> searchers) {
        this.searchers = searchers;
    }

    public void stopSearch() {
        this.stopSearch = true;
    }

    @Override
    public void run() {
        try {
            this.searchListenner.searchStarted();
            this.search();
        }
        finally {
            this.searchListenner.searchComplete();
        }
    }

    private void search() {
        Session session = Model.getSingleton().getSession();
        Matcher matcher = null;
        try {
            if (ExtensionSearch.Type.Custom.equals((Object)this.reqType)) {
                HttpSearcher searcher;
                if (this.searchers != null && this.customSearcherName != null && (searcher = this.searchers.get(this.customSearcherName)) != null) {
                    List<SearchResult> results = this.pcc.hasMaximumMatches() ? searcher.search(this.pattern, this.inverse, this.pcc.getMaximumMatches()) : searcher.search(this.pattern, this.inverse);
                    for (SearchResult sr : results) {
                        this.searchListenner.addSearchResult(sr);
                    }
                }
                return;
            }
            List<Integer> list = Model.getSingleton().getDb().getTableHistory().getHistoryIdsOfHistType(session.getSessionId(), 1, 15, 2, 10);
            int last = list.size();
            int currentRecordId = 0;
            for (int index = 0; index < last && !this.stopSearch; ++index) {
                block33: {
                    int historyId = list.get(index);
                    try {
                        currentRecordId = index;
                        HistoryReference href = new HistoryReference(historyId);
                        HttpMessage message = href.getHttpMessage();
                        if (this.searchJustInScope && !session.isInScope(message.getRequestHeader().getURI().toString()) || this.baseUrl != null && !message.getRequestHeader().getURI().toString().startsWith(this.baseUrl)) continue;
                        if (ExtensionSearch.Type.URL.equals((Object)this.reqType)) {
                            String url = message.getRequestHeader().getURI().toString();
                            matcher = this.pattern.matcher(url);
                            if (this.inverse && !this.pcc.allMatchesProcessed()) {
                                if (!matcher.find()) {
                                    this.notifyInverseMatchFound(currentRecordId, message, SearchMatch.Location.REQUEST_HEAD);
                                }
                            } else {
                                int urlStartPos = message.getRequestHeader().getPrimeHeader().indexOf(url);
                                while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                                    this.notifyMatchFound(currentRecordId, matcher.group(), message, SearchMatch.Location.REQUEST_HEAD, urlStartPos + matcher.start(), urlStartPos + matcher.end());
                                    if (this.searchAllOccurrences) continue;
                                }
                            }
                        }
                        if (ExtensionSearch.Type.Header.equals((Object)this.reqType)) {
                            matcher = this.pattern.matcher(message.getRequestHeader().toString());
                            if (this.inverse && !this.pcc.allMatchesProcessed()) {
                                if (!matcher.find()) {
                                    this.notifyInverseMatchFound(currentRecordId, message, SearchMatch.Location.REQUEST_HEAD);
                                }
                            } else {
                                while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                                    this.notifyMatchFound(currentRecordId, matcher.group(), message, SearchMatch.Location.REQUEST_HEAD, matcher.start(), matcher.end());
                                    if (this.searchAllOccurrences) continue;
                                }
                            }
                            matcher = this.pattern.matcher(message.getResponseHeader().toString());
                            if (this.inverse && !this.pcc.allMatchesProcessed()) {
                                if (!matcher.find()) {
                                    this.notifyInverseMatchFound(currentRecordId, message, SearchMatch.Location.RESPONSE_HEAD);
                                }
                            } else {
                                while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                                    this.notifyMatchFound(currentRecordId, matcher.group(), message, SearchMatch.Location.RESPONSE_HEAD, matcher.start(), matcher.end());
                                    if (this.searchAllOccurrences) continue;
                                }
                            }
                        }
                        if (ExtensionSearch.Type.Request.equals((Object)this.reqType) || ExtensionSearch.Type.All.equals((Object)this.reqType)) {
                            if (this.inverse && !this.pcc.allMatchesProcessed()) {
                                if (!this.pattern.matcher(message.getRequestHeader().toString()).find() && !this.pattern.matcher(message.getRequestBody().toString()).find()) {
                                    this.notifyInverseMatchFound(currentRecordId, message, SearchMatch.Location.REQUEST_HEAD);
                                }
                            } else {
                                matcher = this.pattern.matcher(message.getRequestHeader().toString());
                                while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                                    this.notifyMatchFound(currentRecordId, matcher.group(), message, SearchMatch.Location.REQUEST_HEAD, matcher.start(), matcher.end());
                                    if (this.searchAllOccurrences) continue;
                                }
                                matcher = this.pattern.matcher(message.getRequestBody().toString());
                                while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                                    this.notifyMatchFound(currentRecordId, matcher.group(), message, SearchMatch.Location.REQUEST_BODY, matcher.start(), matcher.end());
                                    if (this.searchAllOccurrences) continue;
                                }
                            }
                        }
                        if (!ExtensionSearch.Type.Response.equals((Object)this.reqType) && !ExtensionSearch.Type.All.equals((Object)this.reqType)) break block33;
                        if (this.inverse && !this.pcc.allMatchesProcessed()) {
                            if (!this.pattern.matcher(message.getResponseHeader().toString()).find() && !this.pattern.matcher(message.getResponseBody().toString()).find()) {
                                this.notifyInverseMatchFound(currentRecordId, message, SearchMatch.Location.RESPONSE_HEAD);
                            }
                            break block33;
                        }
                        matcher = this.pattern.matcher(message.getResponseHeader().toString());
                        while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                            this.notifyMatchFound(currentRecordId, matcher.group(), message, SearchMatch.Location.RESPONSE_HEAD, matcher.start(), matcher.end());
                            if (this.searchAllOccurrences) continue;
                        }
                        matcher = this.pattern.matcher(message.getResponseBody().toString());
                        while (matcher.find() && !this.pcc.allMatchesProcessed()) {
                            this.notifyMatchFound(currentRecordId, matcher.group(), message, SearchMatch.Location.RESPONSE_BODY, matcher.start(), matcher.end());
                            if (this.searchAllOccurrences) continue;
                            break;
                        }
                    }
                    catch (HttpMalformedHeaderException e1) {
                        log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
                if (!this.pcc.hasPageEnded()) {
                    continue;
                }
                break;
            }
        }
        catch (DatabaseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void notifyInverseMatchFound(int currentRecordId, HttpMessage message, SearchMatch.Location location) {
        this.notifyMatchFound(currentRecordId, "", message, location, 0, 0);
    }

    private void notifyMatchFound(int currentRecordId, String stringFound, HttpMessage message, SearchMatch.Location location, int start, int end) {
        this.pcc.recordProcessed(currentRecordId);
        if (!this.pcc.hasPageStarted()) {
            return;
        }
        this.pcc.matchProcessed();
        this.searchListenner.addSearchResult(new SearchResult(this.reqType, this.filter, stringFound, new SearchMatch(message, location, start, end)));
    }

    private static class PaginationConstraintsChecker {
        private boolean pageStarted;
        private boolean pageEnded;
        private final int startRecord;
        private final boolean hasEnd;
        private final int finalRecord;
        private int recordsProcessed = 0;
        private int currentRecordId = -1;
        private final int maximumMatches;
        private final boolean hasMaximumMatches;
        private boolean allMatchesProcessed;
        private int matchesProcessed = 0;

        public PaginationConstraintsChecker(int start, int count, int matches) {
            if (start > 0) {
                this.pageStarted = false;
                this.startRecord = start;
            } else {
                this.pageStarted = true;
                this.startRecord = 0;
            }
            if (count > 0) {
                this.hasEnd = true;
                this.finalRecord = !this.pageStarted ? start + count - 1 : count;
            } else {
                this.hasEnd = false;
                this.finalRecord = 0;
            }
            this.pageEnded = false;
            this.allMatchesProcessed = false;
            this.maximumMatches = matches;
            this.hasMaximumMatches = this.maximumMatches > 0;
        }

        public boolean hasMaximumMatches() {
            return this.hasMaximumMatches;
        }

        public int getMaximumMatches() {
            return this.maximumMatches;
        }

        public void recordProcessed(int recordId) {
            if (this.currentRecordId == recordId) {
                return;
            }
            this.currentRecordId = recordId;
            ++this.recordsProcessed;
            if (!this.pageStarted) {
                boolean bl = this.pageStarted = this.recordsProcessed >= this.startRecord;
            }
            if (this.hasEnd && !this.pageEnded) {
                this.pageEnded = this.recordsProcessed >= this.finalRecord;
            }
        }

        public void matchProcessed() {
            ++this.matchesProcessed;
            if (this.hasMaximumMatches && this.matchesProcessed >= this.maximumMatches) {
                this.allMatchesProcessed = true;
                this.pageEnded = true;
            }
        }

        public boolean hasPageStarted() {
            return this.pageStarted;
        }

        public boolean hasPageEnded() {
            return this.pageEnded;
        }

        public boolean allMatchesProcessed() {
            return this.allMatchesProcessed;
        }
    }
}

