/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;

public class HtmlTag
extends TagSupport {
    protected static MessageResources messages = MessageResources.getMessageResources((String)"org.apache.struts.taglib.html.LocalStrings");
    protected boolean xhtml = false;
    protected boolean lang = false;

    public boolean getXhtml() {
        return this.xhtml;
    }

    public void setXhtml(boolean xhtml) {
        this.xhtml = xhtml;
    }

    public boolean getLang() {
        return this.lang;
    }

    public void setLang(boolean lang) {
        this.lang = lang;
    }

    public int doStartTag() throws JspException {
        TagUtils.getInstance().write(this.pageContext, this.renderHtmlStartElement());
        return 1;
    }

    protected String renderHtmlStartElement() {
        StringBuffer sb = new StringBuffer("<html");
        String language = null;
        String country = "";
        Locale currentLocale = TagUtils.getInstance().getUserLocale(this.pageContext, "org.apache.struts.action.LOCALE");
        language = currentLocale.getLanguage();
        country = currentLocale.getCountry();
        boolean validLanguage = this.isValidRfc2616(language);
        boolean validCountry = this.isValidRfc2616(country);
        if (this.xhtml) {
            this.pageContext.setAttribute("org.apache.struts.globals.XHTML", (Object)"true", 1);
            sb.append(" xmlns=\"http://www.w3.org/1999/xhtml\"");
        }
        if ((this.lang || this.xhtml) && validLanguage) {
            sb.append(" lang=\"");
            sb.append(language);
            if (validCountry) {
                sb.append("-");
                sb.append(country);
            }
            sb.append("\"");
        }
        if (this.xhtml && validLanguage) {
            sb.append(" xml:lang=\"");
            sb.append(language);
            if (validCountry) {
                sb.append("-");
                sb.append(country);
            }
            sb.append("\"");
        }
        sb.append(">");
        return sb.toString();
    }

    public int doEndTag() throws JspException {
        TagUtils.getInstance().write(this.pageContext, "</html>");
        return 6;
    }

    public void release() {
        this.xhtml = false;
        this.lang = false;
    }

    private boolean isValidRfc2616(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetter(c) || c == '-') continue;
            return false;
        }
        return true;
    }
}

