/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.tomcat.dbcp.dbcp2.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp2.DelegatingCallableStatement;
import org.apache.tomcat.dbcp.dbcp2.DelegatingDatabaseMetaData;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.DelegatingStatement;
import org.apache.tomcat.dbcp.dbcp2.Jdbc41Bridge;
import org.apache.tomcat.dbcp.dbcp2.SQLExceptionList;

public class DelegatingConnection<C extends Connection>
extends AbandonedTrace
implements Connection {
    private static final Map<String, ClientInfoStatus> EMPTY_FAILED_PROPERTIES = Collections.emptyMap();
    private volatile C connection;
    private volatile boolean closed;
    private boolean cacheState = true;
    private Boolean autoCommitCached;
    private Boolean readOnlyCached;
    private Integer defaultQueryTimeoutSeconds;

    public DelegatingConnection(C c) {
        this.connection = c;
    }

    public synchronized String toString() {
        String str = null;
        Connection conn = this.getInnermostDelegateInternal();
        if (conn != null) {
            try {
                if (conn.isClosed()) {
                    str = "connection is closed";
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.hashCode());
                    DatabaseMetaData meta = conn.getMetaData();
                    if (meta != null) {
                        sb.append(", URL=");
                        sb.append(meta.getURL());
                        sb.append(", ");
                        sb.append(meta.getDriverName());
                        str = sb.toString();
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return str != null ? str : super.toString();
    }

    public C getDelegate() {
        return this.getDelegateInternal();
    }

    protected final C getDelegateInternal() {
        return this.connection;
    }

    public boolean innermostDelegateEquals(Connection c) {
        Connection innerCon = this.getInnermostDelegateInternal();
        if (innerCon == null) {
            return c == null;
        }
        return innerCon.equals(c);
    }

    public Connection getInnermostDelegate() {
        return this.getInnermostDelegateInternal();
    }

    public final Connection getInnermostDelegateInternal() {
        C conn = this.connection;
        while (conn instanceof DelegatingConnection) {
            if (this != (conn = ((DelegatingConnection)conn).getDelegateInternal())) continue;
            return null;
        }
        return conn;
    }

    public void setDelegate(C connection) {
        this.connection = connection;
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closeInternal();
        }
    }

    protected boolean isClosedInternal() {
        return this.closed;
    }

    protected void setClosedInternal(boolean closed) {
        this.closed = closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected final void closeInternal() throws SQLException {
        try {
            this.passivate();
        }
        finally {
            if (this.connection != null) {
                try {
                    connectionIsClosed = this.connection.isClosed();
                }
                catch (SQLException e) {
                    connectionIsClosed = false;
                }
                try {
                    if (connectionIsClosed) ** GOTO lbl19
                    this.connection.close();
                }
                finally {
                    this.closed = true;
                }
            } else {
                this.closed = true;
            }
lbl19:
            // 3 sources

        }
    }

    protected void handleException(SQLException e) throws SQLException {
        throw e;
    }

    protected <T extends Throwable> T handleExceptionNoThrow(T e) {
        return e;
    }

    private void initializeStatement(DelegatingStatement ds) throws SQLException {
        if (this.defaultQueryTimeoutSeconds != null && this.defaultQueryTimeoutSeconds.intValue() != ds.getQueryTimeout()) {
            ds.setQueryTimeout(this.defaultQueryTimeoutSeconds);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        try {
            DelegatingStatement ds = new DelegatingStatement(this, this.connection.createStatement());
            this.initializeStatement(ds);
            return ds;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        try {
            DelegatingStatement ds = new DelegatingStatement(this, this.connection.createStatement(resultSetType, resultSetConcurrency));
            this.initializeStatement(ds);
            return ds;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        try {
            DelegatingPreparedStatement dps = new DelegatingPreparedStatement(this, this.connection.prepareStatement(sql));
            this.initializeStatement(dps);
            return dps;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        try {
            DelegatingPreparedStatement dps = new DelegatingPreparedStatement(this, this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency));
            this.initializeStatement(dps);
            return dps;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkOpen();
        try {
            DelegatingCallableStatement dcs = new DelegatingCallableStatement(this, this.connection.prepareCall(sql));
            this.initializeStatement(dcs);
            return dcs;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        try {
            DelegatingCallableStatement dcs = new DelegatingCallableStatement(this, this.connection.prepareCall(sql, resultSetType, resultSetConcurrency));
            this.initializeStatement(dcs);
            return dcs;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this.connection.clearWarnings();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    public boolean getCacheState() {
        return this.cacheState;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        if (this.cacheState && this.autoCommitCached != null) {
            return this.autoCommitCached;
        }
        try {
            this.autoCommitCached = this.connection.getAutoCommit();
            return this.autoCommitCached;
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getCatalog();
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingDatabaseMetaData(this, this.connection.getMetaData());
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getTransactionIsolation();
        }
        catch (SQLException e) {
            this.handleException(e);
            return -1;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getTypeMap();
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getWarnings();
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        if (this.cacheState && this.readOnlyCached != null) {
            return this.readOnlyCached;
        }
        try {
            this.readOnlyCached = this.connection.isReadOnly();
            return this.readOnlyCached;
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        try {
            return this.connection.nativeSQL(sql);
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    public Integer getDefaultQueryTimeout() {
        return this.defaultQueryTimeoutSeconds;
    }

    public void setDefaultQueryTimeout(Integer defaultQueryTimeoutSeconds) {
        this.defaultQueryTimeoutSeconds = defaultQueryTimeoutSeconds;
    }

    public void setCacheState(boolean cacheState) {
        this.cacheState = cacheState;
    }

    public void clearCachedState() {
        this.autoCommitCached = null;
        this.readOnlyCached = null;
        if (this.connection instanceof DelegatingConnection) {
            ((DelegatingConnection)this.connection).clearCachedState();
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setAutoCommit(autoCommit);
            if (this.cacheState) {
                this.autoCommitCached = this.connection.getAutoCommit();
            }
        }
        catch (SQLException e) {
            this.autoCommitCached = null;
            this.handleException(e);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setCatalog(catalog);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setReadOnly(readOnly);
            if (this.cacheState) {
                this.readOnlyCached = this.connection.isReadOnly();
            }
        }
        catch (SQLException e) {
            this.readOnlyCached = null;
            this.handleException(e);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setTypeMap(map);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed || this.connection == null || this.connection.isClosed();
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            if (null != this.connection) {
                String label = "";
                try {
                    label = this.connection.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SQLException("Connection " + label + " is closed.");
            }
            throw new SQLException("Connection is null.");
        }
    }

    protected void activate() {
        this.closed = false;
        this.setLastUsed();
        if (this.connection instanceof DelegatingConnection) {
            ((DelegatingConnection)this.connection).activate();
        }
    }

    protected void passivate() throws SQLException {
        List<AbandonedTrace> traces = this.getTrace();
        if (traces != null && !traces.isEmpty()) {
            ArrayList<Exception> thrownList = new ArrayList<Exception>();
            for (AbandonedTrace trace : traces) {
                if (trace instanceof Statement) {
                    try {
                        ((Statement)((Object)trace)).close();
                    }
                    catch (Exception e) {
                        thrownList.add(e);
                    }
                    continue;
                }
                if (!(trace instanceof ResultSet)) continue;
                try {
                    ((ResultSet)((Object)trace)).close();
                }
                catch (Exception e) {
                    thrownList.add(e);
                }
            }
            this.clearTrace();
            if (!thrownList.isEmpty()) {
                throw new SQLExceptionList(thrownList);
            }
        }
        this.setLastUsed(0L);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getHoldability();
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        try {
            this.connection.setHoldability(holdability);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.setSavepoint();
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkOpen();
        try {
            return this.connection.setSavepoint(name);
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        try {
            this.connection.rollback(savepoint);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        try {
            DelegatingStatement ds = new DelegatingStatement(this, this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
            this.initializeStatement(ds);
            return ds;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        try {
            DelegatingPreparedStatement dps = new DelegatingPreparedStatement(this, this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            this.initializeStatement(dps);
            return dps;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        try {
            DelegatingCallableStatement dcs = new DelegatingCallableStatement(this, this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
            this.initializeStatement(dcs);
            return dcs;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            DelegatingPreparedStatement dps = new DelegatingPreparedStatement(this, this.connection.prepareStatement(sql, autoGeneratedKeys));
            this.initializeStatement(dps);
            return dps;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            DelegatingPreparedStatement dps = new DelegatingPreparedStatement(this, this.connection.prepareStatement(sql, columnIndexes));
            this.initializeStatement(dps);
            return dps;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            DelegatingPreparedStatement dps = new DelegatingPreparedStatement(this, this.connection.prepareStatement(sql, columnNames));
            this.initializeStatement(dps);
            return dps;
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (iface.isAssignableFrom(this.connection.getClass())) {
            return true;
        }
        return this.connection.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        if (iface.isAssignableFrom(this.connection.getClass())) {
            return iface.cast(this.connection);
        }
        return this.connection.unwrap(iface);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createArrayOf(typeName, elements);
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createBlob();
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createClob();
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createNClob();
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createSQLXML();
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkOpen();
        try {
            return this.connection.createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public boolean isValid(int timeoutSeconds) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.connection.isValid(timeoutSeconds);
        }
        catch (SQLException e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkOpen();
            this.connection.setClientInfo(name, value);
        }
        catch (SQLClientInfoException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SQLClientInfoException("Connection is closed.", EMPTY_FAILED_PROPERTIES, (Throwable)e);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkOpen();
            this.connection.setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SQLClientInfoException("Connection is closed.", EMPTY_FAILED_PROPERTIES, (Throwable)e);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getClientInfo();
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkOpen();
        try {
            return this.connection.getClientInfo(name);
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        try {
            Jdbc41Bridge.setSchema(this.connection, schema);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        try {
            return Jdbc41Bridge.getSchema(this.connection);
        }
        catch (SQLException e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            Jdbc41Bridge.abort(this.connection, executor);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkOpen();
        try {
            Jdbc41Bridge.setNetworkTimeout(this.connection, executor, milliseconds);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkOpen();
        try {
            return Jdbc41Bridge.getNetworkTimeout(this.connection);
        }
        catch (SQLException e) {
            this.handleException(e);
            return 0;
        }
    }
}

