/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel.analyser;

import java.util.Arrays;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.Frame;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.UninitializedObjectType;

public class LocalVariables {
    private Type[] locals;

    public LocalVariables(int maxLocals) {
        this.locals = new Type[maxLocals];
        Arrays.fill(this.locals, Type.UNKNOWN);
    }

    protected Object clone() {
        LocalVariables lvs = new LocalVariables(this.locals.length);
        System.arraycopy(this.locals, 0, lvs.locals, 0, this.locals.length);
        return lvs;
    }

    public Type get(int i) {
        return this.locals[i];
    }

    public LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    public int maxLocals() {
        return this.locals.length;
    }

    public void set(int i, Type type) {
        if (type == Type.BYTE || type == Type.SHORT || type == Type.BOOLEAN || type == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type + "'. Use Type.INT instead.");
        }
        this.locals[i] = type;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalVariables)) {
            return false;
        }
        LocalVariables lv = (LocalVariables)o;
        return Arrays.equals(this.locals, lv.locals);
    }

    public void merge(LocalVariables that) {
        if (this.locals.length != that.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        for (int i = 0; i < this.locals.length; ++i) {
            this.locals[i] = Frame.merge(this.locals[i], that.locals[i], false);
        }
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.locals.length; ++i) {
            s = s + Integer.toString(i) + ": " + this.locals[i] + "\n";
        }
        return s;
    }

    public void initializeObject(UninitializedObjectType u) {
        for (int i = 0; i < this.locals.length; ++i) {
            if (this.locals[i] != u) continue;
            this.locals[i] = u.getInitialized();
        }
    }
}

