/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.progress.spi.InternalHandle;

public final class ProgressHandle {
    private static final Logger LOG = Logger.getLogger(ProgressHandle.class.getName());
    private InternalHandle internal;

    ProgressHandle(InternalHandle internalHandle) {
        LOG.fine(internalHandle.getDisplayName());
        this.internal = internalHandle;
    }

    public void start() {
        this.start(0, -1L);
    }

    public void start(int n) {
        this.start(n, -1L);
    }

    public void start(int n, long l) {
        this.internal.start("", n, l);
    }

    public void switchToIndeterminate() {
        this.internal.toIndeterminate();
    }

    public void suspend(String string) {
        LOG.log(Level.FINE, "{0}: {1}", new Object[]{this.internal.getDisplayName(), string});
        this.internal.toSilent(string);
    }

    public void switchToDeterminate(int n) {
        this.internal.toDeterminate(n, -1L);
    }

    public void switchToDeterminate(int n, long l) {
        this.internal.toDeterminate(n, l);
    }

    public void finish() {
        this.internal.finish();
    }

    public void progress(int n) {
        this.progress(null, n);
    }

    public void progress(String string) {
        this.progress(string, -2);
    }

    public void progress(String string, int n) {
        LOG.log(Level.FINE, "{0}: {1}", new Object[]{this.internal.getDisplayName(), string});
        this.internal.progress(string, n);
    }

    public void setInitialDelay(int n) {
        this.internal.setInitialDelay(n);
    }

    public void setDisplayName(String string) {
        LOG.fine(string);
        this.internal.requestDisplayNameChange(string);
    }

    JComponent extractComponent() {
        return this.internal.extractComponent();
    }

    InternalHandle getInternalHandle() {
        return this.internal;
    }

    JLabel extractDetailLabel() {
        return this.internal.extractDetailLabel();
    }

    JLabel extractMainLabel() {
        return this.internal.extractMainLabel();
    }
}

