/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.util.XMLizable;
import org.apache.xmlgraphics.xmp.XMPProperty;
import org.apache.xmlgraphics.xmp.XMPSchema;
import org.apache.xmlgraphics.xmp.XMPSchemaRegistry;
import org.apache.xmlgraphics.xmp.merge.MergeRuleSet;
import org.apache.xmlgraphics.xmp.merge.PropertyMerger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Metadata
implements XMLizable {
    private Map properties = new HashMap();

    public void setProperty(XMPProperty prop) {
        this.properties.put(prop.getName(), prop);
    }

    public XMPProperty getProperty(String uri, String localName) {
        return this.getProperty(new QName(uri, localName));
    }

    public XMPProperty getProperty(QName name) {
        XMPProperty prop = (XMPProperty)this.properties.get(name);
        return prop;
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public void mergeInto(Metadata target) {
        XMPSchemaRegistry registry = XMPSchemaRegistry.getInstance();
        Iterator iter = this.properties.values().iterator();
        while (iter.hasNext()) {
            XMPProperty prop = (XMPProperty)iter.next();
            XMPSchema schema = registry.getSchema(prop.getNamespace());
            MergeRuleSet rules = schema.getDefaultMergeRuleSet();
            PropertyMerger merger = rules.getPropertyMergerFor(prop);
            merger.merge(prop, target);
        }
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        handler.startElement("adobe:ns:meta/", "xmpmeta", "x:xmpmeta", atts);
        handler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF", "rdf:RDF", atts);
        HashSet<String> namespaces = new HashSet<String>();
        Iterator<Object> iter = this.properties.keySet().iterator();
        while (iter.hasNext()) {
            namespaces.add(((QName)iter.next()).getNamespaceURI());
        }
        iter = namespaces.iterator();
        while (iter.hasNext()) {
            String prefix;
            String ns = (String)iter.next();
            XMPSchema schema = XMPSchemaRegistry.getInstance().getSchema(ns);
            String string = prefix = schema != null ? schema.getPreferredPrefix() : null;
            if (prefix != null) {
                handler.startPrefixMapping(prefix, ns);
            }
            atts.clear();
            atts.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", "rdf:about", "CDATA", "");
            handler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF", "rdf:Description", atts);
            Iterator props = this.properties.values().iterator();
            while (props.hasNext()) {
                XMPProperty prop = (XMPProperty)props.next();
                if (!prop.getName().getNamespaceURI().equals(ns)) continue;
                prop.toSAX(handler);
            }
            handler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF", "rdf:Description");
            if (prefix == null) continue;
            handler.endPrefixMapping(prefix);
        }
        handler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF", "rdf:RDF");
        handler.endElement("adobe:ns:meta/", "xmpmeta", "x:xmpmeta");
    }
}

