/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.UriUtil;
import java.net.URI;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;

public class GithubUrlUtil {
    @NlsSafe
    @NotNull
    public static String removeProtocolPrefix(String url) {
        int index = url.indexOf(64);
        if (index != -1) {
            String string = url.substring(index + 1).replace(':', '/');
            if (string == null) {
                GithubUrlUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        index = url.indexOf("://");
        if (index != -1) {
            String string = url.substring(index + 3);
            if (string == null) {
                GithubUrlUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            GithubUrlUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String removeTrailingSlash(@NotNull String s) {
        if (s == null) {
            GithubUrlUtil.$$$reportNull$$$0(3);
        }
        if (s.endsWith("/")) {
            String string = s.substring(0, s.length() - 1);
            if (string == null) {
                GithubUrlUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            GithubUrlUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Deprecated
    @NotNull
    public static String getApiUrl(@NotNull String urlFromSettings) {
        if (urlFromSettings == null) {
            GithubUrlUtil.$$$reportNull$$$0(6);
        }
        String string = GithubServerPath.from(urlFromSettings).toApiUrl();
        if (string == null) {
            GithubUrlUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static GHRepositoryPath getUserAndRepositoryFromRemoteUrl(@NotNull String remoteUrl) {
        int index1;
        if (remoteUrl == null) {
            GithubUrlUtil.$$$reportNull$$$0(8);
        }
        if ((index1 = (remoteUrl = GithubUrlUtil.removeProtocolPrefix(GithubUrlUtil.removeEndingDotGit(remoteUrl))).lastIndexOf(47)) == -1) {
            return null;
        }
        String url = remoteUrl.substring(0, index1);
        int index2 = Math.max(url.lastIndexOf(47), url.lastIndexOf(58));
        if (index2 == -1) {
            return null;
        }
        String username = remoteUrl.substring(index2 + 1, index1);
        String reponame = remoteUrl.substring(index1 + 1);
        if (username.isEmpty() || reponame.isEmpty()) {
            return null;
        }
        return new GHRepositoryPath(username, reponame);
    }

    @NlsSafe
    @NotNull
    private static String removeEndingDotGit(@NotNull String url) {
        if (url == null) {
            GithubUrlUtil.$$$reportNull$$$0(9);
        }
        url = GithubUrlUtil.removeTrailingSlash(url);
        String DOT_GIT = ".git";
        if (url.endsWith(".git")) {
            String string = url.substring(0, url.length() - ".git".length());
            if (string == null) {
                GithubUrlUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            GithubUrlUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static URI getUriFromRemoteUrl(@NotNull String remoteUrl) {
        if (remoteUrl == null) {
            GithubUrlUtil.$$$reportNull$$$0(12);
        }
        String fixed = GithubUrlUtil.removeEndingDotGit(UriUtil.trimTrailingSlashes((String)remoteUrl));
        try {
            if (!fixed.contains("://")) {
                return new URI("https://" + GithubUrlUtil.removeProtocolPrefix(fixed).replace(':', '/'));
            }
            return new URI(fixed);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Deprecated
    @NotNull
    public static String getHostFromUrl(@NotNull String url) {
        String path;
        int index;
        if (url == null) {
            GithubUrlUtil.$$$reportNull$$$0(13);
        }
        if ((index = (path = GithubUrlUtil.removeProtocolPrefix(url).replace(':', '/')).indexOf(47)) == -1) {
            String string = path;
            if (string == null) {
                GithubUrlUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = path.substring(0, index);
        if (string == null) {
            GithubUrlUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Deprecated
    @Nullable
    public static String makeGithubRepoUrlFromRemoteUrl(@NotNull String remoteUrl, @NotNull String host) {
        GHRepositoryPath repo;
        if (remoteUrl == null) {
            GithubUrlUtil.$$$reportNull$$$0(16);
        }
        if (host == null) {
            GithubUrlUtil.$$$reportNull$$$0(17);
        }
        if ((repo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl)) == null) {
            return null;
        }
        return host + "/" + repo.getOwner() + "/" + repo.getRepository();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/util/GithubUrlUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlFromSettings";
                break;
            }
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "removeProtocolPrefix";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/util/GithubUrlUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTrailingSlash";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiUrl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEndingDotGit";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostFromUrl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeTrailingSlash";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getApiUrl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUserAndRepositoryFromRemoteUrl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeEndingDotGit";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUriFromRemoteUrl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHostFromUrl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "makeGithubRepoUrlFromRemoteUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

