/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.beanproperty;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.reflect.exception.ReflectionError;
import org.fest.reflect.util.Types;
import org.fest.util.Preconditions;

public final class PropertyAccessor<T> {
    private final Class<T> propertyType;
    private final Object target;
    private final PropertyDescriptor descriptor;

    PropertyAccessor(@Nonnull String propertyName, @Nonnull Class<T> propertyType, @Nonnull Object target) {
        this.propertyType = (Class)Preconditions.checkNotNull(propertyType);
        this.target = Preconditions.checkNotNull((Object)target);
        this.descriptor = this.findPropertyDescriptor(Preconditions.checkNotNullOrEmpty((String)propertyName));
    }

    private PropertyDescriptor findPropertyDescriptor(@Nonnull String propertyName) {
        BeanInfo beanInfo;
        Class<?> targetType = this.target.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(targetType);
        }
        catch (Throwable t) {
            String format = "Failed to get BeanInfo for type %s";
            throw new ReflectionError(String.format(format, targetType.getName()), t);
        }
        PropertyDescriptor found = null;
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            if (!propertyName.equals(descriptor.getName())) continue;
            found = descriptor;
            break;
        }
        if (found != null) {
            Class<?> actualType = found.getPropertyType();
            if (!this.propertyType.isAssignableFrom(actualType)) {
                String format = "Expecting type of property '%s' in %s to be <%s> but was <%s>";
                String msg = String.format(format, propertyName, targetType.getName(), this.propertyType.getName(), actualType.getName());
                throw new ReflectionError(msg);
            }
            return found;
        }
        String msg = String.format("Failed to find property '%s' in %s", propertyName, targetType.getName());
        throw new ReflectionError(msg);
    }

    public void set(@Nullable T value) {
        try {
            this.descriptor.getWriteMethod().invoke(this.target, value);
        }
        catch (Exception e) {
            String format = "Failed to set value %s in property '%s'";
            String msg = String.format(format, String.valueOf(value), this.descriptor.getName());
            throw new ReflectionError(msg, e);
        }
    }

    @Nullable
    public T get() {
        try {
            Object value = this.descriptor.getReadMethod().invoke(this.target, new Object[0]);
            return Types.castSafely(value, this.propertyType);
        }
        catch (Throwable t) {
            String msg = String.format("Failed to get the value of property '%s'", this.descriptor.getName());
            throw new ReflectionError(msg, t);
        }
    }

    @Nonnull
    public PropertyDescriptor target() {
        return this.descriptor;
    }
}

