/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.whitelist;

import com.github.markusbernhardt.proxy.search.browser.ie.IELocalByPassFilter;
import com.github.markusbernhardt.proxy.selector.whitelist.HostnameFilter;
import com.github.markusbernhardt.proxy.selector.whitelist.IPWithSubnetChecker;
import com.github.markusbernhardt.proxy.selector.whitelist.IpRangeFilter;
import com.github.markusbernhardt.proxy.selector.whitelist.WhiteListParser;
import com.github.markusbernhardt.proxy.util.UriFilter;
import java.util.ArrayList;
import java.util.List;

public class DefaultWhiteListParser
implements WhiteListParser {
    @Override
    public List<UriFilter> parseWhiteList(String whiteList) {
        ArrayList<UriFilter> result = new ArrayList<UriFilter>();
        String[] token = whiteList.split("[, ]+");
        for (int i = 0; i < token.length; ++i) {
            String tkn = token[i].trim();
            if (this.isIP4SubnetFilter(tkn) || this.isIP6SubnetFilter(tkn)) {
                result.add(new IpRangeFilter(tkn));
                continue;
            }
            if (tkn.endsWith("*")) {
                tkn = tkn.substring(0, tkn.length() - 1);
                result.add(new HostnameFilter(HostnameFilter.Mode.BEGINS_WITH, tkn));
                continue;
            }
            if (tkn.trim().startsWith("*")) {
                tkn = tkn.substring(1);
                result.add(new HostnameFilter(HostnameFilter.Mode.ENDS_WITH, tkn));
                continue;
            }
            if (tkn.trim().equals("<local>")) {
                result.add(new IELocalByPassFilter());
                continue;
            }
            result.add(new HostnameFilter(HostnameFilter.Mode.ENDS_WITH, tkn));
        }
        return result;
    }

    private boolean isIP6SubnetFilter(String token) {
        return IPWithSubnetChecker.isValidIP6Range(token);
    }

    private boolean isIP4SubnetFilter(String token) {
        return IPWithSubnetChecker.isValidIP4Range(token);
    }
}

