/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.fest.swing.timing.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.actions.ChooseProgrammingLanguageForLearningAction;
import training.lang.LangManager;
import training.learn.LearnBundle;
import training.learn.lesson.LessonManager;
import training.ui.LearnToolWindow;
import training.ui.LearningUiUtil;
import training.ui.views.LanguageChoosePanel;
import training.ui.views.LearnPanel;
import training.ui.views.ModulesPanel;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\u0006\u0010\u001e\u001a\u00020\u0018J\u0006\u0010\u001f\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u0018J\b\u0010!\u001a\u00020\u0018H\u0002R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltraining/ui/LearnToolWindow;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "wholeToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "<set-?>", "Ltraining/ui/views/LearnPanel;", "learnPanel", "getLearnPanel", "()Ltraining/ui/views/LearnPanel;", "modulesPanel", "Ltraining/ui/views/ModulesPanel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "reinitViews", "", "reinitViewsInternal", "restartAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "kotlin.jvm.PlatformType", "setChooseLanguageButton", "setLearnPanel", "setModulesPanel", "showGotItAboutRestart", "updateScrollPane", "intellij.featuresTrainer"})
public final class LearnToolWindow
extends SimpleToolWindowPanel
implements DataProvider {
    @NotNull
    private final Disposable parentDisposable;
    private JBScrollPane scrollPane;
    @Nullable
    private LearnPanel learnPanel;
    private final ModulesPanel modulesPanel;
    @NotNull
    private final Project project;
    private final ToolWindow wholeToolWindow;

    @NotNull
    public final Disposable getParentDisposable() {
        return this.parentDisposable;
    }

    @Nullable
    public final LearnPanel getLearnPanel() {
        return this.learnPanel;
    }

    private final void reinitViewsInternal() {
        this.learnPanel = new LearnPanel(this);
        this.modulesPanel.updateMainPanel();
    }

    public final void setLearnPanel() {
        this.wholeToolWindow.setTitleActions(CollectionsKt.listOf((Object)this.restartAction()));
        this.scrollPane.setViewportView((Component)this.learnPanel);
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    public final void showGotItAboutRestart() {
        GotItTooltip gotIt = new GotItTooltip("reset.lesson.got.it", LearnBundle.INSTANCE.message("completed.lessons.got.it", new Object[0]), this.parentDisposable);
        if (gotIt.canShow()) {
            AnAction anAction = this.restartAction();
            if (anAction == null) {
                return;
            }
            AnAction needToFindButton = anAction;
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(needToFindButton, gotIt){
                final /* synthetic */ AnAction $needToFindButton;
                final /* synthetic */ GotItTooltip $gotIt;

                public final void run() {
                    Timeout timeout = Timeout.timeout((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                    Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"Timeout.timeout(500, TimeUnit.MILLISECONDS)");
                    ActionButton button2 = (ActionButton)LearningUiUtil.findShowingComponentWithTimeout$default(LearningUiUtil.INSTANCE, null, ActionButton.class, timeout, null, (Function1)new Function1<ActionButton, Boolean>(this){
                        final /* synthetic */ showGotItAboutRestart.1 this$0;

                        public final boolean invoke(@NotNull ActionButton it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it.getAction(), (Object)this.this$0.$needToFindButton);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }, 8, null);
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    Application application = ApplicationManager.getApplication();
                    Runnable runnable2 = new Runnable(this, button2){
                        final /* synthetic */ showGotItAboutRestart.1 this$0;
                        final /* synthetic */ ActionButton $button$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$button$inlined = actionButton;
                        }

                        public final void run() {
                            boolean bl = false;
                            this.this$0.$gotIt.show((JComponent)this.$button$inlined, GotItTooltip.BOTTOM_MIDDLE);
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application.invokeLater(runnable2, modalityState);
                }
                {
                    this.$needToFindButton = anAction;
                    this.$gotIt = gotItTooltip;
                }
            });
        }
    }

    private final AnAction restartAction() {
        return ActionManager.getInstance().getAction("RestartLessonAction");
    }

    public final void setModulesPanel() {
        this.setChooseLanguageButton();
        this.modulesPanel.updateMainPanel();
        this.scrollPane.setViewportView((Component)this.modulesPanel);
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    private final void setChooseLanguageButton() {
        Collection collection = LangManager.Companion.getInstance().getSupportedLanguagesExtensions();
        boolean bl = false;
        if (!collection.isEmpty() && LangManager.Companion.getInstance().getSupportedLanguagesExtensions().size() > 1) {
            this.wholeToolWindow.setTitleActions(CollectionsKt.listOf((Object)((Object)new ChooseProgrammingLanguageForLearningAction(this))));
        }
    }

    private final void updateScrollPane() {
        this.scrollPane.getViewport().revalidate();
        this.scrollPane.getViewport().repaint();
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    public final void reinitViews() {
        this.reinitViewsInternal();
        this.updateScrollPane();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public LearnToolWindow(@NotNull Project project, @NotNull ToolWindow wholeToolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)wholeToolWindow, (String)"wholeToolWindow");
        super(true, true);
        this.project = project;
        this.wholeToolWindow = wholeToolWindow;
        Disposable disposable = this.wholeToolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"wholeToolWindow.disposable");
        this.parentDisposable = disposable;
        this.modulesPanel = new ModulesPanel();
        this.setChooseLanguageButton();
        this.reinitViewsInternal();
        JBScrollPane jBScrollPane = this.scrollPane = LangManager.Companion.getInstance().isLangUndefined() ? new JBScrollPane((Component)new LanguageChoosePanel(this, false, false, 6, null)) : new JBScrollPane((Component)this.modulesPanel);
        if (LessonManager.Companion.getInstance().lessonIsRunning$intellij_featuresTrainer()) {
            this.setLearnPanel();
        }
        this.setContent((JComponent)this.scrollPane);
    }
}

