/*
 * Decompiled with CFR 0.152.
 */
package training.learn.js;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.fields.ExtendableTextField;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.commands.kotlin.TaskRuntimeContext;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0004\u001a\f\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u0004\u001a\u001a\u0010\t\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u0012\u0010\r\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\u0001\u001a\u0012\u0010\u000e\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\u0001\u001a\u001a\u0010\u000f\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u001a\u0010\u0010\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u00a8\u0006\u0012"}, d2={"shiftSymbol", "", "checkWordInSearchEverywhereInput", "", "Ltraining/commands/kotlin/TaskRuntimeContext;", "expected", "findElementAtCaret", "Lcom/intellij/psi/PsiElement;", "findTextAtCaret", "textAfterOffset", "offset", "", "text", "textAtCaretEqualsTo", "textBeforeCaret", "textBeforeOffset", "textOnLine", "line", "intellij.featuresTrainer"})
public final class JSCommonLessonUtilsKt {
    public static final boolean textBeforeCaret(@NotNull TaskRuntimeContext $this$textBeforeCaret, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$textBeforeCaret, (String)"$this$textBeforeCaret");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        CaretModel caretModel = $this$textBeforeCaret.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        return JSCommonLessonUtilsKt.textBeforeOffset($this$textBeforeCaret, offset, text2);
    }

    public static final boolean textBeforeOffset(@NotNull TaskRuntimeContext $this$textBeforeOffset, int offset, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$textBeforeOffset, (String)"$this$textBeforeOffset");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (offset < text2.length()) {
            return false;
        }
        Document document = $this$textBeforeOffset.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        CharSequence subSequence = document.getCharsSequence().subSequence(offset - text2.length(), offset);
        return Intrinsics.areEqual((Object)((Object)subSequence).toString(), (Object)text2);
    }

    public static final boolean textAfterOffset(@NotNull TaskRuntimeContext $this$textAfterOffset, int offset, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$textAfterOffset, (String)"$this$textAfterOffset");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Document document = $this$textAfterOffset.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"editor.document.charsSequence");
        CharSequence charsSequence = charSequence;
        if (offset + text2.length() > charsSequence.length()) {
            return false;
        }
        CharSequence subSequence = charsSequence.subSequence(offset, offset + text2.length());
        return Intrinsics.areEqual((Object)((Object)subSequence).toString(), (Object)text2);
    }

    public static final boolean textOnLine(@NotNull TaskRuntimeContext $this$textOnLine, int line, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$textOnLine, (String)"$this$textOnLine");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        int lineStartOffset = $this$textOnLine.getEditor().getDocument().getLineStartOffset(line);
        int lineEndOffset = $this$textOnLine.getEditor().getDocument().getLineEndOffset(line);
        Document document = $this$textOnLine.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        CharSequence subSequence = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
        return StringsKt.contains$default((CharSequence)((Object)subSequence).toString(), (CharSequence)text2, (boolean)false, (int)2, null);
    }

    @Nullable
    public static final PsiElement findElementAtCaret(@NotNull TaskRuntimeContext $this$findElementAtCaret) {
        Intrinsics.checkNotNullParameter((Object)$this$findElementAtCaret, (String)"$this$findElementAtCaret");
        CaretModel caretModel = $this$findElementAtCaret.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        CaretModel caret2 = caretModel;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)$this$findElementAtCaret.getProject()).getPsiFile($this$findElementAtCaret.getEditor().getDocument());
        Intrinsics.checkNotNull((Object)psiFile);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiDocumentManager.getIn\u2026siFile(editor.document)!!");
        PsiFile psiFile2 = psiFile;
        int offset = caret2.getOffset();
        return psiFile2.findElementAt(offset);
    }

    @Nullable
    public static final String findTextAtCaret(@NotNull TaskRuntimeContext $this$findTextAtCaret) {
        PsiElement element;
        Intrinsics.checkNotNullParameter((Object)$this$findTextAtCaret, (String)"$this$findTextAtCaret");
        PsiElement psiElement = element = JSCommonLessonUtilsKt.findElementAtCaret($this$findTextAtCaret);
        return psiElement != null ? psiElement.getText() : null;
    }

    public static final boolean textAtCaretEqualsTo(@NotNull TaskRuntimeContext $this$textAtCaretEqualsTo, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$textAtCaretEqualsTo, (String)"$this$textAtCaretEqualsTo");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String foundText = JSCommonLessonUtilsKt.findTextAtCaret($this$textAtCaretEqualsTo);
        return Intrinsics.areEqual((Object)text2, (Object)foundText) || Intrinsics.areEqual((Object)text2, (Object)"(");
    }

    @NotNull
    public static final String shiftSymbol() {
        if (SystemInfo.isMac) {
            return "\u21e7";
        }
        return "Shift";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean checkWordInSearchEverywhereInput(@NotNull TaskRuntimeContext $this$checkWordInSearchEverywhereInput, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)$this$checkWordInSearchEverywhereInput, (String)"$this$checkWordInSearchEverywhereInput");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Component component2 = $this$checkWordInSearchEverywhereInput.getFocusOwner();
        if (!(component2 instanceof ExtendableTextField)) {
            component2 = null;
        }
        ExtendableTextField extendableTextField = (ExtendableTextField)component2;
        Object object = extendableTextField;
        if (extendableTextField == null) return false;
        String string = object.getText();
        object = string;
        if (string == null) return false;
        Object object2 = object;
        boolean bl = false;
        Object object3 = object2;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)object3).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        object = string2;
        if (string2 == null) return false;
        CharSequence charSequence = (CharSequence)object;
        object2 = expected;
        bl = false;
        String string3 = ((String)object2).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null)) return false;
        return true;
    }
}

