/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.youtrack.YouTrackIntellisense;
import com.intellij.tasks.youtrack.YouTrackRepository;
import com.intellij.tasks.youtrack.lang.YouTrackLanguage;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class YouTrackRepositoryEditor
extends BaseRepositoryEditor<YouTrackRepository> {
    private EditorTextField myDefaultSearch;
    private JBLabel mySearchLabel;

    public YouTrackRepositoryEditor(Project project, YouTrackRepository repository, Consumer<? super YouTrackRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDefaultSearch.getDocument());
        assert (file != null);
        file.putUserData(YouTrackIntellisense.INTELLISENSE_KEY, (Object)new YouTrackIntellisense((YouTrackRepository)this.myRepository));
    }

    protected void afterTestConnection(boolean connectionSuccessful) {
        super.afterTestConnection(connectionSuccessful);
        if (connectionSuccessful) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    public void apply() {
        ((YouTrackRepository)this.myRepository).setDefaultSearch(this.myDefaultSearch.getText());
        super.apply();
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.mySearchLabel = new JBLabel(TaskBundle.message((String)"label.search", (Object[])new Object[0]), 4);
        this.myDefaultSearch = new LanguageTextField((Language)YouTrackLanguage.INSTANCE, this.myProject, ((YouTrackRepository)this.myRepository).getDefaultSearch());
        this.installListener(this.myDefaultSearch);
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.mySearchLabel, (JComponent)this.myDefaultSearch).getPanel();
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.mySearchLabel.setAnchor(anchor);
    }
}

