/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.GenericRepositoryUtil;
import com.intellij.tasks.generic.ManageTemplateVariablesDialog;
import com.intellij.tasks.generic.ResponseHandler;
import com.intellij.tasks.generic.ResponseType;
import com.intellij.tasks.generic.TemplateVariable;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HTTPMethod;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericRepositoryEditor<T extends GenericRepository>
extends BaseRepositoryEditor<T> {
    protected EditorTextField myLoginURLText;
    private EditorTextField myTasksListURLText;
    private EditorTextField mySingleTaskURLText;
    protected JBLabel myLoginURLLabel;
    protected ComboBox myLoginMethodTypeComboBox;
    private ComboBox myTasksListMethodTypeComboBox;
    private ComboBox mySingleTaskMethodComboBox;
    private JPanel myPanel;
    private JRadioButton myXmlRadioButton;
    private JRadioButton myTextRadioButton;
    private JButton myTest2Button;
    private JRadioButton myJsonRadioButton;
    private JButton myManageTemplateVariablesButton;
    private JButton myResetToDefaultsButton;
    private JPanel myCardPanel;
    private JBLabel mySingleTaskURLLabel;
    private JBCheckBox myDownloadTasksInSeparateRequests;
    private Map<JTextField, TemplateVariable> myField2Variable;
    private final Map<JRadioButton, ResponseType> myRadio2ResponseType;

    public GenericRepositoryEditor(final Project project, T repository, Consumer<T> changeListener) {
        super(project, repository, changeListener);
        this.$$$setupUI$$$();
        this.myTest2Button.addActionListener(new ActionListener((GenericRepository)((Object)repository)){
            final /* synthetic */ GenericRepository val$repository;
            {
                this.val$repository = genericRepository;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericRepositoryEditor.this.afterTestConnection(TaskManager.getManager((Project)project).testConnection((TaskRepository)this.val$repository));
            }
        });
        this.myLoginAnonymouslyJBCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericRepositoryEditor.this.loginUrlEnablingChanged();
            }
        });
        this.myUseHttpAuthenticationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericRepositoryEditor.this.loginUrlEnablingChanged();
            }
        });
        ActionListener radioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericRepositoryEditor.this.singleTaskUrlEnablingChanged();
                GenericRepositoryEditor.this.doApply();
                GenericRepositoryEditor.this.selectCardByResponseType();
            }
        };
        this.myXmlRadioButton.addActionListener(radioButtonListener);
        this.myTextRadioButton.addActionListener(radioButtonListener);
        this.myJsonRadioButton.addActionListener(radioButtonListener);
        this.myLoginMethodTypeComboBox.setSelectedItem((Object)((GenericRepository)this.myRepository).getLoginMethodType().toString());
        this.myTasksListMethodTypeComboBox.setSelectedItem((Object)((GenericRepository)this.myRepository).getTasksListMethodType().toString());
        this.mySingleTaskMethodComboBox.setSelectedItem((Object)((GenericRepository)this.myRepository).getSingleTaskMethodType().toString());
        this.installListener((JComboBox)this.myLoginMethodTypeComboBox);
        this.installListener((JComboBox)this.myTasksListMethodTypeComboBox);
        this.installListener((JComboBox)this.mySingleTaskMethodComboBox);
        this.installListener(this.myLoginURLText);
        this.installListener(this.myTasksListURLText);
        this.installListener(this.mySingleTaskURLText);
        this.installListener((JCheckBox)this.myDownloadTasksInSeparateRequests);
        this.myTabbedPane.addTab(TaskBundle.message((String)"server.configuration", (Object[])new Object[0]), (Component)this.myPanel);
        ResponseHandler xmlHandler = ((GenericRepository)this.myRepository).getResponseHandler(ResponseType.XML);
        ResponseHandler jsonHandler = ((GenericRepository)this.myRepository).getResponseHandler(ResponseType.JSON);
        ResponseHandler textHandler = ((GenericRepository)this.myRepository).getResponseHandler(ResponseType.TEXT);
        this.myCardPanel.add((Component)xmlHandler.getConfigurationComponent(this.myProject), ResponseType.XML.getMimeType());
        this.myCardPanel.add((Component)jsonHandler.getConfigurationComponent(this.myProject), ResponseType.JSON.getMimeType());
        this.myCardPanel.add((Component)textHandler.getConfigurationComponent(this.myProject), ResponseType.TEXT.getMimeType());
        this.myRadio2ResponseType = new IdentityHashMap<JRadioButton, ResponseType>();
        this.myRadio2ResponseType.put(this.myJsonRadioButton, ResponseType.JSON);
        this.myRadio2ResponseType.put(this.myXmlRadioButton, ResponseType.XML);
        this.myRadio2ResponseType.put(this.myTextRadioButton, ResponseType.TEXT);
        this.myManageTemplateVariablesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageTemplateVariablesDialog dialog = new ManageTemplateVariablesDialog(GenericRepositoryEditor.this.myManageTemplateVariablesButton);
                dialog.setTemplateVariables(((GenericRepository)GenericRepositoryEditor.this.myRepository).getAllTemplateVariables());
                if (dialog.showAndGet()) {
                    ((GenericRepository)GenericRepositoryEditor.this.myRepository).setTemplateVariables(ContainerUtil.filter(dialog.getTemplateVariables(), variable -> !variable.isReadOnly()));
                    GenericRepositoryEditor.this.myCustomPanel.removeAll();
                    GenericRepositoryEditor.this.myCustomPanel.add(GenericRepositoryEditor.this.createCustomPanel());
                    GenericRepositoryEditor.this.myTabbedPane.getComponentAt(0).repaint();
                    List<String> placeholders = GenericRepositoryUtil.createPlaceholdersList((GenericRepository)GenericRepositoryEditor.this.myRepository);
                    ((TextFieldWithAutoCompletion)GenericRepositoryEditor.this.myLoginURLText).setVariants(placeholders);
                    ((TextFieldWithAutoCompletion)GenericRepositoryEditor.this.myTasksListURLText).setVariants(GenericRepositoryUtil.concat(placeholders, "{max}", "{since}"));
                    ((TextFieldWithAutoCompletion)GenericRepositoryEditor.this.mySingleTaskURLText).setVariants(GenericRepositoryUtil.concat(placeholders, "{id}"));
                    GenericRepositoryEditor.this.myPanel.repaint();
                }
            }
        });
        this.myResetToDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GenericRepository)GenericRepositoryEditor.this.myRepository).resetToDefaults();
                GenericRepositoryEditor.this.reset(((GenericRepository)GenericRepositoryEditor.this.myRepository).clone());
            }
        });
        this.selectRadioButtonByResponseType();
        this.selectCardByResponseType();
        this.loginUrlEnablingChanged();
        this.singleTaskUrlEnablingChanged();
        this.myDownloadTasksInSeparateRequests.setSelected(((GenericRepository)this.myRepository).getDownloadTasksInSeparateRequests());
    }

    private void singleTaskUrlEnablingChanged() {
        boolean enabled = !this.myTextRadioButton.isSelected();
        this.mySingleTaskURLText.setEnabled(enabled);
        this.mySingleTaskMethodComboBox.setEnabled(enabled);
        this.mySingleTaskURLLabel.setEnabled(enabled);
    }

    protected void loginUrlEnablingChanged() {
        boolean enabled = !this.myLoginAnonymouslyJBCheckBox.isSelected() && !this.myUseHttpAuthenticationCheckBox.isSelected();
        this.myLoginURLLabel.setEnabled(enabled);
        this.myLoginURLText.setEnabled(enabled);
        this.myLoginMethodTypeComboBox.setEnabled(enabled);
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myField2Variable = new IdentityHashMap<JTextField, TemplateVariable>();
        FormBuilder builder = FormBuilder.createFormBuilder();
        for (TemplateVariable variable : ((GenericRepository)this.myRepository).getTemplateVariables()) {
            if (!variable.isShownOnFirstTab()) continue;
            JTextField field = variable.isHidden() ? new JPasswordField(variable.getValue()) : new JTextField(variable.getValue());
            this.myField2Variable.put(field, variable);
            this.installListener(field);
            JBLabel label = new JBLabel(GenericRepositoryUtil.prettifyVariableName(variable.getName()) + ":", 4);
            label.setAnchor(this.getAnchor());
            builder.addLabeledComponent((JComponent)label, (JComponent)field);
        }
        return builder.getPanel();
    }

    protected void reset(GenericRepository clone) {
        this.myLoginURLText.setText(clone.getLoginUrl());
        this.myTasksListURLText.setText(clone.getTasksListUrl());
        this.mySingleTaskURLText.setText(clone.getSingleTaskUrl());
        this.myLoginMethodTypeComboBox.setSelectedItem((Object)clone.getLoginMethodType());
        this.myTasksListMethodTypeComboBox.setSelectedItem((Object)clone.getTasksListMethodType());
        this.mySingleTaskMethodComboBox.setSelectedItem((Object)clone.getSingleTaskMethodType());
        this.selectRadioButtonByResponseType();
        this.selectCardByResponseType();
        this.loginUrlEnablingChanged();
        this.myDownloadTasksInSeparateRequests.setSelected(((GenericRepository)this.myRepository).getDownloadTasksInSeparateRequests());
    }

    private void selectRadioButtonByResponseType() {
        for (Map.Entry<JRadioButton, ResponseType> entry : this.myRadio2ResponseType.entrySet()) {
            if (entry.getValue() != ((GenericRepository)this.myRepository).getResponseType()) continue;
            entry.getKey().setSelected(true);
        }
    }

    private void selectCardByResponseType() {
        CardLayout cardLayout = (CardLayout)this.myCardPanel.getLayout();
        cardLayout.show(this.myCardPanel, ((GenericRepository)this.myRepository).getResponseType().getMimeType());
    }

    public void apply() {
        ((GenericRepository)this.myRepository).setLoginUrl(this.myLoginURLText.getText());
        ((GenericRepository)this.myRepository).setTasksListUrl(this.myTasksListURLText.getText());
        ((GenericRepository)this.myRepository).setSingleTaskUrl(this.mySingleTaskURLText.getText());
        ((GenericRepository)this.myRepository).setLoginMethodType(HTTPMethod.valueOf((String)((String)this.myLoginMethodTypeComboBox.getSelectedItem())));
        ((GenericRepository)this.myRepository).setTasksListMethodType(HTTPMethod.valueOf((String)((String)this.myTasksListMethodTypeComboBox.getSelectedItem())));
        ((GenericRepository)this.myRepository).setSingleTaskMethodType(HTTPMethod.valueOf((String)((String)this.mySingleTaskMethodComboBox.getSelectedItem())));
        ((GenericRepository)this.myRepository).setDownloadTasksInSeparateRequests(this.myDownloadTasksInSeparateRequests.isSelected());
        for (Map.Entry<JTextField, TemplateVariable> entry : this.myField2Variable.entrySet()) {
            TemplateVariable variable = entry.getValue();
            JTextField field = entry.getKey();
            variable.setValue(field.getText());
        }
        for (Map.Entry<JComponent, Object> entry : this.myRadio2ResponseType.entrySet()) {
            if (!((JRadioButton)entry.getKey()).isSelected()) continue;
            ((GenericRepository)this.myRepository).setResponseType((ResponseType)((Object)entry.getValue()));
        }
        super.apply();
    }

    private void createUIComponents() {
        List<String> placeholders = GenericRepositoryUtil.createPlaceholdersList((GenericRepository)this.myRepository);
        this.myLoginURLText = this.createTextFieldWithCompletion(((GenericRepository)this.myRepository).getLoginUrl(), placeholders);
        this.myTasksListURLText = this.createTextFieldWithCompletion(((GenericRepository)this.myRepository).getTasksListUrl(), GenericRepositoryUtil.concat(placeholders, "{max}", "{since}"));
        this.mySingleTaskURLText = this.createTextFieldWithCompletion(((GenericRepository)this.myRepository).getSingleTaskUrl(), GenericRepositoryUtil.concat(placeholders, "{id}"));
    }

    private TextFieldWithAutoCompletion<String> createTextFieldWithCompletion(String text, List<String> variants) {
        TextFieldWithAutoCompletion.StringsCompletionProvider provider = new TextFieldWithAutoCompletion.StringsCompletionProvider(variants, null){

            @Nullable
            public String getPrefix(@NotNull String text, int offset) {
                int i;
                if (text == null) {
                    7.$$$reportNull$$$0(0);
                }
                if ((i = text.lastIndexOf(123, offset - 1)) < 0) {
                    return "";
                }
                return text.substring(i, offset);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/tasks/generic/GenericRepositoryEditor$7", "getPrefix"));
            }
        };
        return new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)provider, true, text);
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        List labels = UIUtil.findComponentsOfType((JComponent)this.myCustomPanel, JBLabel.class);
        for (JBLabel label : labels) {
            label.setAnchor(anchor);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JBLabel jBLabel;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JBLabel jBLabel2;
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JBCheckBox jBCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, 8, false, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Response Type:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myXmlRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("XML");
        jRadioButton3.setMnemonic('M');
        jRadioButton3.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(49, 44), null));
        this.myTextRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Text");
        jRadioButton2.setMnemonic('T');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, new Dimension(51, 44), null));
        this.myJsonRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("JSON");
        jRadioButton.setMnemonic('O');
        jRadioButton.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(55, 44), null));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalTextPosition(4);
        jLabel.setText("Each task in separate request:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDownloadTasksInSeparateRequests = jBCheckBox = new JBCheckBox();
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 5, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myTest2Button = jButton3 = new JButton();
        jButton3.setText("Test");
        jButton3.setMnemonic('S');
        jButton3.setDisplayedMnemonicIndex(2);
        jPanel4.add((Component)jButton3, new GridConstraints(0, 3, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myManageTemplateVariablesButton = jButton2 = new JButton();
        jButton2.setText("Manage Template Variables...");
        jButton2.setMnemonic('A');
        jButton2.setDisplayedMnemonicIndex(1);
        jPanel4.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myResetToDefaultsButton = jButton = new JButton();
        jButton.setText("Reset to Defaults");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCardPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.mySingleTaskURLLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Single Task URL:");
        jBLabel2.setDisplayedMnemonic('S');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.mySingleTaskURLText;
        jPanel2.add((Component)editorTextField, new GridConstraints(2, 1, 1, 1, 0, 3, 6, 0, null, new Dimension(10, -1), null));
        this.mySingleTaskMethodComboBox = comboBox3 = new ComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("GET");
        defaultComboBoxModel.addElement("POST");
        comboBox3.setModel(defaultComboBoxModel);
        jPanel2.add((Component)comboBox3, new GridConstraints(2, 2, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Tasks List URL:");
        jBLabel4.setDisplayedMnemonic('L');
        jBLabel4.setDisplayedMnemonicIndex(6);
        jPanel2.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myTasksListURLText;
        jPanel2.add((Component)editorTextField2, new GridConstraints(1, 1, 1, 1, 0, 3, 6, 0, null, new Dimension(10, -1), null));
        this.myTasksListMethodTypeComboBox = comboBox2 = new ComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("GET");
        defaultComboBoxModel2.addElement("POST");
        comboBox2.setModel(defaultComboBoxModel2);
        jPanel2.add((Component)comboBox2, new GridConstraints(1, 2, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myLoginURLLabel = jBLabel = new JBLabel();
        jBLabel.setText("Login URL:");
        jBLabel.setDisplayedMnemonic('G');
        jBLabel.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        EditorTextField editorTextField3 = this.myLoginURLText;
        jPanel2.add((Component)editorTextField3, new GridConstraints(0, 1, 1, 1, 0, 3, 6, 0, null, new Dimension(10, -1), null));
        this.myLoginMethodTypeComboBox = comboBox = new ComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel3.addElement("GET");
        defaultComboBoxModel3.addElement("POST");
        comboBox.setModel(defaultComboBoxModel3);
        jPanel2.add((Component)comboBox, new GridConstraints(0, 2, 1, 1, 0, 0, 2, 0, null, null, null));
        jBLabel2.setLabelFor((Component)editorTextField);
        jBLabel4.setLabelFor((Component)editorTextField2);
        jBLabel.setLabelFor((Component)editorTextField3);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

