/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore.type;

import io.netty.buffer.ByteBuf;
import org.jetbrains.integratedBinaryPacking.IntBitPacker;
import org.jetbrains.integratedBinaryPacking.IntegratedBinaryPacking;
import org.jetbrains.integratedBinaryPacking.LongBitPacker;
import org.jetbrains.mvstore.DataUtil;
import org.jetbrains.mvstore.KeyManager;
import org.jetbrains.mvstore.MVMap;
import org.jetbrains.mvstore.MVStore;

final class LongKeyManager
implements KeyManager<Long> {
    static final long[] EMPTY_ARRAY = new long[0];
    private final long[] keys;

    LongKeyManager(long[] keys) {
        if (MVStore.ASSERT_MODE) {
            for (int i = 1; i < keys.length; ++i) {
                if (keys[i] <= keys[i - 1]) {
                    throw new AssertionError((Object)(keys[i] + " <= " + keys[i - 1]));
                }
            }
        }
        this.keys = keys;
    }

    LongKeyManager(ByteBuf buf, int count) {
        long initValue;
        if (count == 0) {
            this.keys = EMPTY_ARRAY;
            return;
        }
        this.keys = new long[count];
        int variableEncodingLength = count % 64;
        if (variableEncodingLength == 0) {
            initValue = 0L;
        } else {
            LongBitPacker.decompressVariable(buf, this.keys, variableEncodingLength);
            initValue = this.keys[variableEncodingLength - 1];
            if (variableEncodingLength == count) {
                return;
            }
        }
        int compressedArrayLength = IntBitPacker.readVar(buf);
        long[] compressed = new long[compressedArrayLength];
        DataUtil.readLongArray(compressed, buf, compressedArrayLength);
        LongBitPacker.decompressIntegrated(compressed, 0, this.keys, variableEncodingLength, count, initValue);
    }

    @Override
    public int getKeyCount() {
        return this.keys.length;
    }

    @Override
    public Long getKey(int index) {
        return this.keys[index];
    }

    @Override
    public int binarySearch(Long key, MVMap<Long, ?> map2, int initialGuess) {
        int length = this.keys.length;
        if (length == 0) {
            return -1;
        }
        int low = 0;
        int high = length - 1;
        int x = initialGuess - 1;
        if (x < 0 || x > high) {
            x = high >>> 1;
        }
        return LongKeyManager.binarySearch(key, this.keys, low, high, x);
    }

    private static int binarySearch(long key, long[] storage, int low, int high, int x) {
        while (low <= high) {
            long midVal = storage[x];
            if (key > midVal) {
                low = x + 1;
            } else if (key < midVal) {
                high = x - 1;
            } else {
                return x;
            }
            x = low + high >>> 1;
        }
        return -(low + 1);
    }

    public LongKeyManager expandKeys(int extraKeyCount, Long[] extraKeys, MVMap<Long, ?> map2) {
        int keyCount = this.keys.length;
        long[] newKeys = new long[keyCount + extraKeyCount];
        System.arraycopy(this.keys, 0, newKeys, 0, keyCount);
        System.arraycopy(extraKeys, 0, newKeys, keyCount, extraKeyCount);
        return new LongKeyManager(newKeys);
    }

    @Override
    public KeyManager<Long> copy(int startIndex, int endIndex, MVMap<Long, ?> map2) {
        long[] newKeys = new long[endIndex - startIndex];
        System.arraycopy(this.keys, startIndex, newKeys, 0, newKeys.length);
        return new LongKeyManager(newKeys);
    }

    @Override
    public KeyManager<Long> insertKey(int index, Long key, MVMap<Long, ?> map2) {
        int keyCount = this.keys.length;
        assert (index <= keyCount) : index + " > " + keyCount;
        long[] newKeys = new long[keyCount + 1];
        DataUtil.copyWithGap(this.keys, newKeys, keyCount, index);
        newKeys[index] = key;
        return new LongKeyManager(newKeys);
    }

    @Override
    public KeyManager<Long> remove(int index, MVMap<Long, ?> map2) {
        int keyCount = this.keys.length;
        if (keyCount == 1) {
            return new LongKeyManager(EMPTY_ARRAY);
        }
        long[] newKeys = new long[keyCount - 1];
        DataUtil.copyExcept(this.keys, newKeys, keyCount, index);
        return new LongKeyManager(newKeys);
    }

    @Override
    public void write(int count, MVMap<Long, ?> map2, ByteBuf buf) {
        long initValue;
        if (count == 0) {
            return;
        }
        int variableEncodingLength = count % 64;
        if (variableEncodingLength == 0) {
            initValue = 0L;
        } else {
            LongBitPacker.compressVariable(this.keys, 0, variableEncodingLength, buf);
            if (count == variableEncodingLength) {
                return;
            }
            initValue = this.keys[variableEncodingLength - 1];
        }
        long[] compressed = new long[IntegratedBinaryPacking.estimateCompressedArrayLength(this.keys, variableEncodingLength, count, initValue)];
        int compressedArrayLength = LongBitPacker.compressIntegrated(this.keys, variableEncodingLength, count, compressed, initValue);
        LongBitPacker.writeVar(buf, compressedArrayLength);
        DataUtil.writeLongArray(compressed, buf, compressedArrayLength);
    }

    @Override
    public int getSerializedDataSize() {
        int count = this.keys.length;
        if (count == 0) {
            return 0;
        }
        int variableEncodingLength = count % 64;
        int result = variableEncodingLength * 9;
        if (count == variableEncodingLength) {
            return result;
        }
        return result + IntegratedBinaryPacking.estimateCompressedArrayLength(this.keys, variableEncodingLength, count, variableEncodingLength == 0 ? 0L : this.keys[variableEncodingLength - 1]);
    }
}

