/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.HundredNanoseconds;
import java.text.Collator;
import java.time.temporal.TemporalUnit;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

public class MemoryFileSystemProperties {
    static final String UNIX_SEPARATOR = "/";
    static final String WINDOWS_SEPARATOR = "\\";
    public static final TemporalUnit WINDOWS_RESOLUTION = new HundredNanoseconds();
    public static final String DEFAULT_NAME_SEPARATOR = "/";
    public static final String DEFAULT_NAME_SEPARATOR_PROPERTY = "file.separator";
    public static final String CURRENT_WORKING_DIRECTORY_PROPERTY = "user.dir";
    public static final String ROOTS_PROPERTY = "roots";
    public static final String FILE_ATTRIBUTE_VIEWS_PROPERTY = "file.attrs";
    public static final String FORBIDDEN_CHARACTERS_PROPERTY = "file.name.forbidden";
    public static final String USERS_PROPERTY = "users";
    public static final String GROUPS_PROPERTY = "groups";
    public static final String PATH_STORE_TRANSFORMER_PROPERTY = "path.store.transformer";
    public static final String PATH_LOOKUP_TRANSFORMER_PROPERTY = "path.lookup.transformer";
    public static final String PRINCIPAL_TRANSFORMER_PROPERTY = "principal.transformer";
    public static final String FILE_TIME_RESOLUTION_PROPERTY = "file.time.resolution";
    public static final String FILE_CHANNEL_DIRECTORY_PROPERTY = "filechannel.on.directory";
    public static final String COLLATOR_PROPERTY = "collator";
    public static final String UMASK_PROPERTY = "file.umask";
    static final String UNIX_ROOT = "/";
    static final List<String> DEFAULT_ROOTS = Collections.singletonList("/");
    private static final AtomicReference<CollatorCache> INSENSITIVE_COLLATOR = new AtomicReference();
    private static final AtomicReference<CollatorCache> DECOMPOSITION_COLLATOR = new AtomicReference();
    private static final AtomicReference<CollatorCache> NO_DECOMPOSITION_COLLATOR = new AtomicReference();

    static Collator caseSensitiveCollator(Locale locale, boolean decomposition) {
        AtomicReference<CollatorCache> reference = decomposition ? DECOMPOSITION_COLLATOR : NO_DECOMPOSITION_COLLATOR;
        int decompositionMode = decomposition ? 1 : 0;
        return MemoryFileSystemProperties.getCaseSensitiveCollatorFromCache(locale, reference, decompositionMode);
    }

    private static Collator getCaseSensitiveCollatorFromCache(Locale locale, AtomicReference<CollatorCache> reference, int decompositionMode) {
        CollatorCache cache = reference.get();
        if (cache == null || !cache.locale.equals(locale)) {
            Collator collator = Collator.getInstance(locale);
            collator.setDecomposition(decompositionMode);
            collator.setStrength(3);
            reference.set(new CollatorCache(locale, collator));
            return collator;
        }
        return cache.collator;
    }

    static Collator caseInsensitiveCollator(Locale locale) {
        CollatorCache cache = INSENSITIVE_COLLATOR.get();
        if (cache == null || !cache.locale.equals(locale)) {
            Collator collator = Collator.getInstance(locale);
            collator.setDecomposition(0);
            collator.setStrength(1);
            INSENSITIVE_COLLATOR.set(new CollatorCache(locale, collator));
            return collator;
        }
        return cache.collator;
    }

    static final class CollatorCache {
        final Locale locale;
        final Collator collator;

        CollatorCache(Locale locale, Collator collator) {
            this.locale = locale;
            this.collator = collator;
        }
    }
}

