/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyCharmCommunityCustomizationBundle;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddNewCondaEnvFromFilePanel;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfigurationExtension;
import com.jetbrains.python.sdk.configuration.PySdkConfigurationCollector;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0017\u0010\u0019\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b\u001b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0015\u0010\u001c\u001a\u00070\u000f\u00a2\u0006\u0002\b\u001d2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010 \u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/python/sdk/configuration/PyEnvironmentYmlSdkConfiguration;", "Lcom/jetbrains/python/sdk/configuration/PyProjectSdkConfigurationExtension;", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "askForEnvData", "Lcom/jetbrains/python/sdk/add/PyAddNewCondaEnvFromFilePanel$Data;", "module", "Lcom/intellij/openapi/module/Module;", "source", "Lcom/jetbrains/python/sdk/configuration/PySdkConfigurationCollector$Companion$Source;", "createAndAddCondaEnv", "Lcom/intellij/openapi/projectRoots/Sdk;", "condaExecutable", "", "environmentYml", "createAndAddSdk", "createAndAddSdkForConfigurator", "createAndAddSdkForInspection", "createCondaEnv", "project", "Lcom/intellij/openapi/project/Project;", "executableToEventField", "Lcom/jetbrains/python/sdk/configuration/PySdkConfigurationCollector$Companion$InputData;", "getEnvironmentYml", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "getIntentionName", "Lcom/intellij/codeInspection/util/IntentionName;", "isApplicable", "", "safelyListCondaEnvironments", "", "Dialog", "intellij.pycharm.community.customization.impl"})
public final class PyEnvironmentYmlSdkConfiguration
implements PyProjectSdkConfigurationExtension {
    private final Logger LOGGER;

    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.getEnvironmentYml(module) != null;
    }

    @Nullable
    public Sdk createAndAddSdkForConfigurator(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.createAndAddSdk(module, PySdkConfigurationCollector.Companion.Source.CONFIGURATOR);
    }

    @NotNull
    public String getIntentionName(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = PyCharmCommunityCustomizationBundle.message("sdk.create.condaenv.suggestion", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyCharmCommunityCustomiz\u2026ate.condaenv.suggestion\")");
        return string;
    }

    @Nullable
    public Sdk createAndAddSdkForInspection(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.createAndAddSdk(module, PySdkConfigurationCollector.Companion.Source.INSPECTION);
    }

    private final VirtualFile getEnvironmentYml(Module module) {
        return PyUtil.findInRoots((Module)module, (String)"environment.yml");
    }

    /*
     * WARNING - void declaration
     */
    private final Sdk createAndAddSdk(Module module, PySdkConfigurationCollector.Companion.Source source) {
        PyAddNewCondaEnvFromFilePanel.Data data;
        void condaExecutable;
        PyAddNewCondaEnvFromFilePanel.Data data2 = this.askForEnvData(module, source);
        if (data2 == null) {
            return null;
        }
        PyAddNewCondaEnvFromFilePanel.Data data3 = data2;
        String string = data3.component1();
        String environmentYml = data3.component2();
        Sdk sdk = this.createAndAddCondaEnv(module, (String)condaExecutable, environmentYml);
        if (sdk != null) {
            data3 = sdk;
            boolean bl = false;
            boolean bl2 = false;
            PyAddNewCondaEnvFromFilePanel.Data it = data3;
            boolean bl3 = false;
            PyCondaPackageService.onCondaEnvCreated((String)condaExecutable);
            data = data3;
        } else {
            data = null;
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    private final PyAddNewCondaEnvFromFilePanel.Data askForEnvData(Module module, PySdkConfigurationCollector.Companion.Source source) {
        void envData;
        void permitted;
        VirtualFile virtualFile = this.getEnvironmentYml(module);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile environmentYml = virtualFile;
        String condaExecutable = PyCondaPackageService.getCondaExecutable(null);
        if (source == PySdkConfigurationCollector.Companion.Source.INSPECTION && CondaEnvSdkFlavor.validateCondaPath((String)condaExecutable) == null) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            PySdkConfigurationCollector.Companion.logCondaEnvDialogSkipped$intellij_pycharm_community_customization_impl(project, source, this.executableToEventField(condaExecutable));
            String string = condaExecutable;
            Intrinsics.checkNotNull((Object)string);
            String string2 = environmentYml.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"environmentYml.path");
            return new PyAddNewCondaEnvFromFilePanel.Data(string, string2);
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this, module, environmentYml, (Ref.BooleanRef)permitted, (Ref.ObjectRef)envData){
            final /* synthetic */ PyEnvironmentYmlSdkConfiguration this$0;
            final /* synthetic */ Module $module;
            final /* synthetic */ VirtualFile $environmentYml;
            final /* synthetic */ Ref.BooleanRef $permitted;
            final /* synthetic */ Ref.ObjectRef $envData;

            public final void run() {
                Dialog dialog = new Dialog(this.$module, this.$environmentYml);
                this.$permitted.element = dialog.showAndGet();
                this.$envData.element = dialog.getEnvData();
                PyEnvironmentYmlSdkConfiguration.access$getLOGGER$p(this.this$0).debug("Dialog exit code: " + dialog.getExitCode() + ", " + this.$permitted.element);
            }
            {
                this.this$0 = pyEnvironmentYmlSdkConfiguration;
                this.$module = module;
                this.$environmentYml = virtualFile;
                this.$permitted = booleanRef;
                this.$envData = objectRef;
            }
        });
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        PyAddNewCondaEnvFromFilePanel.Data data = (PyAddNewCondaEnvFromFilePanel.Data)envData.element;
        PySdkConfigurationCollector.Companion.logCondaEnvDialog$intellij_pycharm_community_customization_impl(project, permitted.element, source, this.executableToEventField(data != null ? data.getCondaPath() : null));
        return permitted.element ? (PyAddNewCondaEnvFromFilePanel.Data)envData.element : null;
    }

    private final Sdk createAndAddCondaEnv(Module module, String condaExecutable, String environmentYml) {
        Sdk sdk;
        ProgressManager.progress((String)PyBundle.message((String)"python.sdk.creating.conda.environment.sentence", (Object[])new Object[0]));
        this.LOGGER.debug("Creating conda environment");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        String string = this.createCondaEnv(project, condaExecutable, environmentYml);
        if (string == null) {
            return null;
        }
        String path = string;
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        PySdkConfigurationCollector.Companion.logCondaEnv$intellij_pycharm_community_customization_impl(project2, PySdkConfigurationCollector.Companion.CondaEnvResult.CREATED);
        boolean shared = PyCondaSdkCustomizer.Companion.getInstance().getSharedEnvironmentsByDefault();
        String basePath = BasePySdkExtKt.getBasePath((Module)module);
        PyDetectedSdk pyDetectedSdk = new PyDetectedSdk(path);
        boolean bl = false;
        boolean bl2 = false;
        PyDetectedSdk it = pyDetectedSdk;
        boolean bl3 = false;
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectJdkTable, (String)"ProjectJdkTable.getInstance()");
        Object[] objectArray = projectJdkTable.getAllJdks();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ProjectJdkTable.getInstance().allJdks");
        List existingSdks = ArraysKt.asList((Object[])objectArray);
        if (shared) {
            this.LOGGER.debug("Setting up conda environment: " + path);
            sdk = PySdkExtKt.setup((PyDetectedSdk)it, (List)existingSdks);
        } else {
            this.LOGGER.debug("Setting up associated conda environment: " + path + ", " + basePath);
            sdk = PySdkExtKt.setupAssociated((PyDetectedSdk)it, (List)existingSdks, (String)basePath);
        }
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this, shared, path, basePath, sdk2, module){
            final /* synthetic */ PyEnvironmentYmlSdkConfiguration this$0;
            final /* synthetic */ boolean $shared;
            final /* synthetic */ String $path;
            final /* synthetic */ String $basePath;
            final /* synthetic */ Sdk $sdk;
            final /* synthetic */ Module $module;

            public final void run() {
                if (this.$shared) {
                    PyEnvironmentYmlSdkConfiguration.access$getLOGGER$p(this.this$0).debug("Adding conda environment: " + this.$path);
                } else {
                    PyEnvironmentYmlSdkConfiguration.access$getLOGGER$p(this.this$0).debug("Adding associated conda environment: " + this.$path + ", " + this.$basePath);
                }
                SdkConfigurationUtil.addSdk((Sdk)this.$sdk);
                if (!this.$shared) {
                    PySdkExtKt.associateWithModule((Sdk)this.$sdk, (Module)this.$module, null);
                }
            }
            {
                this.this$0 = pyEnvironmentYmlSdkConfiguration;
                this.$shared = bl;
                this.$path = string;
                this.$basePath = string2;
                this.$sdk = sdk;
                this.$module = module;
            }
        });
        return sdk2;
    }

    private final PySdkConfigurationCollector.Companion.InputData executableToEventField(String condaExecutable) {
        CharSequence charSequence = condaExecutable;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? PySdkConfigurationCollector.Companion.InputData.NOT_FILLED : PySdkConfigurationCollector.Companion.InputData.SPECIFIED;
    }

    private final String createCondaEnv(Project project, String condaExecutable, String environmentYml) {
        List<String> list = this.safelyListCondaEnvironments(project, condaExecutable);
        if (list == null) {
            return null;
        }
        List<String> condaEnvironmentsBefore = list;
        try {
            PyCondaRunKt.runConda((String)condaExecutable, (List)CollectionsKt.listOf((Object[])new String[]{"env", "create", "-f", environmentYml}));
        }
        catch (ExecutionException e) {
            PySdkConfigurationCollector.Companion.logCondaEnv$intellij_pycharm_community_customization_impl(project, PySdkConfigurationCollector.Companion.CondaEnvResult.CREATION_FAILURE);
            this.LOGGER.warn("Exception during creating conda environment", (Throwable)e);
            String string = PyCharmCommunityCustomizationBundle.message("sdk.create.condaenv.exception.dialog.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyCharmCommunityCustomiz\u2026.exception.dialog.title\")");
            PySdkExtKt.showSdkExecutionException(null, (ExecutionException)e, (String)string);
            return null;
        }
        List<String> list2 = this.safelyListCondaEnvironments(project, condaExecutable);
        if (list2 == null) {
            return null;
        }
        List<String> condaEnvironmentsAfter = list2;
        List difference = CollectionsKt.minus((Iterable)condaEnvironmentsAfter, (Iterable)condaEnvironmentsBefore);
        Object object = CollectionsKt.singleOrNull((List)difference);
        boolean bl = false;
        boolean bl2 = false;
        String it = (String)object;
        boolean bl3 = false;
        if (it == null) {
            PySdkConfigurationCollector.Companion.logCondaEnv$intellij_pycharm_community_customization_impl(project, difference.isEmpty() ? PySdkConfigurationCollector.Companion.CondaEnvResult.NO_LISTING_DIFFERENCE : PySdkConfigurationCollector.Companion.CondaEnvResult.AMBIGUOUS_LISTING_DIFFERENCE);
            this.LOGGER.warn(StringsKt.trimIndent((String)("\n          Several or none conda envs found:\n          Before: " + condaEnvironmentsBefore + "\n          After: " + condaEnvironmentsAfter + "\n          ")));
        }
        String string = (String)object;
        if (string == null) {
            return null;
        }
        String rootDir = string;
        Collection collection = CondaEnvSdkFlavor.findInRootDirectory((VirtualFile)LocalFileSystem.getInstance().refreshAndFindFileByPath(rootDir));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"CondaEnvSdkFlavor.findIn\u2026dFindFileByPath(rootDir))");
        Collection paths = collection;
        Object object2 = CollectionsKt.singleOrNull((Iterable)paths);
        bl2 = false;
        boolean bl4 = false;
        String it2 = (String)object2;
        boolean bl5 = false;
        PySdkConfigurationCollector.Companion.logCondaEnv$intellij_pycharm_community_customization_impl(project, paths.isEmpty() ? PySdkConfigurationCollector.Companion.CondaEnvResult.NO_BINARY : PySdkConfigurationCollector.Companion.CondaEnvResult.AMBIGUOUS_BINARIES);
        if (it2 == null) {
            this.LOGGER.warn("Several or none conda env binaries found: " + rootDir + ", " + paths);
        }
        return (String)object2;
    }

    private final List<String> safelyListCondaEnvironments(Project project, String condaExecutable) {
        List list;
        try {
            list = PyCondaRunKt.listCondaEnvironments((String)condaExecutable);
        }
        catch (ExecutionException e) {
            PySdkConfigurationCollector.Companion.logCondaEnv$intellij_pycharm_community_customization_impl(project, PySdkConfigurationCollector.Companion.CondaEnvResult.LISTING_FAILURE);
            this.LOGGER.warn("Exception during listing conda environments", (Throwable)e);
            String string = PyCharmCommunityCustomizationBundle.message("sdk.detect.condaenv.exception.dialog.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyCharmCommunityCustomiz\u2026.exception.dialog.title\")");
            PySdkExtKt.showSdkExecutionException(null, (ExecutionException)e, (String)string);
            list = null;
        }
        return list;
    }

    public PyEnvironmentYmlSdkConfiguration() {
        Logger logger = Logger.getInstance(PyEnvironmentYmlSdkConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(PyEnv\u2026onfiguration::class.java)");
        this.LOGGER = logger;
    }

    public static final /* synthetic */ Logger access$getLOGGER$p(PyEnvironmentYmlSdkConfiguration $this) {
        return $this.LOGGER;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/sdk/configuration/PyEnvironmentYmlSdkConfiguration$Dialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "module", "Lcom/intellij/openapi/module/Module;", "environmentYml", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/vfs/VirtualFile;)V", "envData", "Lcom/jetbrains/python/sdk/add/PyAddNewCondaEnvFromFilePanel$Data;", "getEnvData", "()Lcom/jetbrains/python/sdk/add/PyAddNewCondaEnvFromFilePanel$Data;", "panel", "Lcom/jetbrains/python/sdk/add/PyAddNewCondaEnvFromFilePanel;", "createCenterPanel", "Ljavax/swing/JComponent;", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "postponeValidation", "", "intellij.pycharm.community.customization.impl"})
    private static final class Dialog
    extends DialogWrapper {
        private final PyAddNewCondaEnvFromFilePanel panel;

        @NotNull
        public final PyAddNewCondaEnvFromFilePanel.Data getEnvData() {
            return this.panel.getEnvData();
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            boolean bl = false;
            boolean bl2 = false;
            JPanel $this$apply = jPanel;
            boolean bl3 = false;
            Border border = IdeBorderFactory.createEmptyBorder((Insets)new Insets(4, 0, 6, 0));
            String string = PyCharmCommunityCustomizationBundle.message("sdk.create.condaenv.permission", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyCharmCommunityCustomiz\u2026ate.condaenv.permission\")");
            String message = string;
            $this$apply.add((Component)JBUI.Panels.simplePanel((Component)((Component)new JBLabel(message))).withBorder(border), "North");
            $this$apply.add((Component)this.panel, "Center");
            return jPanel;
        }

        protected boolean postponeValidation() {
            return false;
        }

        @NotNull
        protected List<ValidationInfo> doValidateAll() {
            return this.panel.validateAll();
        }

        public Dialog(@NotNull Module module, @NotNull VirtualFile environmentYml) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)environmentYml, (String)"environmentYml");
            super(module.getProject(), false, DialogWrapper.IdeModalityType.PROJECT);
            this.panel = new PyAddNewCondaEnvFromFilePanel(module, environmentYml);
            this.setTitle(PyBundle.message((String)"python.sdk.creating.conda.environment.title", (Object[])new Object[0]));
            this.init();
            Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

                public final void dispose() {
                    if (this.isOK()) {
                        panel.logData();
                    }
                }
            });
        }
    }
}

