/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.jcef.MarkdownJCEFPreviewExtension;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.ui.preview.PreviewLAFThemeStyles;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/BaseStylesExtension;", "Lorg/intellij/plugins/markdown/extensions/jcef/MarkdownJCEFPreviewExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "()V", "priority", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Priority;", "getPriority", "()Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Priority;", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "styles", "", "", "getStyles", "()Ljava/util/List;", "canProvide", "", "resourceName", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "Companion", "intellij.markdown"})
public final class BaseStylesExtension
implements MarkdownJCEFPreviewExtension,
ResourceProvider {
    @NotNull
    private final MarkdownBrowserPreviewExtension.Priority priority = MarkdownBrowserPreviewExtension.Priority.BEFORE_ALL;
    @NotNull
    private final List<String> styles = CollectionsKt.listOf((Object[])new String[]{"baseStyles/default.css", "baseStyles/colors.css"});
    @NotNull
    private final ResourceProvider resourceProvider = this;
    private static final String COLORS_CSS_FILENAME = "baseStyles/colors.css";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public MarkdownBrowserPreviewExtension.Priority getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    @Nullable
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        if (Intrinsics.areEqual((Object)resourceName, (Object)COLORS_CSS_FILENAME)) {
            String string = PreviewLAFThemeStyles.createStylesheet();
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            return new ResourceProvider.Resource(byArray, null, 2, null);
        }
        MarkdownApplicationSettings markdownApplicationSettings = MarkdownApplicationSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)markdownApplicationSettings, (String)"MarkdownApplicationSettings.getInstance()");
        MarkdownCssSettings markdownCssSettings = markdownApplicationSettings.getMarkdownCssSettings();
        boolean bl = false;
        boolean bl2 = false;
        MarkdownCssSettings $this$with = markdownCssSettings;
        boolean bl3 = false;
        return $this$with.isCustomStylesheetEnabled() ? ResourceProvider.Companion.loadExternalResource$default(ResourceProvider.Companion, new File($this$with.getCustomStylesheetPath()), null, 2, null) : ResourceProvider.Companion.loadInternalResource$default(ResourceProvider.Companion, Reflection.getOrCreateKotlinClass(BaseStylesExtension.class), resourceName, null, 4, null);
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return this.getStyles().contains(resourceName);
    }

    @Override
    @NotNull
    public Map<String, Function1<String, Unit>> getEvents() {
        return MarkdownJCEFPreviewExtension.DefaultImpls.getEvents(this);
    }

    @Override
    @NotNull
    public List<String> getScripts() {
        return MarkdownJCEFPreviewExtension.DefaultImpls.getScripts(this);
    }

    @Override
    public int compareTo(@NotNull MarkdownBrowserPreviewExtension other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MarkdownJCEFPreviewExtension.DefaultImpls.compareTo(this, other);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/BaseStylesExtension$Companion;", "", "()V", "COLORS_CSS_FILENAME", "", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

