/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.extensions.python.PyClassExtKt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.PythonUnitTestDetectorsKt;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0011"}, d2={"isTestClass", "", "clazz", "Lcom/jetbrains/python/psi/PyClass;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "isTestElement", "element", "Lcom/intellij/psi/PsiElement;", "typeEvalContext", "isTestFile", "file", "Lcom/jetbrains/python/psi/PyFile;", "isTestFunction", "function", "Lcom/jetbrains/python/psi/PyFunction;", "isUnitTestCaseClass", "intellij.python.psi.impl"})
public final class PythonUnitTestDetectorsKt {
    public static final boolean isTestFunction(@NotNull PyFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        String string = function.getName();
        return string != null && StringsKt.startsWith$default((String)string, (String)"test", (boolean)false, (int)2, null);
    }

    public static final boolean isUnitTestCaseClass(@NotNull PyClass clazz, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return PyClassExtKt.inherits(clazz, context, "unittest.TestCase", "unittest.case.TestCase");
    }

    public static final boolean isTestClass(@NotNull PyClass clazz, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (PythonUnitTestDetectorsKt.isUnitTestCaseClass(clazz, context)) {
            return true;
        }
        String string = clazz.getName();
        if (string == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.name ?: return false");
        String className = string;
        if (!StringsKt.startsWith$default((String)className, (String)"Test", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)className, (String)"Test", (boolean)false, (int)2, null)) {
            return false;
        }
        Processor<PyFunction> processor2 = new Processor<PyFunction>(){
            private boolean hasTestFunction;

            public final boolean getHasTestFunction() {
                return this.hasTestFunction;
            }

            public boolean process(@NotNull PyFunction function) {
                block2: {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        if (PythonUnitTestDetectorsKt.isTestFunction(function)) break block1;
                        String string = function.getName();
                        if (string == null) break block2;
                        if (!string.equals("setUp")) break block2;
                    }
                    this.hasTestFunction = true;
                    return false;
                }
                return true;
            }
        };
        boolean bl = false;
        boolean bl2 = false;
        Processor<PyFunction> $this$apply = processor2;
        boolean bl3 = false;
        clazz.visitMethods((Processor<? super PyFunction>)((Processor)$this$apply), true, context);
        return $this$apply.getHasTestFunction();
    }

    public static final boolean isTestFile(@NotNull PyFile file, @NotNull TypeEvalContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (file.getTopLevelClasses().stream().anyMatch((Predicate)new Predicate<PyClass>(context){
            final /* synthetic */ TypeEvalContext $context;

            public final boolean test(@NotNull PyClass o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                return PythonUnitTestDetectorsKt.isTestClass(o, this.$context);
            }
            {
                this.$context = typeEvalContext;
            }
        })) {
            bl = true;
        } else {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            bl = StringsKt.startsWith$default((String)string, (String)"test_", (boolean)false, (int)2, null) || file.getTopLevelFunctions().stream().anyMatch(isTestFile.2.INSTANCE);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTestElement(@NotNull PsiElement element, @NotNull TypeEvalContext typeEvalContext) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)typeEvalContext, (String)"typeEvalContext");
        PsiElement psiElement = element;
        if (psiElement instanceof PyFile) {
            bl = PythonUnitTestDetectorsKt.isTestFile((PyFile)element, typeEvalContext);
            return bl;
        } else {
            if (psiElement instanceof PsiDirectory) {
                String string = ((PsiDirectory)element).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name");
                if (StringsKt.contains((CharSequence)string, (CharSequence)"test", (boolean)true)) return true;
                PsiElement[] psiElementArray = ((PsiDirectory)element).getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"element.children");
                PsiElement[] $this$any$iv = psiElementArray;
                boolean $i$f$any = false;
                PsiElement[] psiElementArray2 = $this$any$iv;
                int n = psiElementArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    PsiElement element$iv;
                    PsiElement it = element$iv = psiElementArray2[n2];
                    boolean bl2 = false;
                    if (it instanceof PyFile && PythonUnitTestDetectorsKt.isTestFile((PyFile)it, typeEvalContext)) {
                        return true;
                    }
                    boolean bl3 = false;
                    if (bl3) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            if (psiElement instanceof PyFunction) {
                bl = PythonUnitTestDetectorsKt.isTestFunction((PyFunction)element);
                return bl;
            } else {
                if (!(psiElement instanceof PyClass)) return false;
                bl = PythonUnitTestDetectorsKt.isTestClass((PyClass)element, typeEvalContext);
            }
        }
        return bl;
    }
}

