/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.BlockingSet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.UnsupportedPythonSdkTypeException;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class PythonSdkUpdaterOld
implements StartupActivity.Background {
    private static final Logger LOG = Logger.getInstance(PythonSdkUpdaterOld.class);
    private static final Object ourLock = new Object();
    private static final Set<String> ourScheduledToRefresh = new HashSet<String>();
    private static final BlockingSet<String> ourUnderRefresh = new BlockingSet();
    private static final NotificationGroup NOTIFICATION_GROUP = PythonSdkUpdater.NOTIFICATION_GROUP;

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(0);
        }
        PythonSdkUpdaterOld.updateProjectSdksOnStartup(project);
    }

    static void updateProjectSdksOnStartup(final @NotNull Project project) {
        Application application;
        if (project == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(1);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode()) {
            return;
        }
        if (project.isDisposed()) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, PyBundle.message("python.sdk.updating.python.paths", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Sdk sdk : PythonSdkUpdaterOld.getPythonSdks(project)) {
                    PythonSdkUpdaterOld.update(sdk, project, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/sdk/PythonSdkUpdaterOld$1", "run"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean update(final @NotNull Sdk sdk, @Nullable Project project, final @Nullable Component ownerComponent) {
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(2);
        }
        final Application application = ApplicationManager.getApplication();
        assert (!application.isWriteAccessAllowed()) : "sdk update should not be run in edt neither under write action";
        final String key = PythonSdkType.getSdkKey(sdk);
        Object object = ourLock;
        synchronized (object) {
            ourScheduledToRefresh.add(key);
        }
        String sdkHome = sdk.getHomePath();
        if (sdkHome != null && (PythonSdkUtil.isVirtualEnv(sdkHome) || PythonSdkUtil.isConda(sdk))) {
            Future updateSdkFeature = application.executeOnPooledThread(() -> PySdkUtil.activateVirtualEnv(sdk));
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    updateSdkFeature.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new AssertionError("Exception thrown while synchronizing with sdk updater ", e);
                }
            }
        }
        PythonSdkUpdaterOld.updateLocalSdkVersion(sdk);
        if (!PythonSdkUpdaterOld.updateLocalSdkPaths(sdk, project)) {
            return false;
        }
        if (project == null) {
            return true;
        }
        if (application.isUnitTestMode()) {
            return true;
        }
        final Throwable methodCallStacktrace = new Throwable("SDK update trace");
        application.invokeLater(() -> {
            Object object = ourLock;
            synchronized (object) {
                if (!ourScheduledToRefresh.contains(key)) {
                    if (Trigger.LOG.isDebugEnabled()) {
                        Trigger.LOG.debug("Dropping simultaneous SDK update for " + key + " triggered by " + Trigger.getCauseByTrace(methodCallStacktrace));
                    }
                    return;
                }
                ourScheduledToRefresh.remove(key);
            }
            if (project.isDisposed()) {
                return;
            }
            if (PythonSdkUtil.findSdkByKey(key) == null) {
                return;
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, PyBundle.message("sdk.gen.updating.interpreter", new Object[0]), false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Project project1 = this.getProject();
                    Sdk sdkInsideTask = PythonSdkUtil.findSdkByKey(key);
                    if (sdkInsideTask != null) {
                        ourUnderRefresh.put((Object)key);
                        try {
                            String skeletonsPath = PythonSdkUtil.getSkeletonsPath(sdk);
                            try {
                                if (PythonSdkUtil.isRemote(sdkInsideTask) && project1 == null && ownerComponent == null) {
                                    LOG.error("For refreshing skeletons of remote SDK, either project or owner component must be specified");
                                }
                                String sdkPresentableName = PythonSdkUpdaterOld.getSdkPresentableName(sdk);
                                LOG.info("Performing background update of skeletons for SDK " + sdkPresentableName);
                                indicator.setText(PyBundle.message("python.sdk.updating.skeletons", new Object[0]));
                                try {
                                    if (Trigger.LOG.isDebugEnabled()) {
                                        Trigger.LOG.debug("Performing skeletons update triggered by " + Trigger.getCauseByTrace(methodCallStacktrace));
                                    }
                                    PySkeletonRefresher.refreshSkeletonsOfSdk(project1, ownerComponent, skeletonsPath, sdkInsideTask);
                                    PythonSdkUpdaterOld.updateRemoteSdkPaths(sdkInsideTask, this.getProject());
                                    indicator.setIndeterminate(true);
                                    indicator.setText(PyBundle.message("python.sdk.scanning.installed.packages", new Object[0]));
                                    indicator.setText2("");
                                    LOG.info("Performing background scan of packages for SDK " + sdkPresentableName);
                                    PyPackageManager.getInstance(sdkInsideTask).refreshAndGetPackages(true);
                                }
                                catch (com.intellij.execution.ExecutionException e) {
                                    if (LOG.isDebugEnabled()) {
                                        e.initCause(methodCallStacktrace);
                                        LOG.debug((Throwable)e);
                                    }
                                    LOG.warn(e.getMessage());
                                }
                                if (project1 != null) {
                                    application.invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)project1).restart(), project1.getDisposed());
                                }
                            }
                            catch (UnsupportedPythonSdkTypeException e) {
                                NOTIFICATION_GROUP.createNotification(PyBundle.message("sdk.gen.failed.notification.title", new Object[0]), null, PyBundle.message("remote.interpreter.support.is.not.available", sdk.getName()), NotificationType.WARNING).notify(project1);
                            }
                            catch (InvalidSdkException e) {
                                if (PythonSdkUtil.isRemote(sdkInsideTask)) {
                                    PythonSdkType.notifyRemoteSdkSkeletonsFail(e, () -> {
                                        Sdk sdkInsideNotify = PythonSdkUtil.findSdkByKey(key);
                                        if (sdkInsideNotify != null) {
                                            PythonSdkUpdaterOld.update(sdkInsideNotify, project1, ownerComponent);
                                        }
                                    });
                                } else if (!PythonSdkUtil.isInvalid(sdkInsideTask)) {
                                    LOG.error((Throwable)e);
                                }
                            }
                        }
                        finally {
                            try {
                                ourUnderRefresh.remove((Object)key);
                            }
                            catch (IllegalStateException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/sdk/PythonSdkUpdaterOld$2", "run"));
                }
            });
        }, ModalityState.NON_MODAL);
        return true;
    }

    public static void updateOrShowError(@NotNull Sdk sdk, @Nullable Project project, @Nullable Component ownerComponent) {
        boolean success;
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(3);
        }
        if (!(success = PythonSdkUpdaterOld.update(sdk, project, ownerComponent))) {
            Messages.showErrorDialog((Project)project, (String)PyBundle.message("python.sdk.cannot.setup.sdk", PythonSdkUpdaterOld.getSdkPresentableName(sdk)), (String)PyBundle.message("python.sdk.invalid.python.sdk", new Object[0]));
        }
    }

    private static void updateLocalSdkVersion(@NotNull Sdk sdk) {
        String versionString;
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(4);
        }
        if (!PythonSdkUtil.isRemote(sdk) && !StringUtil.equals((CharSequence)(versionString = sdk.getSdkType().getVersionString(sdk)), (CharSequence)sdk.getVersionString())) {
            PythonSdkUpdaterOld.changeSdkModificator(sdk, (Processor<SdkModificator>)((Processor)modificatorToWrite -> {
                modificatorToWrite.setVersionString(versionString);
                return true;
            }));
        }
    }

    private static boolean updateLocalSdkPaths(@NotNull Sdk sdk, @Nullable Project project) {
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(5);
        }
        if (!PythonSdkUtil.isRemote(sdk)) {
            List<VirtualFile> localSdkPaths;
            boolean forceCommit = PythonSdkUpdaterOld.ensureBinarySkeletonsDirectoryExists(sdk);
            try {
                localSdkPaths = PythonSdkUpdaterOld.getLocalSdkPaths(sdk, project);
            }
            catch (InvalidSdkException e) {
                if (!PythonSdkUtil.isInvalid(sdk)) {
                    LOG.error((Throwable)e);
                }
                return false;
            }
            PythonSdkUpdaterOld.commitSdkPathsIfChanged(sdk, localSdkPaths, forceCommit);
        }
        return true;
    }

    private static void updateRemoteSdkPaths(@NotNull Sdk sdk, @Nullable Project project) {
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(6);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            boolean forceCommit = PythonSdkUpdaterOld.ensureBinarySkeletonsDirectoryExists(sdk);
            List<VirtualFile> remoteSdkPaths = PythonSdkUpdaterOld.getRemoteSdkPaths(sdk, project);
            PythonSdkUpdaterOld.commitSdkPathsIfChanged(sdk, remoteSdkPaths, forceCommit);
        }
    }

    private static boolean ensureBinarySkeletonsDirectoryExists(Sdk sdk) {
        String skeletonsPath = PythonSdkUtil.getSkeletonsPath(sdk);
        return skeletonsPath != null && new File(skeletonsPath).mkdirs();
    }

    @NotNull
    private static List<VirtualFile> getLocalSdkPaths(@NotNull Sdk sdk, @Nullable Project project) throws InvalidSdkException {
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(7);
        }
        ImmutableList immutableList = ImmutableList.builder().addAll(PythonSdkUpdaterOld.filterRootPaths(sdk, PythonSdkUpdaterOld.evaluateSysPath(sdk), project)).addAll(PythonSdkUpdaterOld.getSkeletonsPaths(sdk)).addAll(PythonSdkUpdaterOld.getUserAddedPaths(sdk)).addAll(PyTypeShed.INSTANCE.findRootsForSdk(sdk)).build();
        if (immutableList == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @NotNull
    private static List<VirtualFile> getRemoteSdkPaths(@NotNull Sdk sdk, @Nullable Project project) {
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(9);
        }
        ImmutableList immutableList = ImmutableList.builder().addAll(PythonSdkUpdaterOld.getRemoteSdkMappedPaths(sdk, project)).addAll(PythonSdkUpdaterOld.getSkeletonsPaths(sdk)).addAll(PythonSdkUpdaterOld.getUserAddedPaths(sdk)).addAll(PyTypeShed.INSTANCE.findRootsForSdk(sdk)).build();
        if (immutableList == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(10);
        }
        return immutableList;
    }

    @NotNull
    private static List<VirtualFile> getUserAddedPaths(@NotNull Sdk sdk) {
        SdkAdditionalData additionalData;
        PythonSdkAdditionalData pythonAdditionalData;
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(11);
        }
        ArrayList arrayList = (pythonAdditionalData = PyUtil.as(additionalData = sdk.getSdkAdditionalData(), PythonSdkAdditionalData.class)) != null ? Lists.newArrayList(pythonAdditionalData.getAddedPathFiles()) : Collections.emptyList();
        if (arrayList == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> getRemoteSdkMappedPaths(@NotNull Sdk sdk, @Nullable Project project) {
        SdkAdditionalData additionalData;
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(13);
        }
        if ((additionalData = sdk.getSdkAdditionalData()) instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase remoteSdkData = (PyRemoteSdkAdditionalDataBase)additionalData;
            ArrayList<String> paths2 = new ArrayList<String>();
            for (PathMappingSettings.PathMapping mapping : remoteSdkData.getPathMappings().getPathMappings()) {
                paths2.add(mapping.getLocalRoot());
            }
            return PythonSdkUpdaterOld.filterRootPaths(sdk, paths2, project);
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> filterRootPaths(@NotNull Sdk sdk, @NotNull List<String> paths2, @Nullable Project project) {
        PythonSdkAdditionalData pythonAdditionalData;
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(15);
        }
        if (paths2 == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(16);
        }
        Collection<Object> excludedPaths = (pythonAdditionalData = PyUtil.as(sdk.getSdkAdditionalData(), PythonSdkAdditionalData.class)) != null ? pythonAdditionalData.getExcludedPathFiles() : Collections.emptyList();
        HashSet<VirtualFile> moduleRoots = new HashSet<VirtualFile>();
        if (project != null) {
            Module[] modules;
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                moduleRoots.addAll(PyUtil.getSourceRoots(module));
            }
        }
        ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
        VirtualFile condaFolder = PythonSdkUtil.isConda(sdk) ? PythonSdkUtil.getCondaDirectory(sdk) : null;
        for (String path : paths2) {
            VirtualFile rootFile;
            VirtualFile virtualFile;
            if (!(path == null || FileUtilRt.extensionEquals((String)path, (String)"egg-info") || (virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(path)) == null || virtualFile.equals(condaFolder) || excludedPaths.contains(rootFile = PythonSdkType.getSdkRootVirtualFile(virtualFile)) || moduleRoots.contains(rootFile))) {
                results.add(rootFile);
                continue;
            }
            LOG.info("Bogus sys.path entry " + path);
        }
        ArrayList<VirtualFile> arrayList = results;
        if (arrayList == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> getSkeletonsPaths(@NotNull Sdk sdk) {
        VirtualFile userSkeletonsDir;
        VirtualFile skeletonsDir;
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(18);
        }
        ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
        String skeletonsPath = PythonSdkUtil.getSkeletonsPath(sdk);
        if (skeletonsPath != null && (skeletonsDir = StandardFileSystems.local().refreshAndFindFileByPath(skeletonsPath)) != null) {
            results.add(skeletonsDir);
            LOG.info("Binary skeletons directory for SDK " + PythonSdkUpdaterOld.getSdkPresentableName(sdk) + "): " + skeletonsDir.getPath());
        }
        if ((userSkeletonsDir = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) != null) {
            results.add(userSkeletonsDir);
            LOG.info("User skeletons directory for SDK " + PythonSdkUpdaterOld.getSdkPresentableName(sdk) + "): " + userSkeletonsDir.getPath());
        }
        ArrayList<VirtualFile> arrayList = results;
        if (arrayList == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    private static String getSdkPresentableName(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(20);
        }
        String homePath = sdk.getHomePath();
        String name = sdk.getName();
        Object object = homePath != null ? name + " (" + homePath + ")" : name;
        if (object == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(21);
        }
        return object;
    }

    @NotNull
    private static List<String> evaluateSysPath(@NotNull Sdk sdk) throws InvalidSdkException {
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(22);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            throw new IllegalArgumentException("Cannot evaluate sys.path for remote Python interpreter " + sdk);
        }
        long startTime = System.currentTimeMillis();
        List<String> sysPath = PythonSdkType.getSysPath(sdk);
        LOG.info("Updating sys.path took " + (System.currentTimeMillis() - startTime) + " ms");
        List<String> list = sysPath;
        if (list == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(23);
        }
        return list;
    }

    private static void commitSdkPathsIfChanged(@NotNull Sdk sdk, @NotNull List<VirtualFile> sdkPaths, boolean forceCommit) {
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(24);
        }
        if (sdkPaths == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(25);
        }
        List<VirtualFile> currentSdkPaths = Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
        if (forceCommit || !Sets.newHashSet(sdkPaths).equals(Sets.newHashSet(currentSdkPaths))) {
            PythonSdkUpdaterOld.changeSdkModificator(sdk, (Processor<SdkModificator>)((Processor)effectiveModificator -> {
                effectiveModificator.removeAllRoots();
                for (VirtualFile sdkPath : sdkPaths) {
                    effectiveModificator.addRoot(PythonSdkType.getSdkRootVirtualFile(sdkPath), OrderRootType.CLASSES);
                }
                return true;
            }));
        }
    }

    private static void changeSdkModificator(@NotNull Sdk sdk, @NotNull Processor<SdkModificator> processor2) {
        if (sdk == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(26);
        }
        if (processor2 == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(27);
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            SdkModificator effectiveModificator = sdk.getSdkModificator();
            if (processor2.process((Object)effectiveModificator)) {
                effectiveModificator.commitChanges();
            }
        });
    }

    @NotNull
    private static Set<Sdk> getPythonSdks(@NotNull Project project) {
        if (project == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(28);
        }
        LinkedHashSet<Sdk> pythonSdks = new LinkedHashSet<Sdk>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk = PythonSdkUtil.findPythonSdk(module);
            if (sdk == null || !(sdk.getSdkType() instanceof PythonSdkType)) continue;
            pythonSdks.add(sdk);
        }
        LinkedHashSet<Sdk> linkedHashSet = pythonSdks;
        if (linkedHashSet == null) {
            PythonSdkUpdaterOld.$$$reportNull$$$0(29);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUpdaterOld";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPaths";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdaterOld";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalSdkPaths";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkPaths";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAddedPaths";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkMappedPaths";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRootPaths";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPaths";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPresentableName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSysPath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateProjectSdksOnStartup";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateOrShowError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalSdkVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalSdkPaths";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateRemoteSdkPaths";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocalSdkPaths";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkPaths";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserAddedPaths";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkMappedPaths";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterRootPaths";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSkeletonsPaths";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSdkPresentableName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSysPath";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "commitSdkPathsIfChanged";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "changeSdkModificator";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPythonSdks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Trigger {
        STARTUP_ACTIVITY("com.jetbrains.python.sdk.PythonSdkUpdater$1.run"),
        CHANGE_UNDER_INTERPRETER_ROOTS("com.jetbrains.python.packaging.PyPackageManagerImpl.lambda$subscribeToLocalChanges"),
        REFRESH_AFTER_PACKAGING_OPERATION("com.jetbrains.python.packaging.PyPackageManagerImpl.lambda$refresh"),
        START_SDK_UPDATES_ACTION("com.jetbrains.python.sdk.PyUpdateProjectSdkAction.actionPerformed");

        private static final Logger LOG;
        private final String myFrameMarker;

        private Trigger(String frameMarker) {
            if (frameMarker == null) {
                Trigger.$$$reportNull$$$0(0);
            }
            this.myFrameMarker = frameMarker;
        }

        @NotNull
        public static String getCauseByTrace(@NotNull Throwable trace) {
            Trigger trigger;
            if (trace == null) {
                Trigger.$$$reportNull$$$0(1);
            }
            if ((trigger = Trigger.findTriggerByTrace(trace)) != null) {
                String string = trigger.name();
                if (string == null) {
                    Trigger.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = "Unknown trigger:\n" + ExceptionUtil.getThrowableText((Throwable)trace);
            if (string == null) {
                Trigger.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public static Trigger findTriggerByTrace(@NotNull Throwable trace) {
            if (trace == null) {
                Trigger.$$$reportNull$$$0(4);
            }
            String traceText = ExceptionUtil.getThrowableText((Throwable)trace);
            for (Trigger value : Trigger.values()) {
                if (!traceText.contains(value.myFrameMarker)) continue;
                return value;
            }
            return null;
        }

        static {
            LOG = Logger.getInstance(Trigger.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameMarker";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkUpdaterOld$Trigger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkUpdaterOld$Trigger";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCauseByTrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCauseByTrace";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findTriggerByTrace";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

