/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveCallQuickFix;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCallingNonCallableInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyCallingNonCallableInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyCallingNonCallableInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    @Nullable
    private static Boolean isCallable(@NotNull PyExpression element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyCallingNonCallableInspection.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyCallingNonCallableInspection.$$$reportNull$$$0(3);
        }
        if (element instanceof PyQualifiedExpression && "__class__".equals(element.getName())) {
            return true;
        }
        return PyTypeChecker.isCallable(context.getType(element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyCallingNonCallableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitPyCallExpression(node);
            this.checkCallable(node, node.getCallee());
        }

        @Override
        public void visitPyDecorator(@NotNull PyDecorator decorator) {
            if (decorator == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitPyDecorator(decorator);
            PyExpression callee = decorator.getCallee();
            this.checkCallable(decorator, callee);
            if (decorator.hasArgumentList()) {
                this.checkCallable(decorator, decorator);
            }
        }

        private void checkCallable(@NotNull PyElement node, @Nullable PyExpression callee) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (node.getParent() instanceof PyDecorator) {
                return;
            }
            if (callee != null && PyCallingNonCallableInspection.isCallable(callee, this.myTypeEvalContext) == Boolean.FALSE) {
                PyType calleeType = this.myTypeEvalContext.getType(callee);
                @InspectionMessage String message = PyPsiBundle.message("INSP.expression.is.not.callable", new Object[0]);
                if (calleeType instanceof PyClassType) {
                    message = PyPsiBundle.message("INSP.class.object.is.not.callable", calleeType.getName());
                } else {
                    String name = callee.getName();
                    if (name != null) {
                        message = PyPsiBundle.message("INSP.symbol.is.not.callable", name);
                    }
                }
                this.registerProblem((PsiElement)node, message, new PyRemoveCallQuickFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decorator";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyCallingNonCallableInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyDecorator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkCallable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

