/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import com.jetbrains.python.documentation.docstrings.TagBasedDocString;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EpydocString
extends TagBasedDocString {
    public static String[] RTYPE_TAGS = new String[]{"rtype", "returntype"};
    public static String[] KEYWORD_ARGUMENT_TAGS = new String[]{"keyword", "kwarg", "kwparam"};
    public static String[] ALL_TAGS = new String[]{"@param", "@type", "@return", "@rtype", "@keyword", "@raise", "@ivar", "@cvar", "@var", "@group", "@sort", "@note", "@attention", "@bug", "@warning", "@version", "@todo", "@deprecated", "@since", "@status", "@change", "@permission", "@requires", "@precondition", "@postcondition", "@invariant", "@author", "@organization", "@copyright", "@license", "@contact", "@summary", "@see"};
    public static String[] ADDITIONAL = new String[]{"group", "sort", "note", "attention", "bug", "warning", "version", "todo", "deprecated", "since", "status", "change", "permission", "requires", "precondition", "postcondition", "invariant", "author", "organization", "copyright", "license", "contact", "summary", "see"};

    public EpydocString(@NotNull Substring docstringText) {
        if (docstringText == null) {
            EpydocString.$$$reportNull$$$0(0);
        }
        super(docstringText, "@");
    }

    @Override
    @NotNull
    public String getDescription() {
        String html = EpydocString.inlineMarkupToHTML(this.myDescription);
        assert (html != null);
        String string = html;
        if (string == null) {
            EpydocString.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getParameters() {
        List<String> list = EpydocString.toUniqueStrings(this.getParameterSubstrings());
        if (list == null) {
            EpydocString.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getKeywordArguments() {
        List<String> list = EpydocString.toUniqueStrings(this.getKeywordArgumentSubstrings());
        if (list == null) {
            EpydocString.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public String getReturnType() {
        return EpydocString.removeInlineMarkup(this.getReturnTypeSubstring());
    }

    @Override
    public String getReturnDescription() {
        return EpydocString.inlineMarkupToHTML(this.getTagValue(RETURN_TAGS));
    }

    @Override
    @Nullable
    public String getParamType(@Nullable String paramName) {
        return EpydocString.removeInlineMarkup(this.getParamTypeSubstring(paramName));
    }

    @Override
    @Nullable
    public String getParamDescription(@Nullable String paramName) {
        if (paramName == null) {
            return null;
        }
        Substring value = this.getTagValue(PARAM_TAGS, paramName);
        if (value == null) {
            value = this.getTagValue(PARAM_TAGS, "*" + paramName);
        }
        if (value == null) {
            value = this.getTagValue(PARAM_TAGS, "**" + paramName);
        }
        return EpydocString.inlineMarkupToHTML(value);
    }

    @Override
    @Nullable
    public String getKeywordArgumentDescription(@Nullable String paramName) {
        if (paramName == null) {
            return null;
        }
        return EpydocString.inlineMarkupToHTML(this.getTagValue(KEYWORD_ARGUMENT_TAGS, paramName));
    }

    @Override
    @NotNull
    public List<String> getRaisedExceptions() {
        List<String> list = EpydocString.toUniqueStrings(this.getTagArguments(RAISES_TAGS));
        if (list == null) {
            EpydocString.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public String getRaisedExceptionDescription(@Nullable String exceptionName) {
        if (exceptionName == null) {
            return null;
        }
        return EpydocString.removeInlineMarkup(this.getTagValue(RAISES_TAGS, exceptionName));
    }

    @Override
    public String getAttributeDescription() {
        Substring value = this.getTagValue(VARIABLE_TAGS);
        return EpydocString.convertInlineMarkup(value != null ? value.toString() : null, true);
    }

    @Nullable
    public static String removeInlineMarkup(@Nullable String s) {
        return EpydocString.convertInlineMarkup(s, false);
    }

    @Nullable
    private static String removeInlineMarkup(@Nullable Substring s) {
        return EpydocString.convertInlineMarkup(s != null ? s.concatTrimmedLines(" ") : null, false);
    }

    @Nullable
    private static String convertInlineMarkup(@Nullable String s, boolean toHTML) {
        if (s == null) {
            return null;
        }
        MarkupConverter converter = toHTML ? new HTMLConverter() : new MarkupConverter();
        converter.appendWithMarkup(s);
        return converter.result();
    }

    private static int findMatchingEndBrace(String s, int bracePos) {
        int braceCount = 1;
        for (int pos = bracePos + 1; pos < s.length(); ++pos) {
            char c = s.charAt(pos);
            if (c == '{') {
                ++braceCount;
                continue;
            }
            if (c != '}' || --braceCount != 0) continue;
            return pos;
        }
        return -1;
    }

    private static String joinLines(String s, boolean addSpace) {
        int lineBreakStart;
        while ((lineBreakStart = ((String)s).indexOf(10)) >= 0) {
            int lineBreakEnd;
            int blankLines = 0;
            for (lineBreakEnd = lineBreakStart + 1; lineBreakEnd < ((String)s).length() && (((String)s).charAt(lineBreakEnd) == ' ' || ((String)s).charAt(lineBreakEnd) == '\n'); ++lineBreakEnd) {
                if (((String)s).charAt(lineBreakEnd) != '\n') continue;
                ++blankLines;
            }
            if (addSpace) {
                String separator = blankLines > 0 ? "<p>" : " ";
                s = ((String)s).substring(0, lineBreakStart) + separator + ((String)s).substring(lineBreakEnd);
                continue;
            }
            s = ((String)s).substring(0, lineBreakStart) + ((String)s).substring(lineBreakEnd);
        }
        return s;
    }

    @Nullable
    public static String inlineMarkupToHTML(@Nullable String s) {
        return EpydocString.convertInlineMarkup(s, true);
    }

    @Nullable
    private static String inlineMarkupToHTML(@Nullable Substring s) {
        return s != null ? EpydocString.inlineMarkupToHTML(s.concatTrimmedLines(" ")) : null;
    }

    @Override
    public List<String> getAdditionalTags() {
        ArrayList<String> list = new ArrayList<String>();
        for (String tagName : ADDITIONAL) {
            Map map2 = (Map)this.myArgTagValues.get(tagName);
            if (map2 == null) continue;
            list.add(tagName);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Substring> getKeywordArgumentSubstrings() {
        List<Substring> list = this.getTagArguments(KEYWORD_ARGUMENT_TAGS);
        if (list == null) {
            EpydocString.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public Substring getReturnTypeSubstring() {
        return this.getTagValue(RTYPE_TAGS);
    }

    @Override
    public Substring getParamTypeSubstring(@Nullable String paramName) {
        return paramName == null ? this.getTagValue("type") : this.getTagValue("type", paramName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docstringText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/EpydocString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/EpydocString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRaisedExceptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordArgumentSubstrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HTMLConverter
    extends MarkupConverter {
        private HTMLConverter() {
        }

        @Override
        protected void appendText(String text2) {
            this.myResult.append(EpydocString.joinLines(XmlTagUtilBase.escapeString((String)text2, (boolean)false), true));
        }

        @Override
        protected void appendMarkup(char markupChar, @NotNull String markupContent) {
            if (markupContent == null) {
                HTMLConverter.$$$reportNull$$$0(0);
            }
            if (markupChar == 'U') {
                this.appendLink(markupContent);
                return;
            }
            switch (markupChar) {
                case 'I': {
                    this.appendTagPair(markupContent, "i");
                    break;
                }
                case 'B': {
                    this.appendTagPair(markupContent, "b");
                    break;
                }
                case 'C': {
                    this.appendTagPair(markupContent, "code");
                    break;
                }
                default: {
                    this.myResult.append(StringUtil.escapeXmlEntities((String)markupContent));
                }
            }
        }

        private void appendTagPair(String markupContent, String tagName) {
            this.myResult.append("<").append(tagName).append(">");
            this.appendWithMarkup(markupContent);
            this.myResult.append("</").append(tagName).append(">");
        }

        private void appendLink(@NotNull String markupContent) {
            String linkText;
            if (markupContent == null) {
                HTMLConverter.$$$reportNull$$$0(1);
            }
            String linkUrl = linkText = StringUtil.escapeXmlEntities((String)markupContent);
            int pos = markupContent.indexOf(60);
            if (pos >= 0 && markupContent.endsWith(">")) {
                linkText = StringUtil.escapeXmlEntities((String)markupContent.substring(0, pos).trim());
                linkUrl = EpydocString.joinLines(StringUtil.escapeXmlEntities((String)markupContent.substring(pos + 1, markupContent.length() - 1)), false);
            }
            this.myResult.append("<a href=\"");
            if (!linkUrl.matches("[a-z]+:.+")) {
                this.myResult.append("http://");
            }
            this.myResult.append(linkUrl).append("\">").append(linkText).append("</a>");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "markupContent";
            objectArray2[1] = "com/jetbrains/python/documentation/docstrings/EpydocString$HTMLConverter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendMarkup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendLink";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MarkupConverter {
        protected final StringBuilder myResult = new StringBuilder();

        private MarkupConverter() {
        }

        public void appendWithMarkup(String s) {
            int bracePos;
            int pos = 0;
            while ((bracePos = s.indexOf(123, pos)) >= 1) {
                char prevChar = s.charAt(bracePos - 1);
                if (prevChar >= 'A' && prevChar <= 'Z') {
                    this.appendText(s.substring(pos, bracePos - 1));
                    int rbracePos = EpydocString.findMatchingEndBrace(s, bracePos);
                    if (rbracePos < 0) {
                        pos = bracePos + 1;
                        break;
                    }
                    String inlineMarkupContent = s.substring(bracePos + 1, rbracePos);
                    this.appendMarkup(prevChar, inlineMarkupContent);
                    pos = rbracePos + 1;
                    continue;
                }
                this.appendText(s.substring(pos, bracePos + 1));
                pos = bracePos + 1;
            }
            this.appendText(s.substring(pos));
        }

        protected void appendText(String text2) {
            this.myResult.append(text2);
        }

        protected void appendMarkup(char markupChar, @NotNull String markupContent) {
            if (markupContent == null) {
                MarkupConverter.$$$reportNull$$$0(0);
            }
            this.appendWithMarkup(markupContent);
        }

        public String result() {
            return this.myResult.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupContent", "com/jetbrains/python/documentation/docstrings/EpydocString$MarkupConverter", "appendMarkup"));
        }
    }
}

