/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JInternalFrame;
import org.fest.reflect.core.Reflection;
import org.fest.reflect.exception.ReflectionError;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.driver.ComponentMovableQuery;
import org.fest.swing.driver.ComponentMoveTask;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.ComponentSetSizeTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Pair;
import org.fest.swing.util.Triple;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

@InternalApi
public abstract class ContainerDriver<T extends Container>
extends ComponentDriver<T> {
    public ContainerDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    protected final void doResizeWidth(@Nonnull T c, int width) {
        Pair<Dimension, Insets> resizeInfo = this.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.first;
        this.resizeBy(c, resizeInfo, width - size.width, 0);
    }

    @RunsInEDT
    protected final void doResizeHeight(@Nonnull T c, int height) {
        Pair<Dimension, Insets> resizeInfo = this.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.first;
        this.resizeBy(c, resizeInfo, 0, height - size.height);
    }

    @RunsInEDT
    protected final void resize(@Nonnull T c, int width, int height) {
        Pair<Dimension, Insets> resizeInfo = this.resizeInfo(c);
        Dimension size = (Dimension)resizeInfo.first;
        this.resizeBy(c, resizeInfo, width - size.width, height - size.height);
    }

    @Nonnull
    @RunsInEDT
    private Pair<Dimension, Insets> resizeInfo(final @Nonnull T c) {
        Pair<Dimension, Insets> result = GuiActionRunner.execute(new GuiQuery<Pair<Dimension, Insets>>(){

            @Override
            @Nullable
            protected Pair<Dimension, Insets> executeInEDT() {
                ContainerDriver.this.checkCanResize(c);
                return Pair.of(c.getSize(), c.getInsets());
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @VisibleForTesting
    @RunsInCurrentThread
    void checkCanResize(@Nonnull T c) {
        if (!this.isResizable(c)) {
            String msg = String.format("Expecting component %s to be resizable by the user", Formatting.format(c));
            throw new IllegalStateException(msg);
        }
        if (c instanceof JInternalFrame) {
            ComponentPreconditions.checkShowing(c);
            return;
        }
        ComponentPreconditions.checkEnabledAndShowing(c);
    }

    @RunsInCurrentThread
    protected boolean isResizable(@Nonnull T c) {
        try {
            Boolean resizable = (Boolean)Reflection.method((String)"isResizable").withReturnType(Boolean.TYPE).in(c).invoke(new Object[0]);
            return (Boolean)Preconditions.checkNotNull((Object)resizable);
        }
        catch (ReflectionError e) {
            return false;
        }
    }

    @RunsInEDT
    private void resizeBy(@Nonnull T c, @Nonnull Pair<Dimension, Insets> resizeInfo, int x, int y) {
        this.simulateResizeStarted(c, resizeInfo, x, y);
        Dimension size = (Dimension)resizeInfo.first;
        ComponentSetSizeTask.setComponentSize(c, size.width + x, size.height + y);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateResizeStarted(@Nonnull T c, @Nonnull Pair<Dimension, Insets> resizeInfo, int x, int y) {
        Point p = ContainerDriver.resizeLocation(resizeInfo);
        this.moveMouseIgnoringAnyError(c, p);
        this.moveMouseIgnoringAnyError(c, p.x + x, p.y + y);
    }

    @Nonnull
    private static Point resizeLocation(@Nonnull Pair<Dimension, Insets> resizeInfo) {
        return ContainerDriver.resizeLocation((Dimension)Preconditions.checkNotNull(resizeInfo.first), (Insets)Preconditions.checkNotNull(resizeInfo.second));
    }

    @Nonnull
    private static Point resizeLocation(@Nonnull Dimension size, @Nonnull Insets insets) {
        return ContainerDriver.resizeLocation(size.width, size.height, insets.right, insets.bottom);
    }

    @Nonnull
    private static Point resizeLocation(int width, int height, int right, int bottom) {
        return new Point(width - right / 2, height - bottom / 2);
    }

    @RunsInEDT
    public void move(@Nonnull T c, int x, int y) {
        Triple<Dimension, Insets, Point> moveInfo = this.moveInfo(c);
        Point locationOnScreen = (Point)moveInfo.third;
        this.moveBy(c, moveInfo, x - locationOnScreen.x, y - locationOnScreen.y);
    }

    @Nonnull
    @RunsInEDT
    private Triple<Dimension, Insets, Point> moveInfo(final @Nonnull T c) {
        Triple<Dimension, Insets, Point> result = GuiActionRunner.execute(new GuiQuery<Triple<Dimension, Insets, Point>>(){

            @Override
            @Nullable
            protected Triple<Dimension, Insets, Point> executeInEDT() {
                ContainerDriver.this.checkCanMove(c);
                Point locationOnScreen = null;
                try {
                    locationOnScreen = c.getLocationOnScreen();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
                if (locationOnScreen == null) {
                    String msg = String.format("Expecting component %s to be showing on the screen", Formatting.format(c));
                    throw new IllegalStateException(msg);
                }
                return Triple.of(c.getSize(), c.getInsets(), locationOnScreen);
            }
        });
        return (Triple)Preconditions.checkNotNull(result);
    }

    @RunsInCurrentThread
    private void checkCanMove(@Nonnull T c) {
        ComponentPreconditions.checkEnabledAndShowing(c);
        if (!ComponentMovableQuery.isUserMovable(c)) {
            String msg = String.format("Expecting component %s to be movable by the user", Formatting.format(c));
            throw new IllegalStateException(msg);
        }
    }

    @RunsInEDT
    private void moveBy(@Nonnull T c, @Nonnull Triple<Dimension, Insets, Point> moveInfo, int x, int y) {
        this.simulateMoveStarted(c, moveInfo, x, y);
        Point locationOnScreen = (Point)moveInfo.third;
        Point location = new Point(locationOnScreen.x + x, locationOnScreen.y + y);
        ComponentMoveTask.moveComponent(c, location);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateMoveStarted(@Nonnull T c, @Nonnull Triple<Dimension, Insets, Point> moveInfo, int x, int y) {
        Point p = this.moveLocation((Dimension)Preconditions.checkNotNull((Object)moveInfo.first), (Insets)Preconditions.checkNotNull((Object)moveInfo.second));
        this.moveMouseIgnoringAnyError(c, p);
        this.moveMouseIgnoringAnyError(c, p.x + x, p.y + y);
    }

    @Nonnull
    private Point moveLocation(@Nonnull Dimension size, @Nonnull Insets insets) {
        return new Point(size.width / 2, insets.top / 2);
    }
}

