/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.Platform;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.Preconditions;

public class AWT {
    private static final String ROOT_FRAME_CLASSNAME = SwingUtilities.class.getName() + "$";
    private static final ToolkitProvider TOOLKIT_PROVIDER = ToolkitProvider.instance();

    public static boolean isPointInScreenBoundaries(@Nonnull JComponent c, @Nonnull Point p) {
        Point where = AWT.translate(c, p.x, p.y);
        return AWT.isPointInScreenBoundaries(where);
    }

    public static boolean isPointInScreenBoundaries(@Nonnull Point p) {
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration[] graphicsConfigurations;
            for (GraphicsConfiguration gc : graphicsConfigurations = gd.getConfigurations()) {
                if (!gc.getBounds().contains(p)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    @RunsInCurrentThread
    public static Point translate(@Nonnull Component c, int x, int y) {
        Point p = AWT.locationOnScreenOf(c);
        if (p == null) {
            return null;
        }
        p.translate(x, y);
        return p;
    }

    @Nonnull
    @RunsInEDT
    public static Point visibleCenterOf(final @Nonnull Component c) {
        Point center = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                if (c instanceof JComponent) {
                    return AWT.centerOfVisibleRect((JComponent)c);
                }
                return AWT.centerOf(c);
            }
        });
        return (Point)Preconditions.checkNotNull((Object)center);
    }

    @Nonnull
    @RunsInCurrentThread
    public static Point centerOf(@Nonnull Component c) {
        Dimension size = c.getSize();
        return new Point(size.width / 2, size.height / 2);
    }

    @Nonnull
    @RunsInCurrentThread
    public static Point centerOfVisibleRect(@Nonnull JComponent c) {
        Rectangle r = c.getVisibleRect();
        return AWT.centerOf((Rectangle)Preconditions.checkNotNull((Object)r));
    }

    @Nonnull
    @RunsInCurrentThread
    public static Point centerOf(@Nonnull Rectangle r) {
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    @Nonnull
    @RunsInCurrentThread
    public static Insets insetsFrom(@Nonnull Container c) {
        try {
            Insets insets = c.getInsets();
            if (insets != null) {
                return insets;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Insets(0, 0, 0, 0);
    }

    public static boolean isAppletViewer(@Nullable Component c) {
        return c != null && "sun.applet.AppletViewer".equals(c.getClass().getName());
    }

    public static boolean isSharedInvisibleFrame(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        return c instanceof Frame && (c == JOptionPane.getRootFrame() || c.getClass().getName().startsWith(ROOT_FRAME_CLASSNAME));
    }

    @RunsInCurrentThread
    public static boolean isHeavyWeightPopup(@Nonnull Component c) {
        if (!(c instanceof Window) || c instanceof Dialog || c instanceof Frame) {
            return false;
        }
        String name = AWT.obtainNameSafely(c);
        if ("###overrideRedirect###".equals(name) || "###focusableSwingPopup###".equals(name)) {
            return true;
        }
        String typeName = c.getClass().getName();
        return typeName.contains("PopupFactory$WindowPopup") || typeName.contains("HeavyWeightWindow");
    }

    @Nullable
    @RunsInCurrentThread
    private static String obtainNameSafely(@Nonnull Component c) {
        try {
            return c.getName();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Nullable
    @RunsInCurrentThread
    public static Component invokerOf(@Nonnull Component c) {
        if (c instanceof JPopupMenu) {
            return ((JPopupMenu)c).getInvoker();
        }
        Container parent = c.getParent();
        return parent != null ? AWT.invokerOf(parent) : null;
    }

    @Nullable
    @RunsInCurrentThread
    public static Point locationOnScreenOf(@Nonnull Component c) {
        if (!AWT.isAWTTreeLockHeld()) {
            return new Point(c.getLocationOnScreen());
        }
        if (!c.isShowing()) {
            return null;
        }
        Point location = new Point(c.getLocation());
        if (c instanceof Window) {
            return location;
        }
        Container parent = c.getParent();
        if (parent == null) {
            return null;
        }
        Point parentLocation = AWT.locationOnScreenOf(parent);
        if (parentLocation != null) {
            location.translate(parentLocation.x, parentLocation.y);
            return location;
        }
        return null;
    }

    public static boolean popupOnPress() {
        return !Platform.isWindows();
    }

    public static int popupMask() {
        return 4;
    }

    public static boolean isAWTTreeLockHeld() {
        Frame[] frames = Frame.getFrames();
        if (frames.length == 0) {
            return false;
        }
        Object treeLock = Preconditions.checkNotNull((Object)frames[0].getTreeLock());
        ThreadStateChecker checker = new ThreadStateChecker(treeLock);
        try {
            checker.start();
            if (checker.isAlive()) {
                checker.join(100L);
            }
            return checker.isAlive();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private AWT() {
    }

    private static class ThreadStateChecker
    extends Thread {
        private final Object lock;

        public ThreadStateChecker(@Nonnull Object lock) {
            super("Thread state checker");
            this.setDaemon(true);
            this.lock = lock;
        }

        @Override
        public synchronized void start() {
            super.start();
            try {
                this.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this;
            synchronized (object) {
                this.notifyAll();
            }
            object = this.lock;
            synchronized (object) {
                this.setName(super.getName());
            }
        }
    }
}

