/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.io.NettyUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0011H$\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/io/webSocket/WebSocketProtocolHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "()V", "channelRead", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "message", "", "closeFrameReceived", "channel", "Lio/netty/channel/Channel;", "Lio/netty/handler/codec/http/websocketx/CloseWebSocketFrame;", "exceptionCaught", "cause", "", "textFrameReceived", "Lio/netty/handler/codec/http/websocketx/TextWebSocketFrame;", "intellij.platform.builtInServer.impl"})
public abstract class WebSocketProtocolHandler
extends ChannelInboundHandlerAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void channelRead(@NotNull ChannelHandlerContext context, @NotNull Object message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = message;
        if (!(object instanceof WebSocketFrame) || object instanceof PongWebSocketFrame) {
            ReferenceCountUtil.release((Object)message);
        } else if (object instanceof PingWebSocketFrame) {
            context.channel().writeAndFlush((Object)new PongWebSocketFrame(((WebSocketFrame)message).content()));
        } else if (object instanceof CloseWebSocketFrame) {
            Channel channel2 = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel2, (String)"context.channel()");
            this.closeFrameReceived(channel2, (CloseWebSocketFrame)message);
        } else if (object instanceof TextWebSocketFrame) {
            try {
                Channel channel3 = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel3, (String)"context.channel()");
                this.textFrameReceived(channel3, (TextWebSocketFrame)message);
            }
            finally {
                if (((WebSocketFrame)message).refCnt() > 0) {
                    ((WebSocketFrame)message).release();
                }
            }
        } else {
            throw (Throwable)new UnsupportedOperationException(((WebSocketFrame)message).getClass().getName() + " frame types not supported");
        }
    }

    protected abstract void textFrameReceived(@NotNull Channel var1, @NotNull TextWebSocketFrame var2);

    protected void closeFrameReceived(@NotNull Channel channel2, @NotNull CloseWebSocketFrame message) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        channel2.close();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        NettyUtil.logAndClose((Throwable)cause, (Logger)BuiltInWebServerKt.getLOG(), (Channel)context.channel());
    }
}

