/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.filePointer;

import com.google.common.io.Files;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModulePathKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.filePointer.RootsChangeWatcher;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.ModifiableModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/filePointer/RootsChangeWatcher;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "kotlin.jvm.PlatformType", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class RootsChangeWatcher {
    private final ModuleManager moduleManager;
    @NotNull
    private final Project project;

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public RootsChangeWatcher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.moduleManager = ModuleManager.getInstance((Project)this.project);
        this.project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - void declaration
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Iterable $this$forEach$iv = events;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void oldUrl;
                    Pair<String, String> pair;
                    VFileEvent event = (VFileEvent)element$iv;
                    boolean bl = false;
                    if (event instanceof VFilePropertyChangeEvent) {
                        this.propertyChanged((VFilePropertyChangeEvent)event);
                    }
                    if (this.getUrls(event) == null) {
                        continue;
                    }
                    String string = (String)pair.component1();
                    String newUrl = (String)pair.component2();
                    if (!(Intrinsics.areEqual((Object)oldUrl, (Object)newUrl) ^ true)) continue;
                    this.updateModuleName((String)oldUrl, newUrl);
                }
            }

            private final void updateModuleName(String oldUrl, String newUrl) {
                String newModuleName;
                if (!this.isImlFile(oldUrl) || !this.isImlFile(newUrl)) {
                    return;
                }
                String oldModuleName = ModulePathKt.getModuleNameByFilePath(oldUrl);
                if (Intrinsics.areEqual((Object)oldModuleName, (Object)(newModuleName = ModulePathKt.getModuleNameByFilePath(newUrl)))) {
                    return;
                }
                WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.getProject());
                ModuleEntity moduleEntity = (ModuleEntity)workspaceModel.getEntityStorage().getCurrent().resolve(new ModuleId(oldModuleName));
                if (moduleEntity == null) {
                    return;
                }
                ModuleEntity moduleEntity2 = moduleEntity;
                workspaceModel.updateProjectModel((Function1)new Function1<WorkspaceEntityStorageBuilder, ModuleEntity>(moduleEntity2, newModuleName){
                    final /* synthetic */ ModuleEntity $moduleEntity;
                    final /* synthetic */ String $newModuleName;

                    @NotNull
                    public final ModuleEntity invoke(@NotNull WorkspaceEntityStorageBuilder diff) {
                        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
                        return (ModuleEntity)diff.modifyEntity(ModifiableModuleEntity.class, (WorkspaceEntity)this.$moduleEntity, (Function1)new Function1<ModifiableModuleEntity, Unit>(this){
                            final /* synthetic */ updateModuleName.1 this$0;

                            public final void invoke(@NotNull ModifiableModuleEntity $this$modifyEntity) {
                                Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$receiver");
                                $this$modifyEntity.setName(this.this$0.$newModuleName);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                    }
                    {
                        this.$moduleEntity = moduleEntity;
                        this.$newModuleName = string;
                        super(1);
                    }
                });
            }

            private final void propertyChanged(VFilePropertyChangeEvent event) {
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                if (!virtualFile.isDirectory() || event.getRequestor() instanceof StateStorage || Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name") ^ true) {
                    return;
                }
                VirtualFile virtualFile2 = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.file");
                Object object = virtualFile2.getParent();
                if (object == null || (object = object.getPath()) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.file.parent?.path ?: return");
                Object parentPath = object;
                String newAncestorPath = (String)parentPath + '/' + event.getNewValue();
                String oldAncestorPath = (String)parentPath + '/' + event.getOldValue();
                boolean someModulePathIsChanged = false;
                ModuleManager moduleManager = moduleManager;
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"moduleManager");
                Module[] moduleArray = moduleManager.getModules();
                int n = moduleArray.length;
                for (int j = 0; j < n; ++j) {
                    String moduleFilePath;
                    Module module;
                    Module module2 = module = moduleArray[j];
                    Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
                    if (!module2.isLoaded() || module.isDisposed()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)module.getModuleFilePath(), (String)"module.moduleFilePath");
                    if (!FileUtil.isAncestor((String)oldAncestorPath, (String)moduleFilePath, (boolean)true)) continue;
                    IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)module);
                    Path path = Paths.get(newAncestorPath, FileUtil.getRelativePath((String)oldAncestorPath, (String)moduleFilePath, (char)'/'));
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(newAncestorPat\u2026th, moduleFilePath, '/'))");
                    iComponentStore.setPath(path);
                    ClasspathStorage.modulePathChanged(module);
                    someModulePathIsChanged = true;
                }
                if (someModulePathIsChanged) {
                    moduleManager.incModificationCount();
                }
            }

            private final boolean isImlFile(String $this$isImlFile) {
                return Intrinsics.areEqual((Object)Files.getFileExtension((String)$this$isImlFile), (Object)"iml");
            }

            private final Pair<String, String> getUrls(VFileEvent event) {
                String oldUrl = null;
                String newUrl = null;
                VFileEvent vFileEvent = event;
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    String string = VfsUtilCore.pathToUrl((String)((VFilePropertyChangeEvent)event).getOldPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(event.oldPath)");
                    oldUrl = string;
                    String string2 = VfsUtilCore.pathToUrl((String)((VFilePropertyChangeEvent)event).getNewPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VfsUtilCore.pathToUrl(event.newPath)");
                    newUrl = string2;
                } else if (vFileEvent instanceof VFileMoveEvent) {
                    String string = VfsUtilCore.pathToUrl((String)((VFileMoveEvent)event).getOldPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(event.oldPath)");
                    oldUrl = string;
                    String string3 = VfsUtilCore.pathToUrl((String)((VFileMoveEvent)event).getNewPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"VfsUtilCore.pathToUrl(event.newPath)");
                    newUrl = string3;
                } else {
                    return null;
                }
                return TuplesKt.to((Object)oldUrl, (Object)newUrl);
            }
        });
    }
}

