/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.NSAutoreleaseLock;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public final class Utils {
    private static final Logger LOG = Logger.getInstance(Utils.class);
    @NonNls
    private static final String TB_SERVER_PROCESS = "TouchBarServer";

    public static boolean isTouchBarServerRunning() {
        GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"pgrep", TB_SERVER_PROCESS}).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.SYSTEM);
        try {
            ProcessOutput out = ExecUtil.execAndGetOutput((GeneralCommandLine)cmdLine);
            return !out.getStdout().isEmpty();
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public static boolean restartTouchBarServer() {
        try {
            GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"pkill", TB_SERVER_PROCESS}).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.SYSTEM);
            ProcessOutput out = ExecUtil.sudoAndGetOutput((GeneralCommandLine)cmdLine, (String)"");
            return out.getStderr().isEmpty();
        }
        catch (ExecutionException | IOException e) {
            LOG.error(e);
            return false;
        }
    }

    public static String getAppId() {
        String appId;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        try (NSAutoreleaseLock lock = new NSAutoreleaseLock();){
            ID bundle = Foundation.invoke((String)"NSBundle", (String)"mainBundle", (Object[])new Object[0]);
            ID dict = Foundation.invoke((ID)bundle, (String)"infoDictionary", (Object[])new Object[0]);
            ID nsAppID = Foundation.invoke((ID)dict, (String)"objectForKey:", (Object[])new Object[]{Foundation.nsString((String)"CFBundleIdentifier")});
            appId = Foundation.toStringViaUTF8((ID)nsAppID);
        }
        if (appId == null || appId.isEmpty()) {
            LOG.error("can't obtain application id from NSBundle.mainBundle");
        }
        return appId;
    }
}

