/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.SeverityUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.SeverityEditorDialog;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class LevelChooserAction
extends ComboBoxAction
implements DumbAware {
    private final SeverityRegistrar mySeverityRegistrar;
    private final boolean myIncludeDoNotShow;
    private HighlightSeverity myChosen = null;

    public LevelChooserAction(SeverityRegistrar severityRegistrar) {
        this(severityRegistrar, false);
    }

    public LevelChooserAction(SeverityRegistrar severityRegistrar, boolean includeDoNotShow) {
        this.mySeverityRegistrar = severityRegistrar;
        this.myIncludeDoNotShow = includeDoNotShow;
    }

    @NotNull
    public DefaultActionGroup createPopupActionGroup(JComponent anchor2) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (HighlightSeverity severity : LevelChooserAction.getSeverities(this.mySeverityRegistrar, this.myIncludeDoNotShow)) {
            HighlightSeverityAction action2 = new HighlightSeverityAction(severity);
            if (this.myChosen == null) {
                this.setChosen(action2.getSeverity());
            }
            group2.add((AnAction)action2);
        }
        group2.addSeparator();
        group2.add((AnAction)new DumbAwareAction(InspectionsBundle.message((String)"inspection.edit.severities.action", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((project = e.getProject()) != null) {
                    SeverityEditorDialog.show(project, LevelChooserAction.this.myChosen, LevelChooserAction.this.mySeverityRegistrar, true, (Consumer<? super HighlightSeverity>)((Consumer)severity -> {
                        LevelChooserAction.this.setChosen((HighlightSeverity)severity);
                        LevelChooserAction.this.onChosen((HighlightSeverity)severity);
                    }));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/LevelChooserAction$1", "actionPerformed"));
            }
        });
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            LevelChooserAction.$$$reportNull$$$0(0);
        }
        return defaultActionGroup;
    }

    public static List<HighlightSeverity> getSeverities(SeverityRegistrar severityRegistrar) {
        return LevelChooserAction.getSeverities(severityRegistrar, true);
    }

    public static List<HighlightSeverity> getSeverities(SeverityRegistrar severityRegistrar, boolean includeDoNotShow) {
        ArrayList<HighlightSeverity> severities = new ArrayList<HighlightSeverity>();
        for (SeverityRegistrar.SeverityBasedTextAttributes type : SeverityUtil.getRegisteredHighlightingInfoTypes(severityRegistrar)) {
            severities.add(type.getSeverity());
        }
        if (includeDoNotShow) {
            severities.add(HighlightSeverity.INFORMATION);
        }
        return severities;
    }

    protected abstract void onChosen(HighlightSeverity var1);

    public void setChosen(HighlightSeverity severity) {
        this.myChosen = severity;
        Presentation templatePresentation = this.getTemplatePresentation();
        templatePresentation.setText(SingleInspectionProfilePanel.renderSeverity(severity));
        templatePresentation.setIcon(HighlightDisplayLevel.find((HighlightSeverity)severity).getIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/LevelChooserAction", "createPopupActionGroup"));
    }

    private final class HighlightSeverityAction
    extends DumbAwareAction {
        private final HighlightSeverity mySeverity;

        public HighlightSeverity getSeverity() {
            return this.mySeverity;
        }

        private HighlightSeverityAction(HighlightSeverity severity) {
            this.mySeverity = severity;
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setText(SingleInspectionProfilePanel.renderSeverity(severity));
            presentation2.setIcon(HighlightDisplayLevel.find((HighlightSeverity)severity).getIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                HighlightSeverityAction.$$$reportNull$$$0(0);
            }
            HighlightSeverity severity = this.getSeverity();
            LevelChooserAction.this.setChosen(severity);
            LevelChooserAction.this.onChosen(severity);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/LevelChooserAction$HighlightSeverityAction", "actionPerformed"));
        }
    }
}

