/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DiskQueryRelay<Param, Result> {
    @NotNull
    private final Function<? super Param, ? extends Result> myFunction;
    private final Map<Param, Future<Result>> myTasks;

    public DiskQueryRelay(@NotNull Function<? super Param, ? extends Result> function) {
        if (function == null) {
            DiskQueryRelay.$$$reportNull$$$0(0);
        }
        this.myTasks = new ConcurrentHashMap<Param, Future<Result>>();
        this.myFunction = function;
    }

    public Result accessDiskWithCheckCanceled(@NotNull Param arg) {
        if (arg == null) {
            DiskQueryRelay.$$$reportNull$$$0(1);
        }
        if (ProgressIndicatorProvider.getGlobalProgressIndicator() == null) {
            return this.myFunction.apply(arg);
        }
        Future future2 = this.myTasks.computeIfAbsent(arg, eachArg -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                Result Result2 = this.myFunction.apply(eachArg);
                return Result2;
            }
            finally {
                this.myTasks.remove(eachArg);
            }
        }));
        if (future2.isDone()) {
            this.myTasks.remove(arg, future2);
        }
        return (Result)ProgressIndicatorUtils.awaitWithCheckCanceled(future2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/DiskQueryRelay";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accessDiskWithCheckCanceled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

