/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.UnknownInvalidSdk;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdk;
import com.intellij.openapi.projectRoots.impl.UnknownMissingSdkFixLocal;
import com.intellij.openapi.projectRoots.impl.UnknownSdkBalloonNotification;
import com.intellij.openapi.projectRoots.impl.UnknownSdkBlockingCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkEditorNotification;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.projectRoots.impl.UnknownSdkSnapshot;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTrackerQueue;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkResolver;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.TripleFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownSdkTracker {
    private static final Logger LOG = Logger.getInstance(UnknownSdkTracker.class);
    @NotNull
    private final Project myProject;
    private final Predicate<UnknownSdkSnapshot> myIsNewSnapshot;

    @NotNull
    public static UnknownSdkTracker getInstance(@NotNull Project project) {
        if (project == null) {
            UnknownSdkTracker.$$$reportNull$$$0(0);
        }
        UnknownSdkTracker unknownSdkTracker = (UnknownSdkTracker)project.getService(UnknownSdkTracker.class);
        if (unknownSdkTracker == null) {
            UnknownSdkTracker.$$$reportNull$$$0(1);
        }
        return unknownSdkTracker;
    }

    public UnknownSdkTracker(@NotNull Project project) {
        if (project == null) {
            UnknownSdkTracker.$$$reportNull$$$0(2);
        }
        this.myIsNewSnapshot = new Predicate<UnknownSdkSnapshot>(){
            private UnknownSdkSnapshot myPreviousRequestCache = null;

            @Override
            public boolean test(UnknownSdkSnapshot snapshot) {
                if (snapshot.equals(this.myPreviousRequestCache)) {
                    return false;
                }
                this.myPreviousRequestCache = snapshot;
                return true;
            }
        };
        this.myProject = project;
    }

    private static boolean isEnabled() {
        return Registry.is((String)"unknown.sdk") && UnknownSdkResolver.EP_NAME.hasAnyExtensions();
    }

    @NotNull
    public List<UnknownSdkFix> collectUnknownSdks(@NotNull UnknownSdkBlockingCollector collector, @NotNull ProgressIndicator indicator) {
        if (collector == null) {
            UnknownSdkTracker.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(4);
        }
        if (!UnknownSdkTracker.isEnabled()) {
            List<UnknownSdkFix> list2 = List.of();
            if (list2 == null) {
                UnknownSdkTracker.$$$reportNull$$$0(5);
            }
            return list2;
        }
        UnknownSdkSnapshot snapshot = collector.collectSdksBlocking();
        Function<ProgressIndicator, List<UnknownSdkFix>> action2 = this.createProcessSdksAction(snapshot);
        if (action2 == null) {
            List<UnknownSdkFix> list3 = List.of();
            if (list3 == null) {
                UnknownSdkTracker.$$$reportNull$$$0(6);
            }
            return list3;
        }
        List<UnknownSdkFix> list4 = action2.apply(indicator);
        if (list4 == null) {
            UnknownSdkTracker.$$$reportNull$$$0(7);
        }
        return list4;
    }

    @NotNull
    private Runnable newUpdateTask(final @NotNull ShowStatusCallback showStatus, final @NotNull Predicate<UnknownSdkSnapshot> shouldProcessSnapshot) {
        if (showStatus == null) {
            UnknownSdkTracker.$$$reportNull$$$0(8);
        }
        if (shouldProcessSnapshot == null) {
            UnknownSdkTracker.$$$reportNull$$$0(9);
        }
        return new Runnable(){

            @Override
            public void run() {
                if (!UnknownSdkTracker.isEnabled() || !Registry.is((String)"unknown.sdk.auto")) {
                    showStatus.showEmptyStatus();
                    return;
                }
                new UnknownSdkCollector(UnknownSdkTracker.this.myProject).collectSdksPromise(snapshot -> {
                    if (!shouldProcessSnapshot.test(snapshot)) {
                        return;
                    }
                    final Progressive action2 = UnknownSdkTracker.this.createProcessSdksAction((UnknownSdkSnapshot)snapshot, showStatus);
                    if (action2 == null) {
                        return;
                    }
                    ProgressManager.getInstance().run((Task)new Task.Backgroundable(UnknownSdkTracker.this.myProject, ProjectBundle.message((String)"progress.title.resolving.sdks", (Object[])new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            action2.run(indicator);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker$1$1", "run"));
                        }
                    });
                });
            }
        };
    }

    public void updateUnknownSdks() {
        UnknownSdkTrackerQueue.getInstance(this.myProject).queue(this.newUpdateTask(new DefaultShowStatusCallbackAdapter(), this.myIsNewSnapshot));
    }

    private static boolean allowFixesFor(@NotNull SdkTypeId type) {
        if (type == null) {
            UnknownSdkTracker.$$$reportNull$$$0(10);
        }
        return UnknownSdkResolver.EP_NAME.findFirstSafe(it -> it.supportsResolution(type)) != null;
    }

    @NotNull
    private static <E extends UnknownSdk> List<E> filterOnlyAllowedEntries(@NotNull List<? extends E> input) {
        if (input == null) {
            UnknownSdkTracker.$$$reportNull$$$0(11);
        }
        ArrayList<UnknownSdk> copy2 = new ArrayList<UnknownSdk>();
        for (UnknownSdk item : input) {
            SdkType type = item.getSdkType();
            if (!UnknownSdkTracker.allowFixesFor((SdkTypeId)type)) continue;
            copy2.add(item);
        }
        ArrayList<UnknownSdk> arrayList = copy2;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static List<Sdk> filterOnlyAllowedSdkEntries(@NotNull List<Sdk> input) {
        if (input == null) {
            UnknownSdkTracker.$$$reportNull$$$0(13);
        }
        ArrayList<Sdk> copy2 = new ArrayList<Sdk>();
        for (Sdk item : input) {
            SdkTypeId type = item.getSdkType();
            if (!UnknownSdkTracker.allowFixesFor(type)) continue;
            copy2.add(item);
        }
        ArrayList<Sdk> arrayList = copy2;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    private Function<ProgressIndicator, List<UnknownSdkFix>> createProcessSdksAction(@NotNull UnknownSdkSnapshot snapshot) {
        if (snapshot == null) {
            UnknownSdkTracker.$$$reportNull$$$0(15);
        }
        List<UnknownSdk> fixable = UnknownSdkTracker.filterOnlyAllowedEntries(snapshot.getResolvableSdks());
        List<Sdk> usedSdks = UnknownSdkTracker.filterOnlyAllowedSdkEntries(snapshot.getKnownSdks());
        if (fixable.isEmpty() && usedSdks.isEmpty()) {
            return null;
        }
        return indicator -> {
            try {
                List<Object> invalidSdks = new ArrayList();
                Map<Object, Object> localFixes = new HashMap();
                Map<Object, Object> downloadFixes = new HashMap();
                if (!usedSdks.isEmpty()) {
                    indicator.pushState();
                    indicator.setText(ProjectBundle.message((String)"progress.text.resolving.existing.sdks", (Object[])new Object[0]));
                    invalidSdks = UnknownInvalidSdk.resolveInvalidSdks(usedSdks);
                    fixable.addAll(invalidSdks);
                    indicator.popState();
                }
                if (!fixable.isEmpty()) {
                    indicator.pushState();
                    indicator.setText(ProjectBundle.message((String)"progress.text.resolving.missing.sdks", (Object[])new Object[0]));
                    List<UnknownSdkResolver.UnknownSdkLookup> lookups = this.collectSdkLookups((ProgressIndicator)indicator);
                    if (!lookups.isEmpty()) {
                        indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.local.sdks", (Object[])new Object[0]));
                        localFixes = UnknownSdkTracker.findFixesAndRemoveFixable(indicator, fixable, lookups, UnknownSdkResolver.UnknownSdkLookup::proposeLocalFix);
                        if (!fixable.isEmpty()) {
                            indicator.setText(ProjectBundle.message((String)"progress.text.looking.for.downloadable.sdks", (Object[])new Object[0]));
                            downloadFixes = UnknownSdkTracker.findFixesAndRemoveFixable(indicator, fixable, lookups, UnknownSdkResolver.UnknownSdkLookup::proposeDownload);
                        }
                    }
                    indicator.popState();
                }
                ArrayList<UnknownSdkFix> fixProposals = new ArrayList<UnknownSdkFix>();
                fixable.removeAll(invalidSdks);
                for (UnknownInvalidSdk unknownInvalidSdk : invalidSdks) {
                    UnknownSdkLocalSdkFix localSdkFix = (UnknownSdkLocalSdkFix)localFixes.remove(unknownInvalidSdk);
                    UnknownSdkDownloadableSdkFix downloadableSdkFix = (UnknownSdkDownloadableSdkFix)downloadFixes.remove(unknownInvalidSdk);
                    fixProposals.add(unknownInvalidSdk.buildFix(this.myProject, localSdkFix, downloadableSdkFix));
                }
                ImmutableSet allMissingSdks = ImmutableSet.builder().addAll(downloadFixes.keySet()).addAll(localFixes.keySet()).addAll((Iterable)fixable).build();
                for (UnknownSdk unknownSdk2 : allMissingSdks) {
                    String name = unknownSdk2.getSdkName();
                    if (name == null) continue;
                    UnknownSdkDownloadableSdkFix downloadFix = (UnknownSdkDownloadableSdkFix)downloadFixes.get(unknownSdk2);
                    UnknownSdkLocalSdkFix localSdkFix = (UnknownSdkLocalSdkFix)localFixes.get(unknownSdk2);
                    fixProposals.add(UnknownMissingSdk.createMissingSdkFix(this.myProject, unknownSdk2, localSdkFix, downloadFix));
                }
                return List.copyOf(fixProposals);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    ExceptionUtil.rethrow((Throwable)t);
                }
                LOG.warn("Failed to complete SDKs lookup. " + t.getMessage(), t);
                return List.of();
            }
        };
    }

    @Nullable
    private Progressive createProcessSdksAction(@NotNull UnknownSdkSnapshot snapshot, @NotNull ShowStatusCallback showStatus) {
        Function<ProgressIndicator, List<UnknownSdkFix>> task2;
        if (snapshot == null) {
            UnknownSdkTracker.$$$reportNull$$$0(16);
        }
        if (showStatus == null) {
            UnknownSdkTracker.$$$reportNull$$$0(17);
        }
        if ((task2 = this.createProcessSdksAction(snapshot)) == null) {
            return null;
        }
        return indicator -> {
            try {
                List result2 = (List)task2.apply(indicator);
                showStatus.showStatus(result2, indicator);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    showStatus.showInterruptedStatus();
                    ExceptionUtil.rethrow((Throwable)t);
                }
                LOG.warn("Failed to complete SDKs lookup. " + t.getMessage(), t);
                showStatus.showEmptyStatus();
            }
        };
    }

    @NotNull
    public List<UnknownSdkFix> applyAutoFixesAndNotify(@NotNull List<UnknownSdkFix> fixes, @NotNull ProgressIndicator indicator) {
        if (fixes == null) {
            UnknownSdkTracker.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(19);
        }
        ArrayList<UnknownSdkFix> otherFixes = new ArrayList<UnknownSdkFix>();
        ArrayList<UnknownMissingSdkFixLocal> localFixes = new ArrayList<UnknownMissingSdkFixLocal>();
        for (UnknownSdkFix unknownSdkFix : fixes) {
            UnknownSdkFixAction action2 = unknownSdkFix.getSuggestedFixAction();
            if (action2 instanceof UnknownMissingSdkFixLocal) {
                localFixes.add((UnknownMissingSdkFixLocal)action2);
                continue;
            }
            otherFixes.add(unknownSdkFix);
        }
        if (!localFixes.isEmpty()) {
            indicator.pushState();
            indicator.setText(ProjectBundle.message((String)"progress.text.configuring.sdks", (Object[])new Object[0]));
            for (UnknownMissingSdkFixLocal unknownMissingSdkFixLocal : new ArrayList(localFixes)) {
                try {
                    unknownMissingSdkFixLocal.applySuggestionBlocking(indicator);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to apply SDK fix: " + unknownMissingSdkFixLocal + ". " + t.getMessage(), t);
                    localFixes.remove(unknownMissingSdkFixLocal);
                }
            }
            UnknownSdkBalloonNotification.getInstance(this.myProject).notifyFixedSdks(localFixes);
            indicator.popState();
        }
        ArrayList<UnknownSdkFix> arrayList = otherFixes;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    public boolean isAutoFixAction(@Nullable UnknownSdkFixAction fix) {
        return fix instanceof UnknownMissingSdkFixLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Sdk applyAutoFixAndNotify(@NotNull UnknownSdkFixAction fix, @NotNull ProgressIndicator indicator) throws IllegalArgumentException {
        if (fix == null) {
            UnknownSdkTracker.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(22);
        }
        if (!this.isAutoFixAction(fix)) {
            throw new IllegalArgumentException("The argument must pass #isAutoFixAction test");
        }
        assert (fix instanceof UnknownMissingSdkFixLocal) : "Invalid fix: " + fix;
        indicator.pushState();
        indicator.setText(ProjectBundle.message((String)"progress.text.configuring.sdks", (Object[])new Object[0]));
        Sdk sdk2 = fix.applySuggestionBlocking(indicator);
        Sdk sdk3 = sdk2;
        if (sdk3 == null) {
            UnknownSdkTracker.$$$reportNull$$$0(23);
        }
        return sdk3;
        finally {
            indicator.popState();
            UnknownSdkBalloonNotification.getInstance(this.myProject).notifyFixedSdks(List.of((UnknownMissingSdkFixLocal)fix));
        }
    }

    @NotNull
    private List<UnknownSdkResolver.UnknownSdkLookup> collectSdkLookups(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(24);
        }
        ArrayList<UnknownSdkResolver.UnknownSdkLookup> lookups = new ArrayList<UnknownSdkResolver.UnknownSdkLookup>();
        UnknownSdkResolver.EP_NAME.forEachExtensionSafe(ext -> {
            UnknownSdkResolver.UnknownSdkLookup resolver = ext.createResolver(this.myProject, indicator);
            if (resolver != null) {
                lookups.add(resolver);
            }
        });
        ArrayList<UnknownSdkResolver.UnknownSdkLookup> arrayList = lookups;
        if (arrayList == null) {
            UnknownSdkTracker.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    private static <R> Map<UnknownSdk, R> findFixesAndRemoveFixable(@NotNull ProgressIndicator indicator, @NotNull List<UnknownSdk> infos, @NotNull List<UnknownSdkResolver.UnknownSdkLookup> lookups, @NotNull TripleFunction<UnknownSdkResolver.UnknownSdkLookup, UnknownSdk, ProgressIndicator, R> fun) {
        if (indicator == null) {
            UnknownSdkTracker.$$$reportNull$$$0(26);
        }
        if (infos == null) {
            UnknownSdkTracker.$$$reportNull$$$0(27);
        }
        if (lookups == null) {
            UnknownSdkTracker.$$$reportNull$$$0(28);
        }
        if (fun == null) {
            UnknownSdkTracker.$$$reportNull$$$0(29);
        }
        indicator.pushState();
        LinkedHashMap<UnknownSdk, Object> result2 = new LinkedHashMap<UnknownSdk, Object>();
        Iterator<UnknownSdk> iterator2 = infos.iterator();
        block0: while (iterator2.hasNext()) {
            UnknownSdk info = iterator2.next();
            for (UnknownSdkResolver.UnknownSdkLookup lookup2 : lookups) {
                indicator.pushState();
                Object fix = fun.fun((Object)lookup2, (Object)info, (Object)indicator);
                indicator.popState();
                if (fix == null) continue;
                result2.put(info, fix);
                iterator2.remove();
                continue block0;
            }
        }
        indicator.popState();
        LinkedHashMap<UnknownSdk, Object> linkedHashMap = result2;
        if (linkedHashMap == null) {
            UnknownSdkTracker.$$$reportNull$$$0(30);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 20: 
            case 23: 
            case 25: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 20: 
            case 23: 
            case 25: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 20: 
            case 23: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 4: 
            case 19: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showStatus";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldProcessSnapshot";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookups";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnknownSdks";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOnlyAllowedEntries";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOnlyAllowedSdkEntries";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAutoFixesAndNotify";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAutoFixAndNotify";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSdkLookups";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findFixesAndRemoveFixable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 20: 
            case 23: 
            case 25: 
            case 30: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectUnknownSdks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newUpdateTask";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "allowFixesFor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterOnlyAllowedEntries";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterOnlyAllowedSdkEntries";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createProcessSdksAction";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "applyAutoFixesAndNotify";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "applyAutoFixAndNotify";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectSdkLookups";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findFixesAndRemoveFixable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 20: 
            case 23: 
            case 25: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DefaultShowStatusCallbackAdapter
    implements ShowStatusCallback {
        private DefaultShowStatusCallbackAdapter() {
        }

        @Override
        public void showStatus(@NotNull List<UnknownSdkFix> fixes, @NotNull ProgressIndicator indicator) {
            if (fixes == null) {
                DefaultShowStatusCallbackAdapter.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                DefaultShowStatusCallbackAdapter.$$$reportNull$$$0(1);
            }
            fixes = UnknownSdkTracker.this.applyAutoFixesAndNotify(fixes, indicator);
            UnknownSdkEditorNotification.getInstance(UnknownSdkTracker.this.myProject).showNotifications(fixes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/projectRoots/impl/UnknownSdkTracker$DefaultShowStatusCallbackAdapter";
            objectArray[2] = "showStatus";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ShowStatusCallback {
        public void showStatus(@NotNull List<UnknownSdkFix> var1, @NotNull ProgressIndicator var2);

        default public void showInterruptedStatus() {
            this.showStatus(Collections.emptyList(), (ProgressIndicator)new EmptyProgressIndicator());
        }

        default public void showEmptyStatus() {
            this.showStatus(Collections.emptyList(), (ProgressIndicator)new EmptyProgressIndicator());
        }
    }
}

