/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupStub;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionUpdateEdtExecutor;
import com.intellij.openapi.actionSystem.impl.AsyncDataContext;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.PaintEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

final class ActionUpdater {
    private static final Logger LOG = Logger.getInstance(ActionUpdater.class);
    private static final Executor ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Action Updater", (int)2);
    private final boolean myModalContext;
    private final PresentationFactory myFactory;
    private final DataContext myDataContext;
    private final String myPlace;
    private final boolean myContextMenuAction;
    private final boolean myToolbarAction;
    private final boolean myTransparentOnly;
    private final Map<AnAction, Presentation> myUpdatedPresentations = new ConcurrentHashMap<AnAction, Presentation>();
    private final Map<ActionGroup, List<AnAction>> myGroupChildren = new ConcurrentHashMap<ActionGroup, List<AnAction>>();
    private final Map<ActionGroup, Boolean> myCanBePerformedCache = new ConcurrentHashMap<ActionGroup, Boolean>();
    private final UpdateStrategy myRealUpdateStrategy;
    private final UpdateStrategy myCheapStrategy;
    private final Utils.ActionGroupVisitor myVisitor;
    private boolean myAllowPartialExpand = true;

    ActionUpdater(boolean isInModalContext, PresentationFactory presentationFactory, DataContext dataContext, String place, boolean isContextMenuAction, boolean isToolbarAction, boolean transparentOnly) {
        this(isInModalContext, presentationFactory, dataContext, place, isContextMenuAction, isToolbarAction, transparentOnly, null);
    }

    ActionUpdater(boolean isInModalContext, PresentationFactory presentationFactory, DataContext dataContext, String place, boolean isContextMenuAction, boolean isToolbarAction, boolean transparentOnly, Utils.ActionGroupVisitor visitor) {
        this.myModalContext = isInModalContext;
        this.myFactory = presentationFactory;
        this.myDataContext = dataContext;
        this.myVisitor = visitor;
        this.myPlace = place;
        this.myContextMenuAction = isContextMenuAction;
        this.myToolbarAction = isToolbarAction;
        this.myTransparentOnly = transparentOnly;
        this.myRealUpdateStrategy = new UpdateStrategy((NullableFunction<AnAction, Presentation>)((NullableFunction)action2 -> {
            Presentation presentation2 = ActionUpdateEdtExecutor.computeOnEdt(() -> this.myFactory.getPresentation((AnAction)action2).clone());
            presentation2.setEnabledAndVisible(true);
            Supplier<Boolean> doUpdate2 = () -> ActionUpdater.doUpdate(this.myModalContext, action2, this.createActionEvent((AnAction)action2, presentation2), this.myVisitor);
            boolean success = ActionUpdater.callAction(action2, "update", doUpdate2);
            return success ? presentation2 : null;
        }), (NotNullFunction<ActionGroup, AnAction[]>)((NotNullFunction)group2 -> ActionUpdater.callAction((AnAction)group2, "getChildren", () -> group2.getChildren(this.createActionEvent((AnAction)group2, this.orDefault((AnAction)group2, this.myUpdatedPresentations.get(group2)))))), group2 -> ActionUpdater.callAction((AnAction)group2, "canBePerformed", () -> group2.canBePerformed(this.getDataContext((AnAction)group2))));
        this.myCheapStrategy = new UpdateStrategy((NullableFunction<AnAction, Presentation>)((NullableFunction)this.myFactory::getPresentation), (NotNullFunction<ActionGroup, AnAction[]>)((NotNullFunction)group2 -> group2.getChildren(null)), group2 -> true);
    }

    private void applyPresentationChanges() {
        for (Map.Entry<AnAction, Presentation> entry : this.myUpdatedPresentations.entrySet()) {
            Presentation original = this.myFactory.getPresentation(entry.getKey());
            Presentation cloned = entry.getValue();
            original.copyFrom(cloned);
            ActionUpdater.reflectSubsequentChangesInOriginalPresentation(original, cloned);
        }
    }

    private DataContext getDataContext(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionUpdater.$$$reportNull$$$0(0);
        }
        if (this.myVisitor == null) {
            return this.myDataContext;
        }
        if (this.myDataContext instanceof AsyncDataContext) {
            return this.myDataContext;
        }
        Component component2 = this.myVisitor.getCustomComponent(action2);
        return component2 != null ? DataManager.getInstance().getDataContext(component2) : this.myDataContext;
    }

    private static void reflectSubsequentChangesInOriginalPresentation(Presentation original, Presentation cloned) {
        cloned.addPropertyChangeListener(e -> {
            if (SwingUtilities.isEventDispatchThread()) {
                original.copyFrom(cloned);
            }
        });
    }

    private static <T> T callAction(AnAction action2, String operation, Supplier<? extends T> call) {
        if (action2 instanceof UpdateInBackground || ApplicationManager.getApplication().isDispatchThread()) {
            return call.get();
        }
        ProgressIndicator progress2 = Objects.requireNonNull(ProgressManager.getInstance().getProgressIndicator());
        return (T)ActionUpdateEdtExecutor.computeOnEdt(() -> {
            long start2 = System.currentTimeMillis();
            try {
                Object object = ProgressManager.getInstance().runProcess(((Supplier)call)::get, (ProgressIndicator)ProgressWrapper.wrap(progress2));
                return object;
            }
            finally {
                long elapsed = System.currentTimeMillis() - start2;
                if (elapsed > 100L) {
                    LOG.warn("Slow (" + elapsed + "ms) '" + operation + "' on action " + action2 + " of " + action2.getClass() + ". Consider speeding it up and/or implementing UpdateInBackground.");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AnAction> expandActionGroup(ActionGroup group2, boolean hideDisabled) {
        try {
            List<AnAction> list2 = this.expandActionGroup(group2, hideDisabled, this.myRealUpdateStrategy);
            return list2;
        }
        finally {
            this.applyPresentationChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AnAction> expandActionGroupFull(ActionGroup group2, boolean hideDisabled) {
        try {
            this.myAllowPartialExpand = false;
            List<AnAction> list2 = this.expandActionGroup(group2, hideDisabled, this.myRealUpdateStrategy);
            return list2;
        }
        finally {
            this.myAllowPartialExpand = true;
            this.applyPresentationChanges();
        }
    }

    private List<AnAction> expandActionGroup(ActionGroup group2, boolean hideDisabled, UpdateStrategy strategy) {
        if (this.myVisitor != null) {
            this.myVisitor.begin();
        }
        return ActionUpdater.removeUnnecessarySeparators(this.doExpandActionGroup(group2, hideDisabled, strategy));
    }

    @NotNull
    List<AnAction> expandActionGroupWithTimeout(ActionGroup group2, boolean hideDisabled) {
        List<AnAction> list2 = this.expandActionGroupWithTimeout(group2, hideDisabled, Registry.intValue((String)"actionSystem.update.timeout.ms"));
        if (list2 == null) {
            ActionUpdater.$$$reportNull$$$0(1);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    List<AnAction> expandActionGroupWithTimeout(ActionGroup group2, boolean hideDisabled, int timeoutMs) {
        List<AnAction> result2 = (List<AnAction>)ProgressIndicatorUtils.withTimeout(timeoutMs, () -> this.expandActionGroup(group2, hideDisabled));
        List<AnAction> list2 = result2 != null ? result2 : this.expandActionGroup(group2, hideDisabled, this.myCheapStrategy);
        List<AnAction> list3 = list2;
        if (list3 == null) {
            ActionUpdater.$$$reportNull$$$0(2);
        }
        return list3;
        finally {
            this.applyPresentationChanges();
        }
    }

    CancellablePromise<List<AnAction>> expandActionGroupAsync(ActionGroup group2, boolean hideDisabled) {
        AsyncPromise promise = new AsyncPromise();
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        promise.onError(arg_0 -> this.lambda$expandActionGroupAsync$13((ProgressIndicator)indicator, arg_0));
        ActionUpdater.cancelAndRestartOnUserActivity(promise, (ProgressIndicator)indicator);
        ourExecutor.execute(() -> this.lambda$expandActionGroupAsync$16(promise, group2, hideDisabled, (ProgressIndicator)indicator));
        return promise;
    }

    private static void cancelAndRestartOnUserActivity(Promise<?> promise, ProgressIndicator indicator) {
        Disposable disposable2 = Disposer.newDisposable((String)"Action Update");
        IdeEventQueue.getInstance().addPostprocessor(e -> {
            if (e instanceof ComponentEvent && !(e instanceof PaintEvent) && ((long)e.getID() & 0x20L) == 0L) {
                indicator.cancel();
            }
            return false;
        }, disposable2);
        promise.onProcessed(__ -> Disposer.dispose((Disposable)disposable2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AnAction> doExpandActionGroup(ActionGroup group2, boolean hideDisabled, UpdateStrategy strategy) {
        if (group2 instanceof ActionGroupStub) {
            throw new IllegalStateException("Trying to expand non-unstubbed group");
        }
        if (this.myAllowPartialExpand) {
            ProgressManager.checkCanceled();
        }
        if (this.myVisitor != null && !this.myVisitor.enterNode(group2)) {
            return Collections.emptyList();
        }
        try {
            Presentation presentation2 = this.update((AnAction)group2, strategy);
            if (presentation2 == null || !presentation2.isVisible()) {
                List<AnAction> list2 = Collections.emptyList();
                return list2;
            }
            List<AnAction> children2 = this.getGroupChildren(group2, strategy);
            List list3 = ContainerUtil.concat(children2, child2 -> this.expandGroupChild((AnAction)child2, hideDisabled, strategy));
            return list3;
        }
        finally {
            if (this.myVisitor != null) {
                this.myVisitor.leaveNode();
            }
        }
    }

    private List<AnAction> getGroupChildren(ActionGroup group2, UpdateStrategy strategy) {
        return this.myGroupChildren.computeIfAbsent(group2, __ -> {
            Object[] children2 = (AnAction[])strategy.getChildren.fun((Object)group2);
            int nullIndex = ArrayUtil.indexOf((Object[])children2, null);
            if (nullIndex < 0) {
                return Arrays.asList(children2);
            }
            LOG.error("action is null: i=" + nullIndex + " group=" + group2 + " group id=" + ActionManager.getInstance().getId((AnAction)group2));
            return ContainerUtil.filter((Object[])children2, (Condition)Conditions.notNull());
        });
    }

    private List<AnAction> expandGroupChild(AnAction child2, boolean hideDisabled, UpdateStrategy strategy) {
        if ((!this.myTransparentOnly || child2.isTransparentUpdate()) && this.update(child2, strategy) == null) {
            return Collections.emptyList();
        }
        Presentation presentation2 = this.orDefault(child2, this.myUpdatedPresentations.get(child2));
        if (!presentation2.isVisible() || !presentation2.isEnabled() && hideDisabled) {
            return Collections.emptyList();
        }
        if (child2 instanceof ActionGroup) {
            ActionGroup actionGroup = (ActionGroup)child2;
            if (hideDisabled && !this.hasEnabledChildren(actionGroup, strategy)) {
                return Collections.emptyList();
            }
            if (actionGroup.isPopup(this.myPlace)) {
                if (actionGroup.disableIfNoVisibleChildren()) {
                    boolean visibleChildren = this.hasVisibleChildren(actionGroup, strategy);
                    if (actionGroup.hideIfNoVisibleChildren() && !visibleChildren) {
                        return Collections.emptyList();
                    }
                    presentation2.setEnabled(visibleChildren || this.canBePerformed(actionGroup, strategy));
                }
                if (this.myVisitor != null) {
                    this.myVisitor.visitLeaf(child2);
                }
                if (hideDisabled && !(child2 instanceof CompactActionGroup)) {
                    return Collections.singletonList(new EmptyAction.DelegatingCompactActionGroup((ActionGroup)child2));
                }
                return Collections.singletonList(child2);
            }
            return this.doExpandActionGroup((ActionGroup)child2, hideDisabled || actionGroup instanceof CompactActionGroup, strategy);
        }
        if (this.myVisitor != null) {
            this.myVisitor.visitLeaf(child2);
        }
        return Collections.singletonList(child2);
    }

    boolean canBePerformedCached(ActionGroup group2) {
        return !Boolean.FALSE.equals(this.myCanBePerformedCache.get(group2));
    }

    private boolean canBePerformed(ActionGroup group2, UpdateStrategy strategy) {
        return this.myCanBePerformedCache.computeIfAbsent(group2, __ -> strategy.canBePerformed.test(group2));
    }

    private Presentation orDefault(AnAction action2, Presentation presentation2) {
        return presentation2 != null ? presentation2 : ActionUpdateEdtExecutor.computeOnEdt(() -> this.myFactory.getPresentation(action2));
    }

    private static List<AnAction> removeUnnecessarySeparators(List<? extends AnAction> visible) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        for (AnAction anAction : visible) {
            if (anAction instanceof Separator) {
                if (StringUtil.isEmpty((String)((Separator)anAction).getText()) && (result2.isEmpty() || result2.get(result2.size() - 1) instanceof Separator)) continue;
                result2.add(anAction);
                continue;
            }
            result2.add(anAction);
        }
        return result2;
    }

    private AnActionEvent createActionEvent(AnAction action2, Presentation presentation2) {
        AnActionEvent event = new AnActionEvent(null, this.getDataContext(action2), this.myPlace, presentation2, ActionManager.getInstance(), 0, this.myContextMenuAction, this.myToolbarAction);
        event.setInjectedContext(action2.isInInjectedContext());
        return event;
    }

    private boolean hasEnabledChildren(ActionGroup group2, UpdateStrategy strategy) {
        return this.hasChildrenWithState(group2, false, true, strategy, new LinkedHashSet<ActionGroup>());
    }

    boolean hasVisibleChildren(ActionGroup group2) {
        return this.hasVisibleChildren(group2, this.myRealUpdateStrategy);
    }

    private boolean hasVisibleChildren(ActionGroup group2, UpdateStrategy strategy) {
        return this.hasChildrenWithState(group2, true, false, strategy, new LinkedHashSet<ActionGroup>());
    }

    private boolean hasChildrenWithState(ActionGroup group2, boolean checkVisible, boolean checkEnabled, UpdateStrategy strategy, LinkedHashSet<ActionGroup> visited) {
        if (group2 instanceof AlwaysVisibleActionGroup) {
            return true;
        }
        if (visited.size() > 1000) {
            LOG.error("Too deep action group nesting: " + visited);
            return true;
        }
        for (AnAction anAction : this.getGroupChildren(group2, strategy)) {
            Project project;
            ProgressManager.checkCanceled();
            if (anAction instanceof Separator || (project = (Project)CommonDataKeys.PROJECT.getData(this.getDataContext(anAction))) != null && DumbService.getInstance((Project)project).isDumb() && !anAction.isDumbAware()) continue;
            Presentation presentation2 = this.orDefault(anAction, this.update(anAction, strategy));
            if (anAction instanceof ActionGroup) {
                ActionGroup childGroup = (ActionGroup)anAction;
                if (!visited.add(childGroup)) {
                    LOG.error("Action group cycle detected: " + childGroup + " in " + visited);
                    return true;
                }
                if (childGroup.isPopup() && (checkVisible && !presentation2.isVisible() || checkEnabled && !presentation2.isEnabled())) continue;
                if (this.hasChildrenWithState(childGroup, checkVisible, checkEnabled, strategy, visited)) {
                    return true;
                }
                if (!strategy.canBePerformed.test(childGroup)) continue;
                return true;
            }
            if ((!checkVisible || !presentation2.isVisible()) && (!checkEnabled || !presentation2.isEnabled())) continue;
            return true;
        }
        return false;
    }

    private static void handleUpdateException(AnAction action2, Presentation presentation2, Throwable exc) {
        String id2 = ActionManager.getInstance().getId(action2);
        if (id2 != null) {
            LOG.error("update failed for AnAction(" + action2.getClass().getName() + ") with ID=" + id2, exc);
        } else {
            LOG.error("update failed for ActionGroup: " + action2 + "[" + presentation2.getText() + "]", exc);
        }
    }

    @Nullable
    private Presentation update(AnAction action2, UpdateStrategy strategy) {
        Presentation cached = this.myUpdatedPresentations.get(action2);
        if (cached != null) {
            return cached;
        }
        Presentation presentation2 = (Presentation)strategy.update.fun((Object)action2);
        if (presentation2 != null) {
            this.myUpdatedPresentations.put(action2, presentation2);
        }
        return presentation2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean doUpdate(boolean isInModalContext, AnAction action2, AnActionEvent e, Utils.ActionGroupVisitor visitor) {
        boolean result2;
        if (ApplicationManager.getApplication().isDisposed()) {
            return false;
        }
        if (visitor != null && !visitor.beginUpdate(action2, e)) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        try {
            result2 = !ActionUtil.performDumbAwareUpdate((boolean)isInModalContext, (AnAction)action2, (AnActionEvent)e, (boolean)false);
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Throwable exc) {
            ActionUpdater.handleUpdateException(action2, e.getPresentation(), exc);
            boolean bl = false;
            return bl;
        }
        finally {
            if (visitor != null) {
                visitor.endUpdate(action2);
            }
        }
        long endTime = System.currentTimeMillis();
        if (endTime - startTime > 10L && LOG.isDebugEnabled()) {
            LOG.debug("Action " + action2 + ": updated in " + (endTime - startTime) + " ms");
        }
        return result2;
    }

    private /* synthetic */ void lambda$expandActionGroupAsync$16(AsyncPromise promise, ActionGroup group2, boolean hideDisabled, ProgressIndicator indicator) {
        while (promise.getState() == Promise.State.PENDING) {
            try {
                boolean success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                    List<AnAction> result2 = this.expandActionGroup(group2, hideDisabled, this.myRealUpdateStrategy);
                    ActionUpdateEdtExecutor.computeOnEdt(() -> {
                        this.applyPresentationChanges();
                        promise.setResult((Object)result2);
                        return null;
                    });
                }, new SensitiveProgressWrapper(indicator));
                if (success) continue;
                ProgressIndicatorUtils.yieldToPendingWriteActions();
            }
            catch (Throwable e) {
                promise.setError(e);
            }
        }
    }

    private /* synthetic */ void lambda$expandActionGroupAsync$13(ProgressIndicator indicator, Throwable __) {
        indicator.cancel();
        ActionUpdateEdtExecutor.computeOnEdt(() -> {
            this.applyPresentationChanges();
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionUpdater";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "expandActionGroupWithTimeout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataContext";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UpdateStrategy {
        final NullableFunction<AnAction, Presentation> update;
        final NotNullFunction<ActionGroup, AnAction[]> getChildren;
        final Predicate<ActionGroup> canBePerformed;

        UpdateStrategy(NullableFunction<AnAction, Presentation> update2, NotNullFunction<ActionGroup, AnAction[]> getChildren, Predicate<ActionGroup> canBePerformed) {
            this.update = update2;
            this.getChildren = getChildren;
            this.canBePerformed = canBePerformed;
        }
    }
}

