/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.collectors.fus.ui.persistence.ToolbarClicksCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.ActionUpdater;
import com.intellij.openapi.actionSystem.impl.AsyncDataContext;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ToolbarUpdater;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.CancellablePromise;

public class ActionToolbarImpl
extends JPanel
implements ActionToolbar,
QuickActionProvider {
    private static final Logger LOG = Logger.getInstance(ActionToolbarImpl.class);
    private static final Set<ActionToolbarImpl> ourToolbars = new LinkedHashSet<ActionToolbarImpl>();
    private static final String RIGHT_ALIGN_KEY = "RIGHT_ALIGN";
    private static final String SECONDARY_SHORTCUT = "SecondaryActions.shortcut";
    private final List<Rectangle> myComponentBounds;
    private JBDimension myMinimumButtonSize;
    @ActionToolbar.LayoutPolicy
    private int myLayoutPolicy;
    private int myOrientation;
    private final ActionGroup myActionGroup;
    @NotNull
    private final String myPlace;
    List<? extends AnAction> myVisibleActions;
    private final PresentationFactory myPresentationFactory;
    private final boolean myDecorateButtons;
    private final ToolbarUpdater myUpdater;
    private boolean myAdjustTheSameSize;
    private final ActionButtonLook myMinimalButtonLook;
    private final DataManager myDataManager;
    private Rectangle myAutoPopupRec;
    private final DefaultActionGroup mySecondaryActions;
    private SecondaryGroupUpdater mySecondaryGroupUpdater;
    private boolean myForceMinimumSize;
    private boolean myForceShowFirstComponent;
    private boolean mySkipWindowAdjustments;
    private boolean myMinimalMode;
    private boolean myNoGapMode;
    private ActionButton mySecondaryActionsButton;
    private int myFirstOutsideIndex;
    private JBPopup myPopup;
    private JComponent myTargetComponent;
    private boolean myReservePlaceAutoPopupIcon;
    private boolean myShowSeparatorTitles;
    private boolean myAlreadyUpdated;
    private boolean myHideDisabled;
    private CancellablePromise<List<AnAction>> myLastUpdate;

    public static void updateAllToolbarsImmediately() {
        ActionToolbarImpl.updateAllToolbarsImmediately(false);
    }

    public static void updateAllToolbarsImmediately(boolean includeInvisible) {
        for (ActionToolbarImpl toolbar : new ArrayList<ActionToolbarImpl>(ourToolbars)) {
            toolbar.updateActionsImmediately(includeInvisible);
            for (Component c : toolbar.getComponents()) {
                if (c instanceof ActionButton) {
                    ((ActionButton)c).updateToolTipText();
                    ((ActionButton)c).updateIcon();
                }
                toolbar.updateUI();
            }
        }
    }

    public ActionButton getSecondaryActionsButton() {
        return this.mySecondaryActionsButton;
    }

    public ActionToolbarImpl(@NotNull String place, @NotNull ActionGroup actionGroup, boolean horizontal) {
        if (place == null) {
            ActionToolbarImpl.$$$reportNull$$$0(0);
        }
        if (actionGroup == null) {
            ActionToolbarImpl.$$$reportNull$$$0(1);
        }
        this(place, actionGroup, horizontal, false, false);
    }

    public ActionToolbarImpl(@NotNull String place, @NotNull ActionGroup actionGroup, boolean horizontal, boolean decorateButtons) {
        if (place == null) {
            ActionToolbarImpl.$$$reportNull$$$0(2);
        }
        if (actionGroup == null) {
            ActionToolbarImpl.$$$reportNull$$$0(3);
        }
        this(place, actionGroup, horizontal, decorateButtons, false);
    }

    public ActionToolbarImpl(@NotNull String place, @NotNull ActionGroup actionGroup, boolean horizontal, boolean decorateButtons, boolean updateActionsNow) {
        if (place == null) {
            ActionToolbarImpl.$$$reportNull$$$0(4);
        }
        if (actionGroup == null) {
            ActionToolbarImpl.$$$reportNull$$$0(5);
        }
        super(null);
        this.myComponentBounds = new ArrayList<Rectangle>();
        this.myMinimumButtonSize = JBUI.emptySize();
        this.myPresentationFactory = new PresentationFactory();
        this.myMinimalButtonLook = ActionButtonLook.INPLACE_LOOK;
        this.mySecondaryActions = new DefaultActionGroup(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.update(e);
                if (ActionToolbarImpl.this.mySecondaryGroupUpdater != null) {
                    e.getPresentation().setIcon(this.getTemplatePresentation().getIcon());
                    ActionToolbarImpl.this.mySecondaryGroupUpdater.update(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl$1", "update"));
            }
        };
        this.myFirstOutsideIndex = -1;
        this.myReservePlaceAutoPopupIcon = true;
        this.myHideDisabled = false;
        this.myPlace = place;
        this.myActionGroup = actionGroup;
        this.myVisibleActions = new ArrayList<AnAction>();
        this.myDataManager = DataManager.getInstance();
        this.myDecorateButtons = decorateButtons;
        this.myUpdater = new ToolbarUpdater(this){

            @Override
            protected void updateActionsImpl(boolean transparentOnly, boolean forced) {
                if (!ApplicationManager.getApplication().isDisposed()) {
                    ActionToolbarImpl.this.updateActionsImpl(transparentOnly, forced);
                }
            }
        };
        this.setOrientation(horizontal ? 0 : 1);
        this.mySecondaryActions.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        this.mySecondaryActions.setPopup(true);
        this.myUpdater.updateActions(updateActionsNow, false, false);
        this.enableEvents(51L);
        this.setMiniMode(false);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        for (Component component2 : this.getComponents()) {
            this.tweakActionComponentUI(component2);
        }
    }

    @NotNull
    public String getPlace() {
        String string = this.myPlace;
        if (string == null) {
            ActionToolbarImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ourToolbars.add(this);
        this.updateActionsImmediately();
    }

    private boolean isInsideNavBar() {
        return "NavBarToolbar".equals(this.myPlace);
    }

    @Override
    public void removeNotify() {
        CancellablePromise<List<AnAction>> lastUpdate;
        super.removeNotify();
        ourToolbars.remove(this);
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
        if ((lastUpdate = this.myLastUpdate) != null) {
            lastUpdate.cancel();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    lastUpdate.blockingGet(1, TimeUnit.DAYS);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @NotNull
    public JComponent getComponent() {
        ActionToolbarImpl actionToolbarImpl = this;
        if (actionToolbarImpl == null) {
            ActionToolbarImpl.$$$reportNull$$$0(7);
        }
        return actionToolbarImpl;
    }

    public int getLayoutPolicy() {
        return this.myLayoutPolicy;
    }

    public void setLayoutPolicy(@ActionToolbar.LayoutPolicy int layoutPolicy) {
        if (layoutPolicy != 0 && layoutPolicy != 1 && layoutPolicy != 2) {
            throw new IllegalArgumentException("wrong layoutPolicy: " + layoutPolicy);
        }
        this.myLayoutPolicy = layoutPolicy;
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @NotNull
    public ActionGroup getActionGroup() {
        ActionGroup actionGroup = this.myActionGroup;
        if (actionGroup == null) {
            ActionToolbarImpl.$$$reportNull$$$0(8);
        }
        return actionGroup;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myLayoutPolicy == 2 && this.myAutoPopupRec != null) {
            if (this.myOrientation == 0) {
                int dy = this.myAutoPopupRec.height / 2 - AllIcons.Ide.Link.getIconHeight() / 2;
                AllIcons.Ide.Link.paintIcon(this, g, (int)this.myAutoPopupRec.getMaxX() - AllIcons.Ide.Link.getIconWidth() - 1, this.myAutoPopupRec.y + dy);
            } else {
                int dx = this.myAutoPopupRec.width / 2 - AllIcons.Ide.Link.getIconWidth() / 2;
                AllIcons.Ide.Link.paintIcon(this, g, this.myAutoPopupRec.x + dx, (int)this.myAutoPopupRec.getMaxY() - AllIcons.Ide.Link.getIconWidth() - 1);
            }
        }
    }

    public void setSecondaryButtonPopupStateModifier(@NotNull SecondaryGroupUpdater secondaryGroupUpdater) {
        if (secondaryGroupUpdater == null) {
            ActionToolbarImpl.$$$reportNull$$$0(9);
        }
        this.mySecondaryGroupUpdater = secondaryGroupUpdater;
    }

    protected void fillToolBar(@NotNull List<? extends AnAction> actions, boolean layoutSecondaries) {
        if (actions == null) {
            ActionToolbarImpl.$$$reportNull$$$0(10);
        }
        boolean isLastElementSeparator = false;
        ArrayList<AnAction> rightAligned = new ArrayList<AnAction>();
        for (int i2 = 0; i2 < actions.size(); ++i2) {
            AnAction action2 = actions.get(i2);
            if (action2 instanceof RightAlignedToolbarAction) {
                rightAligned.add(action2);
                continue;
            }
            if (layoutSecondaries && !this.myActionGroup.isPrimary(action2)) {
                this.mySecondaryActions.add(action2);
                continue;
            }
            if (action2 instanceof Separator) {
                if (isLastElementSeparator) continue;
                if (i2 > 0 && i2 < actions.size() - 1) {
                    this.add("Constraint.Separator", new MySeparator(this.myShowSeparatorTitles ? ((Separator)action2).getText() : null));
                    isLastElementSeparator = true;
                    continue;
                }
            } else if (action2 instanceof CustomComponentAction) {
                this.add("Constraint.CustomComponent", this.getCustomComponent(action2));
            } else {
                this.add("Constraint.ActionButton", this.createToolbarButton(action2));
            }
            isLastElementSeparator = false;
        }
        if (this.mySecondaryActions.getChildrenCount() > 0) {
            this.mySecondaryActionsButton = new ActionButton((AnAction)this.mySecondaryActions, this.myPresentationFactory.getPresentation((AnAction)this.mySecondaryActions), this.myPlace, this.getMinimumButtonSize()){

                @Override
                protected String getShortcutText() {
                    Object shortcut = this.myPresentation.getClientProperty(ActionToolbarImpl.SECONDARY_SHORTCUT);
                    return shortcut != null ? shortcut.toString() : super.getShortcutText();
                }
            };
            this.mySecondaryActionsButton.setNoIconsInPopup(true);
            this.add("Constraint.SecondaryAction", this.mySecondaryActionsButton);
        }
        for (AnAction action2 : rightAligned) {
            JComponent button2;
            JComponent jComponent = button2 = action2 instanceof CustomComponentAction ? this.getCustomComponent(action2) : this.createToolbarButton(action2);
            if (!this.isInsideNavBar()) {
                button2.putClientProperty(RIGHT_ALIGN_KEY, Boolean.TRUE);
            }
            this.add(button2);
        }
    }

    @NotNull
    protected final JComponent getCustomComponent(final @NotNull AnAction action2) {
        class ToolbarClicksCollectorListener
        extends MouseAdapter {
            ToolbarClicksCollectorListener() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ToolbarClicksCollector.record(action2, ActionToolbarImpl.this.myPlace, e, ActionToolbarImpl.this.getDataContext());
            }
        }
        Presentation presentation2;
        JComponent customComponent;
        if (action2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(11);
        }
        if ((customComponent = (JComponent)(presentation2 = this.myPresentationFactory.getPresentation(action2)).getClientProperty(CustomComponentAction.COMPONENT_KEY)) == null) {
            customComponent = this.createCustomComponent((CustomComponentAction)action2, presentation2);
            presentation2.putClientProperty(CustomComponentAction.COMPONENT_KEY, (Object)customComponent);
            ComponentUtil.putClientProperty((JComponent)customComponent, (Key)CustomComponentAction.ACTION_KEY, (Object)action2);
        }
        this.tweakActionComponentUI(customComponent);
        AbstractButton clickable = (AbstractButton)UIUtil.findComponentOfType((JComponent)customComponent, AbstractButton.class);
        if (clickable != null && Arrays.stream(clickable.getMouseListeners()).noneMatch(ml -> ml instanceof ToolbarClicksCollectorListener)) {
            clickable.addMouseListener(new ToolbarClicksCollectorListener());
        }
        JComponent jComponent = customComponent;
        if (jComponent == null) {
            ActionToolbarImpl.$$$reportNull$$$0(12);
        }
        return jComponent;
    }

    protected JComponent createCustomComponent(@NotNull CustomComponentAction action2, @NotNull Presentation presentation2) {
        if (action2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(13);
        }
        if (presentation2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(14);
        }
        JComponent result2 = action2.createCustomComponent(presentation2, this.myPlace);
        GotItTooltip.followToolbarComponent(presentation2, result2, this.getComponent());
        return result2;
    }

    private void tweakActionComponentUI(@NotNull Component actionComponent) {
        if (actionComponent == null) {
            ActionToolbarImpl.$$$reportNull$$$0(15);
        }
        if ("EditorToolbar".equals(this.myPlace)) {
            actionComponent.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            actionComponent.setForeground(ColorUtil.dimmer((Color)JBColor.BLACK));
        }
    }

    @NotNull
    private Dimension getMinimumButtonSize() {
        Dimension dimension = this.isInsideNavBar() ? NAVBAR_MINIMUM_BUTTON_SIZE : DEFAULT_MINIMUM_BUTTON_SIZE;
        if (dimension == null) {
            ActionToolbarImpl.$$$reportNull$$$0(16);
        }
        return dimension;
    }

    @NotNull
    protected ActionButton createToolbarButton(@NotNull AnAction action2, ActionButtonLook look, @NotNull String place, @NotNull Presentation presentation2, @NotNull Dimension minimumSize) {
        if (action2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(17);
        }
        if (place == null) {
            ActionToolbarImpl.$$$reportNull$$$0(18);
        }
        if (presentation2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(19);
        }
        if (minimumSize == null) {
            ActionToolbarImpl.$$$reportNull$$$0(20);
        }
        if (action2.displayTextInToolbar()) {
            int mnemonic = KeyEvent.getExtendedKeyCodeForChar(action2.getTemplatePresentation().getMnemonic());
            ActionButtonWithText buttonWithText = new ActionButtonWithText(action2, presentation2, place, minimumSize);
            if (mnemonic != 0) {
                buttonWithText.registerKeyboardAction(__ -> buttonWithText.click(), KeyStroke.getKeyStroke(mnemonic, 512), 2);
            }
            this.tweakActionComponentUI(buttonWithText);
            ActionButtonWithText actionButtonWithText = buttonWithText;
            if (actionButtonWithText == null) {
                ActionToolbarImpl.$$$reportNull$$$0(21);
            }
            return actionButtonWithText;
        }
        ActionButton actionButton = new ActionButton(action2, presentation2, place, minimumSize){

            @Override
            protected DataContext getDataContext() {
                return ActionToolbarImpl.this.getToolbarDataContext();
            }

            @Override
            @NotNull
            protected Icon getFallbackIcon(boolean enabled) {
                Icon icon2 = enabled ? AllIcons.Toolbar.Unknown : IconLoader.getDisabledIcon((Icon)AllIcons.Toolbar.Unknown);
                if (icon2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                return icon2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl$4", "getFallbackIcon"));
            }
        };
        actionButton.setLook(look);
        actionButton.setBorder((Border)(this.myOrientation == 1 ? JBUI.Borders.empty((int)2, (int)1) : JBUI.Borders.empty((int)1, (int)2)));
        GotItTooltip.followToolbarComponent(presentation2, actionButton, this.getComponent());
        ActionButton actionButton2 = actionButton;
        if (actionButton2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(22);
        }
        return actionButton2;
    }

    @NotNull
    protected final ActionButton createToolbarButton(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(23);
        }
        ActionButton actionButton = this.createToolbarButton(action2, this.myMinimalMode ? this.myMinimalButtonLook : (this.myDecorateButtons ? new ActionButtonLook(){

            @Override
            public void paintBorder(Graphics g, JComponent c, int state) {
                g.setColor(JBColor.border());
                g.drawLine(c.getWidth() - 1, 0, c.getWidth() - 1, c.getHeight());
            }

            @Override
            public void paintBackground(Graphics g, JComponent component2, int state) {
                if (state == -1) {
                    g.setColor(component2.getBackground().darker());
                    ((Graphics2D)g).fill(g.getClip());
                }
            }
        } : null), this.myPlace, this.myPresentationFactory.getPresentation(action2), (Dimension)this.myMinimumButtonSize.size());
        if (actionButton == null) {
            ActionToolbarImpl.$$$reportNull$$$0(24);
        }
        return actionButton;
    }

    @Override
    public void doLayout() {
        int componentCount;
        if (!this.isValid()) {
            this.calculateBounds(this.getSize(), this.myComponentBounds);
        }
        LOG.assertTrue((componentCount = this.getComponentCount()) <= this.myComponentBounds.size());
        for (int i2 = componentCount - 1; i2 >= 0; --i2) {
            Component component2 = this.getComponent(i2);
            component2.setBounds(this.myComponentBounds.get(i2));
        }
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            this.calculateBounds(this.getSize(), this.myComponentBounds);
            super.validate();
        }
    }

    protected Dimension getChildPreferredSize(int index) {
        Component component2 = this.getComponent(index);
        return component2.isVisible() ? component2.getPreferredSize() : new Dimension();
    }

    private int getMaxButtonWidth() {
        int width = 0;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Dimension dimension = this.getChildPreferredSize(i2);
            width = Math.max(width, dimension.width);
        }
        return width;
    }

    public int getMaxButtonHeight() {
        int height = 0;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Dimension dimension = this.getChildPreferredSize(i2);
            height = Math.max(height, dimension.height);
        }
        return height;
    }

    private void calculateBoundsNowrapImpl(@NotNull List<? extends Rectangle> bounds2) {
        int componentCount;
        if (bounds2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(25);
        }
        LOG.assertTrue((componentCount = this.getComponentCount()) <= bounds2.size());
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        if (this.myAdjustTheSameSize) {
            int maxWidth = this.getMaxButtonWidth();
            int maxHeight = this.getMaxButtonHeight();
            int offset = 0;
            if (this.myOrientation == 0) {
                for (int i2 = 0; i2 < componentCount; ++i2) {
                    Rectangle r = bounds2.get(i2);
                    r.setBounds(insets.left + offset, insets.top + (height - maxHeight) / 2, maxWidth, maxHeight);
                    offset += maxWidth;
                }
            } else {
                for (int i3 = 0; i3 < componentCount; ++i3) {
                    Rectangle r = bounds2.get(i3);
                    r.setBounds(insets.left + (width - maxWidth) / 2, insets.top + offset, maxWidth, maxHeight);
                    offset += maxHeight;
                }
            }
        } else if (this.myOrientation == 0) {
            int maxHeight = this.getMaxButtonHeight();
            int offset = 0;
            for (int i4 = 0; i4 < componentCount; ++i4) {
                Dimension d = this.getChildPreferredSize(i4);
                Rectangle r = bounds2.get(i4);
                r.setBounds(insets.left + offset, insets.top + (maxHeight - d.height) / 2, d.width, d.height);
                offset += d.width;
            }
        } else {
            int maxWidth = this.getMaxButtonWidth();
            int offset = 0;
            for (int i5 = 0; i5 < componentCount; ++i5) {
                Dimension d = this.getChildPreferredSize(i5);
                Rectangle r = bounds2.get(i5);
                r.setBounds(insets.left + (maxWidth - d.width) / 2, insets.top + offset, d.width, d.height);
                offset += d.height;
            }
        }
    }

    private void calculateBoundsAutoImp(@NotNull Dimension sizeToFit, @NotNull List<? extends Rectangle> bounds2) {
        boolean actualLayout;
        int componentCount;
        if (sizeToFit == null) {
            ActionToolbarImpl.$$$reportNull$$$0(26);
        }
        if (bounds2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(27);
        }
        LOG.assertTrue((componentCount = this.getComponentCount()) <= bounds2.size());
        boolean bl = actualLayout = bounds2 == this.myComponentBounds;
        if (actualLayout) {
            this.myAutoPopupRec = null;
        }
        int autoButtonSize = AllIcons.Ide.Link.getIconWidth();
        boolean full = false;
        Insets insets = this.getInsets();
        int widthToFit = sizeToFit.width - insets.left - insets.right;
        int heightToFit = sizeToFit.height - insets.top - insets.bottom;
        if (this.myOrientation == 0) {
            int eachX = 0;
            int maxHeight = heightToFit;
            for (int i2 = 0; i2 < componentCount; ++i2) {
                Component component2 = this.getComponent(i2);
                boolean isLast = i2 == componentCount - 1;
                Rectangle eachBound = new Rectangle(this.getChildPreferredSize(i2));
                maxHeight = Math.max(eachBound.height, maxHeight);
                if (!full) {
                    boolean inside;
                    boolean bl2 = isLast ? eachX + eachBound.width <= widthToFit : (inside = eachX + eachBound.width + autoButtonSize <= widthToFit);
                    if (inside) {
                        if (component2 == this.mySecondaryActionsButton) {
                            assert (isLast);
                            if (sizeToFit.width != Integer.MAX_VALUE && !this.myNoGapMode) {
                                eachBound.x = sizeToFit.width - insets.right - eachBound.width;
                                eachX = (int)eachBound.getMaxX() - insets.left;
                            } else {
                                eachBound.x = insets.left + eachX;
                            }
                        } else {
                            eachBound.x = insets.left + eachX;
                            eachX += eachBound.width;
                        }
                        eachBound.y = insets.top;
                    } else {
                        full = true;
                    }
                }
                if (full) {
                    if (this.myAutoPopupRec == null) {
                        this.myAutoPopupRec = new Rectangle(insets.left + eachX, insets.top, widthToFit - eachX, heightToFit);
                        this.myFirstOutsideIndex = i2;
                    }
                    eachBound.x = Integer.MAX_VALUE;
                    eachBound.y = Integer.MAX_VALUE;
                }
                bounds2.get(i2).setBounds(eachBound);
            }
            for (Rectangle rectangle : bounds2) {
                if (rectangle.height >= maxHeight) continue;
                rectangle.y += (maxHeight - rectangle.height) / 2;
            }
        } else {
            int eachY = 0;
            for (int i3 = 0; i3 < componentCount; ++i3) {
                Rectangle eachBound = new Rectangle(this.getChildPreferredSize(i3));
                if (!full) {
                    boolean bl3;
                    if (i3 < componentCount - 1) {
                        bl3 = eachY + eachBound.height + autoButtonSize < heightToFit;
                    } else {
                        boolean bl4 = bl3 = eachY + eachBound.height < heightToFit;
                    }
                    if (bl3) {
                        eachBound.x = insets.left;
                        eachBound.y = insets.top + eachY;
                        eachY += eachBound.height;
                    } else {
                        full = true;
                    }
                }
                if (full) {
                    if (this.myAutoPopupRec == null) {
                        this.myAutoPopupRec = new Rectangle(insets.left, insets.top + eachY, widthToFit, heightToFit - eachY);
                        this.myFirstOutsideIndex = i3;
                    }
                    eachBound.x = Integer.MAX_VALUE;
                    eachBound.y = Integer.MAX_VALUE;
                }
                bounds2.get(i3).setBounds(eachBound);
            }
        }
    }

    private void calculateBoundsWrapImpl(@NotNull Dimension sizeToFit, @NotNull List<? extends Rectangle> bounds2) {
        if (sizeToFit == null) {
            ActionToolbarImpl.$$$reportNull$$$0(28);
        }
        if (bounds2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(29);
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            try {
                this.setLayoutPolicy(0);
                this.calculateBoundsNowrapImpl(bounds2);
            }
            finally {
                this.setLayoutPolicy(1);
            }
            return;
        }
        int componentCount = this.getComponentCount();
        LOG.assertTrue(componentCount <= bounds2.size());
        Insets insets = this.getInsets();
        int widthToFit = sizeToFit.width - insets.left - insets.right;
        int heightToFit = sizeToFit.height - insets.top - insets.bottom;
        if (this.myAdjustTheSameSize) {
            int maxWidth = this.getMaxButtonWidth();
            int maxHeight = this.getMaxButtonHeight();
            int xOffset = 0;
            int yOffset = 0;
            if (this.myOrientation == 0) {
                int maxRowWidth = this.getMaxRowWidth(widthToFit, maxWidth);
                for (int i2 = 0; i2 < componentCount; ++i2) {
                    if (xOffset + maxWidth > maxRowWidth) {
                        xOffset = 0;
                        yOffset += maxHeight;
                    }
                    Rectangle each = bounds2.get(i2);
                    each.setBounds(insets.left + xOffset, insets.top + yOffset, maxWidth, maxHeight);
                    xOffset += maxWidth;
                }
            } else {
                int maxRowHeight = Math.max(heightToFit, componentCount * this.myMinimumButtonSize.height() / 3);
                for (int i3 = 0; i3 < componentCount; ++i3) {
                    if (yOffset + maxHeight > maxRowHeight) {
                        yOffset = 0;
                        xOffset += maxWidth;
                    }
                    Rectangle each = bounds2.get(i3);
                    each.setBounds(insets.left + xOffset, insets.top + yOffset, maxWidth, maxHeight);
                    yOffset += maxHeight;
                }
            }
        } else if (this.myOrientation == 0) {
            int rowHeight = 0;
            Dimension[] dims = new Dimension[componentCount];
            for (int i4 = 0; i4 < componentCount; ++i4) {
                dims[i4] = this.getChildPreferredSize(i4);
                int height = dims[i4].height;
                rowHeight = Math.max(rowHeight, height);
            }
            int xOffset = 0;
            int yOffset = 0;
            int maxRowWidth = this.getMaxRowWidth(widthToFit, this.myMinimumButtonSize.width());
            for (int i5 = 0; i5 < componentCount; ++i5) {
                Dimension d = dims[i5];
                if (xOffset + d.width > maxRowWidth) {
                    xOffset = 0;
                    yOffset += rowHeight;
                }
                Rectangle each = bounds2.get(i5);
                each.setBounds(insets.left + xOffset, insets.top + yOffset + (rowHeight - d.height) / 2, d.width, d.height);
                xOffset += d.width;
            }
        } else {
            int rowWidth = 0;
            Dimension[] dims = new Dimension[componentCount];
            for (int i6 = 0; i6 < componentCount; ++i6) {
                dims[i6] = this.getChildPreferredSize(i6);
                int width = dims[i6].width;
                rowWidth = Math.max(rowWidth, width);
            }
            int xOffset = 0;
            int yOffset = 0;
            int maxRowHeight = Math.max(heightToFit, componentCount * this.myMinimumButtonSize.height() / 3);
            for (int i7 = 0; i7 < componentCount; ++i7) {
                Dimension d = dims[i7];
                if (yOffset + d.height > maxRowHeight) {
                    yOffset = 0;
                    xOffset += rowWidth;
                }
                Rectangle each = bounds2.get(i7);
                each.setBounds(insets.left + xOffset + (rowWidth - d.width) / 2, insets.top + yOffset, d.width, d.height);
                yOffset += d.height;
            }
        }
    }

    private int getMaxRowWidth(int widthToFit, int maxWidth) {
        int componentCount = this.getComponentCount();
        int maxRowWidth = Math.max(widthToFit, componentCount * maxWidth / 3);
        for (int i2 = 0; i2 < componentCount; ++i2) {
            Component component2 = this.getComponent(i2);
            if (!(component2 instanceof JComponent) || ((JComponent)component2).getClientProperty(RIGHT_ALIGN_KEY) != Boolean.TRUE) continue;
            maxRowWidth -= this.getChildPreferredSize((int)i2).width;
        }
        return maxRowWidth;
    }

    protected void calculateBounds(@NotNull Dimension size2Fit, @NotNull List<Rectangle> bounds2) {
        if (size2Fit == null) {
            ActionToolbarImpl.$$$reportNull$$$0(30);
        }
        if (bounds2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(31);
        }
        bounds2.clear();
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            bounds2.add(new Rectangle());
        }
        if (this.myLayoutPolicy == 0) {
            this.calculateBoundsNowrapImpl(bounds2);
        } else if (this.myLayoutPolicy == 1) {
            this.calculateBoundsWrapImpl(size2Fit, bounds2);
        } else if (this.myLayoutPolicy == 2) {
            this.calculateBoundsAutoImp(size2Fit, bounds2);
        } else {
            throw new IllegalStateException("unknown layoutPolicy: " + this.myLayoutPolicy);
        }
        if (this.getComponentCount() > 0 && size2Fit.width < Integer.MAX_VALUE) {
            int maxHeight = 0;
            for (int i3 = 0; i3 < bounds2.size() - 2; ++i3) {
                maxHeight = Math.max(maxHeight, bounds2.get((int)i3).height);
            }
            int rightOffset = 0;
            Insets insets = this.getInsets();
            int i4 = this.getComponentCount() - 1;
            int j = 1;
            while (i4 > 0) {
                Component component2 = this.getComponent(i4);
                if (component2 instanceof JComponent && ((JComponent)component2).getClientProperty(RIGHT_ALIGN_KEY) == Boolean.TRUE) {
                    Rectangle r = bounds2.get(bounds2.size() - j);
                    r.x = size2Fit.width - (rightOffset += bounds2.get((int)i4).width);
                    r.y = insets.top + (this.getHeight() - insets.top - insets.bottom - bounds2.get((int)i4).height) / 2;
                }
                --i4;
                ++j;
            }
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = this.updatePreferredSize(super.getPreferredSize());
        if (dimension == null) {
            ActionToolbarImpl.$$$reportNull$$$0(32);
        }
        return dimension;
    }

    protected Dimension updatePreferredSize(Dimension preferredSize) {
        ArrayList<Rectangle> bounds2 = new ArrayList<Rectangle>();
        this.calculateBounds(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE), bounds2);
        if (bounds2.isEmpty()) {
            return JBUI.emptySize();
        }
        int forcedHeight = 0;
        if (this.getWidth() > 0 && this.getLayoutPolicy() == 1 && this.myOrientation == 0) {
            ArrayList<Rectangle> limitedBounds = new ArrayList<Rectangle>();
            this.calculateBounds(new Dimension(this.getWidth(), Integer.MAX_VALUE), limitedBounds);
            Rectangle union = null;
            for (Rectangle bound : limitedBounds) {
                union = union == null ? bound : union.union(bound);
            }
            forcedHeight = union != null ? union.height : 0;
        }
        int xLeft = Integer.MAX_VALUE;
        int yTop = Integer.MAX_VALUE;
        int xRight = Integer.MIN_VALUE;
        int yBottom = Integer.MIN_VALUE;
        for (int i2 = bounds2.size() - 1; i2 >= 0; --i2) {
            Rectangle each = bounds2.get(i2);
            if (each.x == Integer.MAX_VALUE) continue;
            xLeft = Math.min(xLeft, each.x);
            yTop = Math.min(yTop, each.y);
            xRight = Math.max(xRight, each.x + each.width);
            yBottom = Math.max(yBottom, each.y + each.height);
        }
        Dimension dimension = new Dimension(xRight - xLeft, Math.max(yBottom - yTop, forcedHeight));
        if (this.myLayoutPolicy == 2 && this.myReservePlaceAutoPopupIcon && !this.isInsideNavBar()) {
            if (this.myOrientation == 0) {
                dimension.width += AllIcons.Ide.Link.getIconWidth();
            } else {
                dimension.height += AllIcons.Ide.Link.getIconHeight();
            }
        }
        JBInsets.addTo((Dimension)dimension, (Insets)this.getInsets());
        return dimension;
    }

    public void setForceMinimumSize(boolean force) {
        this.myForceMinimumSize = force;
    }

    public void setForceShowFirstComponent(boolean showFirstComponent) {
        this.myForceShowFirstComponent = showFirstComponent;
    }

    public void setSkipWindowAdjustments(boolean skipWindowAdjustments) {
        this.mySkipWindowAdjustments = skipWindowAdjustments;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.updateMinimumSize(super.getMinimumSize());
    }

    protected Dimension updateMinimumSize(Dimension minimumSize) {
        if (this.myForceMinimumSize) {
            return this.updatePreferredSize(minimumSize);
        }
        if (this.myLayoutPolicy == 2) {
            Insets i2 = this.getInsets();
            if (this.myForceShowFirstComponent && this.getComponentCount() > 0 && this.getComponent(0).isShowing()) {
                Component c = this.getComponent(0);
                Dimension firstSize = c.getPreferredSize();
                if (this.myOrientation == 0) {
                    return new Dimension(firstSize.width + AllIcons.Ide.Link.getIconWidth() + i2.left + i2.right, Math.max(firstSize.height, this.myMinimumButtonSize.height()) + i2.top + i2.bottom);
                }
                return new Dimension(Math.max(firstSize.width, AllIcons.Ide.Link.getIconWidth()) + i2.left + i2.right, firstSize.height + this.myMinimumButtonSize.height() + i2.top + i2.bottom);
            }
            return new Dimension(AllIcons.Ide.Link.getIconWidth() + i2.left + i2.right, this.myMinimumButtonSize.height() + i2.top + i2.bottom);
        }
        return minimumSize;
    }

    @NotNull
    protected Color getSeparatorColor() {
        Color color = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
        if (color == null) {
            ActionToolbarImpl.$$$reportNull$$$0(33);
        }
        return color;
    }

    protected int getSeparatorHeight() {
        return JBUIScale.scale((int)24);
    }

    public void adjustTheSameSize(boolean value2) {
        if (this.myAdjustTheSameSize == value2) {
            return;
        }
        this.myAdjustTheSameSize = value2;
        this.revalidate();
    }

    public void setMinimumButtonSize(@NotNull Dimension size) {
        if (size == null) {
            ActionToolbarImpl.$$$reportNull$$$0(34);
        }
        this.myMinimumButtonSize = JBDimension.create((Dimension)size, (boolean)true);
        for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component2 = this.getComponent(i2);
            if (!(component2 instanceof ActionButton)) continue;
            ActionButton button2 = (ActionButton)component2;
            button2.setMinimumButtonSize(size);
        }
        this.revalidate();
    }

    public void setOrientation(int orientation) {
        if (0 != orientation && 1 != orientation) {
            throw new IllegalArgumentException("wrong orientation: " + orientation);
        }
        this.myOrientation = orientation;
    }

    public int getOrientation() {
        return this.myOrientation;
    }

    public void updateActionsImmediately() {
        this.updateActionsImmediately(false);
    }

    public void updateActionsImmediately(boolean includeInvisible) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUpdater.updateActions(true, false, includeInvisible);
    }

    public void setHideDisabled(boolean hideDisabled) {
        this.myHideDisabled = hideDisabled;
        this.updateActionsImmediately();
    }

    private void updateActionsImpl(boolean transparentOnly, boolean forced) {
        DataContext dataContext = this.getDataContext();
        boolean async = this.myAlreadyUpdated && Registry.is((String)"actionSystem.update.actions.asynchronously") && ourToolbars.contains(this) && this.isShowing();
        ActionUpdater updater = new ActionUpdater(LaterInvocator.isInModalContext(), this.myPresentationFactory, async ? new AsyncDataContext(dataContext) : dataContext, this.myPlace, false, true, transparentOnly);
        if (async) {
            if (this.myLastUpdate != null) {
                this.myLastUpdate.cancel();
            }
            this.myLastUpdate = updater.expandActionGroupAsync(this.myActionGroup, this.myHideDisabled);
            this.myLastUpdate.onSuccess(actions -> this.actionsUpdated(forced, (List<? extends AnAction>)actions)).onProcessed(__ -> {
                this.myLastUpdate = null;
            });
        } else {
            this.actionsUpdated(forced, updater.expandActionGroupWithTimeout(this.myActionGroup, this.myHideDisabled));
            this.myAlreadyUpdated = true;
        }
        if (this.mySecondaryActionsButton != null) {
            this.mySecondaryActionsButton.update();
            this.mySecondaryActionsButton.repaint();
        }
    }

    protected void actionsUpdated(boolean forced, @NotNull List<? extends AnAction> newVisibleActions) {
        if (newVisibleActions == null) {
            ActionToolbarImpl.$$$reportNull$$$0(35);
        }
        if (forced || !newVisibleActions.equals(this.myVisibleActions) || this.myPresentationFactory.isNeedRebuild()) {
            boolean shouldRebuildUI = newVisibleActions.isEmpty() || this.myVisibleActions.isEmpty();
            this.myVisibleActions = newVisibleActions;
            Dimension oldSize = this.getPreferredSize();
            this.removeAll();
            this.mySecondaryActions.removeAll();
            this.mySecondaryActionsButton = null;
            this.fillToolBar(this.myVisibleActions, this.getLayoutPolicy() == 2 && this.myOrientation == 0);
            this.myPresentationFactory.resetNeedRebuild();
            Dimension newSize = this.getPreferredSize();
            if (!this.mySkipWindowAdjustments) {
                ((WindowManagerEx)WindowManager.getInstance()).adjustContainerWindow(this, oldSize, newSize);
            }
            if (shouldRebuildUI) {
                this.revalidate();
            } else {
                Container parent = this.getParent();
                if (parent != null) {
                    parent.invalidate();
                    parent.validate();
                }
            }
            this.repaint();
        }
    }

    public boolean hasVisibleActions() {
        return !this.myVisibleActions.isEmpty();
    }

    public void setTargetComponent(JComponent component2) {
        this.myTargetComponent = component2;
        if (this.myTargetComponent != null) {
            ActionToolbarImpl.updateWhenFirstShown(this.myTargetComponent, new ToolbarReference(this));
        }
    }

    private static void updateWhenFirstShown(@NotNull JComponent targetComponent, final @NotNull ToolbarReference ref) {
        if (targetComponent == null) {
            ActionToolbarImpl.$$$reportNull$$$0(36);
        }
        if (ref == null) {
            ActionToolbarImpl.$$$reportNull$$$0(37);
        }
        Activatable activatable = new Activatable(){

            public void showNotify() {
                ActionToolbarImpl toolbar = (ActionToolbarImpl)ref.get();
                if (toolbar != null) {
                    toolbar.myUpdater.updateActions(false, false, false);
                }
            }
        };
        ref.myDisposable = new UiNotifyConnector(targetComponent, activatable){

            protected void showNotify() {
                super.showNotify();
                ref.disposeReference();
            }
        };
    }

    @NotNull
    public DataContext getToolbarDataContext() {
        DataContext dataContext = this.getDataContext();
        if (dataContext == null) {
            ActionToolbarImpl.$$$reportNull$$$0(38);
        }
        return dataContext;
    }

    public void setShowSeparatorTitles(boolean showSeparatorTitles) {
        this.myShowSeparatorTitles = showSeparatorTitles;
    }

    @NotNull
    protected DataContext getDataContext() {
        DataContext dataContext = this.myTargetComponent != null ? this.myDataManager.getDataContext((Component)this.myTargetComponent) : ((DataManagerImpl)this.myDataManager).getDataContextTest(this);
        if (dataContext == null) {
            ActionToolbarImpl.$$$reportNull$$$0(39);
        }
        return dataContext;
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if (this.getLayoutPolicy() != 2) {
            return;
        }
        if (this.myAutoPopupRec != null && this.myAutoPopupRec.contains(e.getPoint())) {
            IdeFocusManager.getInstance(null).doWhenFocusSettlesDown(this::showAutoPopup);
        }
    }

    private void showAutoPopup() {
        Point location;
        ActionGroup group2;
        if (this.isPopupShowing()) {
            return;
        }
        if (this.myOrientation == 0) {
            group2 = this.myActionGroup;
        } else {
            DefaultActionGroup outside = new DefaultActionGroup();
            for (int i2 = this.myFirstOutsideIndex; i2 < this.myVisibleActions.size(); ++i2) {
                outside.add(this.myVisibleActions.get(i2));
            }
            group2 = outside;
        }
        final class AutoPopupToolbar
        extends PopupToolbar
        implements DataProvider {
            private AutoPopupToolbar(@NotNull String place, ActionGroup actionGroup, @NotNull boolean horizontal, JComponent parent) {
                if (place == null) {
                    AutoPopupToolbar.$$$reportNull$$$0(0);
                }
                if (actionGroup == null) {
                    AutoPopupToolbar.$$$reportNull$$$0(1);
                }
                if (parent == null) {
                    AutoPopupToolbar.$$$reportNull$$$0(2);
                }
                super(place, actionGroup, horizontal, parent);
            }

            @Override
            protected void onOtherActionPerformed() {
                ActionToolbarImpl.this.hidePopup();
            }

            @Override
            @NotNull
            protected DataContext getDataContext() {
                DataContext dataContext = ActionToolbarImpl.this.getDataContext();
                if (dataContext == null) {
                    AutoPopupToolbar.$$$reportNull$$$0(3);
                }
                return dataContext;
            }

            @Nullable
            public Object getData(@NotNull @NonNls String dataId) {
                if (dataId == null) {
                    AutoPopupToolbar.$$$reportNull$$$0(4);
                }
                if (ActionToolbarImpl.this.getDataContext().getData(PlatformDataKeys.CONTEXT_COMPONENT) != this) {
                    return ActionToolbarImpl.this.getDataContext().getData(dataId);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actionGroup";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl$1AutoPopupToolbar";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl$1AutoPopupToolbar";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDataContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getData";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        AutoPopupToolbar popupToolbar = new AutoPopupToolbar(this.myPlace, group2, true, this);
        popupToolbar.setLayoutPolicy(0);
        popupToolbar.updateActionsImmediately();
        if (this.myOrientation == 0) {
            location = this.getLocationOnScreen();
            ToolWindow toolWindow = (ToolWindow)DataManager.getInstance().getDataContext((Component)this).getData(PlatformDataKeys.TOOL_WINDOW);
            if (toolWindow != null && toolWindow.getAnchor() == ToolWindowAnchor.RIGHT) {
                int rightXOnScreen = location.x + this.getWidth();
                int toolbarPreferredWidth = popupToolbar.getPreferredSize().width;
                location.x = rightXOnScreen - toolbarPreferredWidth;
            }
        } else {
            location = this.getLocationOnScreen();
            location.y = location.y + this.getHeight() - popupToolbar.getPreferredSize().height;
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)popupToolbar, null);
        builder2.setResizable(false).setMovable(true).setRequestFocus(true).setMayBeParent(true).setTitle(null).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setCancelCallback(() -> {
            boolean toClose = actionManager.isActionPopupStackEmpty();
            if (toClose) {
                this.myUpdater.updateActions(false, true, false);
            }
            return toClose;
        }).setCancelOnMouseOutCallback(event -> this.myAutoPopupRec != null && actionManager.isActionPopupStackEmpty() && !new RelativeRectangle((Component)this, this.myAutoPopupRec).contains(new RelativePoint(event)));
        builder2.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    8.$$$reportNull$$$0(0);
                }
                ActionToolbarImpl.this.processClosed();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl$8", "onClosed"));
            }
        });
        this.myPopup = builder2.createPopup();
        Disposer.register((Disposable)this.myPopup, (Disposable)popupToolbar);
        this.myPopup.showInScreenCoordinates((Component)this, location);
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window == null) {
            return;
        }
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ActionToolbarImpl.this.hidePopup();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                ActionToolbarImpl.this.hidePopup();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ActionToolbarImpl.this.hidePopup();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ActionToolbarImpl.this.hidePopup();
            }
        };
        window.addComponentListener(componentAdapter);
        Disposer.register((Disposable)popupToolbar, () -> window.removeComponentListener(componentAdapter));
    }

    private boolean isPopupShowing() {
        return this.myPopup != null && !this.myPopup.isDisposed();
    }

    private void hidePopup() {
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.processClosed();
        }
    }

    private void processClosed() {
        if (this.myPopup == null) {
            return;
        }
        if (this.myPopup.isVisible()) {
            return;
        }
        this.myPopup = null;
        this.myUpdater.updateActions(false, false, false);
    }

    public void setReservePlaceAutoPopupIcon(boolean reserve) {
        this.myReservePlaceAutoPopupIcon = reserve;
    }

    public void setSecondaryActionsTooltip(@NotNull @NlsContexts.Tooltip String secondaryActionsTooltip) {
        if (secondaryActionsTooltip == null) {
            ActionToolbarImpl.$$$reportNull$$$0(40);
        }
        this.mySecondaryActions.getTemplatePresentation().setText(secondaryActionsTooltip);
    }

    public void setSecondaryActionsShortcut(@NotNull String secondaryActionsShortcut) {
        if (secondaryActionsShortcut == null) {
            ActionToolbarImpl.$$$reportNull$$$0(41);
        }
        this.mySecondaryActions.getTemplatePresentation().putClientProperty(SECONDARY_SHORTCUT, (Object)secondaryActionsShortcut);
    }

    public void setSecondaryActionsIcon(Icon icon2) {
        this.setSecondaryActionsIcon(icon2, false);
    }

    public void setSecondaryActionsIcon(Icon icon2, boolean hideDropdownIcon) {
        Presentation presentation2 = this.mySecondaryActions.getTemplatePresentation();
        presentation2.setIcon(icon2);
        presentation2.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)(hideDropdownIcon ? Boolean.TRUE : null));
    }

    public void setNoGapMode() {
        this.myNoGapMode = true;
    }

    @NotNull
    public List<AnAction> getActions(boolean originalProvider) {
        List<AnAction> list2 = this.getActions();
        if (list2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(42);
        }
        return list2;
    }

    @NotNull
    public List<AnAction> getActions() {
        AnAction[] kids;
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        ArrayList<AnAction> secondary = new ArrayList<AnAction>();
        for (AnAction each : kids = this.myActionGroup.getChildren(null)) {
            if (this.myActionGroup.isPrimary(each)) {
                result2.add(each);
                continue;
            }
            secondary.add(each);
        }
        result2.add((AnAction)new Separator());
        result2.addAll(secondary);
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            ActionToolbarImpl.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    public void setMiniMode(boolean minimalMode) {
        this.myMinimalMode = minimalMode;
        if (this.myMinimalMode) {
            this.setMinimumButtonSize((Dimension)JBUI.emptySize());
            this.setLayoutPolicy(0);
            this.setBorder((Border)JBUI.Borders.empty());
            this.setOpaque(false);
        } else {
            this.setBorder(JBUI.Borders.empty((int)2));
            this.setMinimumButtonSize((Dimension)(this.myDecorateButtons ? JBUI.size((int)30, (int)20) : DEFAULT_MINIMUM_BUTTON_SIZE));
            this.setOpaque(true);
            this.setLayoutPolicy(2);
        }
        this.myUpdater.updateActions(false, true, false);
    }

    @TestOnly
    public Presentation getPresentation(AnAction action2) {
        return this.myPresentationFactory.getPresentation(action2);
    }

    public void clearPresentationCache() {
        this.myPresentationFactory.reset();
    }

    static {
        JBUIScale.addUserScaleChangeListener(__ -> {
            ((JBDimension)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE).update();
            ((JBDimension)ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE).update();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryGroupUpdater";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionComponent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimumSize";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sizeToFit";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size2Fit";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVisibleActions";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetComponent";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryActionsTooltip";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryActionsShortcut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumButtonSize";
                break;
            }
            case 21: 
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarButton";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorColor";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarDataContext";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 43: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSecondaryButtonPopupStateModifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillToolBar";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomComponent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tweakActionComponentUI";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarButton";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calculateBoundsNowrapImpl";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calculateBoundsAutoImp";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "calculateBoundsWrapImpl";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "calculateBounds";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setMinimumButtonSize";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "actionsUpdated";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "updateWhenFirstShown";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setSecondaryActionsTooltip";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setSecondaryActionsShortcut";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface SecondaryGroupUpdater {
        public void update(@NotNull AnActionEvent var1);
    }

    static abstract class PopupToolbar
    extends ActionToolbarImpl
    implements AnActionListener,
    Disposable {
        private final JComponent myParent;

        PopupToolbar(@NotNull String place, @NotNull ActionGroup actionGroup, boolean horizontal, @NotNull JComponent parent) {
            if (place == null) {
                PopupToolbar.$$$reportNull$$$0(0);
            }
            if (actionGroup == null) {
                PopupToolbar.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                PopupToolbar.$$$reportNull$$$0(2);
            }
            super(place, actionGroup, horizontal, false, true);
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(AnActionListener.TOPIC, (Object)this);
            this.myParent = parent;
            this.setBorder(this.myParent.getBorder());
        }

        @Override
        public Container getParent() {
            Container parent = super.getParent();
            return parent != null ? parent : this.myParent;
        }

        public void dispose() {
        }

        public void afterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            if (action2 == null) {
                PopupToolbar.$$$reportNull$$$0(3);
            }
            if (dataContext == null) {
                PopupToolbar.$$$reportNull$$$0(4);
            }
            if (event == null) {
                PopupToolbar.$$$reportNull$$$0(5);
            }
            if (!this.myVisibleActions.contains(action2)) {
                this.onOtherActionPerformed();
            }
        }

        protected abstract void onOtherActionPerformed();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl$PopupToolbar";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterActionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MySeparator
    extends JComponent {
        private final String myText;

        private MySeparator(String text2) {
            this.myText = text2;
            this.setFont((Font)JBUI.Fonts.toolbarSmallComboBoxFont());
        }

        @Override
        public Dimension getPreferredSize() {
            int gap = JBUIScale.scale((int)2);
            int center = JBUIScale.scale((int)3);
            int width = gap * 2 + center;
            int height = ActionToolbarImpl.this.getSeparatorHeight();
            if (ActionToolbarImpl.this.myOrientation == 0) {
                if (this.myText != null) {
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    int textWidth = this.getTextWidth(fontMetrics, this.myText, this.getGraphics());
                    return new JBDimension(width + gap * 2 + textWidth, Math.max(fontMetrics.getHeight(), height), true);
                }
                return new JBDimension(width, height, true);
            }
            return new JBDimension(height, width, true);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.getParent() == null) {
                return;
            }
            int gap = JBUIScale.scale((int)2);
            int center = JBUIScale.scale((int)3);
            int offset = ActionToolbarImpl.this.myOrientation == 0 ? ActionToolbarImpl.this.getHeight() - ActionToolbarImpl.this.getMaxButtonHeight() - 1 : ActionToolbarImpl.this.getWidth() - ActionToolbarImpl.this.getMaxButtonWidth() - 1;
            g.setColor(ActionToolbarImpl.this.getSeparatorColor());
            if (ActionToolbarImpl.this.myOrientation == 0) {
                int y2 = ActionToolbarImpl.this.getHeight() - gap * 2 - offset;
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)center, (double)gap, (double)center, (double)y2);
                if (this.myText != null) {
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    int top = (this.getHeight() - fontMetrics.getHeight()) / 2;
                    UISettings.setupAntialiasing((Graphics)g);
                    g.setColor(JBColor.foreground());
                    g.drawString(this.myText, gap * 2 + center + gap, top + fontMetrics.getAscent());
                }
            } else {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)gap, (double)center, (double)(ActionToolbarImpl.this.getWidth() - gap * 2 - offset), (double)center);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getTextWidth(@NotNull FontMetrics fontMetrics, @NotNull String text2, @Nullable Graphics graphics) {
            if (fontMetrics == null) {
                MySeparator.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                MySeparator.$$$reportNull$$$0(1);
            }
            if (graphics == null) {
                return fontMetrics.stringWidth(text2);
            }
            Graphics g = graphics.create();
            try {
                UISettings.setupAntialiasing((Graphics)g);
                int n = fontMetrics.getStringBounds((String)text2, (Graphics)g).getBounds().width;
                return n;
            }
            finally {
                g.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fontMetrics";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl$MySeparator";
            objectArray[2] = "getTextWidth";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ToolbarReference
    extends WeakReference<ActionToolbarImpl> {
        private static final ReferenceQueue<ActionToolbarImpl> ourQueue = new ReferenceQueue();
        private volatile Disposable myDisposable;

        ToolbarReference(@NotNull ActionToolbarImpl toolbar) {
            if (toolbar == null) {
                ToolbarReference.$$$reportNull$$$0(0);
            }
            super(toolbar, ourQueue);
            ToolbarReference.processQueue();
        }

        private static void processQueue() {
            ToolbarReference ref;
            while ((ref = (ToolbarReference)ourQueue.poll()) != null) {
                ref.disposeReference();
            }
        }

        private void disposeReference() {
            Disposable disposable2 = this.myDisposable;
            if (disposable2 != null) {
                this.myDisposable = null;
                Disposer.dispose((Disposable)disposable2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl$ToolbarReference", "<init>"));
        }
    }
}

