/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickList
extends ExternalizableSchemeAdapter
implements SerializableScheme {
    public static final String QUICK_LIST_PREFIX = "QuickList.";
    @NonNls
    public static final String SEPARATOR_ID = "QuickList.$Separator$";
    private static final String ID_TAG = "id";
    private static final String ACTION_TAG = "action";
    static final String DISPLAY_NAME_TAG = "display";
    private static final String DESCRIPTION_TAG = "description";
    private String myDescription;
    private String[] myActionIds;
    private SchemeState schemeState;

    QuickList() {
        this.myActionIds = ArrayUtilRt.EMPTY_STRING_ARRAY;
        this.setName("");
    }

    public QuickList(@NotNull String name, @Nullable String description, String[] actionIds) {
        if (name == null) {
            QuickList.$$$reportNull$$$0(0);
        }
        this.myActionIds = ArrayUtilRt.EMPTY_STRING_ARRAY;
        this.setName(name);
        this.myDescription = StringUtil.nullize((String)description);
        this.myActionIds = actionIds;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String value2) {
        this.myDescription = StringUtil.nullize((String)value2);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public String[] getActionIds() {
        return this.myActionIds;
    }

    public void setActionIds(String @NotNull [] value2) {
        if (value2 == null) {
            QuickList.$$$reportNull$$$0(1);
        }
        this.myActionIds = value2;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuickList)) {
            return false;
        }
        QuickList quickList = (QuickList)o;
        return Arrays.equals(this.myActionIds, quickList.myActionIds) && Comparing.strEqual((String)this.myDescription, (String)quickList.myDescription) && this.getName().equals(quickList.getName());
    }

    public int hashCode() {
        return 29 * this.getName().hashCode() + Comparing.hashcode((Object)this.myDescription);
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.getName() + " " + this.getDescription();
        if (string == null) {
            QuickList.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getActionId() {
        String string = QUICK_LIST_PREFIX + this.getName();
        if (string == null) {
            QuickList.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void readExternal(@NotNull Element element2) {
        if (element2 == null) {
            QuickList.$$$reportNull$$$0(4);
        }
        this.setName(element2.getAttributeValue(DISPLAY_NAME_TAG));
        this.myDescription = StringUtil.nullize((String)element2.getAttributeValue(DESCRIPTION_TAG));
        List actionElements = element2.getChildren(ACTION_TAG);
        this.myActionIds = new String[actionElements.size()];
        int n = actionElements.size();
        for (int i2 = 0; i2 < n; ++i2) {
            this.myActionIds[i2] = ((Element)actionElements.get(i2)).getAttributeValue(ID_TAG);
        }
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element element2 = new Element("list");
        element2.setAttribute(DISPLAY_NAME_TAG, this.getName());
        if (this.myDescription != null) {
            element2.setAttribute(DESCRIPTION_TAG, this.myDescription);
        }
        for (String actionId : this.getActionIds()) {
            element2.addContent(new Element(ACTION_TAG).setAttribute(ID_TAG, actionId));
        }
        this.schemeState = SchemeState.UNCHANGED;
        Element element3 = element2;
        if (element3 == null) {
            QuickList.$$$reportNull$$$0(5);
        }
        return element3;
    }

    @Override
    @Nullable
    public SchemeState getSchemeState() {
        return this.schemeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/QuickList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/QuickList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setActionIds";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

