/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.index;

import com.google.common.hash.HashCode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.stubs.FileContentHashing;
import com.intellij.psi.stubs.HashCodeDescriptor;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 &*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0002J\u0017\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0004\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0016H$J\b\u0010!\u001a\u00020\u0016H\u0016J\r\u0010\"\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b#J\u001e\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00132\u0006\u0010%\u001a\u00020\u0016H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/index/PrebuiltIndexProvider;", "Value", "Lcom/intellij/openapi/Disposable;", "()V", "dirName", "", "getDirName", "()Ljava/lang/String;", "indexExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getIndexExternalizer", "()Lcom/intellij/util/io/DataExternalizer;", "indexName", "getIndexName", "myFileContentHashing", "Lcom/intellij/psi/stubs/FileContentHashing;", "myOpenCloseLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "myPrebuiltIndexStorage", "Lcom/intellij/util/io/PersistentHashMap;", "Lcom/google/common/hash/HashCode;", "copyPrebuiltIndicesToIndexRoot", "Ljava/io/File;", "prebuiltIndicesRoot", "dispose", "", "doDispose", "findPrebuiltIndicesRoot", "get", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "(Lcom/intellij/util/indexing/FileContent;)Ljava/lang/Object;", "getIndexRoot", "indexRoot", "init", "init$intellij_platform_indexing_impl", "openIndexStorage", "indexesRoot", "Companion", "intellij.platform.indexing.impl"})
public abstract class PrebuiltIndexProvider<Value>
implements Disposable {
    private final FileContentHashing myFileContentHashing = new FileContentHashing();
    private final ReentrantReadWriteLock myOpenCloseLock = new ReentrantReadWriteLock();
    private PersistentHashMap<HashCode, Value> myPrebuiltIndexStorage;
    private static final Logger LOG;
    @JvmField
    public static final boolean DEBUG_PREBUILT_INDICES;
    @JvmField
    public static final boolean USE_PREBUILT_INDEX;
    public static final Companion Companion;

    @NotNull
    protected abstract String getDirName();

    @NotNull
    protected abstract String getIndexName();

    @NotNull
    protected abstract DataExternalizer<Value> getIndexExternalizer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init$intellij_platform_indexing_impl() {
        ReentrantReadWriteLock.WriteLock writeLock = this.myOpenCloseLock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"myOpenCloseLock.writeLock()");
        Lock lock = writeLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            if (USE_PREBUILT_INDEX) {
                File indexesRoot = this.findPrebuiltIndicesRoot();
                try {
                    if (indexesRoot != null && indexesRoot.exists()) {
                        Object object;
                        indexesRoot = this.copyPrebuiltIndicesToIndexRoot(indexesRoot);
                        this.myPrebuiltIndexStorage = this.openIndexStorage(indexesRoot);
                        LOG.info("Using prebuilt " + this.getIndexName() + " from " + ((object = this.myPrebuiltIndexStorage) != null && (object = object.getBaseFile()) != null ? object.toAbsolutePath() : null));
                    } else {
                        LOG.info("Prebuilt " + this.getIndexName() + " indices are missing for " + this.getDirName());
                    }
                }
                catch (ProcessCanceledException e) {
                    throw (Throwable)e;
                }
                catch (Exception e) {
                    this.myPrebuiltIndexStorage = null;
                    StringBuilder stringBuilder = new StringBuilder().append("Prebuilt indices can't be loaded at ");
                    File file2 = indexesRoot;
                    Intrinsics.checkNotNull((Object)file2);
                    LOG.warn(stringBuilder.append(file2).toString(), (Throwable)e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    protected final Value get(@NotNull FileContent fileContent) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
            corrupted = false;
            v0 = this.myOpenCloseLock.readLock();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"myOpenCloseLock.readLock()");
            var3_3 = v0;
            var4_4 = false;
            var5_5 = false;
            var3_3.lock();
            try {
                $i$a$-withLock-PrebuiltIndexProvider$get$1 = false;
                if (this.myPrebuiltIndexStorage == null) ** GOTO lbl27
                hashCode = this.myFileContentHashing.hashString(fileContent);
                try {
                    v1 = this.myPrebuiltIndexStorage;
                    Intrinsics.checkNotNull(v1);
                    var9_10 = v1.get((Object)hashCode);
                }
                catch (Exception e) {
                    v2 = new StringBuilder().append("Error reading prebuilt stubs from ");
                    v3 = this.myPrebuiltIndexStorage;
                    Intrinsics.checkNotNull(v3);
                    PrebuiltIndexProvider.LOG.error(v2.append(v3.getBaseFile()).toString(), (Throwable)e);
                    corrupted = true;
lbl27:
                    // 2 sources

                    var5_6 = Unit.INSTANCE;
                    break block7;
                }
                return (Value)var9_10;
            }
            finally {
                var3_3.unlock();
            }
        }
        if (corrupted) {
            this.doDispose();
        }
        return null;
    }

    @Nullable
    public PersistentHashMap<HashCode, Value> openIndexStorage(@NotNull File indexesRoot) {
        Intrinsics.checkNotNullParameter((Object)indexesRoot, (String)"indexesRoot");
        return new PersistentHashMap<HashCode, Value>(this, indexesRoot, new File(indexesRoot, this.getIndexName() + ".input"), HashCodeDescriptor.Companion.getInstance(), this.getIndexExternalizer()){
            final /* synthetic */ PrebuiltIndexProvider this$0;
            final /* synthetic */ File $indexesRoot;

            protected boolean isReadOnly() {
                return true;
            }
            {
                this.this$0 = this$0;
                this.$indexesRoot = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        };
    }

    @NotNull
    protected abstract File getIndexRoot();

    private final File copyPrebuiltIndicesToIndexRoot(File prebuiltIndicesRoot) throws IOException {
        File indexRoot = this.getIndexRoot();
        FileUtil.copyDir((File)prebuiltIndicesRoot, (File)indexRoot, (FileFilter)new FileFilter(this){
            final /* synthetic */ PrebuiltIndexProvider this$0;

            public final boolean accept(File f) {
                File file2 = f;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"f");
                String string = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.name");
                return StringsKt.startsWith$default((String)string, (String)this.this$0.getIndexName(), (boolean)false, (int)2, null);
            }
            {
                this.this$0 = prebuiltIndexProvider;
            }
        });
        return indexRoot;
    }

    private final File findPrebuiltIndicesRoot() {
        String path = System.getProperty("prebuilt_indices_path");
        if (path != null && new File(path).exists()) {
            return new File(path, this.getDirName());
        }
        File f = this.indexRoot();
        return f.exists() ? f : null;
    }

    @NotNull
    public File indexRoot() {
        return new File(PathManager.getHomePath(), "index/" + this.getDirName());
    }

    public void dispose() {
        this.doDispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doDispose() {
        ReentrantReadWriteLock.WriteLock writeLock = this.myOpenCloseLock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"myOpenCloseLock.writeLock()");
        Lock lock = writeLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            if (this.myPrebuiltIndexStorage != null) {
                try {
                    PersistentHashMap<HashCode, Value> persistentHashMap = this.myPrebuiltIndexStorage;
                    Intrinsics.checkNotNull(persistentHashMap);
                    persistentHashMap.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                this.myPrebuiltIndexStorage = null;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public PrebuiltIndexProvider() {
        this.init$intellij_platform_indexing_impl();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#com.intellij.index.PrebuiltIndexProviderBase");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026ebuiltIndexProviderBase\")");
        LOG = logger;
        DEBUG_PREBUILT_INDICES = SystemProperties.getBooleanProperty((String)"debug.prebuilt.indices", (boolean)false);
        USE_PREBUILT_INDEX = Registry.is((String)"use.prebuilt.indices");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/index/PrebuiltIndexProvider$Companion;", "", "()V", "DEBUG_PREBUILT_INDICES", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "USE_PREBUILT_INDEX", "intellij.platform.indexing.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

