/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteNameDescriptionLocation;
import com.intellij.ide.util.DeleteTypeDescriptionLocation;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FactoryMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public final class DeleteUtil {
    private DeleteUtil() {
    }

    @NlsContexts.DialogMessage
    public static String generateWarningMessage(@PropertyKey(resourceBundle="messages.IdeBundle") @PropertyKey(resourceBundle="messages.IdeBundle") String key, PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            DeleteUtil.$$$reportNull$$$0(0);
        }
        if (elements2.length == 1) {
            String name = ElementDescriptionUtil.getElementDescription((PsiElement)elements2[0], (ElementDescriptionLocation)DeleteNameDescriptionLocation.INSTANCE);
            String type = ElementDescriptionUtil.getElementDescription((PsiElement)elements2[0], (ElementDescriptionLocation)DeleteTypeDescriptionLocation.SINGULAR);
            return IdeBundle.message((String)key, (Object[])new Object[]{type + (String)(StringUtil.isEmptyOrSpaces((String)name) ? "" : " \"" + name + "\"")});
        }
        Map countMap = FactoryMap.create(k -> 0);
        HashMap<String, String> pluralToSingular = new HashMap<String, String>();
        int directoryCount = 0;
        String containerType = null;
        for (PsiElement elementToDelete : elements2) {
            String type = ElementDescriptionUtil.getElementDescription((PsiElement)elementToDelete, (ElementDescriptionLocation)DeleteTypeDescriptionLocation.PLURAL);
            pluralToSingular.put(type, ElementDescriptionUtil.getElementDescription((PsiElement)elementToDelete, (ElementDescriptionLocation)DeleteTypeDescriptionLocation.SINGULAR));
            int oldCount = (Integer)countMap.get(type);
            countMap.put(type, oldCount + 1);
            if (!(elementToDelete instanceof PsiDirectoryContainer)) continue;
            containerType = type;
            directoryCount += ((PsiDirectoryContainer)elementToDelete).getDirectories().length;
        }
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry entry : countMap.entrySet()) {
            if (buffer.length() > 0) {
                buffer.append(" ").append(IdeBundle.message((String)"prompt.delete.and", (Object[])new Object[0])).append(" ");
            }
            int count = (Integer)entry.getValue();
            buffer.append(count).append(" ");
            if (count == 1) {
                buffer.append((String)pluralToSingular.get(entry.getKey()));
            } else {
                buffer.append((String)entry.getKey());
            }
            if (!((String)entry.getKey()).equals(containerType)) continue;
            buffer.append(" ").append(IdeBundle.message((String)"prompt.delete.directory.paren", (Object[])new Object[]{directoryCount}));
        }
        return IdeBundle.message((String)key, (Object[])new Object[]{buffer.toString()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/DeleteUtil", "generateWarningMessage"));
    }
}

