/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.CountComponent;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.openapi.options.ConfigurableTreeRenderer;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerConfigurableTreeRenderer
extends AncestorListenerAdapter
implements ConfigurableTreeRenderer,
Consumer<Integer> {
    private final CountComponent myCountLabel = new CountComponent();
    private final JLabel myExtraLabel = new JLabel();
    private final JPanel myPanel = new NonOpaquePanel();
    private PluginUpdatesService myService;
    private SimpleTree myTree;
    private String myCountValue;

    public PluginManagerConfigurableTreeRenderer() {
        this.myPanel.setLayout(new BorderLayout(PluginManagerConfigurableTreeRenderer.getHGap(), 0));
        this.myPanel.add((Component)this.myCountLabel, "West");
        this.myPanel.add((Component)this.myExtraLabel, "East");
    }

    @Nullable
    public Pair<Component, ConfigurableTreeRenderer.Layout> getDecorator(@NotNull SimpleTree tree, @Nullable UnnamedConfigurable configurable2, boolean selected2) {
        Icon icon2;
        if (tree == null) {
            PluginManagerConfigurableTreeRenderer.$$$reportNull$$$0(0);
        }
        if (this.myTree == null) {
            this.myService = PluginUpdatesService.connectTreeRenderer(this);
            tree.addAncestorListener((AncestorListener)((Object)this));
            this.myTree = tree;
        }
        Icon icon3 = icon2 = DynamicBundle.LanguageBundleEP.EP_NAME.hasAnyExtensions() ? AllIcons.General.LocalizationSettings : null;
        if (icon2 == null && this.myCountValue == null) {
            return null;
        }
        this.myCountLabel.setText(StringUtil.defaultIfEmpty((String)this.myCountValue, (String)"0"));
        this.myCountLabel.setSelected(selected2);
        this.myExtraLabel.setIcon(icon2);
        this.myExtraLabel.setBackground(this.myCountLabel.getBackground());
        CountComponent component2 = icon2 == null ? this.myCountLabel : (this.myCountValue == null ? this.myExtraLabel : this.myPanel);
        boolean isPanel = component2 == this.myPanel;
        return Pair.create((Object)component2, (renderer2, bounds2, text2, right, textBaseline) -> {
            Dimension size = renderer2.getPreferredSize();
            int preferredWidth = size.width;
            int preferredHeight = size.height;
            renderer2.setBounds(right.x + (right.width - preferredWidth) / 2 - JBUIScale.scale((int)20) - this.getPreferredShift(isPanel), bounds2.y + textBaseline - this.myCountLabel.getBaseline(preferredWidth, preferredHeight), preferredWidth, preferredHeight);
            renderer2.doLayout();
        });
    }

    public void ancestorRemoved(AncestorEvent event) {
        this.myService.dispose();
    }

    @Override
    public void accept(Integer countValue) {
        String oldCountValue = this.myCountValue;
        String string = this.myCountValue = countValue == null || countValue <= 0 ? null : countValue.toString();
        if (this.myTree != null && !StringUtil.equals((CharSequence)oldCountValue, (CharSequence)this.myCountValue)) {
            this.myTree.repaint();
        }
    }

    private int getPreferredShift(boolean isPanel) {
        return isPanel ? PluginManagerConfigurableTreeRenderer.getHGap() + this.myExtraLabel.getPreferredSize().width / 2 : 0;
    }

    private static int getHGap() {
        return JBUIScale.scale((int)3);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/plugins/PluginManagerConfigurableTreeRenderer", "getDecorator"));
    }
}

