/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.find.actions.FindUsagesAction;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.PingEDT;
import com.intellij.find.actions.ResolverKt;
import com.intellij.find.actions.ShowTargetUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesParameters;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.find.actions.TargetVariant;
import com.intellij.find.actions.UsageListCellRenderer;
import com.intellij.find.actions.UsageVariantHandler;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesHandlerUi;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.ShowUsageViewSettings;
import com.intellij.usages.ShowUsagesSettings;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearchPresentation;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageGroupingRuleProviderImpl;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUsagesAction
extends AnAction
implements PopupAction,
HintManagerImpl.ActionToIgnore {
    public static final String ID = "ShowUsages";

    public ShowUsagesAction() {
        this.setInjectedContext(true);
    }

    public static int getUsagesPageSize() {
        return Math.max(1, Registry.intValue((String)"ide.usages.page.size", (int)100));
    }

    public void update(@NotNull AnActionEvent e) {
        Object[] usageTargets;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(0);
        }
        FindUsagesInFileAction.updateFindUsagesAction(e);
        if (e.getPresentation().isEnabled() && (usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY)) != null && !(ArrayUtil.getFirstElement((Object[])usageTargets) instanceof PsiElementUsageTarget)) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ShowUsagesActionState state = ShowUsagesAction.getState(project);
        Runnable continuation = state.continuation;
        if (continuation != null) {
            state.continuation = null;
            ShowUsagesAction.hideHints();
            continuation.run();
            return;
        }
        RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.usages");
        if (Registry.is((String)"ide.symbol.find.usages")) {
            ShowUsagesAction.showSymbolUsages(project, e.getDataContext());
        } else {
            ShowUsagesAction.showPsiUsages(project, e, popupPosition);
        }
    }

    private static void showSymbolUsages(@NotNull Project project, @NotNull DataContext dataContext) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            ShowUsagesAction.$$$reportNull$$$0(3);
        }
        ShowUsagesAction.showUsages(project, dataContext, ResolverKt.allTargets(dataContext));
    }

    @ApiStatus.Internal
    public static void showUsages(@NotNull Project project, @NotNull DataContext dataContext, @NotNull @NotNull List<@NotNull TargetVariant> targetVariants) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            ShowUsagesAction.$$$reportNull$$$0(5);
        }
        if (targetVariants == null) {
            ShowUsagesAction.$$$reportNull$$$0(6);
        }
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        SearchScope searchScope2 = FindUsagesOptions.findScopeByName(project, dataContext, FindSettings.getInstance().getDefaultScopeName());
        ResolverKt.findShowUsages(project, dataContext, targetVariants, FindBundle.message("show.usages.ambiguous.title", new Object[0]), ShowUsagesAction.createVariantHandler(project, editor, popupPosition, searchScope2));
    }

    @NotNull
    private static UsageVariantHandler createVariantHandler(final @NotNull Project project, final @Nullable Editor editor, final @NotNull RelativePoint popupPosition, final @NotNull SearchScope searchScope2) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(7);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(8);
        }
        if (searchScope2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(9);
        }
        return new UsageVariantHandler(){

            @Override
            public void handleTarget(@NotNull SearchTarget target2) {
                if (target2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShowTargetUsagesActionHandler.showUsages(project, searchScope2, target2, ShowUsagesParameters.initial(project, editor, popupPosition));
            }

            @Override
            public void handlePsi(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                ShowUsagesAction.startFindUsages(element2, popupPosition, editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleTarget";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePsi";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @ApiStatus.Internal
    public static void showUsages(@NotNull Project project, @NotNull DataContext dataContext, @NotNull RelativePoint popupPosition, @NotNull SearchTarget target2) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(10);
        }
        if (dataContext == null) {
            ShowUsagesAction.$$$reportNull$$$0(11);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(12);
        }
        if (target2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(13);
        }
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        SearchScope searchScope2 = FindUsagesOptions.findScopeByName(project, dataContext, FindSettings.getInstance().getDefaultScopeName());
        ShowTargetUsagesActionHandler.showUsages(project, searchScope2, target2, ShowUsagesParameters.initial(project, editor, popupPosition));
    }

    private static void showPsiUsages(@NotNull Project project, @NotNull AnActionEvent e, @NotNull RelativePoint popupPosition) {
        PsiElement element3;
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(14);
        }
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(15);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(16);
        }
        Object[] usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (usageTargets == null) {
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project, editor, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element2 -> {
                ShowUsagesAction.startFindUsages(element2, popupPosition, editor);
                return false;
            }));
        } else if (ArrayUtil.getFirstElement((Object[])usageTargets) instanceof PsiElementUsageTarget && (element3 = ((PsiElementUsageTarget)usageTargets[0]).getElement()) != null) {
            ShowUsagesAction.startFindUsages(element3, popupPosition, editor);
        }
    }

    private static void hideHints() {
        HintManager.getInstance().hideHints(2, false, false);
    }

    public static void startFindUsages(@NotNull PsiElement element2, @NotNull RelativePoint popupPosition, @Nullable Editor editor) {
        Project project;
        FindUsagesManager findUsagesManager;
        FindUsagesHandler handler2;
        if (element2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(17);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(18);
        }
        if ((handler2 = (findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)(project = element2.getProject()))).getFindUsagesManager()).getFindUsagesHandler(element2, FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS)) == null) {
            return;
        }
        FindUsagesOptions options2 = handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
        ShowUsagesAction.showElementUsages(ShowUsagesParameters.initial(project, editor, popupPosition), ShowUsagesAction.createActionHandler(handler2, options2));
    }

    private static void rulesChanged(@NotNull UsageViewImpl usageView, @NotNull PingEDT pingEDT, JBPopup popup2) {
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(19);
        }
        if (pingEDT == null) {
            ShowUsagesAction.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                usageView.waitForUpdateRequestsCompletion();
                if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                    pingEDT.ping();
                }
            }
        }));
    }

    @NotNull
    private static ShowUsagesActionHandler createActionHandler(final @NotNull FindUsagesHandlerBase handler2, final @NotNull FindUsagesOptions options2) {
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(21);
        }
        if (options2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(22);
        }
        final PsiElement[] primaryElements = handler2.getPrimaryElements();
        final PsiElement[] secondaryElements = handler2.getSecondaryElements();
        final String searchString = FindBundle.message("find.usages.of.element.tab.name", options2.generateUsagesString(), UsageViewUtil.getLongName(handler2.getPsiElement()));
        return new ShowUsagesActionHandler(){

            @Override
            public boolean isValid() {
                return handler2.getPsiElement().isValid();
            }

            @Override
            @NotNull
            public UsageSearchPresentation getPresentation() {
                UsageSearchPresentation usageSearchPresentation = () -> searchString;
                if (usageSearchPresentation == null) {
                    2.$$$reportNull$$$0(0);
                }
                return usageSearchPresentation;
            }

            @Override
            @NotNull
            public UsageSearcher createUsageSearcher() {
                UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(handler2, primaryElements, secondaryElements, options2);
                if (usageSearcher == null) {
                    2.$$$reportNull$$$0(1);
                }
                return usageSearcher;
            }

            @Override
            @NotNull
            public SearchScope getSelectedScope() {
                SearchScope searchScope2 = options2.searchScope;
                if (searchScope2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return searchScope2;
            }

            @NotNull
            public GlobalSearchScope getMaximalScope() {
                GlobalSearchScope globalSearchScope = FindUsagesManager.getMaximalScope(handler2);
                if (globalSearchScope == null) {
                    2.$$$reportNull$$$0(3);
                }
                return globalSearchScope;
            }

            @Override
            public ShowUsagesActionHandler showDialog() {
                FindUsagesOptions newOptions = ShowUsagesAction.showDialog(handler2);
                if (newOptions == null) {
                    return null;
                }
                return ShowUsagesAction.createActionHandler(handler2, newOptions);
            }

            @Override
            public void findUsages() {
                Project project = handler2.getProject();
                FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
                findUsagesManager.findUsages(handler2.getPrimaryElements(), handler2.getSecondaryElements(), handler2, options2, FindSettings.getInstance().isSkipResultsWithOneUsage());
            }

            @Override
            @NotNull
            public ShowUsagesActionHandler withScope(@NotNull SearchScope searchScope2) {
                if (searchScope2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                FindUsagesOptions newOptions = options2.clone();
                newOptions.searchScope = searchScope2;
                ShowUsagesActionHandler showUsagesActionHandler = ShowUsagesAction.createActionHandler(handler2, newOptions);
                if (showUsagesActionHandler == null) {
                    2.$$$reportNull$$$0(5);
                }
                return showUsagesActionHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$2";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createUsageSearcher";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedScope";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMaximalScope";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$2";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "withScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "withScope";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    static void showElementUsages(final @NotNull ShowUsagesParameters parameters2, final @NotNull ShowUsagesActionHandler actionHandler) {
        PsiReference reference2;
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(23);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = parameters2.project;
        Editor editor = parameters2.editor;
        UsageViewImpl usageView = ShowUsagesAction.createUsageView(project);
        if (editor != null && (reference2 = TargetElementUtil.findReference(editor)) != null) {
            UsageInfo2UsageAdapter origin = new UsageInfo2UsageAdapter(new UsageInfo(reference2));
            usageView.setOriginUsage((Usage)origin);
        }
        SearchScope searchScope2 = actionHandler.getSelectedScope();
        AtomicInteger outOfScopeUsages = new AtomicInteger();
        ShowUsagesTable table = new ShowUsagesTable(new ShowUsagesTableCellRenderer(usageView, outOfScopeUsages, searchScope2), (UsageView)usageView);
        AsyncProcessIcon processIcon = new AsyncProcessIcon("xxx");
        TitlePanel statusPanel = new TitlePanel();
        statusPanel.add((Component)processIcon, (Object)"East");
        ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, new ArrayList());
        ArrayList usages = new ArrayList();
        LinkedHashSet visibleUsages = new LinkedHashSet();
        table.setTableModel((List<UsageNode>)new SmartList((Object)ShowUsagesAction.createStringNode(UsageViewBundle.message((String)"progress.searching", (Object[])new Object[0]))));
        Runnable itemChosenCallback = table.prepareTable(ShowUsagesAction.showMoreUsagesRunnable(parameters2, actionHandler), ShowUsagesAction.showUsagesInMaximalScopeRunnable(parameters2, actionHandler));
        JBPopup popup2 = ShowUsagesAction.createUsagePopup(usageView, (JTable)((Object)table), itemChosenCallback, statusPanel, parameters2, actionHandler);
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        if (!popup2.isDisposed()) {
            Disposer.register((Disposable)popup2, (Disposable)usageView);
            Disposer.register((Disposable)popup2, () -> ((ProgressIndicator)indicator).cancel());
            EdtScheduledExecutorService.getInstance().schedule(() -> {
                if (!usageView.isDisposed()) {
                    ShowUsagesAction.showPopupIfNeedTo(popup2, parameters2.popupPosition);
                }
            }, 300L, TimeUnit.MILLISECONDS);
        }
        UsageNode USAGES_OUTSIDE_SCOPE_NODE = new UsageNode(null, table.USAGES_OUTSIDE_SCOPE_SEPARATOR);
        UsageNode MORE_USAGES_SEPARATOR_NODE = new UsageNode(null, table.MORE_USAGES_SEPARATOR);
        PingEDT pingEDT = new PingEDT("Rebuild popup in EDT", () -> popup2.isDisposed(), 100, () -> {
            boolean hasOutsideScopeUsages;
            ArrayList copy2;
            if (popup2.isDisposed()) {
                return;
            }
            ArrayList<UsageNode> nodes = new ArrayList<UsageNode>(usages.size());
            List list2 = usages;
            synchronized (list2) {
                if (!(popup2.isVisible() || !usages.isEmpty() && ShowUsagesAction.showPopupIfNeedTo(popup2, parameters2.popupPosition))) {
                    return;
                }
                ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, nodes);
                copy2 = new ArrayList(usages);
            }
            boolean shouldShowMoreSeparator = copy2.contains(table.MORE_USAGES_SEPARATOR);
            if (shouldShowMoreSeparator) {
                nodes.add(MORE_USAGES_SEPARATOR_NODE);
            }
            if ((hasOutsideScopeUsages = copy2.contains(table.USAGES_OUTSIDE_SCOPE_SEPARATOR)) && !shouldShowMoreSeparator) {
                nodes.add(USAGES_OUTSIDE_SCOPE_NODE);
            }
            ArrayList<UsageNode> data2 = new ArrayList<UsageNode>(nodes);
            int filteredOutCount = ShowUsagesAction.getFilteredOutNodeCount(copy2, usageView);
            if (filteredOutCount != 0) {
                DefaultActionGroup filteringActions = (DefaultActionGroup)popup2.getUserData(DefaultActionGroup.class);
                if (filteringActions == null) {
                    return;
                }
                final List unselectedActions = Arrays.stream(filteringActions.getChildren(null)).filter(action2 -> action2 instanceof ToggleAction).map(action2 -> (ToggleAction)action2).filter(ta -> !ta.isSelected(ShowUsagesAction.fakeEvent(ta))).filter(ta -> !StringUtil.isEmpty((String)ta.getTemplatePresentation().getText())).collect(Collectors.toList());
                data2.add(new FilteredOutUsagesNode(table.USAGES_FILTERED_OUT_SEPARATOR, UsageViewBundle.message((String)"usages.were.filtered.out", (Object[])new Object[]{filteredOutCount}), UsageViewBundle.message((String)"usages.were.filtered.out.tooltip", (Object[])new Object[0])){

                    @Override
                    public void onSelected() {
                        ShowUsagesAction.toggleFilters(unselectedActions);
                        ShowUsagesAction.showElementUsages(parameters2, actionHandler);
                    }
                });
            }
            data2.sort(new UsageNodeComparator(table));
            boolean hasMore = shouldShowMoreSeparator || hasOutsideScopeUsages;
            int totalCount = copy2.size();
            int visibleCount = totalCount - filteredOutCount;
            statusPanel.setText(ShowUsagesAction.getStatusString(!processIcon.isDisposed(), hasMore, visibleCount, totalCount));
            ShowUsagesAction.rebuildTable(usageView, data2, table, popup2, parameters2.popupPosition, parameters2.minWidth);
        });
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)usageView);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, () -> ShowUsagesAction.rulesChanged(usageView, pingEDT, popup2));
        Processor collect2 = usage -> {
            if (!UsageViewManagerImpl.isInScope((Usage)usage, (SearchScope)searchScope2)) {
                if (outOfScopeUsages.getAndIncrement() == 0) {
                    visibleUsages.add(USAGES_OUTSIDE_SCOPE_NODE.getUsage());
                    usages.add(table.USAGES_OUTSIDE_SCOPE_SEPARATOR);
                }
                return true;
            }
            List list2 = usages;
            synchronized (list2) {
                if (visibleUsages.size() >= parameters2.maxUsages) {
                    return false;
                }
                UsageNode nodes = (UsageNode)ReadAction.compute(() -> usageView.doAppendUsage(usage));
                usages.add(usage);
                if (nodes != null) {
                    visibleUsages.add(nodes.getUsage());
                    boolean continueSearch = true;
                    if (visibleUsages.size() == parameters2.maxUsages) {
                        visibleUsages.add(MORE_USAGES_SEPARATOR_NODE.getUsage());
                        usages.add(table.MORE_USAGES_SEPARATOR);
                        continueSearch = false;
                    }
                    pingEDT.ping();
                    return continueSearch;
                }
            }
            return true;
        };
        UsageSearcher usageSearcher = actionHandler.createUsageSearcher();
        FindUsagesManager.startProcessUsages(indicator, project, usageSearcher, (Processor<? super Usage>)collect2, () -> ApplicationManager.getApplication().invokeLater(() -> {
            Disposer.dispose((Disposable)processIcon);
            Container parent = processIcon.getParent();
            if (parent != null) {
                parent.remove((Component)processIcon);
                parent.repaint();
            }
            pingEDT.ping();
            List list2 = usages;
            synchronized (list2) {
                if (visibleUsages.isEmpty()) {
                    if (usages.isEmpty()) {
                        String hint = UsageViewBundle.message((String)"no.usages.found.in", (Object[])new Object[]{searchScope2.getDisplayName()});
                        ShowUsagesAction.hint(false, hint, parameters2, actionHandler);
                        ShowUsagesAction.cancel(popup2);
                    }
                } else if (visibleUsages.size() == 1) {
                    if (usages.size() == 1) {
                        Usage usage = (Usage)visibleUsages.iterator().next();
                        if (usage == table.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                            String hint = UsageViewManagerImpl.outOfScopeMessage((int)outOfScopeUsages.get(), (SearchScope)searchScope2);
                            ShowUsagesAction.hint(true, hint, parameters2, actionHandler);
                        } else {
                            String hint = UsageViewBundle.message((String)"show.usages.only.usage", (Object[])new Object[]{searchScope2.getDisplayName()});
                            ShowUsagesAction.navigateAndHint(usage, hint, parameters2, actionHandler);
                        }
                        ShowUsagesAction.cancel(popup2);
                    } else {
                        assert (usages.size() > 1) : usages;
                        Usage visibleUsage = (Usage)visibleUsages.iterator().next();
                        if (ShowUsagesAction.areAllUsagesInOneLine(visibleUsage, usages)) {
                            String hint = UsageViewBundle.message((String)"all.usages.are.in.this.line", (Object[])new Object[]{usages.size(), searchScope2.getDisplayName()});
                            ShowUsagesAction.navigateAndHint(visibleUsage, hint, parameters2, actionHandler);
                            ShowUsagesAction.cancel(popup2);
                        }
                    }
                }
            }
        }, project.getDisposed()));
    }

    private static void toggleFilters(@NotNull List<? extends ToggleAction> unselectedActions) {
        if (unselectedActions == null) {
            ShowUsagesAction.$$$reportNull$$$0(25);
        }
        for (ToggleAction toggleAction : unselectedActions) {
            toggleAction.actionPerformed(ShowUsagesAction.fakeEvent(toggleAction));
        }
    }

    @NotNull
    private static AnActionEvent fakeEvent(@NotNull ToggleAction action2) {
        if (action2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(26);
        }
        return new AnActionEvent(null, DataContext.EMPTY_CONTEXT, "", action2.getTemplatePresentation(), ActionManager.getInstance(), 0);
    }

    @NotNull
    private static UsageViewImpl createUsageView(@NotNull Project project) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(27);
        }
        UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        usageViewPresentation.setDetachedMode(true);
        return new UsageViewImpl(project, usageViewPresentation, UsageTarget.EMPTY_ARRAY, null){

            @NotNull
            public UsageViewSettings getUsageViewSettings() {
                ShowUsageViewSettings showUsageViewSettings = ShowUsagesSettings.getInstance().getState();
                if (showUsageViewSettings == null) {
                    4.$$$reportNull$$$0(0);
                }
                return showUsageViewSettings;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$4", "getUsageViewSettings"));
            }
        };
    }

    @NotNull
    static UsageNode createStringNode(@NotNull Object string) {
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(28);
        }
        return new StringNode(string);
    }

    private static boolean showPopupIfNeedTo(@NotNull JBPopup popup2, @NotNull RelativePoint popupPosition) {
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(29);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(30);
        }
        if (!popup2.isDisposed() && !popup2.isVisible()) {
            popup2.show(popupPosition);
            return true;
        }
        return false;
    }

    @NotNull
    private static JComponent createHintComponent(@NotNull @NlsContexts.HintText String secondInvocationTitle, boolean isWarning, @NotNull JComponent button2) {
        if (secondInvocationTitle == null) {
            ShowUsagesAction.$$$reportNull$$$0(31);
        }
        if (button2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(32);
        }
        JComponent label2 = HintUtil.createInformationLabel(secondInvocationTitle);
        if (isWarning) {
            label2.setBackground(MessageType.WARNING.getPopupBackground());
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        button2.setBackground(label2.getBackground());
        panel2.setBackground(label2.getBackground());
        label2.setOpaque(false);
        label2.setBorder(null);
        panel2.setBorder(HintUtil.createHintBorder());
        panel2.add((Component)label2, "Center");
        panel2.add((Component)button2, "East");
        JPanel jPanel2 = panel2;
        if (jPanel2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(33);
        }
        return jPanel2;
    }

    @NotNull
    private static InplaceButton createSettingsButton(@NotNull Project project, @NotNull Runnable cancelAction, @NotNull Runnable showDialogAndFindUsagesRunnable) {
        KeyboardShortcut shortcut;
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(34);
        }
        if (cancelAction == null) {
            ShowUsagesAction.$$$reportNull$$$0(35);
        }
        if (showDialogAndFindUsagesRunnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(36);
        }
        String tooltip = (shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut()) == null ? FindBundle.message("show.usages.settings.tooltip", new Object[0]) : FindBundle.message("show.usages.settings.tooltip.shortcut", KeymapUtil.getShortcutText((Shortcut)shortcut));
        return new InplaceButton(tooltip, AllIcons.General.Settings, __ -> {
            ApplicationManager.getApplication().invokeLater(showDialogAndFindUsagesRunnable, project.getDisposed());
            cancelAction.run();
        });
    }

    @Nullable
    private static FindUsagesOptions showDialog(@NotNull FindUsagesHandlerBase handler2) {
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(37);
        }
        UIEventLogger.ShowUsagesPopupShowSettings.log();
        AbstractFindUsagesDialog dialog2 = handler2 instanceof FindUsagesHandlerUi ? ((FindUsagesHandlerUi)((Object)handler2)).getFindUsagesDialog(false, false, false) : FindUsagesHandler.createDefaultFindUsagesDialog(false, false, false, handler2);
        if (dialog2.showAndGet()) {
            dialog2.calcFindUsagesOptions();
            return handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
        }
        return null;
    }

    @NotNull
    private static JBPopup createUsagePopup(@NotNull UsageViewImpl usageView, @NotNull JTable table, @NotNull Runnable itemChoseCallback, final @NotNull TitlePanel statusPanel, final @NotNull ShowUsagesParameters parameters2, final @NotNull ShowUsagesActionHandler actionHandler) {
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(38);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(39);
        }
        if (itemChoseCallback == null) {
            ShowUsagesAction.$$$reportNull$$$0(40);
        }
        if (statusPanel == null) {
            ShowUsagesAction.$$$reportNull$$$0(41);
        }
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(42);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(43);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = parameters2.project;
        PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(table);
        String title = UsageViewBundle.message((String)"search.title.0.in.1", (Object[])new Object[]{actionHandler.getPresentation().getSearchString(), actionHandler.getSelectedScope().getDisplayName()});
        builder2.setTitle(XmlStringUtil.wrapInHtml((CharSequence)("<body><nobr>" + StringUtil.escapeXmlEntities((String)title) + "</nobr></body>")));
        builder2.setAdText(ShowUsagesActionHandler.getSecondInvocationHint(actionHandler));
        builder2.setMovable(true).setResizable(true);
        builder2.setItemChoosenCallback(itemChoseCallback);
        final JBPopup[] popup2 = new JBPopup[1];
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel(popup2[0]);
                    ShowUsagesAction.showDialogAndRestart(parameters2, actionHandler);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$5", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        if ((shortcut = ShowUsagesAction.getShowUsagesShortcut()) != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel(popup2[0]);
                    ShowUsagesAction.showUsagesInMaximalScope(parameters2, actionHandler);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$6", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        InplaceButton settingsButton = ShowUsagesAction.createSettingsButton(project, () -> ShowUsagesAction.cancel(popup2[0]), ShowUsagesAction.showDialogAndRestartRunnable(parameters2, actionHandler));
        ActiveComponent statusComponent = new ActiveComponent(){

            public void setActive(boolean active) {
                statusPanel.setActive(active);
            }

            @NotNull
            public JComponent getComponent() {
                TitlePanel titlePanel = statusPanel;
                if (titlePanel == null) {
                    7.$$$reportNull$$$0(0);
                }
                return titlePanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$7", "getComponent"));
            }
        };
        DefaultActionGroup pinGroup = new DefaultActionGroup();
        ActiveComponent pin = ShowUsagesAction.createPinButton(project, popup2, pinGroup, actionHandler::findUsages);
        builder2.setCommandButton((ActiveComponent)new CompositeActiveComponent(new ActiveComponent[]{statusComponent, settingsButton, pin}));
        DefaultActionGroup toolbar = new DefaultActionGroup();
        usageView.addFilteringActions(toolbar);
        toolbar.add((AnAction)UsageGroupingRuleProviderImpl.createGroupByFileStructureAction((UsageViewImpl)usageView));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)toolbar, true);
        actionToolbar.setTargetComponent((JComponent)table);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent toolBar = actionToolbar.getComponent();
        toolBar.setOpaque(false);
        builder2.setSettingButton((Component)toolBar);
        builder2.setCancelKeyEnabled(false);
        PopupUpdateProcessor processor2 = new PopupUpdateProcessor(usageView.getProject()){

            public void updatePopup(Object lookupItemObject) {
            }
        };
        builder2.addListener((JBPopupListener)processor2);
        popup2[0] = builder2.createPopup();
        JComponent content2 = popup2[0].getContent();
        String fullTitle = title + ShowUsagesAction.getStatusString(true, false, 0, 0);
        int approxWidth = (int)(toolBar.getPreferredSize().getWidth() + new JLabel(fullTitle).getPreferredSize().getWidth() + settingsButton.getPreferredSize().getWidth());
        IntRef minWidth = parameters2.minWidth;
        minWidth.set(Math.max(minWidth.get(), approxWidth));
        for (AnAction action2 : toolbar.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        for (AnAction action2 : pinGroup.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        popup2[0].setUserData(Collections.singletonList(toolbar));
        JBPopup jBPopup = popup2[0];
        if (jBPopup == null) {
            ShowUsagesAction.$$$reportNull$$$0(44);
        }
        return jBPopup;
    }

    @NotNull
    private static ActiveComponent createPinButton(@NotNull Project project, final JBPopup @NotNull [] popup2, @NotNull DefaultActionGroup pinGroup, final @NotNull Runnable findUsagesRunnable) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(45);
        }
        if (pinGroup == null) {
            ShowUsagesAction.$$$reportNull$$$0(46);
        }
        if (findUsagesRunnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(47);
        }
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(48);
        }
        Icon icon2 = ToolWindowManager.getInstance((Project)project).getLocationIcon("Find", AllIcons.General.Pin_tab);
        AnAction pinAction = new AnAction(IdeBundle.messagePointer((String)"show.in.find.window.button.name", (Object[])new Object[0]), IdeBundle.messagePointer((String)"show.in.find.window.button.pin.description", (Object[])new Object[0]), icon2){
            {
                super(arg0, arg1, arg2);
                AnAction action2 = ActionManager.getInstance().getAction("FindUsages");
                this.setShortcutSet(action2.getShortcutSet());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                ShowUsagesAction.hideHints();
                ShowUsagesAction.cancel(popup2[0]);
                findUsagesRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$9", "actionPerformed"));
            }
        };
        pinGroup.add(pinAction);
        ActionToolbar pinToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)pinGroup, true);
        pinToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent pinToolBar = pinToolbar.getComponent();
        pinToolBar.setBorder(null);
        pinToolBar.setOpaque(false);
        return new ActiveComponent.Adapter(){

            @NotNull
            public JComponent getComponent() {
                JComponent jComponent = pinToolBar;
                if (jComponent == null) {
                    10.$$$reportNull$$$0(0);
                }
                return jComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$10", "getComponent"));
            }
        };
    }

    private static void cancel(@Nullable JBPopup popup2) {
        if (popup2 != null) {
            popup2.cancel();
        }
    }

    @Nls
    @NotNull
    private static String getStatusString(boolean findUsagesInProgress, boolean hasMore, int visibleCount, int totalCount) {
        if (findUsagesInProgress || hasMore) {
            String string = UsageViewBundle.message((String)"showing.0.usages", (Object[])new Object[]{visibleCount - (hasMore ? 1 : 0)});
            if (string == null) {
                ShowUsagesAction.$$$reportNull$$$0(49);
            }
            return string;
        }
        if (visibleCount != totalCount) {
            String string = UsageViewBundle.message((String)"showing.0.of.1.usages", (Object[])new Object[]{visibleCount, totalCount});
            if (string == null) {
                ShowUsagesAction.$$$reportNull$$$0(50);
            }
            return string;
        }
        String string = UsageViewBundle.message((String)"found.0.usages", (Object[])new Object[]{totalCount});
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(51);
        }
        return string;
    }

    @Nls
    @NotNull
    private static String suggestSecondInvocation(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String text2, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String hint) {
        if (text2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(52);
        }
        HtmlBuilder builder2 = new HtmlBuilder().append(text2);
        if (hint != null) {
            builder2.br().append((HtmlChunk)HtmlChunk.text((String)hint).wrapWith("small"));
        }
        String string = builder2.wrapWithHtmlBody().toString();
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(53);
        }
        return string;
    }

    @Nullable
    static KeyboardShortcut getShowUsagesShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(ID);
    }

    private static int getFilteredOutNodeCount(@NotNull List<? extends Usage> usages, @NotNull UsageViewImpl usageView) {
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(54);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(55);
        }
        return (int)usages.stream().filter(usage -> !usageView.isVisible(usage)).count();
    }

    private static int getUsageOffset(@NotNull Usage usage) {
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(56);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return -1;
        }
        PsiElement element2 = ((UsageInfo2UsageAdapter)usage).getElement();
        if (element2 == null) {
            return -1;
        }
        return element2.getTextRange().getStartOffset();
    }

    private static boolean areAllUsagesInOneLine(@NotNull Usage visibleUsage, @NotNull List<? extends Usage> usages) {
        Editor editor;
        if (visibleUsage == null) {
            ShowUsagesAction.$$$reportNull$$$0(57);
        }
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(58);
        }
        if ((editor = ShowUsagesAction.getEditorFor(visibleUsage)) == null) {
            return false;
        }
        int offset = ShowUsagesAction.getUsageOffset(visibleUsage);
        if (offset == -1) {
            return false;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        for (Usage usage : usages) {
            Editor otherEditor = ShowUsagesAction.getEditorFor(usage);
            if (otherEditor != editor) {
                return false;
            }
            int otherOffset = ShowUsagesAction.getUsageOffset(usage);
            if (otherOffset == -1) {
                return false;
            }
            int otherLine = otherEditor.getDocument().getLineNumber(otherOffset);
            if (otherLine == lineNumber) continue;
            return false;
        }
        return true;
    }

    private static int calcMaxWidth(@NotNull JTable table) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(59);
        }
        int colsNum = table.getColumnModel().getColumnCount();
        int totalWidth = 0;
        for (int col = 0; col < colsNum - 1; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            int preferred = column.getPreferredWidth();
            int width = Math.max(preferred, ShowUsagesAction.columnMaxWidth(table, col));
            totalWidth += width;
            column.setMinWidth(width);
            column.setMaxWidth(width);
            column.setWidth(width);
            column.setPreferredWidth(width);
        }
        return totalWidth += ShowUsagesAction.columnMaxWidth(table, colsNum - 1);
    }

    private static int columnMaxWidth(@NotNull JTable table, int col) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(60);
        }
        TableColumn column = table.getColumnModel().getColumn(col);
        int width = 0;
        for (int row = 0; row < table.getRowCount(); ++row) {
            Component component2 = table.prepareRenderer(column.getCellRenderer(), row, col);
            int rendererWidth = component2.getPreferredSize().width;
            width = Math.max(width, rendererWidth + table.getIntercellSpacing().width);
        }
        return width;
    }

    private static void rebuildTable(@NotNull UsageViewImpl usageView, @NotNull List<UsageNode> data2, @NotNull ShowUsagesTable table, @Nullable JBPopup popup2, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth) {
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(61);
        }
        if (data2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(62);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(63);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(64);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(65);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ShowUsagesTable.MyModel tableModel = table.setTableModel(data2);
        List existingData = tableModel.getItems();
        int row = table.getSelectedRow();
        int newSelection = ShowUsagesAction.updateModel(tableModel, existingData, data2, row == -1 ? 0 : row);
        if (newSelection < 0 || newSelection >= tableModel.getRowCount()) {
            ScrollingUtil.ensureSelectionExists((JTable)((Object)table));
            newSelection = table.getSelectedRow();
        } else {
            Object valueInTopRow;
            if (newSelection == 0 && table.getModel().getRowCount() > 1 && (valueInTopRow = table.getModel().getValueAt(0, 0)) instanceof UsageNode && usageView.isOriginUsage(((UsageNode)valueInTopRow).getUsage())) {
                ++newSelection;
            }
            table.getSelectionModel().setSelectionInterval(newSelection, newSelection);
        }
        ScrollingUtil.ensureIndexIsVisible((JTable)((Object)table), (int)newSelection, (int)0);
        if (popup2 != null) {
            ShowUsagesAction.setSizeAndDimensions((JTable)((Object)table), popup2, popupPosition, minWidth, data2);
        }
    }

    private static int updateModel(@NotNull ShowUsagesTable.MyModel tableModel, @NotNull List<? extends UsageNode> listOld, @NotNull List<? extends UsageNode> listNew, int oldSelection) {
        if (tableModel == null) {
            ShowUsagesAction.$$$reportNull$$$0(66);
        }
        if (listOld == null) {
            ShowUsagesAction.$$$reportNull$$$0(67);
        }
        if (listNew == null) {
            ShowUsagesAction.$$$reportNull$$$0(68);
        }
        Object[] oa = listOld.toArray(new UsageNode[0]);
        Object[] na = listNew.toArray(new UsageNode[0]);
        List<ModelDiff.Cmd> cmds = ModelDiff.createDiffCmds(tableModel, oa, na);
        int selection = oldSelection;
        if (cmds != null) {
            for (ModelDiff.Cmd cmd : cmds) {
                selection = cmd.translateSelection(selection);
                cmd.apply();
            }
        }
        return selection;
    }

    private static void setSizeAndDimensions(@NotNull JTable table, @NotNull JBPopup popup2, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth, @NotNull List<? extends UsageNode> data2) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(69);
        }
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(70);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(71);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(72);
        }
        if (data2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(73);
        }
        if (ShowUsagesAction.isCodeWithMeClientInstance(popup2)) {
            return;
        }
        JComponent content2 = popup2.getContent();
        Window window = SwingUtilities.windowForComponent(content2);
        Dimension d = window.getSize();
        int width = ShowUsagesAction.calcMaxWidth(table);
        width = (int)Math.max(d.getWidth(), (double)width);
        Dimension headerSize = ((AbstractPopup)popup2).getHeaderPreferredSize();
        width = Math.max((int)headerSize.getWidth(), width);
        width = Math.max(minWidth.get(), width);
        int delta = minWidth.get() == -1 ? 0 : width - minWidth.get();
        int newWidth = Math.max(width, d.width + delta);
        minWidth.set(newWidth);
        Dimension footerSize = ((AbstractPopup)popup2).getFooterPreferredSize();
        int footer = footerSize.height;
        int footerBorder = footer == 0 ? 0 : 1;
        Insets insets = ((AbstractPopup)popup2).getPopupBorder().getBorderInsets((Component)content2);
        int minHeight = headerSize.height + footer + footerBorder + insets.top + insets.bottom;
        Rectangle rectangle = ShowUsagesAction.getPreferredBounds(table, popupPosition.getScreenPoint(), newWidth, minHeight, data2.size());
        table.setSize(rectangle.width, rectangle.height - minHeight);
        if (!data2.isEmpty()) {
            ScrollingUtil.ensureSelectionExists((JTable)table);
        }
        Dimension newDim = rectangle.getSize();
        window.setBounds(rectangle);
        window.setMinimumSize(newDim);
        window.setMaximumSize(newDim);
        window.validate();
        window.repaint();
    }

    private static boolean isCodeWithMeClientInstance(@NotNull JBPopup popup2) {
        JComponent content2;
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(74);
        }
        return (content2 = popup2.getContent()).getClientProperty("THIN_CLIENT") != null;
    }

    @NotNull
    private static Rectangle getPreferredBounds(@NotNull JTable table, @NotNull Point point, int width, int minHeight, int modelRows) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(75);
        }
        if (point == null) {
            ShowUsagesAction.$$$reportNull$$$0(76);
        }
        boolean addExtraSpace = Registry.is((String)"ide.preferred.scrollable.viewport.extra.space");
        int visibleRows = Math.min(30, modelRows);
        int rowHeight = table.getRowHeight();
        int space = addExtraSpace && visibleRows < modelRows ? rowHeight / 2 : 0;
        int height = visibleRows * rowHeight + minHeight + space;
        Rectangle bounds2 = new Rectangle(point.x, point.y, width, height);
        ScreenUtil.fitToScreen((Rectangle)bounds2);
        if (bounds2.height != height) {
            bounds2.height = Math.max(1, (bounds2.height - (minHeight += addExtraSpace && space == 0 ? rowHeight / 2 : space)) / rowHeight) * rowHeight + minHeight;
        }
        Rectangle rectangle = bounds2;
        if (rectangle == null) {
            ShowUsagesAction.$$$reportNull$$$0(77);
        }
        return rectangle;
    }

    private static void addUsageNodes(@NotNull GroupNode root, @NotNull UsageViewImpl usageView, @NotNull List<? super UsageNode> outNodes) {
        if (root == null) {
            ShowUsagesAction.$$$reportNull$$$0(78);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(79);
        }
        if (outNodes == null) {
            ShowUsagesAction.$$$reportNull$$$0(80);
        }
        for (UsageNode node : root.getUsageNodes()) {
            Usage usage = node.getUsage();
            if (!usageView.isVisible(usage)) continue;
            node.setParent((MutableTreeNode)root);
            outNodes.add((UsageNode)node);
        }
        for (GroupNode groupNode : root.getSubGroups()) {
            groupNode.setParent((MutableTreeNode)root);
            ShowUsagesAction.addUsageNodes(groupNode, usageView, outNodes);
        }
    }

    private static void navigateAndHint(@NotNull Usage usage, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String hint, @NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(81);
        }
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(82);
        }
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(83);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(84);
        }
        usage.navigate(true);
        Editor newEditor = ShowUsagesAction.getEditorFor(usage);
        if (newEditor == null) {
            return;
        }
        ShowUsagesAction.hint(false, hint, parameters2.withEditor(newEditor), actionHandler);
    }

    private static void hint(boolean isWarning, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String hint, @NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(85);
        }
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(86);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(87);
        }
        Project project = parameters2.project;
        Editor editor = parameters2.editor;
        Runnable runnable2 = () -> {
            if (!actionHandler.isValid()) {
                return;
            }
            JComponent label2 = ShowUsagesAction.createHintComponent(ShowUsagesAction.suggestSecondInvocation(hint, ShowUsagesActionHandler.getSecondInvocationHint(actionHandler)), isWarning, (JComponent)ShowUsagesAction.createSettingsButton(project, ShowUsagesAction::hideHints, ShowUsagesAction.showDialogAndRestartRunnable(parameters2, actionHandler)));
            ShowUsagesActionState state = ShowUsagesAction.getState(project);
            state.continuation = ShowUsagesAction.showUsagesInMaximalScopeRunnable(parameters2, actionHandler);
            Runnable clearContinuation = () -> {
                state.continuation = null;
            };
            ShowUsagesAction.runWhenHidden(label2, clearContinuation);
            if (editor == null || editor.isDisposed() || !editor.getComponent().isShowing()) {
                int flags = 42;
                HintManager.getInstance().showHint(label2, parameters2.popupPosition, flags, 0, clearContinuation);
            } else {
                HintManager.getInstance().showInformationHint(editor, label2);
            }
        };
        if (editor == null) {
            IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(runnable2));
        } else {
            IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> editor.getScrollingModel().runActionOnScrollingFinished(() -> IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> AsyncEditorLoader.performWhenLoaded(editor, runnable2))));
        }
    }

    @Nullable
    private static Editor getEditorFor(@NotNull Usage usage) {
        FileEditorLocation location;
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(88);
        }
        FileEditor newFileEditor = (location = usage.getLocation()) == null ? null : location.getEditor();
        return newFileEditor instanceof TextEditor ? ((TextEditor)newFileEditor).getEditor() : null;
    }

    @NotNull
    private static Runnable showMoreUsagesRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(89);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(90);
        }
        Runnable runnable2 = () -> ShowUsagesAction.showElementUsages(parameters2.moreUsages(), actionHandler);
        if (runnable2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(91);
        }
        return runnable2;
    }

    @NotNull
    private static Runnable showUsagesInMaximalScopeRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(92);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(93);
        }
        Runnable runnable2 = () -> ShowUsagesAction.showUsagesInMaximalScope(parameters2, actionHandler);
        if (runnable2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(94);
        }
        return runnable2;
    }

    private static void showUsagesInMaximalScope(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(95);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(96);
        }
        ShowUsagesAction.showElementUsages(parameters2, actionHandler.withScope(actionHandler.getMaximalScope()));
    }

    @NotNull
    private static Runnable showDialogAndRestartRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(97);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(98);
        }
        Runnable runnable2 = () -> ShowUsagesAction.showDialogAndRestart(parameters2, actionHandler);
        if (runnable2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(99);
        }
        return runnable2;
    }

    private static void showDialogAndRestart(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        ShowUsagesActionHandler newActionHandler;
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(100);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(101);
        }
        if ((newActionHandler = actionHandler.showDialog()) != null) {
            ShowUsagesAction.showElementUsages(parameters2, newActionHandler);
        }
    }

    @NotNull
    private static ShowUsagesActionState getState(@NotNull Project project) {
        if (project == null) {
            ShowUsagesAction.$$$reportNull$$$0(102);
        }
        ShowUsagesActionState showUsagesActionState = (ShowUsagesActionState)ServiceManager.getService((Project)project, ShowUsagesActionState.class);
        if (showUsagesActionState == null) {
            ShowUsagesAction.$$$reportNull$$$0(103);
        }
        return showUsagesActionState;
    }

    private static void runWhenHidden(@NotNull Component c, @NotNull Runnable r) {
        if (c == null) {
            ShowUsagesAction.$$$reportNull$$$0(104);
        }
        if (r == null) {
            ShowUsagesAction.$$$reportNull$$$0(105);
        }
        c.addHierarchyListener(ShowUsagesAction.runWhenHidden(r));
    }

    @NotNull
    private static HierarchyListener runWhenHidden(final @NotNull Runnable r) {
        if (r == null) {
            ShowUsagesAction.$$$reportNull$$$0(106);
        }
        return new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (!BitUtil.isSet((long)e.getChangeFlags(), (long)2L)) {
                    return;
                }
                Component component2 = e.getComponent();
                if (component2.isDisplayable()) {
                    return;
                }
                r.run();
                component2.removeHierarchyListener(this);
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public void startFindUsages(@NotNull PsiElement element2, @NotNull RelativePoint popupPosition, @Nullable Editor editor, int maxUsages) {
        if (element2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(107);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(108);
        }
        ShowUsagesAction.startFindUsages(element2, popupPosition, editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 77: 
            case 91: 
            case 94: 
            case 99: 
            case 103: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 33: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 77: 
            case 91: 
            case 94: 
            case 99: 
            case 103: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 27: 
            case 34: 
            case 45: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetVariants";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 30: 
            case 64: 
            case 71: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupPosition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 38: 
            case 55: 
            case 61: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pingEDT";
                break;
            }
            case 21: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 23: 
            case 42: 
            case 83: 
            case 86: 
            case 89: 
            case 92: 
            case 95: 
            case 97: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 24: 
            case 43: 
            case 84: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 98: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHandler";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unselectedActions";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 29: 
            case 48: 
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondInvocationTitle";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 33: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 77: 
            case 91: 
            case 94: 
            case 99: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelAction";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showDialogAndFindUsagesRunnable";
                break;
            }
            case 39: 
            case 59: 
            case 60: 
            case 63: 
            case 69: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemChoseCallback";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusPanel";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pinGroup";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findUsagesRunnable";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 56: 
            case 81: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleUsage";
                break;
            }
            case 62: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 65: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minWidth";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOld";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listNew";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outNodes";
                break;
            }
            case 82: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createHintComponent";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsagePopup";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusString";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSecondInvocation";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredBounds";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "showMoreUsagesRunnable";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "showUsagesInMaximalScopeRunnable";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "showDialogAndRestartRunnable";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showSymbolUsages";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showUsages";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createVariantHandler";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showPsiUsages";
                break;
            }
            case 17: 
            case 18: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "startFindUsages";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "rulesChanged";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createActionHandler";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showElementUsages";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "toggleFilters";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fakeEvent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createUsageView";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createStringNode";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showPopupIfNeedTo";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createHintComponent";
                break;
            }
            case 33: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 77: 
            case 91: 
            case 94: 
            case 99: 
            case 103: {
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsButton";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createUsagePopup";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createPinButton";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "suggestSecondInvocation";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredOutNodeCount";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getUsageOffset";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "areAllUsagesInOneLine";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "calcMaxWidth";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "columnMaxWidth";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "rebuildTable";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "setSizeAndDimensions";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isCodeWithMeClientInstance";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredBounds";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addUsageNodes";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "navigateAndHint";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "hint";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFor";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "showMoreUsagesRunnable";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "showUsagesInMaximalScopeRunnable";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "showUsagesInMaximalScope";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndRestartRunnable";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndRestart";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "runWhenHidden";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 77: 
            case 91: 
            case 94: 
            case 99: 
            case 103: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Service
    private static final class ShowUsagesActionState {
        Runnable continuation;

        private ShowUsagesActionState() {
        }
    }

    static abstract class FilteredOutUsagesNode
    extends UsageNode {
        @NotNull
        private final String myString;
        private final String myToolTip;

        private FilteredOutUsagesNode(@NotNull Usage fakeUsage, @NotNull String string, @NotNull String toolTip) {
            if (fakeUsage == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(0);
            }
            if (string == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(1);
            }
            if (toolTip == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(2);
            }
            super(null, fakeUsage);
            this.myString = string;
            this.myToolTip = toolTip;
        }

        public String toString() {
            return this.myString;
        }

        @NotNull
        public String getTooltip() {
            String string = this.myToolTip;
            if (string == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(3);
            }
            return string;
        }

        public abstract void onSelected();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fakeUsage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolTip";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$FilteredOutUsagesNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$FilteredOutUsagesNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class StringNode
    extends UsageNode {
        @NotNull
        private final Object myString;

        private StringNode(@NotNull Object string) {
            if (string == null) {
                StringNode.$$$reportNull$$$0(0);
            }
            super(null, (Usage)NullUsage.INSTANCE);
            this.myString = string;
        }

        public String toString() {
            return this.myString.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/find/actions/ShowUsagesAction$StringNode", "<init>"));
        }
    }

    private static final class UsageNodeComparator
    implements Comparator<UsageNode> {
        private final ShowUsagesTable myTable;

        private UsageNodeComparator(@NotNull ShowUsagesTable table) {
            if (table == null) {
                UsageNodeComparator.$$$reportNull$$$0(0);
            }
            this.myTable = table;
        }

        @Override
        public int compare(UsageNode c1, UsageNode c2) {
            VirtualFile v2;
            String name2;
            int weight2;
            int weight1;
            if (c1 instanceof StringNode || c2 instanceof StringNode) {
                if (c1 instanceof StringNode && c2 instanceof StringNode) {
                    return Comparing.compare((Comparable)((Object)c1.toString()), (Comparable)((Object)c2.toString()));
                }
                return c1 instanceof StringNode ? 1 : -1;
            }
            Usage o1 = c1.getUsage();
            Usage o2 = c2.getUsage();
            int n = o1 == this.myTable.USAGES_FILTERED_OUT_SEPARATOR ? 3 : (o1 == this.myTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight1 = o1 == this.myTable.MORE_USAGES_SEPARATOR ? 1 : 0));
            int n2 = o2 == this.myTable.USAGES_FILTERED_OUT_SEPARATOR ? 3 : (o2 == this.myTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight2 = o2 == this.myTable.MORE_USAGES_SEPARATOR ? 1 : 0));
            if (weight1 != weight2) {
                return weight1 - weight2;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            VirtualFile v1 = UsageListCellRenderer.getVirtualFile(o1);
            String name1 = v1 == null ? null : v1.getName();
            int i2 = Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)(name2 = (v2 = UsageListCellRenderer.getVirtualFile(o2)) == null ? null : v2.getName())));
            if (i2 != 0) {
                return i2;
            }
            if (Comparing.equal((Object)v1, (Object)v2)) {
                FileEditorLocation loc1 = o1.getLocation();
                FileEditorLocation loc2 = o2.getLocation();
                return Comparing.compare((Comparable)loc1, (Comparable)loc2);
            }
            String path1 = v1 == null ? null : v1.getPath();
            String path2 = v2 == null ? null : v2.getPath();
            return Comparing.compare((Comparable)((Object)path1), (Comparable)((Object)path2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction$UsageNodeComparator", "<init>"));
        }
    }
}

