/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.idea.Main;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LicensingFacade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EAPUsageCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("user.advanced.info", 4);
    private static final EventId1<BuildType> BUILD = GROUP.registerEvent("build", (EventField)EventFields.Enum((String)"value", BuildType.class));
    private static final EnumEventField<LicenceType> LICENSE_VALUE = EventFields.Enum((String)"value", LicenceType.class);
    private static final StringEventField METADATA = EventFields.StringListValidatedByRegexp((String)"metadata", (String)"license_metadata");
    private static final BooleanEventField IS_JB_TEAM = EventFields.Boolean((String)"is_jb_team");
    private static final VarargEventId LICENSING = GROUP.registerVarargEvent("licencing", new EventField[]{LICENSE_VALUE, METADATA, IS_JB_TEAM});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return EAPUsageCollector.collectMetrics();
    }

    @NotNull
    private static Set<MetricEvent> collectMetrics() {
        block10: {
            HashSet<MetricEvent> hashSet;
            try {
                if (Main.isHeadless()) break block10;
                HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
                if (ApplicationInfoEx.getInstanceEx().isEAP()) {
                    result2.add(BUILD.metric((Object)BuildType.eap));
                } else {
                    result2.add(BUILD.metric((Object)BuildType.release));
                }
                LicensingFacade facade = LicensingFacade.getInstance();
                if (facade != null) {
                    if (facade.isEvaluationLicense()) {
                        result2.add(EAPUsageCollector.newLicencingMetric(LicenceType.evaluation, facade));
                    } else if (!StringUtil.isEmpty((String)facade.getLicensedToMessage())) {
                        result2.add(EAPUsageCollector.newLicencingMetric(LicenceType.license, facade));
                    }
                }
                hashSet = result2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (hashSet == null) {
                EAPUsageCollector.$$$reportNull$$$0(0);
            }
            return hashSet;
        }
        Set<MetricEvent> set2 = Collections.emptySet();
        if (set2 == null) {
            EAPUsageCollector.$$$reportNull$$$0(1);
        }
        return set2;
    }

    @NotNull
    private static MetricEvent newLicencingMetric(@NotNull LicenceType value2, @NotNull LicensingFacade licensingFacade) {
        String metadata;
        if (value2 == null) {
            EAPUsageCollector.$$$reportNull$$$0(2);
        }
        if (licensingFacade == null) {
            EAPUsageCollector.$$$reportNull$$$0(3);
        }
        ArrayList<EventPair> data2 = new ArrayList<EventPair>();
        String licensedToMessage = licensingFacade.getLicensedToMessage();
        if (licensedToMessage != null && licensedToMessage.contains("JetBrains Team")) {
            data2.add(IS_JB_TEAM.with((Object)true));
        }
        if (StringUtil.isNotEmpty((String)(metadata = licensingFacade.metadata))) {
            data2.add(METADATA.with((Object)metadata));
        }
        data2.add(LICENSE_VALUE.with((Object)value2));
        MetricEvent metricEvent = LICENSING.metric(data2);
        if (metricEvent == null) {
            EAPUsageCollector.$$$reportNull$$$0(4);
        }
        return metricEvent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/fusCollectors/EAPUsageCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "licensingFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMetrics";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/fusCollectors/EAPUsageCollector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newLicencingMetric";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newLicencingMetric";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum BuildType {
        eap,
        release;

    }

    private static enum LicenceType {
        evaluation,
        license;

    }
}

