/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.DebuggableRunProfileState;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.DefaultRunProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/runners/DefaultRunProgramRunner;", "Lcom/intellij/execution/runners/ProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getRunnerId", "intellij.platform.execution.impl"})
final class DefaultRunProgramRunner
implements ProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "defaultRunRunner";
    }

    public void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfileState runProfileState = environment.getState();
        if (runProfileState == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)runProfileState, (String)"environment.state ?: return");
        RunProfileState state = runProfileState;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"environment.project");
        ExecutionManager.Companion.getInstance(project).startRunProfile(environment, (Function0)new Function0<Promise<RunContentDescriptor>>(this, state, environment){
            final /* synthetic */ DefaultRunProgramRunner this$0;
            final /* synthetic */ RunProfileState $state;
            final /* synthetic */ ExecutionEnvironment $environment;

            @NotNull
            public final Promise<RunContentDescriptor> invoke() {
                Promise promise;
                FileDocumentManager.getInstance().saveAllDocuments();
                if (this.$state instanceof DebuggableRunProfileState) {
                    Promise promise2 = ((DebuggableRunProfileState)this.$state).execute(-1).then((Function)new Function<ExecutionResult, RunContentDescriptor>(this){
                        final /* synthetic */ execute.1 this$0;

                        @Nullable
                        public final RunContentDescriptor fun(ExecutionResult it) {
                            RunContentDescriptor runContentDescriptor;
                            ExecutionResult executionResult = it;
                            if (executionResult != null) {
                                ExecutionResult executionResult2 = executionResult;
                                boolean bl = false;
                                boolean bl2 = false;
                                ExecutionResult it2 = executionResult2;
                                boolean bl3 = false;
                                runContentDescriptor = new RunContentBuilder(it2, this.this$0.$environment).showRunContent(this.this$0.$environment.getContentToReuse());
                            } else {
                                runContentDescriptor = null;
                            }
                            return runContentDescriptor;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    promise = promise2;
                    Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"state.execute(-1)\n      \u2026            }\n          }");
                } else {
                    promise = Promises.resolvedPromise((Object)DefaultProgramRunnerKt.showRunContent(this.$state.execute(this.$environment.getExecutor(), (ProgramRunner)this.this$0), this.$environment));
                }
                return promise;
            }
            {
                this.this$0 = defaultRunProgramRunner;
                this.$state = runProfileState;
                this.$environment = executionEnvironment;
                super(0);
            }
        });
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)"Run", (Object)executorId) && !(profile instanceof RunConfigurationWithSuppressedDefaultRunAction);
    }
}

