/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.util;

import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.util.AbstractHProfNavigatorReadBuffer;
import com.intellij.util.io.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/diagnostic/hprof/util/HProfReadBufferSlidingWindow;", "Lcom/intellij/diagnostic/hprof/util/AbstractHProfNavigatorReadBuffer;", "channel", "Ljava/nio/channels/FileChannel;", "parser", "Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;", "(Ljava/nio/channels/FileChannel;Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;)V", "buffer", "Ljava/nio/ByteBuffer;", "bufferOffset", "", "bufferSize", "size", "close", "", "get", "", "bytes", "", "getByteBuffer", "", "getInt", "getLong", "getShort", "", "isEof", "", "position", "newPosition", "remapBuffer", "intellij.platform.ide.impl"})
public final class HProfReadBufferSlidingWindow
extends AbstractHProfNavigatorReadBuffer {
    private final long bufferSize;
    private final long size;
    private ByteBuffer buffer;
    private long bufferOffset;
    private final FileChannel channel;

    @Override
    public void close() {
        ByteBufferUtil.cleanBuffer((ByteBuffer)this.buffer);
    }

    @Override
    public void position(long newPosition) {
        if (newPosition >= this.bufferOffset && newPosition <= this.bufferOffset + this.bufferSize) {
            this.buffer.position((int)(newPosition - this.bufferOffset));
        } else {
            this.remapBuffer(newPosition);
        }
    }

    private final void remapBuffer(long newPosition) {
        ByteBuffer oldBuffer = this.buffer;
        MappedByteBuffer mappedByteBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, newPosition, Math.min(this.bufferSize, this.size - newPosition));
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"channel.map(FileChannel.\u2026ize, size - newPosition))");
        this.buffer = mappedByteBuffer;
        this.bufferOffset = newPosition;
        ByteBufferUtil.cleanBuffer((ByteBuffer)oldBuffer);
    }

    @Override
    public boolean isEof() {
        return this.position() == this.size;
    }

    @Override
    public long position() {
        return this.bufferOffset + (long)this.buffer.position();
    }

    @Override
    public void get(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (bytes.length <= this.buffer.remaining()) {
            this.buffer.get(bytes);
        } else {
            int remaining = bytes.length;
            int offset = 0;
            while (remaining > 0) {
                this.remapBuffer(this.position());
                int bytesToFetch = Math.min(remaining, (int)this.bufferSize);
                this.buffer.get(bytes, offset, bytesToFetch);
                remaining -= bytesToFetch;
                offset += bytesToFetch;
            }
        }
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer(int size) {
        boolean useSlice = false;
        if (size < this.buffer.remaining()) {
            useSlice = true;
        } else if ((long)size < this.bufferSize) {
            this.remapBuffer(this.position());
            useSlice = true;
        }
        if (useSlice) {
            ByteBuffer slicedBuffer = this.buffer.slice();
            slicedBuffer.limit(size);
            this.skip(size);
            ByteBuffer byteBuffer = slicedBuffer.asReadOnlyBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slicedBuffer.asReadOnlyBuffer()");
            return byteBuffer;
        }
        byte[] bytes = new byte[size];
        this.get(bytes);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"ByteBuffer.wrap(bytes)");
        return byteBuffer;
    }

    @Override
    public byte get() {
        if (this.buffer.remaining() < 1) {
            this.remapBuffer(this.position());
        }
        return this.buffer.get();
    }

    @Override
    public short getShort() {
        if (this.buffer.remaining() < 2) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getShort();
    }

    @Override
    public int getInt() {
        if (this.buffer.remaining() < 4) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getInt();
    }

    @Override
    public long getLong() {
        if (this.buffer.remaining() < 8) {
            this.remapBuffer(this.position());
        }
        return this.buffer.getLong();
    }

    public HProfReadBufferSlidingWindow(@NotNull FileChannel channel2, @NotNull HProfEventBasedParser parser) {
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        super(parser);
        this.channel = channel2;
        this.bufferSize = 10000000L;
        this.size = this.channel.size();
        MappedByteBuffer mappedByteBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, this.bufferOffset, Math.min(this.bufferSize, this.size));
        Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"channel.map(FileChannel.\u2026th.min(bufferSize, size))");
        this.buffer = mappedByteBuffer;
    }
}

