/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.LockKind;
import com.intellij.diagnostic.RunnablesListener;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBus;
import java.awt.AWTEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class EventWatcherImpl
implements EventWatcher,
Disposable {
    private static final int PUBLISHER_INITIAL_DELAY = 100;
    private static final int PUBLISHER_PERIOD = 1000;
    @NotNull
    private static final Logger LOG = Logger.getInstance(EventWatcherImpl.class);
    @NotNull
    private static final Pattern DESCRIPTION_BY_EVENT = Pattern.compile("(([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)\\[(?<description>\\w+(,runnable=(?<runnable>[^,]+))?[^]]*)].*");
    @NotNull
    private final ConcurrentMap<String, RunnablesListener.WrapperDescription> myWrappers;
    @NotNull
    private final ConcurrentMap<String, RunnablesListener.InvocationsInfo> myDurationsByFqn;
    @NotNull
    private final ConcurrentLinkedQueue<RunnablesListener.InvocationDescription> myRunnables;
    @NotNull
    private final ConcurrentMap<Class<? extends AWTEvent>, ConcurrentLinkedQueue<RunnablesListener.InvocationDescription>> myEventsByClass;
    @NotNull
    private final ConcurrentMap<Long, Class<?>> myRunnablesOrCallablesInProgress;
    @NotNull
    private final ConcurrentMap<String, RunnablesListener.LockAcquirementDescription> myAcquirements;
    @NotNull
    private final ScheduledExecutorService myExecutor;
    @NotNull
    private final ScheduledFuture<?> myThread;
    @NotNull
    private final LogFileWriter myWriter;
    @NotNull
    private final MessageBus myMessageBus;
    @Nullable
    private MatchResult myCurrentResult;

    public EventWatcherImpl(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            EventWatcherImpl.$$$reportNull$$$0(0);
        }
        this.myWrappers = new ConcurrentHashMap<String, RunnablesListener.WrapperDescription>();
        this.myDurationsByFqn = new ConcurrentHashMap<String, RunnablesListener.InvocationsInfo>();
        this.myRunnables = new ConcurrentLinkedQueue();
        this.myEventsByClass = new ConcurrentHashMap<Class<? extends AWTEvent>, ConcurrentLinkedQueue<RunnablesListener.InvocationDescription>>();
        this.myRunnablesOrCallablesInProgress = new ConcurrentHashMap();
        this.myAcquirements = new ConcurrentHashMap<String, RunnablesListener.LockAcquirementDescription>();
        this.myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"EDT Events Logger", (int)1);
        this.myThread = this.myExecutor.scheduleWithFixedDelay(this::dumpDescriptions, 100L, 1000L, TimeUnit.MILLISECONDS);
        this.myWriter = new LogFileWriter();
        this.myCurrentResult = null;
        this.myMessageBus = messageBus;
        this.myMessageBus.connect((Disposable)this).subscribe(RunnablesListener.TOPIC, (Object)this.myWriter);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logTimeMillis(@NotNull String processId, long startedAt, @NotNull Class<? extends Runnable> clazz) {
        void runnableClass;
        if (processId == null) {
            EventWatcherImpl.$$$reportNull$$$0(1);
        }
        if (clazz == null) {
            EventWatcherImpl.$$$reportNull$$$0(2);
        }
        RunnablesListener.InvocationDescription description = new RunnablesListener.InvocationDescription(processId, startedAt);
        EventWatcherImpl.logTimeMillis(description, runnableClass);
    }

    @Override
    public void runnableStarted(@NotNull Runnable runnable2, long startedAt) {
        Class<?> rootClass;
        Field field;
        if (runnable2 == null) {
            EventWatcherImpl.$$$reportNull$$$0(3);
        }
        Object current2 = runnable2;
        while (current2 != null && (field = EventWatcherImpl.findCallableOrRunnableField(rootClass = current2.getClass())) != null) {
            this.myWrappers.compute(rootClass.getName(), RunnablesListener.WrapperDescription::computeNext);
            current2 = ReflectionUtil.getFieldValue((Field)field, (Object)current2);
        }
        this.myRunnablesOrCallablesInProgress.put(startedAt, (current2 != null ? current2 : runnable2).getClass());
    }

    @Override
    public void runnableFinished(@NotNull Runnable runnable2, long startedAt) {
        if (runnable2 == null) {
            EventWatcherImpl.$$$reportNull$$$0(4);
        }
        Class runnableOrCallableClass = Objects.requireNonNull((Class)this.myRunnablesOrCallablesInProgress.remove(startedAt));
        String fqn = runnableOrCallableClass.getName();
        RunnablesListener.InvocationDescription description = new RunnablesListener.InvocationDescription(fqn, startedAt);
        this.myRunnables.offer(description);
        this.myDurationsByFqn.compute(fqn, (ignored, info) -> RunnablesListener.InvocationsInfo.computeNext(fqn, description.getDuration(), info));
        EventWatcherImpl.logTimeMillis(description, runnableOrCallableClass);
    }

    @Override
    public void edtEventStarted(@NotNull AWTEvent event) {
        Matcher matcher;
        if (event == null) {
            EventWatcherImpl.$$$reportNull$$$0(5);
        }
        this.myCurrentResult = (matcher = DESCRIPTION_BY_EVENT.matcher(event.toString())).find() ? matcher.toMatchResult() : null;
    }

    @Override
    public void edtEventFinished(@NotNull AWTEvent event, long startedAt) {
        if (event == null) {
            EventWatcherImpl.$$$reportNull$$$0(6);
        }
        String representation = this.myCurrentResult instanceof Matcher ? ((Matcher)this.myCurrentResult).group("description") : event.toString();
        this.myCurrentResult = null;
        Class<?> eventClass = event.getClass();
        this.myEventsByClass.putIfAbsent(eventClass, new ConcurrentLinkedQueue());
        ((ConcurrentLinkedQueue)this.myEventsByClass.get(eventClass)).offer(new RunnablesListener.InvocationDescription(representation, startedAt));
    }

    @Override
    public void lockAcquired(@NotNull String invokedClassFqn, @NotNull LockKind lockKind) {
        if (invokedClassFqn == null) {
            EventWatcherImpl.$$$reportNull$$$0(7);
        }
        if (lockKind == null) {
            EventWatcherImpl.$$$reportNull$$$0(8);
        }
        this.myAcquirements.compute(invokedClassFqn, (fqn, description) -> RunnablesListener.LockAcquirementDescription.computeNext(fqn, description, lockKind));
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myWriter);
        this.myThread.cancel(true);
        this.myExecutor.shutdownNow();
    }

    private void dumpDescriptions() {
        if (this.myMessageBus.isDisposed()) {
            return;
        }
        RunnablesListener publisher = (RunnablesListener)this.myMessageBus.syncPublisher(RunnablesListener.TOPIC);
        this.myEventsByClass.forEach((eventClass, events) -> publisher.eventsProcessed((Class<? extends AWTEvent>)eventClass, (Collection<RunnablesListener.InvocationDescription>)EventWatcherImpl.joinPolling(events)));
        publisher.runnablesProcessed(EventWatcherImpl.joinPolling(this.myRunnables), this.myDurationsByFqn.values(), this.myWrappers.values());
        publisher.locksAcquired(this.myAcquirements.values());
    }

    @Nullable
    private static Field findCallableOrRunnableField(@NotNull Class<?> rootClass) {
        if (rootClass == null) {
            EventWatcherImpl.$$$reportNull$$$0(9);
        }
        return ReflectionUtil.findFieldInHierarchy(rootClass, field -> ReflectionUtil.isInstanceField((Field)field) && EventWatcherImpl.isCallableOrRunnable(field));
    }

    private static boolean isCallableOrRunnable(@NotNull Field field) {
        Class<?> fieldType;
        if (field == null) {
            EventWatcherImpl.$$$reportNull$$$0(10);
        }
        return ReflectionUtil.isAssignable(Runnable.class, fieldType = field.getType()) || ReflectionUtil.isAssignable(Callable.class, fieldType);
    }

    @NotNull
    private static <T> List<T> joinPolling(@NotNull Queue<T> queue2) {
        if (queue2 == null) {
            EventWatcherImpl.$$$reportNull$$$0(11);
        }
        ArrayList<T> builder2 = new ArrayList<T>();
        while (!queue2.isEmpty()) {
            builder2.add(queue2.poll());
        }
        List list2 = Collections.unmodifiableList(builder2);
        if (list2 == null) {
            EventWatcherImpl.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private static void logTimeMillis(@NotNull RunnablesListener.InvocationDescription description, @NotNull Class<?> runnableClass) {
        if (description == null) {
            EventWatcherImpl.$$$reportNull$$$0(13);
        }
        if (runnableClass == null) {
            EventWatcherImpl.$$$reportNull$$$0(14);
        }
        LoadingState.CONFIGURATION_STORE_INITIALIZED.checkOccurred();
        int threshold = Registry.intValue((String)"ide.event.queue.dispatch.threshold", (int)-1);
        if (threshold < 0 || (long)threshold > description.getDuration()) {
            return;
        }
        LOG.warn(description.toString());
        if (runnableClass != Runnable.class) {
            EventWatcherImpl.addPluginCost(runnableClass, description.getDuration());
        }
    }

    private static void addPluginCost(@NotNull Class<?> runnableClass, long duration) {
        ClassLoader loader2;
        if (runnableClass == null) {
            EventWatcherImpl.$$$reportNull$$$0(15);
        }
        String pluginId = (loader2 = runnableClass.getClassLoader()) instanceof PluginClassLoader ? ((PluginClassLoader)((Object)loader2)).getPluginId().getIdString() : "com.intellij";
        StartUpMeasurer.addPluginCost((String)pluginId, (String)"invokeLater", (long)TimeUnit.MILLISECONDS.toNanos(duration));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processId";
                break;
            }
            case 2: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnableClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokedClassFqn";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lockKind";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/EventWatcherImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/EventWatcherImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "joinPolling";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logTimeMillis";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runnableStarted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runnableFinished";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "edtEventStarted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "edtEventFinished";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lockAcquired";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCallableOrRunnableField";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCallableOrRunnable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "joinPolling";
                break;
            }
            case 12: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addPluginCost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LogFileWriter
    implements RunnablesListener,
    Disposable {
        @NotNull
        private final File myLogDir = new File(new File(PathManager.getLogPath(), "edt-log"), String.format("%tY%<tm%<td-%<tH%<tM%<tS", System.currentTimeMillis()));
        @NotNull
        private final Map<String, RunnablesListener.InvocationsInfo> myInfos = new HashMap<String, RunnablesListener.InvocationsInfo>();
        @NotNull
        private final Map<String, RunnablesListener.WrapperDescription> myWrappers = new HashMap<String, RunnablesListener.WrapperDescription>();

        private LogFileWriter() {
        }

        @Override
        public void eventsProcessed(@NotNull Class<? extends AWTEvent> eventClass, @NotNull Collection<RunnablesListener.InvocationDescription> descriptions) {
            if (eventClass == null) {
                LogFileWriter.$$$reportNull$$$0(0);
            }
            if (descriptions == null) {
                LogFileWriter.$$$reportNull$$$0(1);
            }
            this.appendToFile(eventClass.getSimpleName(), descriptions.stream());
        }

        @Override
        public void runnablesProcessed(@NotNull Collection<RunnablesListener.InvocationDescription> invocations, @NotNull Collection<RunnablesListener.InvocationsInfo> infos, @NotNull Collection<RunnablesListener.WrapperDescription> wrappers) {
            if (invocations == null) {
                LogFileWriter.$$$reportNull$$$0(2);
            }
            if (infos == null) {
                LogFileWriter.$$$reportNull$$$0(3);
            }
            if (wrappers == null) {
                LogFileWriter.$$$reportNull$$$0(4);
            }
            this.appendToFile("Runnables", invocations.stream());
            LogFileWriter.putAllTo(infos, RunnablesListener.InvocationsInfo::getFQN, this.myInfos);
            LogFileWriter.putAllTo(wrappers, RunnablesListener.WrapperDescription::getFQN, this.myWrappers);
        }

        public void dispose() {
            this.writeToFile("Timings", this.myInfos);
            this.writeToFile("Wrappers", this.myWrappers);
        }

        private <T> void appendToFile(@NotNull String kind, @NotNull Stream<T> lines) {
            if (kind == null) {
                LogFileWriter.$$$reportNull$$$0(5);
            }
            if (lines == null) {
                LogFileWriter.$$$reportNull$$$0(6);
            }
            if (!this.myLogDir.isDirectory() && !this.myLogDir.mkdirs()) {
                LOG.debug(this.myLogDir.getAbsolutePath() + " cannot be created");
                return;
            }
            try {
                FileUtil.writeToFile((File)new File(this.myLogDir, kind + ".log"), (String)lines.map(Objects::toString).collect(Collectors.joining("\n")), (boolean)true);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }

        private <K, V> void writeToFile(@NotNull String kind, @NotNull Map<K, V> entities2) {
            if (kind == null) {
                LogFileWriter.$$$reportNull$$$0(7);
            }
            if (entities2 == null) {
                LogFileWriter.$$$reportNull$$$0(8);
            }
            this.appendToFile(kind, entities2.values().stream().sorted());
        }

        private static <E> void putAllTo(@NotNull Collection<E> entities2, @NotNull Function<? super E, String> mapper, @NotNull Map<String, E> map2) {
            if (entities2 == null) {
                LogFileWriter.$$$reportNull$$$0(9);
            }
            if (mapper == null) {
                LogFileWriter.$$$reportNull$$$0(10);
            }
            if (map2 == null) {
                LogFileWriter.$$$reportNull$$$0(11);
            }
            Map entitiesMap2 = entities2.stream().collect(Collectors.toMap(mapper, Function.identity()));
            map2.putAll(entitiesMap2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invocations";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappers";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entities";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diagnostic/EventWatcherImpl$LogFileWriter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "eventsProcessed";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runnablesProcessed";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendToFile";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeToFile";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putAllTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

